/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** initDeclNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ initDeclNodeList
initDeclNodeList_new ()
{
  initDeclNodeList s = (initDeclNodeList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = initDeclNodeListBASESIZE;
  s->elements = (initDeclNode *)
    dmalloc (sizeof (*s->elements) * initDeclNodeListBASESIZE);

  return (s);
}

static void
initDeclNodeList_grow (initDeclNodeList s)
{
  int i;
  initDeclNode *newelements;

  s->nspace = initDeclNodeListBASESIZE + s->nspace;
  newelements = (initDeclNode *) dmalloc (sizeof (*newelements)
					  * (s->nelements + initDeclNodeListBASESIZE));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

initDeclNodeList
initDeclNodeList_add (initDeclNodeList s, initDeclNode el)
{
  if (s->nspace <= 0)
    initDeclNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ cstring
initDeclNodeList_unparse (initDeclNodeList s)
{
  cstring st = cstring_undefined;
  bool first = TRUE;

  initDeclNodeList_elements (s, current)
  {
    if (first)
      {
	first = FALSE;
	st = declaratorNode_unparse (current->declarator);
      }
    else
      {
	st = message ("%q, %q", st, declaratorNode_unparse (current->declarator));
      }

    if (current->value != (termNode) 0)
      {
	st = message ("%q = %q", st, termNode_unparse (current->value));
      }
  } end_initDeclNodeList_elements;

  return st;
}

void
initDeclNodeList_free (initDeclNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      initDeclNode_free (s->elements[i]);
    }

  sfree (s->elements);
  sfree (s);
}
