#ifndef MP_EDITOR_H
#define MP_EDITOR_H
/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
********************************************************************/
/* editor.h */


extern void display_left(KEYCODE,Index);
extern void display_right(KEYCODE,Index);
extern void up(KEYCODE,Index);
extern void down(KEYCODE,Index);
extern void forward_char(KEYCODE,Index);
extern void backward_char(KEYCODE,Index);
extern void forward_line(KEYCODE,Index);
extern void backward_line(KEYCODE,Index);
extern void begin_of_line(KEYCODE,Index);
extern void end_of_line(KEYCODE,Index);
extern void scroll_up(KEYCODE,Index);
extern void scroll_down(KEYCODE,Index);
extern void recenter(KEYCODE,Index);
extern void move_to_center(KEYCODE,Index);
extern void begin_of_buffer(KEYCODE,Index);
extern void end_of_buffer(KEYCODE,Index);
extern void forward_word(KEYCODE,Index);
extern void backward_word(KEYCODE,Index);
extern void transpose_chars(KEYCODE,Index);
extern void transpose_words(KEYCODE,Index);
extern void upcase_word(KEYCODE,Index);
extern void downcase_word(KEYCODE,Index);

extern void next_node_or_text(KEYCODE, Index);
extern void next_node_or_insert(KEYCODE, Index);
extern void next_node_insert(KEYCODE, Index);
extern void openparen_insert(KEYCODE, Index);
extern void closeparen_insert(KEYCODE, Index);
extern void make_list_insert(KEYCODE, Index);
extern void insert_char(KEYCODE,Index);
extern void insert_string(char *);
extern void insert_expr(KEYCODE,Index);
extern void insert_text(KEYCODE,Index);
extern void insert_disp(KEYCODE,Index);
extern void insert_var(KEYCODE,Index);
extern void insert_id(KEYCODE,Index);
extern void insert_op(KEYCODE,Index);
extern void insert_newline(KEYCODE,Index);
extern void insert_hard_newline(KEYCODE,Index);
extern void insert_rtab(KEYCODE,Index);
extern void insert_symbol(KEYCODE,Index);

extern void backward_remove_char(KEYCODE,Index);
extern void forward_remove_char(KEYCODE,Index);
extern void remove_double_chars(KEYCODE,Index);
extern void remove_region(KEYCODE,Index);
extern void kill_region(KEYCODE,Index);
extern void kill_word(KEYCODE,Index);
extern void backward_kill_word(KEYCODE,Index);
extern void kill_line(KEYCODE,Index);
extern void backward_kill_line(KEYCODE,Index);
extern void append_next_kill(KEYCODE, Index);
extern void yank(KEYCODE,Index);

extern void set_index_nr(KEYCODE,Index);
extern void increase_spacing(KEYCODE,Index);
extern void decrease_spacing(KEYCODE,Index);
extern void reset_spacing(KEYCODE,Index);
extern void raise_node(KEYCODE,Index);
extern void lower_region(KEYCODE,Index);
extern void copy_region(KEYCODE,Index);
extern void swap_region(KEYCODE,Index);
extern void set_parens(KEYCODE,Index);
extern void unset_parens(KEYCODE,Index);
extern void clear_parens(KEYCODE,Index);
extern void switch_parens(KEYCODE,Index);
extern void insert_notation(Index);
extern void rename_id(KEYCODE,Index);
extern void apply(KEYCODE,Index);
extern void distribute(KEYCODE,Index);
extern void factorise(KEYCODE,Index);
extern void commute(KEYCODE,Index);
extern void goto_latex_line(KEYCODE,Index);
extern void latex_text_only(Bool tonly);
extern void latex_selection(int selnum);

extern void join_selections(KEYCODE,Index);
extern void swap_selections(KEYCODE,Index);
extern void unset_select(KEYCODE,Index);
extern int  ps_notation(Index *vnr);
extern int  ss_notation(Index *vnr);
extern int  ps_id_font(void);
extern void new_id_font(Index nfnr);
extern void new_version(Index nnnr);
extern void stack_position(void);
extern void use_stack(void);
extern void clear_stack(void);
extern void clear_stack_and_use(void);
extern Bool check_find(void);
extern Bool check_find_replace(void);
extern Bool find_tree(void);
extern void replace_tree(void);
extern void replace_all_tree(void);
extern void remove_find_stack(void);
extern void find_prev_on_stack(void);
extern void find_next_on_stack(void);
extern void find_new_on_stack(void);
extern int  get_findrep(Char *, int*,int);
extern int  put_findrep(void);
extern Bool find_string(Char *);
extern Bool find_backward_string(Char*);
extern Bool findprev_string(Char *);
extern Bool findnext_string(Char *);
extern Bool findwrap_backward_string(Char *);
extern Bool findwrap_string(Char *);
extern Bool find_replace(Char *);
extern Bool findnext_replace(Char *);
extern void replace_string(Char *, Char *);
extern void replace_all(Char *, Char *);
extern Bool find_stencil(Index);
extern Bool find_backward_stencil(Index);
extern Bool findprev_stencil(Index);
extern Bool findnext_stencil(Index);
extern Bool findwrap_backward_stencil(Index);
extern Bool findwrap_stencil(Index);
extern Bool find_replace_stencil(Index);
extern Bool findnext_replace_stencil(Index);
extern void replace_notation(Index,Index);
extern void replace_all_notation(Index, Index);

extern void draw(void *);
extern void update_selections(void);
extern void redraw_window(void*);
extern void word_wrap_window(void*);
extern void word_wrap_selection(int);
extern void clear_tab_positions(void);
extern void resize_window(void*,int,int);
extern void other_window(void*);
extern void editwindow_line(void*,int);
extern void editwindow_topto(void*, Char*);
extern int line_number(void *);
extern int number_of_lines(void*);

extern void *open_miniwindow(void*,int,int);
extern void *open_scratchwindow(void*,int,int);
extern void close_scratchwindow(void);
extern void *open_findwindow(void*,int,int);
extern void close_findwindow(void);
extern void *open_replacewindow(void*,int,int);
extern void close_replacewindow(void);
extern void *open_editwindow(void*,int,int);
extern void close_editwindow(void*);
extern void old_load_editwindow(void*,FILE*);
extern void old_include_editwindow(void*, FILE*);
extern void append_editwindow(void*, char *, int);
extern void load_editwindow(void*);
extern void include_editwindow(void*);
extern void include_selection(void);
extern void save_editwindow(void*);
extern Bool window_changed(void*);
extern Bool window_empty(void*);
extern void latex_editwindow(void*);
extern void clear_window(void*);
extern int  get_node(Char*,int*,int);
extern int  get_ascii_node(Char*,int*,int);
extern void cleanup_nodestack(void);
extern void *make_node(Char type, Char *txt, int len, int nnr, int spacing);
extern void join_parse_stack(void);
extern void *add_parse_stack(Char *txt, int len);

extern void mouse_down(void*,int,int, Index button);
extern void mouse_move(int, int);
extern void mouse_up(int,int);
extern void dbl_click(void);

extern Bool move_selection;
#endif
