/* Included headerfiles */
#include "thot_gui.h"
#include "thot_sys.h"
#include "constmenu.h"
#include "constmedia.h"
#include "typemedia.h"
#include "app.h"
#include "appdialogue.h"
#include "interface.h"
#include "EDITOR.h"
#include "tree.h"
#include "constcorr.h"
#include "libmsg.h"
#include "thotmsg.h"
#include "corrmsg.h"
#include "dialog.h"
#include "application.h"
#include "document.h"
#include "message.h"
#include "view.h"
#include "boutons_f.h"
#include "structlist_f.h"
#include "createabsbox_f.h"
#undef THOT_EXPORT
#define THOT_EXPORT
#include "EDITORactions.h"
#undef THOT_EXPORT
#define THOT_EXPORT extern
#include "edit_tv.h"
#include "print_tv.h"
#include "appdialogue_tv.h"
#include "platform_tv.h"
#include "boxes_tv.h"
#include "modif_tv.h"



#include "EDITOR.h"

static char		BufZone[MAX_PATH];
static PtrSSchema	TableNaturesSchPresent[NbMaxMenuPresNature];
static PtrDocument      pDocChangeSchPresent;
static int		nbNatures;
static Document		HelpDocument;
static int              newShowSpace;

#include "opendoc_f.h"
#include "initdraw_f.h"
#include "viewapi_f.h"
#include "views_f.h"
#include "config_f.h"
#include "docs_f.h"
#include "search_f.h"
#include "savedoc_f.h"
#include "viewcommands_f.h"
#include "paginate_f.h"
#include "searchmenu_f.h"
#include "structcreation_f.h"


/* call back des evenements de l'application */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
void                ThotEditorCallback (int ref, int datatype, char *data);

#else  /* __STDC__ */
void                ThotEditorCallback (ref, datatype, data);
int                 ref;
int                 datatype;
char               *data;

#endif

/* ---------------------------------------------------------------------- */
/* |    ButtonSheet ajoute dans le buffer pointe par BufMenu, apres la  | */
/* |           position Indx, la chaine de caracteres Entree.           | */
/* |           Au retour Indx indique la derniere position occupee dans | */
/* |           le buffer a` la fin de la chaine ajoutee.                | */
/* ---------------------------------------------------------------------- */

#ifdef __STDC__
void                ButtonSheet (int *Indx, char *Entree, char BufMenu[MAX_TXT_LEN])

#else  /* __STDC__ */
void                ButtonSheet (Indx, Entree, BufMenu)
int                *Indx;
char               *Entree;
char                BufMenu[MAX_TXT_LEN];

#endif /* __STDC__ */

{
    int             longueur;

    longueur = strlen(Entree) + 1;
    if(longueur + *Indx < MAX_TXT_LEN)
      {
	strcpy((BufMenu) + *Indx, Entree);
        *Indx += longueur;
      }
  }

/* ----------------------------------------------------------------------
  ThotOpenFirstDoc : opens the documents given on command line
  ---------------------------------------------------------------------- */
#ifdef __STDC__
void ThotOpenFirstDoc(int argc, char **argv)
#else /*__STDC__*/
void ThotOpenFirstDoc(argc, argv)
int argc;
char **argv;
#endif /*__STDC__*/
{
  int i;
  char CurDir[MAX_LEN_ALL_CONST];
  char DocumentName[MAX_LEN_ALL_CONST];
  char PathDoc[MAX_LEN_ALL_CONST];
  char *lastsl;
  Document Doc;
  PtrDocument pDoc;
  boolean ok= False;
 
  TtaSetErrorMessages(0);
  for (i=1;i<argc;i++)
    {
      if (!strcmp(argv[i],"-display"))
	i++;
      else
        {
          if((lastsl=strrchr(argv[i],'/'))!=NULL)
	    {
            CurDir[0]='\0';
	    if(argv[i][0]!='/')
              {
               getcwd(CurDir,MAX_LEN_ALL_CONST);
	       strcat(CurDir,"/");
	      }
            strncat(CurDir,argv[i],(int)(lastsl-argv[i]));
            /* verifier que CurDir appartient au document path */
           if(TtaCheckDirectory(CurDir))
            {
            ok = True;
	    if(!TtaIsInDocumentPath(CurDir))
             {
	       /* si non l'ajouter */
               TtaGetDocumentPath(PathDoc,MAX_LEN_ALL_CONST);
               strcat(PathDoc,":");
               strcat(PathDoc,CurDir);
               TtaSetDocumentPath(PathDoc);
	     }
	    strcpy(DocumentName,lastsl+1);
            }
	  }
         else
          {
           ok = True;
	   strcpy(DocumentName,argv[i]);
          }
        if(ok)
          {
            Doc=TtaOpenDocument (DocumentName,1);
	    if(TtaGetErrorCode()==0)
              {
                pDoc = LoadedDocument[Doc - 1];
                OpenDefaultViews (pDoc); 
              }
          }
       }
    }
}              

/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/* | Actions liees aux evenements de EDITOR.I (section DEFAULT)		| */
/* ---------------------------------------------------------------------- */

/* initialisation de l'editeur thot */
#ifdef __STDC__
void InitThot(NotifyEvent *event)
#else /* __STDC__*/
void InitThot(event)
     NotifyWindow *event;
#endif /* __STDC__*/
{
  HelpDocument=(Document)0;
  BaseAppli = TtaSetCallback((Proc)ThotEditorCallback,MyMaxDialogue);
  indexTable = TtaGetMessageTable("thotmessage",THOT_MAX_MSG);
  InitDraw();
  /* ouvrir le document donne sur la ligne de commande (appArgc, appArgv) */
  ThotOpenFirstDoc(appArgc,appArgv);
}

/* ---------------------------------------------------------------------- */
/* | ApresOuvreVue  Appellee a chaque ouverture de vue cette fonction	| */
/* |	efface la ligne de commande et 	desactive les entrees de menu	| */
/* |	 inutiles							| */  
/* ---------------------------------------------------------------------- */

#ifdef __STDC__
void ApresOuvreVue(NotifyDialog *event)
#else /* __STDC__*/
void ApresOuvreVue(event)
     NotifyDialog *event;
#endif /* __STDC__*/
{  
  PtrDocument   pDoc;
  boolean	Assoc;
  int		frame, Vue;
  char         *dbgmode;

  frame = GetWindowNumber(event->document, event->view);
  GetDocAndView(frame, &pDoc, &Vue, &Assoc);
  
  /* disable command Bar */
    TtcSwitchCommands(event->document, event->view);
  /* disable list menu if not in debug mode */
  dbgmode=TtaGetEnvString("DEBUG");
  if(dbgmode == NULL || strcasecmp(dbgmode,"yes"))
     TtaSetActionOff(event->document,event->view,Present,BList);
  /* disable menus if document is read-only */
  if(TtaGetDocumentAccessMode(event->document)==0)
    {
      TtaSetActionOff(event->document,event->view,DocFile,BSave);
      TtaSetActionOff(event->document,event->view,DocFile,BSaveAs);
      TtaSetActionOff(event->document,event->view,DocFile,BAutosave);
      TtaSetActionOff(event->document,event->view,Edit,BInsert);
      TtaSetActionOff(event->document,event->view,Edit,BPaste);
      TtaSetActionOff(event->document,event->view,Edit,BFromX);
      TtaSetActionOff(event->document,event->view,Edit,BCut);
      TtaSetActionOff(event->document,event->view,Edit,BDelete);
      TtaSetActionOff(event->document,event->view,Edit,BInclude);
      TtaSetActionOff(event->document,event->view,Edit,Transform);
      TtaSetActionOff(event->document,event->view,Edit,BHolophraste);
      TtaSetActionOff(event->document,event->view,Edit,BSpellCheck);
      TtaSetActionOff(event->document,event->view,Page,BInsertPB);
      TtaSetActionOff(event->document,event->view,Page,BPaginateDoc);
      TtaSetActionOff(event->document,event->view,Page,BPaginateView);
      TtaSetActionOff(event->document,event->view,Tools,BIndex);
    }
  if (!PaginatedView(pDoc, Vue, Assoc))
    {
      TtaSetMenuOff(event->document,event->view,Page);
   /*    TtaSetMenuOff(event->document,event->view,); */
    }
  /* ajoute les boutons dessin si le document est ou contient un draw3 */
  if((TtaGetSSchema("Draw3", event->document)!=NULL ) &&
     (TtaGetDocumentAccessMode(event->document)))
          DrawShowTools(event->document);
  /* desactive les boutons si le schema principal du document n'est pas Draw3 */
  if(strcmp(TtaGetSSchemaName(TtaGetDocumentSSchema(event->document)),"Draw3"))
    DrawHideTools(event->document); 
}

/* ---------------------------------------------------------------------- */
/* |    AvantFermeDoc appelee avant chaque fermeture de document      | */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
boolean AvantFermeDoc(NotifyDialog *event)
#else /* __STDC__*/
boolean AvantFermeDoc(event)
     NotifyDialog *event;
#endif /* __STDC__*/
{
 if(HelpDocument == event->document)
   HelpDocument=0;
 DrawCloseDoc(event->document);
 return False;
}

/* ---------------------------------------------------------------------- */
/* |    ApreSelEl appelee apres chaque selection d'element      | */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
void ApresSelEl(NotifyElement *event)
#else /* __STDC__*/
void ApresSelEl(event)
     NotifyElement *event;
#endif /* __STDC__*/
{
  ElementType ElTypeNumber;

  ElTypeNumber = TtaGetElementType(event->element);
  if((strcmp(TtaGetSSchemaName(ElTypeNumber.ElSSchema),"Draw3")) ||
     (TtaIsReadOnly(event->element)))
    DrawHideTools(event->document);
  else
    DrawShowTools(event->document);

}

/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/* |  Retours des menus de thot						| */
/* ---------------------------------------------------------------------- */

/* ---------------------------------------------------------------------- */
/* |    RetMenuDirSchemas traite les retours du formulaire Dossier      | */
/* |           Schemas                                                  | */
/* ---------------------------------------------------------------------- */

#ifdef __STDC__
void                RetMenuDirSchemas (char *Text)

#else  /* __STDC__ */
void                RetMenuDirSchemas (Text)
char               *Text;

#endif /* __STDC__ */

{
   int                 i;

   if (strcmp (SchemaPath, Text) != 0)
     {
	strncpy (SchemaPath, Text, MAX_PATH);
	for (i = 0; i < MAX_PATH && SchemaPath[i] != '\0'; i++)
	   if (SchemaPath[i] == '\n')
	      SchemaPath[i] = PATH_SEP;
	if (TtaCheckPath (SchemaPath))
	  {
	     TtaDisplaySimpleMessage (LIB, INFO, TMSG_MODIFYING_DIR_LIST);
	     /* le directory a ete change' */
	     /* relit les fichiers de configuration */
	     ConfigReadConfigFiles ();
	     /* met a jour le registry */
	     TtaSetEnvString ("THOTSCH", SchemaPath, 1);
	  }
     }
   TtaDestroyDialogue (BaseAppli + MyNumFormDirSchemas);
}


/* ---------------------------------------------------------------------- */
/* |    RetMenuDirDocuments     traite les retours du formulaire Dossier| */
/* |                            Documents                               | */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
void                RetMenuDirDocuments (char *Text)

#else  /* __STDC__ */
void                RetMenuDirDocuments (Text)
char               *Text;

#endif /* __STDC__ */

{
   int                 i;

   if (strcmp (DocumentPath, Text) != 0)
     {
	strncpy (DocumentPath, Text, MAX_PATH);
	for (i = 0; i < MAX_PATH && DocumentPath[i] != '\0'; i++)
	   if (DocumentPath[i] == '\n')
	      DocumentPath[i] = PATH_SEP;
	if (TtaCheckPath (DocumentPath))
	  {
	     TtaDisplaySimpleMessage (LIB, INFO, TMSG_MODIFYING_DIR_LIST);
	     /* le directory a ete change' : met a jour le registry */
	     TtaSetEnvString ("THOTDOC", DocumentPath, 1);
	  }
     }
   TtaDestroyDialogue (BaseAppli + MyNumFormDirDocuments);
}
/* ---------------------------------------------------------------------- */
/* |     Setschemapath : retour du menu Repertoires schemas... afiiche le formulaire    | */
/* |            des repertoires schemas                                         | */
/*---------------------------------------------------------------------- */
#ifdef __STDC__
void Setschemapath(Document document, View view)
#else /* __STDC__*/
void Setschemapath(document, view)
     Document document;
     View view;
#endif /* __STDC__*/
{
  char		BufDir[MAX_PATH];
  int i;

  /* Formulaire Dossiers schemas */
  /* +++++++++++++++++++++++++++ */
  TtaNewForm (BaseAppli+MyNumFormDirSchemas,  0,
	    TtaGetMessage(indexTable, SCHEMA_DIRECTORIES), True, 2 ,'L',D_CANCEL);
  
  /* zone de saisie des dossiers schemas */
  TtaNewTextForm(BaseAppli+MyNumZoneDirSchemas, BaseAppli+MyNumFormDirSchemas,
		TtaGetMessage(indexTable, SCHEMA_DIRECTORIES), 40, 4, False);
  strncpy(BufDir, SchemaPath, MAX_PATH);
  /* remplace ':' par '\n' pour le formulaire de saisie des schemas */
  for (i = 0; i < MAX_PATH && BufDir[i] != '\0'; i++)
    if (BufDir[i] == ':')
      BufDir[i] = '\n';
  TtaSetTextForm(BaseAppli+MyNumZoneDirSchemas, BufDir);
    TtaShowDialogue(BaseAppli+MyNumFormDirSchemas,True);

}


/* ---------------------------------------------------------------------- */
/* |     Setschemapath : retour du menu Repertoires documents... afiiche le formulaire          | */
/* |            des repertoires documents                                               | */
/*---------------------------------------------------------------------- */
#ifdef __STDC__
void Setdocumentpath(Document document, View view)
#else /* __STDC__*/
void Setdocumentpath(document, view)
     Document document;
     View view;
#endif /* __STDC__*/
{
  char		BufDir[MAX_PATH];
  int i;

  /* Formulaire Dossiers documents */
  /* +++++++++++++++++++++++++++++ */
  
  TtaNewForm (BaseAppli+MyNumFormDirDocuments,  0,
	    TtaGetMessage(LIB, TMSG_DOC_DIR), True, 2 ,'L',D_CANCEL);
  
  /* zone de saisie des dossiers documents */
  TtaNewTextForm(BaseAppli+MyNumZoneDirDocuments, BaseAppli+MyNumFormDirDocuments,
		TtaGetMessage(LIB, TMSG_DOC_DIR), 40, 4, False);
  strncpy(BufDir, DocumentPath, MAX_PATH);
  /* remplace ':' par '\n' pour le formulaire de saisie des documents */
  for (i = 0; i < MAX_PATH && BufDir[i] != '\0'; i++)
    if (BufDir[i] == ':')
      BufDir[i] = '\n';
  TtaSetTextForm(BaseAppli+MyNumZoneDirDocuments, BufDir);
  TtaShowDialogue(BaseAppli+MyNumFormDirDocuments,True);
}

/* ---------------------------------------------------------------------- */
/* Retour du menu lister		 */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
void LocLister(Document document, View view)
#else /* __STDC__ */
void LocLister(document,view)
Document document;
View view;
#endif /* __STDC__ */
{
  int Indx;
  char            BufMenu[MAX_TXT_LEN];

  FenetreALister = GetWindowNumber(document, view);
  /* formulaire Lister (mode debug seulement) */
  TtaNewForm (BaseAppli+MyNumFormLister,  0, TtaGetMessage(indexTable, LIST), False, 2, 'L',D_CANCEL);
   /* zone de saisie du nom du fichier liste a creer */
   TtaNewTextForm (BaseAppli + MyNumZoneNomFichierListe, BaseAppli + MyNumFormLister,
		   TtaGetMessage (indexTable, FILE_NAME), 30, 1, False);
   if (FenetreALister == 0)
      /* frame de l'application, c'est la commande Lister Memoire */
     {
	TypeFichierListe = 4;
     }
   else
      /* frame document, cree le sous-menu des types de listes */
     {
	Indx = 0;
	sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (indexTable, ABSTRACT_TREE));
	Indx += strlen (&BufMenu[Indx]) + 1;
	sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (indexTable, STATISTICS));
	Indx += strlen (&BufMenu[Indx]) + 1;
	sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (indexTable, ABSTRACT_IMAGE));
	Indx += strlen (&BufMenu[Indx]) + 1;
	sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (indexTable, MEMORY_OCCUPATION));
	Indx += strlen (&BufMenu[Indx]) + 1;
	sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (indexTable, BOXES));
	TtaNewSubmenu (BaseAppli + MyNumMenuTypeListe, BaseAppli + MyNumFormLister, 0, TtaGetMessage (indexTable, LIST),
		       5, BufMenu, NULL, False);
	TtaSetMenuForm (BaseAppli + MyNumMenuTypeListe, 0);
     }
   /* affiche le dialogue */
   TtaShowDialogue (BaseAppli + MyNumFormLister, False);
}

/* ---------------------------------------------------------------------- */
/* |  ListCommand                                               | */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
void ListCommand(PtrDocument pDoc, int nv, boolean assoc, Name NomFichierListe, int TypeFichierListe)
#else /* __STDC__ */
void ListCommand(pDoc, nv, assoc, NomFichierListe, TypeFichierListe)
        PtrDocument pDoc;
        int nv;
        boolean assoc;
        Name NomFichierListe;
        int TypeFichierListe;
#endif /* __STDC__ */
{
        PtrPasteElem  pDEC;
        int             a;
	FILE           *list;

        if (TypeFichierListe != 4)
           if (pDoc == NULL)
              {
                /* il n'y a pas de vue active, abandon */
                TypeFichierListe = 0;
              }
           else
              /* ce n'est pas une liste de la memoire */
              if (pDoc->DocRootElement == NULL)
                 {
                    TypeFichierListe = 0;
		    /* message: 'Document vide' */
		    TtaDisplaySimpleMessage (INFO, LIB, TMSG_EMPTY_DOC);
		 }
        /* cree le fichier de sortie de la liste */
        list = fopen(NomFichierListe,"w");
        if (list == NULL)
          {
            /* ouverture du fichier impossible */
            TtaDisplayMessage(INFO, LIB, TMSG_WRITING_IMP,NomFichierListe);
            TypeFichierListe = 0;
          }

        if (TypeFichierListe != 0)
           {
             switch (TypeFichierListe)
               {
                 case 1: /* Lister les arbres abstraits du document */
                 case 2: /* Lister les statistiques sur les arbres abstraits */
                    fprintf(list, "document %s\n\n", pDoc->DocDName);
                    if (assoc)
                       /* on liste une fenetre d'elements associes */
                       if (TypeFichierListe == 1)
                         TtaListAbstractTree((Element)pDoc->DocAssocRoot[nv - 1], list);
                       else
                         /* Lister les statistiques d'un arbre abstrait */
                         CountNodes(pDoc->DocAssocRoot[nv-1], list, 0);
                    /* Liste l'arbre principal */
                    else
                    {
                       if (TypeFichierListe == 1)
                         TtaListAbstractTree((Element)pDoc->DocRootElement, list)
;
                       else
                         CountNodes(pDoc->DocRootElement, list, 0);
                       /* Liste les arbres d'elements associes qui s'affichent */
		       /* dans les hauts et bas de page de la vue choisie */
                       for (a = 1; a <= MAX_ASSOC_DOC; a++)
                          if (pDoc->DocAssocRoot[a-1]!= NULL)
                             if (!AssocView(pDoc->DocAssocRoot[a-1]->ElFirstChild))
                                if (TypeFichierListe == 1)
                                  TtaListAbstractTree((Element)pDoc->DocAssocRoot[a-1], list);
                                else
                                  CountNodes(pDoc->DocAssocRoot[a-1], list, 0);
                       /* Liste le contenu du tampon Couper-Copier-Coller */
                       if (TypeFichierListe == 1)
                       {
                          fprintf(list, "\n");
                          fprintf(list, "---- Scrapbook ----\n");
                          if (FirstSavedElement == NULL)
                             fprintf(list, "Empty\n");
                          else
                          {
                             pDEC = FirstSavedElement;
                             do
                             {
                                TtaListAbstractTree((Element)(pDEC->PeElement), list);
                                pDEC = pDEC->PeNext;
                             }
                             while (pDEC != NULL);
                          }
                       }
                    }
                    break;
                 case 3:        /* Lister les paves de la vue */
                    if (nv > 0 && !assoc)
                    {
                       NumberAbsBoxes(pDoc->DocViewRootAb[nv - 1]);
                       ListAbsBoxes(pDoc->DocViewRootAb[nv - 1], 0, list);
                    }
                    else
                       if (pDoc->DocAssocRoot[nv - 1] != NULL && assoc)
			 {
			 NumberAbsBoxes (pDoc->DocAssocRoot[nv - 1]->ElAbstractBox[0]);
			 ListAbsBoxes (pDoc->DocAssocRoot[nv - 1]->ElAbstractBox[0], 0,list);
                       }
                    break;
                 case 4:        /* Occupation memoire */
		   /*   ListeMem(list); */
		   /*  StatMedia(list); */
                    break;
                 case 5:        /* Liste de toutes les boites */
                    if (assoc)

                       ListBoxes(pDoc->DocAssocFrame[nv - 1], list);
                    else

                       ListBoxes(pDoc->DocViewFrame[nv - 1], list)
;
                    break;
               }                    /* end case TypeFichierListe */

            /* termine le fichier */
            fclose(list);

         }
}

/* ---------------------------------------------------------------------- */
/* |    RetMenuLister traite les retours du formulaire Lister.          | */
/* |            liste la structure interne ou le contenu des buffers de | */
/* |            texte ou encore l'arbre des paves.                      | */
/* |            Fonction de mise au point.                              | */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
static void         RetMenuLister (int ref, int val, char *txt)

#else  /* __STDC__ */
static void         RetMenuLister (ref, val, txt)
int                 ref;
int                 val;
char               *txt;

#endif /* __STDC__ */

{
   PtrDocument         pDoc;
   int                 nv;
   boolean             assoc;

   switch (ref - BaseAppli)
	 {
	    case MyNumMenuTypeListe:
	       /* menu type de liste */
	       if (val > 0)
		  /* l'utilisateur a donne' une reponse */
		  TypeFichierListe = val;
	       break;
	    case MyNumZoneNomFichierListe:
	       /* nom du fichier liste a produire */
	       if (txt != NULL)
		  if (txt[0] != '\0')
		     /* l'utilisateur a fourni un nom */
		     strncpy (NomFichierListe, txt, MAX_NAME_LENGTH);
	       break;
	    case MyNumFormLister:
	       /* le formulaire Lister */
	       if (TypeFichierListe != 0 && NomFichierListe[0] != '\0')
		 {
		    /* cherche le document et la vue concernes, sauf pour la */
		    /* commande "Lister memoire" */
		    if (TypeFichierListe != 4)
		       GetDocAndView (FenetreALister, &pDoc, &nv, &assoc);
		    if (pDoc != NULL)
		      ListCommand (pDoc, nv, assoc, NomFichierListe, 
				   TypeFichierListe);
		 }
	       FenetreALister = 0;
	       break;
	 }
}

/* ---------------------------------------------------------------------- */
/* |             intialise et affiche le formulaire de saisie de | */
/* |                    l'intervalle de sauvegarde automatique, sauf si | */
/* |                    le document est en lecture seule.               | */

/* -------------------------------------------------------------- */
#ifdef __STDC__
void LocSetBackupInterval(Document document, View view)
#else /* __STDC__*/
void LocSetBackupInterval(document, view)
     Document document;
     View view;
#endif /* __STDC__*/
{
  PtrDocument pDoc;

  pDoc = LoadedDocument[document - 1];
  if (!pDoc->DocReadOnly)
    {
      TtaNewForm (BaseAppli+MyNumFormAutoSave,  0,
		 TtaGetMessage(indexTable, AUTOSAVE), False, 1, 'L',D_CANCEL);
      TtaNewNumberForm(BaseAppli+MyNumZoneAutoSave, BaseAppli+MyNumFormAutoSave,
		       TtaGetMessage(indexTable, NUMBER_OF_CHAR_BEFORE_SAVE), 
		       0, 32000, False);
      DocSaveInterval = pDoc;
      TtaSetNumberForm(BaseAppli+MyNumZoneAutoSave, pDoc->DocBackUpInterval);
      TtaShowDialogue(BaseAppli+MyNumFormAutoSave, False);
    }
}

/* ---------------------------------------------------------------------- */
/* |    RetMenuAutoSave traite le retour du formulaire de saisie de     | */
/* |                    l'intervalle de sauvegarde automatique          | */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
void                RetMenuAutoSave (int val)

#else  /* __STDC__ */
void                RetMenuAutoSave (val)
int                 val;

#endif /* __STDC__ */

{
   if (DocSaveInterval != NULL)
      if (DocSaveInterval->DocSSchema != NULL)
	 /* le document concerne' existe toujours */
	 if (val >= 32000 || val <= 0)
	    DocSaveInterval->DocBackUpInterval = 0;
   /* pas de sauvegarde automatique */
	 else
	    DocSaveInterval->DocBackUpInterval = val;

}

/* -------------------------------------------------------------- */
#ifdef __STDC__
void                LocPaginateDocument (Document document, View view)
#else  /* __STDC__ */
void                LocPaginateDocument (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   PtrDocument         pDoc;

   pDoc = LoadedDocument[document - 1];
   PaginateDocument (pDoc);
}

/* -------------------------------------------------------------- */
#ifdef __STDC__
void                LocChangePresentation (Document document, View view)
#else  /* __STDC__ */
void                LocChangePresentation (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
#define LgMaxTableNature 20
   PtrSSchema        TableNatures[LgMaxTableNature];
   int                 entreeDesact[LgMaxTableNature];
   int                 LgTableNatures;
   int                 nbPres;
   char                BufMenuNatures[MAX_TXT_LEN];
   char                BufMenu[MAX_TXT_LEN];
   char                BufMenuB[MAX_TXT_LEN];
   char               *ptrBufNat;
   char               *src;
   char               *dest;
   int                 nat;
   int                 NumSousMenu;
   int                 MenuAActiver;
   int                 i, k, l;
   Name                 NomPres;
   char                NomUtilisateur[50];
   PtrDocument         pDoc;

   pDoc = LoadedDocument[document - 1];
   MenuAActiver = 0;
   /* conserve un pointeur sur le contexte du document dont on veut */
   /* changer le schema de presentation */
   pDocChangeSchPresent = pDoc;
   /* met d'abord le schema de structure du document dans la table */
   /* des natures du document */
   TableNatures[0] = pDoc->DocSSchema;
   LgTableNatures = 1;
   /* met ensuite la liste des natures utilisees dans le document */
   SearchNatures (pDoc->DocSSchema, TableNatures, &LgTableNatures, True);
   /* construit un pop-up menu pour la liste des natures dont on */
   /* peut changer le schema de presentation */
   ptrBufNat = &BufMenuNatures[0];
   nbNatures = 0;
   for (nat = 0; nat < LgTableNatures; nat++)
     {
	entreeDesact[nat] = 0;
	/* demande la liste des schemas de presentation definis */
	/* pour cette nature dans la configuration de l'utilisateur */
	nbPres = ConfigMakeMenuPres (TableNatures[nat]->SsName, NULL);
	if (nbPres == 0)
	   /* pas de schema de presentation defini */
	   TableNatures[nat] = NULL;
	else
	   /* il y a des schemas de presentation definis pour cette nature */
	  {
	     /* on cherche dans cette liste le schema de presentation utilise' */
	     /* actuellement dans le document */
	     for (k = 1; k <= nbPres && entreeDesact[nat] == 0; k++)
	       {
		  /* demande le nom reel du schema de presentation */
		  ConfigGetPSchemaName (k, NomPres);
		  if (strcmp (TableNatures[nat]->SsPSchema->PsPresentName,
			      NomPres) == 0)
		     /* c'est le nom du schema de presentation actuel */
		     /* on desactivera l'entree correspondante dans le sous-menu */
		     /* des schemas de presentation de cette nature */
		     entreeDesact[nat] = k;
	       }
	     if (nbPres == 1 && entreeDesact[nat] != 0)
		/* il n'y a qu'un schema de presentation prevu par la */
		/* configuration et c'est celui qui est utilise' actuellement. */
		/* On ne peut donc pas changer de schema pour cette nature */
		TableNatures[nat] = NULL;
	     else if (nbNatures >= NbMaxMenuPresNature)
		/* saturation, on arrete */
		nat = LgTableNatures;
	     else
		/* on ajoute cette nature dans le menu en construction */
	       {
		  nbNatures++;
		  *ptrBufNat = 'M';	/* il y aura un sous-menu */
		  ptrBufNat++;
		  if (TableNatures[nat] == pDoc->DocSSchema)
		     i = 1;	/* schema du document */
		  else if (TableNatures[nat]->SsExtension)
		     i = 3;	/* schema d'extension */
		  else
		     i = 2;	/* schema de nature */
		  ConfigSSchemaExternalName (NomUtilisateur,
					   TableNatures[nat]->SsName, i);
		  if (NomUtilisateur[0] == '\0')
		     strcpy (ptrBufNat, TableNatures[nat]->SsName);
		  else
		     strcpy (ptrBufNat, NomUtilisateur);
		  l = strlen (ptrBufNat) + 1;
		  ptrBufNat += l;
	       }
	  }
     }
   if (nbNatures > 0)
      /* il y a au moins une nature dont on peut changer le schema de */
      /* presentation */
     {
	/* on cree le menu de ces natures s'il y en a plus d'une */
	if (nbNatures > 1)
	  {
	     TtaNewPopup (BaseAppli + MyNumMenuPresNature, 0, TtaGetMessage (indexTable, GLOBAL_LAYOUT),
			  nbNatures, BufMenuNatures, NULL, 'L');
	     MenuAActiver = BaseAppli + MyNumMenuPresNature;
	  }
	/* pour chacune de ces natures, on cree les sous-menus des */
	/* presentation prevues dans la configuration de l'utilisateur */
	NumSousMenu = 0;
	for (nat = 0; nat < LgTableNatures; nat++)
	   if (TableNatures[nat] != NULL)
	      /* cette entree de la table des natures n'a pas ete invalidee */
	     {
		/* demande la liste des presentations prevues dans la */
		/* configuration de l'utilisateur */
		nbPres = ConfigMakeMenuPres (TableNatures[nat]->SsName,
					     BufMenu);
		/* compose un sous-menu a partir de cette liste */
		if (nbPres > 0)
		  {
		     dest = &BufMenuB[0];
		     src = &BufMenu[0];
		     for (k = 1; k <= nbPres; k++)
		       {
			  /* ajoute 'B' au debut de chaque entree */
			  strcpy (dest, "B");
			  dest++;
			  l = strlen (src);
			  strcpy (dest, src);
			  dest += l + 1;
			  src += l + 1;
		       }
		     /* cree le sous-menu des presentations proposees pour cette */
		     /* nature */
		     NumSousMenu++;
		     if (TableNatures[nat] == pDoc->DocSSchema)
			i = 1;	/* schema du document */
		     else if (TableNatures[nat]->SsExtension)
			i = 3;	/* schema d'extension */
		     else
			i = 2;	/* schema de nature */
		     ConfigSSchemaExternalName (NomUtilisateur,
					   TableNatures[nat]->SsName, i);
		     if (NomUtilisateur[0] == '\0')
			strcpy (NomUtilisateur, TableNatures[nat]->SsName);
		     if (nbNatures == 1)
		       {
			  /* il n'y a qu'une nature, c'est un pop-up menu */
			  MenuAActiver = BaseAppli + MyNumMenuPresNature + NumSousMenu;
			  TtaNewPopup (MenuAActiver, 0, NomUtilisateur, nbPres,
				       BufMenuB, NULL, 'L');
		       }
		     else
			/* il y a plusieurs natures, c'est un sous-menu du menu */
			/* des natures */
			TtaNewSubmenu (BaseAppli + MyNumMenuPresNature + NumSousMenu,
			   BaseAppli + MyNumMenuPresNature, NumSousMenu - 1,
			     NomUtilisateur, nbPres, BufMenuB, NULL, False);
		     /* met a jour la table qui servira au retour du sous-menu */
		     TableNaturesSchPresent[NumSousMenu - 1] = TableNatures[nat];
		     /* desactive l'entree de ce sous-menu qui correspond a la */
		     /* presentation actuelle */
		     if (entreeDesact[nat] > 0)
			UnsetEntryMenu (BaseAppli + MyNumMenuPresNature + NumSousMenu,
					 entreeDesact[nat] - 1);
		  }
	     }
	/* active le pop-up menu */
	TtaSetDialoguePosition ();
	TtaShowDialogue (MenuAActiver, False);
     }
}


/* ---------------------------------------------------------------------- */
/* |    RetMenuSchPresent traite les retours du menu des schemas de     | */
/* |            presentation                                            | */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
static void         RetMenuSchPresent (int ref, int val)

#else  /* __STDC__ */
static void         RetMenuSchPresent (ref, val)
int                 ref;
int                 val;

#endif /* __STDC__ */

{
   Name                 newpres;
   int                 nbPres;
   int                 nat;

   nat = ref - (BaseAppli + MyNumMenuPresNature) - 1;
   if (val > 0 && nat >= 0)
      if (pDocChangeSchPresent != NULL)
	 if (pDocChangeSchPresent->DocSSchema != NULL)
	    /* le document est toujours present */
	   {
	      nbPres = ConfigMakeMenuPres (TableNaturesSchPresent[nat]->SsName, NULL);
	      if (nbPres > 0)
		{
		   if (pDocPrint == pDocChangeSchPresent)
		     {
			/* le document pour lequel a ete construit le formulaire */
			/* d'impression change au moins un de ses schemas de */
			/* presentation. Ce formulaire n'est donc plus valide. */
			/* On ferme le formulaire s'il est present sur l'ecran */
			/* et on indique qu'il faudra reconstruire ce formulaire. */
			TtaDestroyDialogue (NumFormPrint);
			TtaDestroyDialogue (NumPrintingFormat);
		     }
		   /* recupere le nom du schema de presentation choisi */
		   ConfigGetPSchemaName (val, newpres);
		   if (nat == 0)
		      /* c'est le schema de presentation du doocument */
		      ChangeDocumentPSchema (pDocChangeSchPresent, newpres);
		   else
		      /* c'est une nature dans le document */
		      ChangeNaturePSchema (pDocChangeSchPresent,
				      TableNaturesSchPresent[nat], newpres);
		}
	   }
}


/* -------------------------------------------------------------- */
#ifdef __STDC__
void                LocPaginateview (Document document, View view)
#else  /* __STDC__ */
void                LocPaginateview (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   PtrDocument         pDoc;
   boolean             Assoc;
   int                 frame, Vue;


   frame = GetWindowNumber (document, view);
   GetDocAndView (frame, &pDoc, &Vue, &Assoc);
   if (PaginatedView (pDoc, Vue, Assoc))
      PaginateView (pDoc, Vue, Assoc);
}
/* -------------------------------------------------------------- */
#ifdef __STDC__
void                LocGotopage (Document document, View view)
#else  /* __STDC__ */
void                LocGotopage (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   PtrDocument         pDoc;
   boolean             Assoc;
   int                 frame, Vue;

   frame = GetWindowNumber (document, view);
   GetDocAndView (frame, &pDoc, &Vue, &Assoc);
   if ((!pDoc->DocReadOnly) && PaginatedView (pDoc, Vue, Assoc))
      BuildGoToPageMenu (pDoc, Vue, Vue, Assoc);
}
/* -------------------------------------------------------------- */
#ifdef __STDC__
void                LocInsertpagebreak (Document document, View view)
#else  /* __STDC__ */
void                LocInsertpagebreak (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   CreateInsertPageMenu ();
}
/* -------------------------------------------------------------- */
#ifdef __STDC__
void                LocChangesynchronize (Document document, View view)
#else  /* __STDC__ */
void                LocChangesynchronize (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   PtrDocument         pDoc;
   boolean             Assoc;
   int                 frame, Vue;

   frame = GetWindowNumber (document, view);
   GetDocAndView (frame, &pDoc, &Vue, &Assoc);
   if (!Assoc)
      /* change le mode de synchronisation de la vue */
      pDoc->DocView[Vue - 1].DvSync = !pDoc->DocView[Vue - 1].DvSync;


}

/* -------------------------------------------------------------- */
#ifdef __STDC__
void                TraiteMenuSpaces (Document document, View view)
#else  /* __STDC__ */
void                TraiteMenuSpaces (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
  char                BufMenu[MAX_TXT_LEN];
  int 		      Indx;

  TtaNewForm (BaseAppli+MyNumFormSpace,  0,
            TtaGetMessage(indexTable, SPACES_MODE), True, 2, 'L',D_CANCEL);
  /* sous-menus mode de saisie et d'affichage */
  Indx = 0;
  sprintf(&BufMenu[Indx], "%s%s", "B", TtaGetMessage(indexTable, VAL_CHARACTER));
  Indx += strlen(&BufMenu[Indx])+1;
  sprintf(&BufMenu[Indx], "%s%s", "B", TtaGetMessage(indexTable, VAL_SPACE));
  TtaNewSubmenu(BaseAppli+MyNumMenuSpaceMode , BaseAppli+MyNumFormSpace, 0,
           TtaGetMessage(indexTable, OUTPUT_MODE), 2, BufMenu, NULL, False);
  newShowSpace = ShowSpace;
  TtaSetMenuForm (BaseAppli + MyNumMenuSpaceMode, newShowSpace);
  TtaShowDialogue(BaseAppli+MyNumFormSpace,FALSE);

}

/* ---------------------------------------------------------------------- */
/* | RetSpacesMode traite les retours du formulaire des espaces        | */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
void RetSpacesModes(int ref, int val)

#else /* __STDC__ */
void RetSpacesModes(ref, val)
        int ref;
        int val;
#endif /* __STDC__ */

{
  if (ref == BaseAppli+MyNumMenuSpaceMode)
    newShowSpace = val;
  else if (val == 1)
  {
    /* Confirmation des modification */
    if (ShowSpace != newShowSpace)
    {
      ShowSpace = newShowSpace;
      /* force le raffichage de toutes les fenetres */
      TtaRefresh();
    }
  }
}



/* -------------------------------------------------------------- */
#ifdef __STDC__
void TraiteMenuHelp(Document document, View view)
#else /* __STDC__*/
void TraiteMenuHelp(document, view)
     Document document;
     View view;
#endif /* __STDC__*/
{
  char *helpdocname;
  NotifyDialog event;
  Document doc;
  View vue;
  
  if (HelpDocument == 0)
    {
      helpdocname=TtaGetEnvString("HelpDocument");
      if (helpdocname ==NULL) {
	return;
      }
      doc=TtaOpenDocument(helpdocname,0);
      if(doc==0){
	return;
      }
      vue = TtaOpenMainView(doc,200,10,180,280);
      if (vue!=0) {
	HelpDocument = doc;
	event.document = doc;
	event.view = vue;
	ApresOuvreVue(&event);
      }
    }
 
}

/* -------------------------------------------------------------- */
#ifdef __STDC__
void LocSplit(Document document, View view)
#else /* __STDC__*/
void LocSplit(document, view)
     Document document;
     View view;
#endif /* __STDC__*/

{
   /* This function has to be written */
}
/* -------------------------------------------------------------- */
#ifdef __STDC__
extern void TtcSurround(Document document, View view);
void LocSurround(Document document, View view)
#else /* __STDC__*/
extern void TtcSurround(/* Document document, View view */);
void LocSurround(document, view)
     Document document;
     View view;
#endif /* __STDC__*/
{
  TtcSurround(document, view);
}


/* ---------------------------------------------------------------------- */
#ifdef __STDC__
void                ThotEditorCallback (int ref, int datatype, char *data)
#else  /* __STDC__ */
void                ThotEditorCallback (ref, datatype, data)
int                 ref;
int                 datatype;
char               *data;

#endif
{

   switch (ref - BaseAppli)
	 {
	    case MyNumZoneDirDocuments:
	    case MyNumZoneDirSchemas:
	       strcpy (BufZone, data);
	       break;
	    case MyNumFormDirDocuments:
	       if ((int) data == 1)
		  RetMenuDirDocuments (BufZone);
	       TtaDestroyDialogue (BaseAppli + MyNumFormDirDocuments);
	       break;
	    case MyNumFormDirSchemas:
	       if ((int) data == 1)
		  RetMenuDirSchemas (BufZone);
	       TtaDestroyDialogue (BaseAppli + MyNumFormDirSchemas);
	       break;

	       /* retours du formulaire mode d'espace */
            case MyNumMenuSpaceMode:
            case MyNumFormSpace:
               RetSpacesModes(ref,(int) data);
               break;

	       /* retours du formulaire lister */
	    case MyNumFormLister:
	       /* formulaire Lister (mode debug seulement) */
	       if ((int) data >= 1)
		  RetMenuLister (ref, (int) data, NULL);
	       TtaDestroyDialogue (BaseAppli + MyNumFormLister);
	       break;
	    case MyNumZoneNomFichierListe:
	       /* zone de saisie du nom du fichier liste a creer */
	       RetMenuLister (ref, 0, (char *) data);
	       break;
	    case MyNumMenuTypeListe:
	       /* sous-menu pour le choix du type de liste a produire */
	       RetMenuLister (ref, (int) data + 1, NULL);
	       break;
	    case MyNumFormAutoSave:
	       if ((int) data >= 1)
		  DocAutoSave = NULL;
	       TtaDestroyDialogue (BaseAppli + MyNumFormAutoSave);
	       break;
	    case MyNumZoneAutoSave:
	       /* zone de saisie de l'intervalle de sauvegarde automatique */
	       if ((int) data >= 1)
		  RetMenuAutoSave ((int) data);
	       break;
	    default:
	       if (ref > BaseAppli + MyNumMenuPresNature &&
		   ref <= BaseAppli + MyNumMenuPresNature + nbNatures)

		  /* menu de changement du schema de presentation du doc. */
		  RetMenuSchPresent (ref, (int) data + 1);
	       else
		  /* retour de dialogue non traite' */
		  fprintf (stdout, "Retour de dialogue non traite: %d\n", ref);


	 }
}
