/*
 *
 *  (c) COPYRIGHT INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/*
 * Warning:
 * This module is part of the Thot library, which was originally
 * developed in French. That's why some comments are still in
 * French, but their translation is in progress and the full module
 * will be available in English in the next release.
 * 
 */

/*
 *
 * Author: I. Vatton (INRIA)
 *
 */
 
#include "thot_sys.h"
#include "constmenu.h"
#include "constmedia.h"
#include "typemedia.h"
#include "app.h"
#include "appdialogue.h"
#include "tree.h"
#include "libmsg.h"
#include "message.h"
#include "dialog.h"
#include "application.h"
#include "document.h"
#include "fileaccess.h"
#include "thotdir.h"
#undef THOT_EXPORT
#define THOT_EXPORT extern
#include "edit_tv.h"
#include "appdialogue_tv.h"
#include "platform_tv.h"
#include "boxes_tv.h"
#include "frame_tv.h"
#include "opendoc_f.h"
#include "createdoc_f.h"
#include "font_f.h"
#include "docs_f.h"
#include "applicationapi_f.h"
#include "callback_f.h"
#include "fileaccess_f.h"
#include "translation_f.h"
#include "browser_f.h"
#include "config_f.h"
#include "platform_f.h"
#include "viewapi_f.h"

extern int          CurrentDialog;
static PathBuffer   SaveDirectoryName;
static PathBuffer   SaveFileName;
static PathBuffer   TraductionSchemaName;
static boolean      SaveDocWithCopy;
static boolean      SaveDocWithMove;
static PtrDocument  DocumentToSave;


/*----------------------------------------------------------------------
   UnsetEntryMenu
   displays as non active the "ent" entry of the menu referenced by
   "ref".
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                UnsetEntryMenu (int ref, int ent)
#else  /* __STDC__ */
void                UnsetEntryMenu (ref, ent)
int                 ref;
int                 ent;

#endif /* __STDC__ */
{
   char                fontname[100];
   char                text[20];

   if (TtWDepth > 1)
      TtaRedrawMenuEntry (ref, ent, NULL, InactiveB_Color, 0);
   else
     {
	FontIdentifier ('L', 'T', 2, 11, 1, text, fontname);
	TtaRedrawMenuEntry (ref, ent, fontname, -1, 0);
     }
}				/*UnsetEntryMenu */

/*----------------------------------------------------------------------
   BuildSaveDocMenu
   does the File Save.
  ----------------------------------------------------------------------*/
void                BuildSaveDocMenu ()

{
   PathBuffer          outputFileName;
   int                 i;
   NotifyDialog        notifyDoc;

   /* Name du fichier a sauver */
   strcpy (outputFileName, SaveDirectoryName);
   strcat (outputFileName, DIR_STR);
   strcat (outputFileName, SaveFileName);
   if (TraductionSchemaName[0] == '\0')
      /* sauver en format Thot */
     {
	strcat (outputFileName, ".PIV");
	(void) StoreDocument (DocumentToSave,
			      SaveFileName, SaveDirectoryName,
			      SaveDocWithCopy, SaveDocWithMove);
     }
   else
      /* exporter le document */
     {
	/* envoie le message DocExport.Pre a l'application */
	notifyDoc.event = TteDocExport;
	notifyDoc.document = (Document) IdentDocument (DocumentToSave);
	notifyDoc.view = 0;
	if (!CallEventType ((NotifyEvent *) & notifyDoc, TRUE))
	   /* l'application accepte que Thot exporte le document */
	  {
	     TtaDisplayMessage (INFO, TtaGetMessage (LIB, TMSG_EXPORTING), DocumentToSave->DocDName);
	     FindCompleteName (SaveFileName, "", SaveDirectoryName, outputFileName, &i);
	     ExportDocument (DocumentToSave, outputFileName, TraductionSchemaName);
	     TtaDisplayMessage (INFO, TtaGetMessage (LIB, TMSG_LIB_DOC_WRITTEN), outputFileName);
	     /* envoie le message DocExport.Post a l'application */
	     notifyDoc.event = TteDocExport;
	     notifyDoc.document = (Document) IdentDocument (DocumentToSave);
	     notifyDoc.view = 0;
	     CallEventType ((NotifyEvent *) & notifyDoc, FALSE);
	  }
     }
}

/*----------------------------------------------------------------------
   CallbackSaveDocMenu
   callback handler for the Save File menu.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                CallbackSaveDocMenu (int ref, int typedata, char *txt)

#else  /* __STDC__ */
void                CallbackSaveDocMenu (ref, typedata, txt)
int                 ref;
int                 typedata;
char               *txt;

#endif /* __STDC__ */

{
   PathBuffer          ptTranslatedName;
   PathBuffer          BufDir;
   int                 i, nbitem;
   int                 val;

   val = (int) txt;
   switch (ref)
	 {
	    case NumZoneDocNameTooSave:
	       /* zone de saisie du nom du document a creer */
	       if (TtaCheckDirectory (txt) && txt[strlen (txt) - 1] != DIR_SEP)
		 {
		    strcpy (SaveDirectoryName, txt);
		    SaveFileName[0] = '\0';
		 }
	       else
		 {
		    /* conserve le nom du document a ouvrir */
		    TtaExtractName (txt, SaveDirectoryName, BufDir);
		    /* RemoveElement le suffixe .PIV du nom de fichier */
		    i = strlen (BufDir) - 4;
		    if (!strcmp (&BufDir[i], ".PIV"))
		       BufDir[i] = '\0';
		    else
		       i += 4;
		    if (i >= MAX_NAME_LENGTH - 1)
		      {
			 i = MAX_NAME_LENGTH - 1;	/*Longueur du nom limitee */
			 BufDir[i] = '\0';
			 strcpy (ptTranslatedName, SaveDirectoryName);
			 strcat (ptTranslatedName, DIR_STR);
			 strcat (ptTranslatedName, BufDir);
			 if (TraductionSchemaName[0] == '\0')
			    strcat (ptTranslatedName, ".PIV");
			 /* reinitialise la zone du nom de document */
			 TtaSetTextForm (NumZoneDocNameTooSave, ptTranslatedName);
		      }
		    strcpy (SaveFileName, BufDir);
		 }

	       if (TtaCheckDirectory (SaveDirectoryName))
		 {
		    /* Est-ce un nouveau directory qui contient des documents */
		    if (!TtaIsInDocumentPath (SaveDirectoryName))
		       if (TtaIsSuffixFileIn (SaveDirectoryName, ".PIV"))
			 {
			    /* il faut ajouter le directory au path */
			    i = strlen (DocumentPath);
			    if (i + strlen (SaveDirectoryName) + 2 < MAX_PATH)
			      {
				 strcat (DocumentPath, PATH_STR);
				 strcat (DocumentPath, SaveDirectoryName);
				 BuildPathDocBuffer (BufDir, '\0', &nbitem);
				 TtaNewSelector (NumZoneDirDocToSave, NumFormSaveAs,
					  TtaGetMessage (LIB, TMSG_DOC_DIR),
				      nbitem, BufDir, 6, NULL, FALSE, TRUE);
			      }
			 }
		 }

	       break;
	    case NumZoneDirDocToSave:
	       /* zone de saisie du directory ou le document doit etre cree */
	       strcpy (SaveDirectoryName, txt);
	       strcpy (ptTranslatedName, SaveDirectoryName);
	       strcat (ptTranslatedName, DIR_STR);
	       strcat (ptTranslatedName, SaveFileName);
	       if (TraductionSchemaName[0] == '\0')
		  strcat (ptTranslatedName, ".PIV");
	       /* reinitialise la zone du nom de document */
	       TtaSetTextForm (NumZoneDocNameTooSave, ptTranslatedName);
	       break;
	    case NumMenuFormatDocToSave:
	       /* sous-menu pour le choix du format de sauvegarde */
	       strcpy (ptTranslatedName, SaveDirectoryName);
	       strcat (ptTranslatedName, DIR_STR);
	       strcat (ptTranslatedName, SaveFileName);
	       if (val == 0)
		 {
		    /* premiere entree du menu format: format Thot */
		    TraductionSchemaName[0] = '\0';
		    strcat (ptTranslatedName, ".PIV");
		    TtaRedrawMenuEntry (NumMenuCopyOrRename, 0, NULL, -1, 1);
		    TtaRedrawMenuEntry (NumMenuCopyOrRename, 1, NULL, -1, 1);
		 }
	       else
		 {
		    ConfigGetExportSchemaName (val, TraductionSchemaName);
		    UnsetEntryMenu (NumMenuCopyOrRename, 0);
		    UnsetEntryMenu (NumMenuCopyOrRename, 1);
		 }
	       /* reinitialise la zone du nom de document */
	       TtaSetTextForm (NumZoneDocNameTooSave, ptTranslatedName);
	       break;
	    case NumMenuCopyOrRename:
	       /* sous-menu copier/renommer un document */
	       if (val == 0)
		  /* c'est un copy */
		 {
		    SaveDocWithCopy = TRUE;
		    SaveDocWithMove = FALSE;
		 }
	       else
		  /* c'est un move */
		 {
		    SaveDocWithCopy = FALSE;
		    SaveDocWithMove = TRUE;
		 }
	       break;
	    case NumFormSaveAs:
	       /* le formulaire Sauver Comme */
	       /* fait disparaitre la feuille de dialogue */
	       if (val == 1)
		 {
		    /* c'est une confirmation */
		    TtaUnmapDialogue (NumFormSaveAs);
		    CurrentDialog = NumFormSaveAs;
		    if (DocumentToSave != NULL)
		       if (DocumentToSave->DocSSchema != NULL)
			  /* le document a sauver n'a pas ete ferme' entre temps */
			  if (!TtaCheckDirectory (SaveDirectoryName))
			    {	/* le repertoire est invalide : affiche un message et detruit les dialogues */
			       TtaDisplayMessage (CONFIRM, TtaGetMessage (LIB, TMSG_MISSING_DIR), SaveDirectoryName);
			       if (ThotLocalActions[T_confirmcreate] != NULL)
				  (*ThotLocalActions[T_confirmcreate])
				     (0, 1, (char *) 1);
			    }
			  else if (!strcmp (SaveDirectoryName, DocumentToSave->DocDirectory)
				   && !strcmp (SaveFileName, DocumentToSave->DocDName)
				   && TraductionSchemaName[0] == '\0')
			    {	/* traite la confirmation */
			       if (ThotLocalActions[T_confirmcreate] != NULL)
				  (*ThotLocalActions[T_confirmcreate]) (NumFormConfirm, 1, (char *) 1);
			    }
			  else
			    {
			       strcpy (ptTranslatedName, SaveDirectoryName);
			       strcat (ptTranslatedName, DIR_STR);
			       strcat (ptTranslatedName, SaveFileName);
			       if (TraductionSchemaName[0] == '\0')
				  strcat (ptTranslatedName, ".PIV");
			       if (TtaFileExist (ptTranslatedName))
				 {
				    /* demande confirmation */
				    sprintf (BufDir, TtaGetMessage (LIB, TMSG_FILE_EXIST), ptTranslatedName);
				    TtaNewLabel (NumLabelConfirm, NumFormConfirm, BufDir);
				    TtaShowDialogue (NumFormConfirm, FALSE);
				 }

			       else
				  /* traite la confirmation */
			       if (ThotLocalActions[T_confirmcreate] != NULL)
				  (*ThotLocalActions[T_confirmcreate]) (NumFormConfirm, 1, (char *) 1);
			    }
		 }
	       else if (ThotLocalActions[T_confirmcreate] != NULL)
		  (*ThotLocalActions[T_confirmcreate]) (0, 1, (char *) 1);
	       break;
	 }
}

/*----------------------------------------------------------------------
   SaveDocAs
   creates, initializes and activates the "Save As" form for document
   pDoc.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         SaveDocAs (PtrDocument pDoc)
#else  /* __STDC__ */
static void         SaveDocAs (pDoc)
PtrDocument         pDoc;

#endif /* __STDC__ */
{
   int                 nbitem;
   char                BufMenu[MAX_TXT_LEN];
   char                BufMenuB[MAX_TXT_LEN];
   char                BufDir[MAX_PATH];
   char               *src;
   char               *dest;
   int                 i, k, l, Indx,entry;

   if (pDoc != NULL)
      if (!pDoc->DocReadOnly)
	 if (pDoc->DocSSchema != NULL)
	   {
	      DocumentToSave = pDoc;
	      /* cree le formaulaire Sauver comme */
	      TtaNewSheet (NumFormSaveAs,  0,
			   TtaGetMessage (LIB, TMSG_SAVE_AS),
		 1, TtaGetMessage (LIB, TMSG_SAVE), TRUE, 3, 'L', D_CANCEL);

	      /* cree et */
	      /* initialise le selecteur sur aucune entree */
	      BuildPathDocBuffer (BufDir, '\0', &nbitem);
	      TtaNewSelector (NumZoneDirDocToSave, NumFormSaveAs,
			      TtaGetMessage (LIB, TMSG_DOC_DIR),
			      nbitem, BufDir, 6, NULL, FALSE, TRUE);
	      entry = SearchStringInBuffer(BufDir,pDoc->DocDirectory,nbitem);
	      TtaSetSelector (NumZoneDirDocToSave, entry, "");
	      /* initialise le titre du formulaire Sauver Comme */
	      strcpy (SaveFileName, pDoc->DocDName);
	      strcpy (SaveDirectoryName, pDoc->DocDirectory);
	      /* compose le menu des formats de sauvegarde applicables */
	      /* a ce document, d'apres sa classe */
	      nbitem = ConfigMakeMenuExport (pDoc->DocSSchema->SsName, BufMenu);
	      /* met le format Thot en tete */
	      BufMenuB[0] = 'B';
	      strcpy (&BufMenuB[1], TtaGetMessage (LIB, TMSG_THOT_APP));
	      l = strlen (TtaGetMessage (LIB, TMSG_THOT_APP)) + 2;
	      /* ajoute 'B' au debut de chaque entree */
	      dest = &BufMenuB[l];
	      src = &BufMenu[0];
	      for (k = 1; k <= nbitem; k++)
		{
		   strcpy (dest, "B");
		   dest++;
		   l = strlen (src);
		   strcpy (dest, src);
		   dest += l + 1;
		   src += l + 1;
		}
	      nbitem++;
	      TtaNewSubmenu (NumMenuFormatDocToSave, NumFormSaveAs, 0,
			     TtaGetMessage (LIB, TMSG_DOC_FORMAT), nbitem, BufMenuB, NULL, TRUE);
	      TtaSetMenuForm (NumMenuFormatDocToSave, 0);
	      /* sous-menu copier/renommer un document */
	      Indx = 0;
	      sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (LIB, TMSG_COPY));
	      Indx += strlen (&BufMenu[Indx]) + 1;
	      sprintf (&BufMenu[Indx], "%s%s", "B", TtaGetMessage (LIB, TMSG_RENAME));
	      TtaNewSubmenu (NumMenuCopyOrRename, NumFormSaveAs, 0,
		   TtaGetMessage (LIB, TMSG_SAVE), 2, BufMenu, NULL, FALSE);
	      TtaSetMenuForm (NumMenuCopyOrRename, 0);
	      /* initialise le  nom de document propose */
	      strcpy (BufMenu, TtaGetMessage (LIB, TMSG_SAVE));
	      strcat (BufMenu, " ");
	      strcat (BufMenu, pDoc->DocDName);
	      TtaChangeFormTitle (NumFormSaveAs, BufMenu);
	      strcpy (BufMenu, SaveDirectoryName);
	      strcat (BufMenu, DIR_STR);
	      strcat (BufMenu, SaveFileName);
	      strcat (BufMenu, ".PIV");
	      /* nom de document propose' */
	      TtaNewTextForm (NumZoneDocNameTooSave, NumFormSaveAs,
		      TtaGetMessage (LIB, TMSG_DOCUMENT_NAME), 50, 1, TRUE);
	      TtaSetTextForm (NumZoneDocNameTooSave, BufMenu);

/*        ActiveEntree(NumMenuCopyOrRename, 0); */
/*        ActiveEntree(NumMenuCopyOrRename, 1); */
/*        TtaSetMenuForm(NumMenuCopyOrRename, 0); */
	      /* premiere entree du menu format: format Thot */
	      TraductionSchemaName[0] = '\0';
	      SaveDocWithCopy = TRUE;
	      SaveDocWithMove = FALSE;
	      /* Formulaire Confirmation creation */
	      strcpy (BufMenu, TtaGetMessage (LIB, TMSG_SAVE_AS));
	      i = strlen (BufMenu) + 1;
	      strcpy (&BufMenu[i], TtaGetMessage (LIB, TMSG_LIB_CONFIRM));
	      TtaNewDialogSheet (NumFormConfirm,  0, NULL, 2, BufMenu, FALSE, 1, 'L', D_CANCEL);

	      /* affiche le formulaire */
	      TtaShowDialogue (NumFormSaveAs, FALSE);
	   }
}

/*----------------------------------------------------------------------
  TtcSaveDocumentAs
  standard handler for a SaveDocumentAs action.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtcSaveDocumentAs (Document document, View view)
#else  /* __STDC__ */
void                TtcSaveDocumentAs (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   PtrDocument         pDoc;
   int                 frame;

   if (document != 0)
     {
	pDoc = LoadedDocument[document - 1];
	if (pDoc != NULL)
	   /* il y a un document pour cette entree de la table */
	  {
	     if (ThotLocalActions[T_savedoc] == NULL)
	       {
		  TteConnectAction (T_savedoc, (Proc) BuildSaveDocMenu);
		  TteConnectAction (T_confirmcreate, (Proc) CallbackConfirmMenu);
		  TteConnectAction (T_rsavedoc, (Proc) CallbackSaveDocMenu);
		  TteConnectAction (T_buildpathdocbuffer, (Proc) BuildPathDocBuffer);
	       }
	     frame = GetWindowNumber (document, view);
	     if (ThotLocalActions[T_updateparagraph] != NULL)
		(*ThotLocalActions[T_updateparagraph]) (ViewFrameTable[frame - 1].FrAbstractBox, frame);
	     SaveDocAs (pDoc);
	  }
     }
}


/*----------------------------------------------------------------------
  TtcSaveDocument
  standard handler for a SaveDocument action.
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                TtcSaveDocument (Document document, View view)
#else  /* __STDC__ */
void                TtcSaveDocument (document, view)
Document            document;
View                view;

#endif /* __STDC__ */
{
   PtrDocument         pDoc;
   int                 frame;

   if (document != 0)
     {
	pDoc = LoadedDocument[document - 1];
	if (pDoc != NULL)
	   /* il y a un document pour cette entree de la table */
	  {
	     frame = GetWindowNumber (document, view);
	     if (ThotLocalActions[T_updateparagraph] != NULL)
		(*ThotLocalActions[T_updateparagraph]) (ViewFrameTable[frame - 1].FrAbstractBox, frame);
	     pDoc->DocModified = !WriteDocument (pDoc, 4);
	  }
     }
}










