/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/
 


/*******************************************************************/
/*                                                                 */
/*  GLOBAL class default variables for cfengine                    */
/*  These variables are what needs to be modified if you add or    */
/*  modify class definitions...                                    */
/*                                                                 */
/*******************************************************************/

#include "cf.defs.h"

/*********************************************************************/

char *CLASSTEXT[] =   /* If you change here change enum classes too! */
   {
   "",                                              /* see cf.defs.h */
   "<soft>",
   "faculty",
   "site",
   "domain",
   "sysadm",
   "netmask",
   "mountpath",
   "homepat",
   "addclasses",
   "timezone",
   "sensiblesize",
   "sensiblecount",
   "editfilesize",
   "actionsequence",               /* All classes must use LOWER CASE */
   "access",                       /* due to ClassStringToCode()      */
   "nfstype",
   "excludecopy",
   "excludelink",
   "copylinks",
   "linkcopies",
   "repository",
   "repchar",
   "split",
   "sun4",
   "ultrix",
   "hpux10",
   "hpux",
   "aix",
   "linux",
   "solaris",
   "osf",
   "sun3",
   "irix",
   "freebsd",
   "unused1",
   "unused2",
   "unused3",
   NULL
   };

/*********************************************************************/

char *CLASSATTRIBUTES[clssattr][attr] = /* Used to match the softclass */
   {                            /* from uname. Only as many characters */
   "-","-","-",                 /* as appear here are matched. The     */
   "-","-","-",                 /* fields are sysname and machine which*/
   "-","-","-",                 /* actually gives the architecture!    */
   "-","-","-",                 /* * and ? are wildcards - is blank    */
   "-","-","-",
   "-","-","-",
   "-","-","-",                    /* remember to change cf.defs.h !!  */
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",   
   "sunos","sun4?","4*",       /* sun 4  */
   "ultrix","risc","4*",       /* ultrix */
   "hp-ux","9000*","?.1?.*",   /* hpux10 */
   "hp-ux","9000*","*",        /* hpux */
   "aix","*","2",              /* aix */
   "linux","*","*",            /* linux */
   "sunos","sun4?","5*",       /* solaris */
   "osf1","alpha","*",         /* osf1 */
   "sunos","sun3","4*",        /* sun3 */
   "irix","ip*","5*",          /* irix */
   "freebsd","i?86","*",       /* freebsd */
   "unused1","blah","blah",
   "unused2","blah","blah",
   "unused3","blah","blah",
   NULL,NULL,NULL
   };

/*********************************************************************/

char *VPSCOMM[clssattr] =
   {
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",   
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   "/bin/ps",
   NULL
   };

/*********************************************************************/

char *VPSOPTS[clssattr] =
   {
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "-ax",    /* sun4 */
   "-ax",    /* ultrix */
   "-ef",     /* hp10 */
   "-ef",    /* houx */
   "-ax",    /* aix */
   "-ax",    /* linux */
   "-ef",    /* solaris */
   "-ax",    /* osf1 */
   "-ax",    /* sun3 */
   "-ef",    /* irix */
   "-ax",    /* freebsd */
   "-",
   "-",
   "-",
   NULL
   };

/*********************************************************************/

char *VMOUNTCOMM[clssattr] =
   {
   "",                                              /* see cf.defs.h */
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "/etc/mount -va 2<&1",
   "/etc/mount -va 2<&1",
   "/sbin/mount -va 2<&1",
   "/etc/mount -va 2<&1",
   "/etc/mount -t nfs 2<&1",
   "/sbin/mount -va 2<&1",        /* not sure about these */
   "/usr/sbin/mount -a 2>&1",
   "/usr/sbin/mount -va 2<&1",
   "/etc/mount -va 2<&1",
   "/sbin/mount -va 2<&1",
   "/sbin/mount -vau 2<&1",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };

/*********************************************************************/

char *VUNMOUNTCOMM[clssattr] =
   {
   "",                                              /* see cf.defs.h */
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "/etc/umount",
   "/etc/umount",
   "/sbin/umount",
   "/etc/umount",
   "/etc/umount",
   "/sbin/umount",        /* not sure about these */
   "/etc/umount",
   "/usr/sbin/umount",
   "/etc/umount",
   "/sbin/umount",
   "/sbin/umount",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };



/*********************************************************************/

char *VMOUNTOPTS[clssattr] =
   {
   "",                                              /* see cf.defs.h */
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,hard,intr",
   "defaults",        /* not sure about these */
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,intr",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };

/*********************************************************************/

char *VIFDEV[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "-",
   "-",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "le0",
   "ln0",
   "lan0",
   "lan0",
   "en0",
   "eth0",    
   "le0",
   "ln0",
   "le0",
   "ec0",
   "ep0",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };


/*********************************************************************/

char *VRESOLVCONF[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "-",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/etc/resolv.conf",    
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/usr/etc/resolv.conf",
   "/etc/resolv.conf",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };



/*********************************************************************/

char *VFSTAB[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "/etc/fstab",
   "/etc/fstab",
   "/etc/fstab",
   "/etc/checklist",
   "/etc/filesystems",
   "/etc/fstab",    
   "/etc/vfstab",
   "/etc/fstab",
   "/etc/fstab",
   "/etc/fstab",
   "/etc/fstab",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };

/*********************************************************************/

char *VMAILDIR[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "-",
   "-",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "/var/spool/mail",
   "/usr/spool/mail",
   "/var/mail",
   "/usr/mail",
   "/var/spool/mail",
   "/var/spool/mail",    
   "/var/mail",
   "/usr/spool/mail",
   "/var/spool/mail",
   "/usr/mail",
   "/var/mail",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };

/*********************************************************************/

char *VNETSTAT[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "/usr/ucb/netstat -rn",
   "/usr/ucb/netstat -rn",
   "/usr/bin/netstat -rn",
   "/usr/bin/netstat -rn",
   "/usr/bin/netstat -rn",
   "/bin/netstat -rn",    
   "/usr/ucb/netstat -rn",
   "/usr/sbin/netstat -rn",
   "/usr/ucb/netstat -rn",
   "/usr/etc/netstat -rn",
   "/usr/bin/netstat -rn",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };


