/*
 * dfile.c - RISCos file processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dfile.c,v 1.3 96/01/11 12:55:12 abe Exp $";
#endif


#include "lsof.h"


/*
 * process_file() - process file
 */

void
process_file(fp)
	struct file *fp;		/* kernel file structure address */
{
	struct file f;
	int flag;

	if (kread((KA_T)fp, (char *)&f, sizeof(f))) {
		(void) sprintf(Namech, "can't read file struct from %#x", fp);
		enter_nm(Namech);
		return;
	}
	Lf->off = (unsigned long)f.f_offset;

	if (f.f_count) {

	/*
	 * Construct access code.
	 */
		if ((flag = (f.f_flag & (FREAD | FWRITE))) == FREAD)
			Lf->access = 'r';
		else if (flag == FWRITE)
			Lf->access = 'w';
		else if (flag == (FREAD | FWRITE))
			Lf->access = 'u';
	/*
	 * Process structure by its type.
	 */
		switch (f.f_type) {
		case DTYPE_VNODE:
			process_node(f.f_data);
			return;
		case DTYPE_SOCKET:
			process_socket((caddr_t)f.f_data);
			return;
		default:
			(void) sprintf(Namech,
				"%#x file struct, ty=%#x, op=%#x",
				fp, f.f_type, f.f_ops);
			enter_nm(Namech);
			return;
		}
	}
	enter_nm("no more information");
}


/*
 * The ck_file_arg() function is obtained from ../common/ckfa.frag
 * The is_file_named() function is obtained from ../common/isfn.frag
 * The print_file() function is obtained from ../common/prtf.frag
 */

/* CKFA_EXPDEV	is not defined. */
/* CKFA_MPXCHAN is not defined. */
