/*
 * dmnt.c - RISCos mount support functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.2 95/10/23 13:04:51 abe Exp $";
#endif


#include "lsof.h"


/*
 * completevfs() - complete local vfs structure
 */
void
completevfs(vfs, dev)
	struct l_vfs *vfs;		/* local vfs structure pointer */
	dev_t *dev;			/* device */
{
	struct mounts *mp;
/*
 * Search for a match on device number.
 */
	for (mp = Mtab; mp; mp = mp->next) {
		if (mp->dev == *dev) {
			vfs->dir = mp->dir;
			vfs->fsname = mp->fsname;

#if	defined(HASFSINO)
			vfs->fs_ino = mp->inode;
#endif	/* defined(HASFSINO) */

			return;
		}
	}
}


/*
 * The readmnt() function is obtained from ../common/rmnt.frag
 * The readvfs() function is obtained from ../common/rvfs.frag
 */

#define	EXPDEV(n)	n
/* MNTSKIP is not defined. */
#define	RVFS_DEVSAVE	1
