/*
 * config.h - configuration file for Renaissoft Qfax 1.2
 * Copyright 1994, 1995 Robert LeBlanc and Renaissoft
 */

#ifndef _CONFIG_H
#define _CONFIG_H

/* Where to find the central fax number phonebook (fax.db) */
#define DATABASE "/conf/fax/fax.db"

/* Where to find your site's preferences/info file (fax.rc) */
#define CONFIG "/conf/fax/fax.rc"

/* Where to find the basic cover letter template (cover-template.ps) */
#define TEMPLATE "/conf/fax/cover-template.ps"

/* Where to store outgoing faxes for later processing */ 
#define FAXQUEUE "/usr/spool/fax/sendq"

/* Where to store inactive (e.g. failed) faxes */
#define STOREDIR "/usr/spool/fax/docq"

/* Where to find Efax's script "fax" (usually /usr/bin/fax) */
#define FAXSCRIPT "/usr/bin/fax"

/* Where to find the status code from the last use of Efax */
#define RESULT "/usr/spool/fax/result/result"

/* Any special way you need to invoke the ls command, e.g. to disable
   colour codes, etc.  Usually just "ls". */
#define LS "ls"

/* Maximum number of faxes you expect to keep in the outgoing spool */
#define MAXFAXES 15

/* Maximum number of times to attempt to send a given fax before
   giving up. */
#define MAXTRIES 3

/* Start and end times (in 24hr format, "xxxx-yyyy") of the period during
   the day in which long-distance fax calls may be placed.  If you want to
   disable this feature, set the start and end times to the same value, e.g.
   "0000-0000" */
#define LDPERIOD "0000-0700"

#endif
