/* `sub.c' -- Program to construct source files by substituting @tags@ in
   template files.  It is intended to be run only by the Makefile.

   Copyright (C) 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Written by Fung-Chai Lim (fclim@acm.org).

   This file is part of GNU ecc.  */

#ifdef HAVE_CONFIG_H
#if defined (CONFIG_BROKETS)
/* We use <config.h> instead of "config.h" so that a compilation
   using -I. -I$srcdir will use ./config.h rather than $srcdir/config.h
   (which it would do because it found this file in $srcdir).  */
#include <config.h>
#else
#include "config.h"
#endif
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#ifndef errno
extern int errno;
#endif

#if __STDC__ && defined (HAVE_VPRINTF)
void error (int, int, char const *, ...);
#else
void error ();
#endif

char *program_name;

static char *read_file _PROTO_ ((const char *const filename));
static void write_file _PROTO_ ((char *contents, const char *const filename,
                                 const char *const input_filename));

extern void make_tables _PROTO_ ((void));
extern int  substitute  _PROTO_ ((const char *const string, FILE *file));

main (argc, argv)
     int argc;
     char *argv[];
{
  char *contents;

  program_name = argv[0];
  if (argc != 3)
    {
      fprintf (stderr, "Usage: %s template-filename output-filename\n",
		       program_name);
      exit (1);
    }

  contents = read_file (argv[1]);
  make_tables ();
  write_file (contents, argv[2], argv[1]);
  free (contents);

  exit (0);
}

     static char *
read_file (filename)
     const char *const filename;
{
  struct stat st;
  char *contents;
  int fd;
  extern char *xmalloc _PROTO_ ((size_t size));

  if (stat (filename, &st) < 0)
    error (1, errno, "can't stat %s", filename);

  contents = xmalloc (st.st_size + 1);

  if ((fd = open (filename, O_RDONLY)) < 0)
    error (1, errno, "can't open %s for reading", filename);

  if (read (fd, contents, st.st_size) != st.st_size)
    error (1, errno, "error in reading %s", filename);
  contents [st.st_size] = '\0';

  (void) close (fd);
  return contents;
}

     static void
write_file (contents, filename, input_filename)
     char *contents;
     const char *const filename;
     const char *const input_filename;
{
  FILE *file;
  char *anchor, *rover;
  size_t count;

  if ((file = fopen (filename, "w")) == NULL)
    error (1, errno, "can't open %s for writing", filename);

  anchor = rover = contents;
  while (*rover)
    {
      while (*rover && *rover != '@')
	rover++;
      count = (size_t) (rover - anchor);
      if (write (fileno (file), anchor, count) != count)
        error (1, errno, "error in writing to %s", filename);
      if (*rover == '\0')
	break;

      anchor = ++rover;
      if (*anchor == '@')
	{
	  ++rover;
	  continue;
	}

      while (*rover && *rover != '@')
	rover++;
      if (*rover == '\0')
	error (1, 0, "unexpected EOF in %s", input_filename);
      *rover = '\0';

      if (strEQ (anchor, "EDIT"))
	{
	  fprintf (file, "This file was generated from `%s' by `%s'.",
		         input_filename, program_name);
	}
      else if (substitute (anchor, file))
        error (1, 0, "unknown tag `%s' in %s", anchor, input_filename);
      /* Do not assume substitute() uses write().  */
      fflush (file);

      anchor = ++rover;
    }

  fclose (file);
}
