/* `options.c' -- Routine to process command-line arguments.

   Copyright (C) 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Written by Fung-Chai Lim (fclim@acm.org).

   This file is part of GNU ecc.  */

#ifdef HAVE_CONFIG_H
#if defined (CONFIG_BROKETS)
/* We use <config.h> instead of "config.h" so that a compilation
   using -I. -I$srcdir will use ./config.h rather than $srcdir/config.h
   (which it would do because it found this file in $srcdir).  */
#include <config.h>
#else
#include "config.h"
#endif
#endif

#include <stdio.h>
#if STDC_HEADERS
#include <string.h>
#else
#include <strings.h>
#endif
#ifndef HAVE_STRCHR
#define strchr	index
#define strrchr	rindex
#endif
#include "getopt.h"

char *program_name;

static int show_help;

static int show_version;

static struct option const long_options[] =
{
  { "encode", no_argument, 0, 'e' },
  { "decode", no_argument, 0, 'd' },
  { "force", no_argument, 0, 'f' },
  { "verbose", no_argument, 0, 'v' },
  { "help", no_argument, &show_help, 1 },
  { "version", no_argument, &show_version, 1 },
  { 0, 0, 0, 0 }
};

extern char version[];

void usage _PROTO_ ((int status));

     void
process_options (argc, argv, encode, force, verbose)
     int argc;
     char **argv;
     int *encode, *force, *verbose;
{
  int i_encode;
  int i_decode;
  int c;

  program_name = argv[0];
  if (program_name && strrchr (program_name, '/'))
    program_name = strrchr (program_name, '/') + 1;

  i_encode = i_decode = *force = *verbose = 0;
  while ((c = getopt_long (argc, argv, "edfv", long_options, (int *)0)) != EOF)
    {
      switch (c)
	{
	case 0:
	  break;
	case 'e':
	  i_encode = 1;
	  break;
	case 'd':
	  i_decode = 1;
	  break;
	case 'f':
	  *force = 1;
	  break;
	case 'v':
	  *verbose = 1;
	  break;
	default:
	  usage (1);
	  /* NOTREACHED */
	}
    }

  if (show_version)
    {
      fprintf (stderr, "%s -- %s\n", program_name, version);
      exit (0);
    }

  if (show_help)
    usage (0);

  if (i_encode + i_decode != 1)
    usage (1);

  *encode = i_encode;
}

     void
usage (status)
     int status;
{
  if (status != 0)
    fprintf (stderr, "Try `%s --help' for more information.\n", program_name);
  else
    {
      fprintf (stderr, "%s: program to encode/decode a file based on \
the Reed-Solomon (255, 249)\n\
3-byte error-correcting code over the Galois Field (2^8).\n",
	       program_name);
      fprintf (stderr, "\
Usage: %s (-e | -d | --encode | --decode)\n\
       [-f] [--force] [-v] [--verbose]\n\
       [--help] [--version]\n\
       [input-file [output-file]]\n",
	       program_name);
      fprintf (stderr, "%s: `--force' overwrites any existing output file.\n",
	       program_name);
    }
  exit (status);
}
