/* `noise.c' -- Program to test GNU ecc.

   Copyright (C) 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Written by Fung-Chai Lim (fclim@acm.org).

   This file is part of GNU ecc.  */

#ifdef HAVE_CONFIG_H
#if defined (CONFIG_BROKETS)
/* We use <config.h> instead of "config.h" so that a compilation
   using -I. -I$srcdir will use ./config.h rather than $srcdir/config.h
   (which it would do because it found this file in $srcdir).  */
#include <config.h>
#else
#include "config.h"
#endif
#endif

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#ifndef errno
extern int errno;
#endif

#if __STDC__ && defined (HAVE_VPRINTF)
void error (int, int, char const *, ...);
#else
void error ();
#endif

char *program_name;

static void usage _PROTO_ ((void));
static void corrupt _PROTO_ ((int count, int infd, int outfd, int errfd));

main (argc, argv)
     int argc;
     char *argv[];
{
  int infd, outfd, errfd;
  int count;

  program_name = argv[0];

  if (argc != 5)
    usage ();

  if ((count = atoi (argv[1])) <= 0)
    usage ();

  if ((infd = open (argv[2], O_RDONLY)) < 0)
    {
      error (0, errno, "can't open %s for reading.", argv[2]);
      usage ();
    }

  if ((outfd = open (argv[3], O_WRONLY | O_CREAT | O_EXCL, 0666)) < 0)
    {
      error (0, errno, "can't open %s for writing.", argv[3]);
      usage ();
    }

  if ((errfd = open (argv[4], O_WRONLY | O_CREAT | O_EXCL, 0666)) < 0)
    {
      error (0, errno, "can't open %s for writing.", argv[4]);
      usage ();
    }

  corrupt (count, infd, outfd, errfd);
}

     static void
usage ()
{
  fprintf (stderr, "Usage: %s n infile outfile errfile\n", program_name);
  fprintf (stderr, "\
%s: Corrupts <infile> with up to <n> errors every 256 bytes.\n",
           program_name);
  exit (1);
}

     static void
corrupt (max, infd, outfd, errfd)
     int max;
     int infd, outfd, errfd;
{
  int n;
  int i, j;
  int count, block;
  int loc;
  int *locations;
  unsigned char val;
  unsigned char buffer[256];
  FILE *errfile;
  extern char *xmalloc _PROTO_ ((size_t size));

  errfile = fdopen (errfd, "w");
  if (errfile == NULL)
    error (1, errno, "can't open stream for file descriptor.");

  locations = (int *) xmalloc (max * sizeof (int));
  srandom (time (0));

  block = 0;
  while ((n = read (infd, buffer, 256)) == 256)
    {
      block++;

      count = random () % (max + 1);	/* MAX is inclusive, so add 1.  */
      if (count)
	{
	  fprintf (errfile, "%d byte error in block %d.\n", count, block);

	  for (i = 0; i < count; i++)
	    locations[i] = 0;

	  for (i = 0; i < count; i++)
	    {
	      while (1) {
		loc = (random () % 255) + 1;	/* Add 1 to avoid 'G'.  */
		for (j = 0; j < i; j++)
		  if (loc == locations[j])
		    break;
		if (j == i)
		  {
		    locations[i] = loc;
		    break;
		  }
	      }
	      val = (random () % 255) + 1;	/* Add 1 so it's an error.  */
	      buffer[loc] += val;
	    }
	}

      if (write (outfd, buffer, 256) != 256)
	error (1, errno, "error while writing.");
    }
  if (n != 0)
    error (1, errno, "error while reading.");

  close (infd);
  close (outfd);
  fclose (errfile);
  exit (0);
}
