INTERFACE igdbm BRAND "1.6";

EXCEPTION NoSuchDatabase : ilu.CString;
EXCEPTION CantCreate : ilu.CString;
EXCEPTION GDBM-Error : ilu.CString;

TYPE Server = OBJECT
  METHODS
    Version () : ilu.CString,
    Create (filename : ilu.CString, blockSize : INTEGER, fileMode : SHORT CARDINAL) : Database RAISES CantCreate END,
    Open (filename : ilu.CString) : Database RAISES NoSuchDatabase END,
    OpenReadOnly (filename : ilu.CString) : Database RAISES NoSuchDatabase END
  END;

TYPE RemovalStatus = ENUMERATION NotPresent, SuccessfullyDeleted END;

EXCEPTION ReadOnly;
EXCEPTION NotPresent;
EXCEPTION AlreadyPresent;

TYPE Datum = SEQUENCE OF BYTE;
TYPE OptionalDatum = OPTIONAL Datum;

TYPE Database = OBJECT COLLECTIBLE
  METHODS
    FUNCTIONAL Filename () : ilu.CString
      "Returns filename the database was opened with",
    FUNCTIONAL ReadOnly () : BOOLEAN
      "Returns TRUE if database has been opened read-only",
    ReplaceOrAdd (key : Datum, value : Datum) RAISES ReadOnly, GDBM-Error END
      "Replaces the value of KEY with VALUE, if KEY is present.",
    Add (key : Datum, value : Datum) RAISES ReadOnly, AlreadyPresent, GDBM-Error END
      "Inserts KEY with value VALUE in db, if not already present.  Raises AlreadyPresent if KEY is there already.",
    Find (key : Datum) : OptionalDatum RAISES GDBM-Error END
      "Returns value of KEY, if present, or NULL otherwise.",
    Remove (key : Datum) : RemovalStatus RAISES ReadOnly, GDBM-Error END
      "Removes value of KEY from db",
    ReOrganize () RAISES ReadOnly, GDBM-Error END
      "Compacts db, removing unused space in file."
  END;
