/* $Id: srvrw.c,v 1.2 1996/01/11 23:47:43 spreitze Exp $ */
/* Last edited by Mike Spreitzer January 11, 1996 3:47 pm PST */

/* A crude brute force adaptation of the command line srvr.c program
   into a *very* elementry windows version (adapted from Petzold 
   "Programming Windows 3.1" */

#include <windows.h>

#include <stdio.h>
#include <winio.h>

#include <math.h>
#include <stdlib.h>
#include <string.h>

#include "resource.h"

#ifdef WIN16
#include "t1hdr.h"
#include "t3hdr.h" 
#else
#include "Test1.h"
#include "Test3.h" 
#endif

#define _MAX_WINDOW_CHARS 8192

/* holds handle of our main window and application instance */
HWND g_h_hwnd;
HANDLE g_h_hInstance;

char g_windowchars[_MAX_WINDOW_CHARS] = "";
char g_c_line[512] = "";

void paintit() {

	static int i_charcount = 10;   /* 10 to allow for safety margin */
	int i_c_line_length;
	RECT        rect ;

	i_c_line_length = strlen(g_c_line);

	if ((i_charcount + i_c_line_length) >= _MAX_WINDOW_CHARS) { 
		 g_windowchars[0] = '\0';
		 i_charcount = 10;
	}
    strcat(g_windowchars, g_c_line);
	i_charcount = i_charcount + i_c_line_length;

	/* force an entire window repaint - really crude here */
	GetClientRect (g_h_hwnd, &rect);
	InvalidateRect(g_h_hwnd, &rect, TRUE);
	SendMessage(g_h_hwnd, WM_PAINT, 0, 0);
    return;
}

int doserve(int* pi_stop) /* used to basically be main() in srvr.c */
{
  /* set up to check messages in the future */
  extern void set_process_windows_messages_alarm (int* pi_stop);
  ilu_Server s;
  Test1_O1  uc, uc2;

  /* blank our window chars */
  g_windowchars[0] = '\0';

  Test1__InitializeServer();
  Test3__InitializeServer();

  s = ILU_C_InitializeServer ("Test1-Server", NULL, NULL, NULL, ilu_TRUE);
  uc = Test1_O1__CreateTrue ( "Test1_Initial_Object", s, NULL );

  if (uc != NULL)
    {
      ILU_C_PublishObject (uc);

      /* test the publish and lookup a bit */
      uc2 = ILU_C_LookupObject ("Test1-Server", "Test1_Initial_Object", Test1_O1__MSType);
      if (uc2 != uc)
	sprintf(g_c_line, "*** Error, lookup returns wrong object\n");
    paintit();
      ILU_C_PublishObject (uc2);

      sprintf(g_c_line, "exported %s\n", ILU_C_SBHOfObject(uc));
      paintit();
	  /* set up to check messages in the future */
      set_process_windows_messages_alarm (pi_stop);
      ILU_C_Stoppable_Run(pi_stop);
      return 0;
    }
  else
    {
	  MessageBox(g_h_hwnd, "couldn't create object\n", 
					"Error", MB_OK | MB_ICONEXCLAMATION);
      return (-1);
    }
  return 1;
}

Test1_U server_Test1_TheO1_U_CSS_to_U( Test1_O1 h, Test1_U * u, Test1_CSS *css, ILU_C_ENVIRONMENT *s )
{
  sprintf(g_c_line, "Test1.O1.U-CSS-to-U\n");
  paintit();
  return( *u );
}

Test1_RO server_Test1_TheO1_f_CSS_to_RO( Test1_O1 h, Test1_CSS *css, ILU_C_ENVIRONMENT *s )
{
  Test1_RO	x = (Test1_RO) ilu_must_malloc( sizeof( Test1_R ));

  x->i = 9;
  Test1_CSS_Init( &x->css , 0, NULL );
  x->a[0]= (Test1_ScS) strdup("hello");
  x->a[1]= (Test1_ScS) strdup("world");
  x->a[2]= (Test1_ScS) strdup("!\n");
  sprintf(g_c_line, "Test1.O1.f-CSS-to-R0\n");
  paintit();
  return( x );
}

float server_Test1_TheO1_R_ScS_to_F( Test1_O1 h, Test1_R *r, Test1_ScS str, ILU_C_ENVIRONMENT *s )
{
  float	f = 39.7;

  sprintf(g_c_line, "Test1.O1.R-ScS-to-F\n");
  paintit();
  return( f );
}

void server_Test1_TheO1_a_RO( Test1_O1 h, Test1_RO ro, ILU_C_ENVIRONMENT *s )
{
  sprintf(g_c_line, "Test1.O1.a-RO\n");
  paintit();
}

Test1_O2 server_Test1_TheO1_get_O2 ( Test1_O1 h, ILU_C_ENVIRONMENT *s )
{
  static Test1_O2 uc = NULL;

  sprintf(g_c_line, "Test1.O1.get-O2\n");
  paintit();
  if (uc == NULL)
    uc = Test1_O2__CreateTrue( NULL, NULL, NULL );
  if (uc == NULL)
    {
      s->_major = ILU_C_USER_EXCEPTION;
      s->returnCode = ex_Test1_CantCreate;
      return (NULL);
    }
  else
    return (uc);
}

Test1_O3 server_Test1_TheO1_get_O3 ( Test1_O1 h, ilu_boolean b, ILU_C_ENVIRONMENT *s )
{
  Test1_O3 uc;
  static int one = 0;

  sprintf(g_c_line, "Test1.O1.get-O3\n");
  paintit();
  if (b)
    uc = Test3_O__CreateTrue( NULL, NULL, NULL );
  else
    {
      if (one == 0)
	{
	  one = 1;
	  sprintf(g_c_line, "making O3...\n");
      paintit();
	  uc = Test1_O3__CreateTrue( NULL, NULL, NULL );
	}
      else
	{
	  one = 0;
	  sprintf(g_c_line, "making O4...\n");
      paintit();
	  uc = Test1_O4__CreateTrue (NULL, NULL, NULL);
	}
    }
  if (uc == NULL)
    {
      s->_major = ILU_C_USER_EXCEPTION;
      s->returnCode = ex_Test1_CantCreate;
      return (NULL);
    }
  else
    return (uc);
}

Test1_CSS server_Test1_O2_OO_A0_to_CSS (Test1_O2 self, Test1_OO o, Test1_A0 a, ILU_C_ENVIRONMENT *s)
{
  sprintf(g_c_line, "Test1.o2.OO-A0-to-CSS\n");
  paintit();
  if (o == NULL)
    {
      s->_major = ILU_C_USER_EXCEPTION;
      s->returnCode = ex_Test1_E2;
      s->ptr = (void *) ilu_must_malloc(sizeof(ilu_integer));
      *((ilu_integer *) s->ptr) = 7;
      return (Test1_CSS_Create(0,NULL));
    }
  else
    {
      Test1_CSS css = Test1_CSS_Create (0, NULL);
      return (css);
    }
}

Test1_A0 * server_Test1_O2_R_I_A1_to_I_A0 (Test1_O2 self, Test1_R *r, Test1_I *i, Test1_A1 a, ILU_C_ENVIRONMENT *s)
{
  Test1_A0 * a2;

  sprintf(g_c_line, "Test1.O2.R-I-A1-to-I-A0\n");
  paintit();
  a2 = (Test1_A0 *) ilu_must_malloc(8);
  return (a2);
}

#if !(defined(WIN32) || defined(WIN16))
static char *strdup(char *s)
{
  char *copy = NULL;
  if (s != NULL)
    {
      copy = ilu_must_malloc(strlen(s) + 1);
      strcpy (copy, s);
    }
  return (copy);
}
#endif /* !(defined(WIN32) || defined(WIN16)) */

Test1_IS server_Test1_O3_RS_R_to_R_IS (Test1_O3 self, Test1_RS *r, Test1_R *r2, ILU_C_ENVIRONMENT *s)
{
  Test1_IS is;

  sprintf(g_c_line, "Test1.O3.RS-R-to-R-IS\n");
  paintit();
  r2->i = 3;
  r2->css._maximum = 0;
  r2->css._length = 0;
  r2->css._buffer = NULL;
  r2->a[0] = (Test1_ScS) strdup("just");
  r2->a[1] = (Test1_ScS) strdup("a");
  r2->a[2] = (Test1_ScS) strdup("string");
  is._maximum = 0;
  is._length = 0;
  is._buffer = NULL;
  return (is);
}

Test1_IS server_Test1_P_RS_R_to_R_IS (Test1_P self, Test1_RS *r, Test1_R *r2, ILU_C_ENVIRONMENT *s)
{
  Test1_IS is;

  sprintf(g_c_line, "Test1.P.RS-R-to-R-IS\n");
  paintit();
  r2->i = 25719;
  r2->css._maximum = 0;
  r2->css._length = 0;
  r2->css._buffer = NULL;
  r2->a[0] = (Test1_ScS) strdup("from");
  r2->a[1] = (Test1_ScS) strdup("P");
  r2->a[2] = (Test1_ScS) strdup("string");
  is._maximum = 0;
  is._length = 0;
  is._buffer = NULL;
  return (is);
}

Test1_I server_Test1_P_BS_to_I (Test1_P self, Test1_BS *b, ILU_C_ENVIRONMENT *s)
{
  return (b->_length);
}

Test1_IS server_Test1_O4_RS_R_to_R_IS (Test1_O4 self, Test1_RS *r, Test1_R *r2, ILU_C_ENVIRONMENT *s)
{
  Test1_IS is;

  sprintf(g_c_line, "Test1.O4.RS-R-to-R-IS\n");
  paintit();
  r2->i = 25719;
  r2->css._maximum = 0;
  r2->css._length = 0;
  r2->css._buffer = NULL;
  r2->a[0] = (Test1_ScS) strdup("from");
  r2->a[1] = (Test1_ScS) strdup("P");
  r2->a[2] = (Test1_ScS) strdup("string");
  is._maximum = 0;
  is._length = 0;
  is._buffer = NULL;
  return (is);
}

void server_Test1_O4_O1_U_to_U (Test1_O4 self, Test1_O1 o, Test1_U *u, ILU_C_ENVIRONMENT *s)
{
  sprintf(g_c_line, "Test1.O4.O1-U-to-U\n");
  paintit();
  u->_d = Test1_U__O1;
  u->_u.O1 = o;
  return;
}

Test1_I server_Test1_O4_BS_to_I (Test1_O4 self, Test1_BS *b, ILU_C_ENVIRONMENT *s)
{
#define GETB(x)		((b->_length <= (x)) ? 0 : b->_buffer[x])

  sprintf(g_c_line, "Test1.O4.BS_to_I (%lu:  %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x ...) => %lu\n",
	  b->_length,
	  GETB(0), GETB(1), GETB(2), GETB(3), GETB(4), GETB(5), GETB(6), GETB(7), GETB(8), GETB(9), GETB(10),
	  b->_length);
  paintit();
  return (b->_length);
}

ilu_real server_Test1_O4_R_to_R (Test1_O4 self, ilu_real r, ILU_C_ENVIRONMENT *s)
{
  ilu_real r2 = 1020304.05060708;

  sprintf(g_c_line, "Test1.O4.R_to_R (%.10f) => %.10f\n", r, r2);
  paintit();
  return (r2);
}

Test1_I server_Test1_O3_BS_to_I (Test1_P self, Test1_BS *b, ILU_C_ENVIRONMENT *s)
{
  return (b->_length * b->_length);
}

Test1_I server_Test3_O_BS_to_I (Test3_O self, Test1_BS *b, ILU_C_ENVIRONMENT *s)
{
  return (b->_length * b->_length);
}

Test1_IS server_Test1_P_m2 (Test1_P self, long int j, ILU_C_ENVIRONMENT *s)
{
  Test1_IS foo;

  foo._maximum = 2;
  foo._length = 2;
  foo._buffer = (long int *) ilu_must_malloc(foo._maximum * sizeof(long int));
  foo._buffer[0] = j;
  foo._buffer[1] = j * j;
  return (foo);
}

void server_Test1_O3_O1_U_to_U (Test1_O3 self, Test1_O1 o, Test1_U *u, ILU_C_ENVIRONMENT *s)
{
  sprintf(g_c_line, "Test1.O3.O1-U-to-U\n");
  paintit();
  u->_d = Test1_U__O1;
  u->_u.O1 = o;
  return;
}

void server_Test1_P_O1_U_to_U (Test1_P self, Test1_O1 o, Test1_U *u, ILU_C_ENVIRONMENT *s)
{
  sprintf(g_c_line, "Test1.P.O1-U-to-U\n");
  paintit();
  u->_d = Test1_U__O1;
  u->_u.O1 = o;
  return;
}

Test1_IS server_Test3_O_RS_R_to_R_IS (Test3_O self, Test1_RS *r, Test1_R *r2, ILU_C_ENVIRONMENT *s)
{
  Test1_IS is;

  sprintf(g_c_line, "Test3.O.RS-R-to-R-IS\n");
  paintit();
  r2->i = 3;
  r2->css._maximum = 0;
  r2->css._length = 0;
  r2->css._buffer = NULL;
  r2->a[0] = (Test1_ScS) strdup("just");
  r2->a[1] = (Test1_ScS) strdup("a");
  r2->a[2] = (Test1_ScS) strdup("string");
  is._maximum = 0;
  is._length = 0;
  is._buffer = NULL;
  return (is);
}

void server_Test3_O_O1_U_to_U (Test1_O3 self, Test1_O1 o, Test1_U *u, ILU_C_ENVIRONMENT *s)
{
  sprintf(g_c_line, "Test3.O.O1-U-to-U(0x%lx, {%d})\n", (unsigned long) o, u->_d);
  paintit();
  u->_d = Test1_U__O1;
  u->_u.O1 = o;
  return;
}

ilu_integer server_Test3_O_SR_to_I (Test3_O self, ilu_shortreal i, ILU_C_ENVIRONMENT *s)
{
  ilu_integer j = i;

  sprintf(g_c_line, "Test3.O.SR-to-I(%f)\n", i);
  paintit();
  return (j);
}

Test1_U server_Test3_O_I_to_Test1U (Test3_O self, Test1_I i, ILU_C_ENVIRONMENT *s)
{
  Test1_U u;

  sprintf(g_c_line, "Test3.O.I-to-Test1U(%ld)\n", i);
  paintit();
  u._d = Test1_U__boolean;
  u._u.boolean = ilu_TRUE;
  return (u);
}

BOOL CALLBACK AboutDlgProc (HWND hDlg, UINT message, UINT wParam, LONG lParam) {
     switch (message) {
          case WM_INITDIALOG :
               return TRUE ;
          case WM_COMMAND :
               switch (wParam) {
			    case IDOK :
			         EndDialog (hDlg, 0) ;
			         return TRUE ;
                }
               break ;
          }
     return FALSE ;
}
                     
                     
/* our post quit message processing */
int after_windows_quit(int status) {
	return status;
}


long CALLBACK WndProc (HWND hwnd, UINT message, UINT wParam, LONG lParam)
     {
     HDC         hdc ;
     PAINTSTRUCT ps ;
     RECT        rect ;
	 static int i_already_serving = 0;
	 static int i_stop = 0;
	 
     switch (message)
          {
          case WM_PAINT :
               hdc = BeginPaint (hwnd, &ps) ;
               GetClientRect (hwnd, &rect) ;
               DrawText (hdc, g_windowchars, -1, &rect, DT_LEFT) ;
               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY :
               PostQuitMessage (0) ;
               return 0 ;

		  case WM_COMMAND :
		  	switch (LOWORD(wParam)) {
				case ID_ACTION_RUN	:
					if (i_already_serving != 0) {
						MessageBox(hwnd, "Already Serving", "Info", MB_OK | MB_ICONEXCLAMATION);
						break;
					}
					i_already_serving = 1;
					i_stop = 0;
					if (doserve(&i_stop) != 0) { 
						MessageBox(hwnd, "doserve Unsuccessful", "Error", MB_OK | MB_ICONEXCLAMATION);
					}
					MessageBox(hwnd, "doserve Successful", "Error", MB_OK | MB_ICONEXCLAMATION);
					i_already_serving = 0;					
					break;
				case ID_ACTION_EXIT :
					/* XXX Note:  Under WIN16, something in the tcpip system actually dispatches messages
   					for us while we're blocked in select.  Wherever this dispatch loop is, it
   					seems to not exit when a WM_QUIT is posted, so we'll force our ilu main loop to 
   					stop here by calling ilu_ExitMainLoop on our i_stop variable */  
   					ilu_ExitMainLoop(&i_stop);
					// MessageBox(NULL, "WndProc posted a quit message", "Info", MB_OK);
					PostQuitMessage (0) ;
					/* XXX Note the preceeding works fine under the win16 susbsystem under NT, but doesn't work
   					properly on an actual win16 platform with Microsoft's tcpip ! The select() call in
   					this case doesn't seem to always pay attention to timeouts! So we're going to 
   					just flat out exit on WIN16 */
#ifdef WIN16
					exit(after_windows_quit(0));
#endif
					break;
				case ID_ABOUT_SRVRW :
				 DialogBox(g_h_hInstance, MAKEINTRESOURCE(IDD_DIALOG1),
                         g_h_hwnd, (DLGPROC)AboutDlgProc);
					break;

			}
          }

     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }


int CALLBACK WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
     {
     static char szAppName[] = "iluTest1WindowsServer" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (hInstance, "srvrw_icon") ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU1) ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName,       // window class name
                    "iluTest1WindowsServer",   // window caption
                    WS_OVERLAPPEDWINDOW,   // window style
                    CW_USEDEFAULT,         // initial x position
                    CW_USEDEFAULT,         // initial y position
                    CW_USEDEFAULT,         // initial x size
                    CW_USEDEFAULT,         // initial y size
                    NULL,                  // parent window handle
                    NULL,                  // window menu handle
                    hInstance,             // program instance handle
                    NULL) ;                // creation parameters

	 /* save our window handle and app instance in the globals */
	 g_h_hwnd = hwnd;
	 g_h_hInstance = hInstance;

#ifdef WIN16     
     /* initialize winsock when under WIN16 */
     ilu_StartupWinsock ();
#endif
 
	 /* create our console for stdio output (e.g. from the ilu runtime) */
	 winio_console(hInstance, hPrevInstance,
            nCmdShow, 0, "serverw Console");

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     // MessageBox(NULL, "WinMain left the dispatch loop", "Info", MB_OK);
     return after_windows_quit(msg.wParam) ;
     }

