/*
** Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: cstubber.h,v 1.21 1996/01/10 09:45:31 spreitze Exp $ */
/* Last edited by Mike Spreitzer January 9, 1996 9:17 pm PST */

#include <stdio.h>

#if (defined(WIN32) && defined(_WINIO))
#include <winiodef.h>
extern int vfprintf_winio(FILE*, const char*, va_list);
/* defunct - extern int g_i_on_win32s; */
#endif /* (defined(WIN32) && defined(_WINIO)) */

#include <string.h>

#include <iluptype.h>

#define True TRUE
#define False FALSE

typedef void (*EnumProc) (void *, void *);
typedef boolean (*FindProc) (void *, void *);

#define Assert( e )	{if ( !( e )) \
	fatal( "Assertion <" # e "> failed in file %s line %d\n",__FILE__, __LINE__);}
#define CAlloc( n, t )	( t * ) iluparser_Malloc( n * sizeof( t ))
#define CRealloc( p, n, t ) ( t * ) iluparser_Realloc( p, n * sizeof( t ))

#define SegFault	*((char *)1)='a'
#define new_list	iluparser_new_list

typedef struct context_s {
    Interface 		interface;
    FILE 		*file;
    Type 		class;
    int			counter;
} *Context;

string          class_procedure_name(Procedure);
void            dedent(void);
void            emit(char *,...);
void            indent(void);
string          c_interface_name(Interface);
string          c_return_type(Type);
string          c_type_name(Type);
string          c_parameter_type(Type, ArgDirection);
string          c_argument_name(Argument);
string          c_constant_name(Constant);
string          c_exception_name(Exception);
string          c_simple_name(Name);
string          c_procedure_name(Procedure);
string          c_string(string);
boolean         IsSequenceObject(Type, Interface);
boolean         IsPipeObject(Type, Interface);
boolean         TypeIsStruct(Type);
boolean         TypeIsArray(Type);
boolean         TypeIsString(Type);
boolean         TypeIsWString(Type);
boolean         TypeIsPointer(Type);
boolean         TypeIsNonObjectStruct(Type);
boolean         NonStringSequence(Type);
boolean         HasFreeRoutine(Type);
void            SizeValue(Context, Type, char *name);
void            MarshallValue(Context, Type, string name, int indent);
void 
UnmarshallValue(Context c, Type t, unsigned long line, string buffer,
		int indent, boolean terminate, boolean allocate);
boolean         BlockingCall(Procedure);
void            fatal(char *,...);
void            error(char *,...);
void            generateCommonCode(Interface, FILE *);
void            generateClientCode(Interface, FILE *);
void            generateServerCode(Interface, FILE *);
void            generateCHeaders(Interface, FILE *);
void            generateNecessaryIncludes(Context);
void            listArgumentTypes(Argument, Context);
void            setFile(FILE *);
void            clearMethodList(void);
boolean         methodInList(char *methodName);
void            addMethodToList(char *methodName);
Interface       OriginalInterface(Type);
Type            UltimateType(Type);
boolean         ReadSynonyms(char *filename);
boolean         IsCacheableMethod(Procedure m);
boolean         PassedByRef(Type type);
void            encodeArgument(Argument arg, Context context);

void 
FreeValue(Type type, char *name, Context context,
	  int indent);
/* Emits a series of statements, with the given indentation. */

void 
generateProcHeader(Procedure m, Context c,
		   boolean external);
int             methodNdxOf(Procedure p, Type t);

extern cardinal MethodRecordID;
extern void     codeType(Type, char **, ArgDirection);
extern char    *interface_header_name(char *pc_interfacename);
extern char    *InterfaceHeaderTranslationFile;

#define SINGLETON(Type)	(type_description(Type)->structuredDes.object->singleton)

#define AND		&&
#define OR		||
#define NOT		!
