/* d_trln.cc
 *$Header: /al/acs/src/RCS/d_trln.cc,v 9.25 95/10/29 01:44:44 al Exp $
 * Transmission line. (ideal lossless.  for now, AC only)
 */
#include "ap.h"
#include "m_matrix.h"
#include "d_trln.h"
#include "error.h"
#include "io.h"
#include "s__.h"
/*--------------------------------------------------------------------------*/
//		TRANSLINE_COMMON::TRANSLINE_COMMON();
//		DEV_TRANSLINE::DEV_TRANSLINE();
//	void	DEV_TRANSLINE::parse(CS *cmd);
// 	void	DEV_TRANSLINE::print(int,int)const;
// 	int	DEV_TRANSLINE::dotr();
// 	void	DEV_TRANSLINE::doac();
//	void	DEV_TRANSLINE::setinitcond(CS*);
/*--------------------------------------------------------------------------*/
const double LINLENTOL = .000001;
const double DEFAULT_NL = 0.25;
DEV_TRANSLINE* This;	/* pass this around argparse */
/*--------------------------------------------------------------------------*/
TRANSLINE_COMMON::TRANSLINE_COMMON()
{
  z0 = 0.;
  td = 0.;
  f  = 0.;
  nl = DEFAULT_NL;
  reson = 0.;
  int i;
  for (i = 0;  i < NUM_INIT_COND;  i++)
    ic[i] = 0.;
  icset = FALSE;
}
/*--------------------------------------------------------------------------*/
DEV_TRANSLINE::DEV_TRANSLINE()
{
  devclass = TWOPORT;
  common = new TRANSLINE_COMMON;
}
/*--------------------------------------------------------------------------*/
void DEV_TRANSLINE::parse(CS& cmd)
{
  TRANSLINE_COMMON* c = (TRANSLINE_COMMON*)common;
  This = this;
  parselabel(cmd);
  parsenodes(cmd,NUMNODES);
  for (;;){
    if (cmd.argparse(REPEAT,
	"Z",	a2DOUBLE,   &c->z0,	&c->z0,
	"Freq",	aUDOUBLE,   &c->f,
	"Nl",	aUDOUBLE,   &c->nl,
	"Ic",	aFFUNCTION, DEV_TRANSLINE::setinitcond,
	"")){
      ;
    }else{
      cmd.check(bWARNING);
      break;
    }
  }
  if (c->nl == 0.)
    c->nl = DEFAULT_NL;
  c->reson = c->f * (.25 / c->nl);
}
/*--------------------------------------------------------------------------*/
/* setinitcond: set initial conditions
 * called indirectly thru argparse
 * "This" is a fudge to get around a restriction in argparse
 */
void DEV_TRANSLINE::setinitcond(CS& cmd)
{
  TRANSLINE_COMMON* c = (TRANSLINE_COMMON*)This->common;
  int i;
  c->icset = TRUE;
  for (i = 0;  i < NUM_INIT_COND;  i++)
    c->ic[i] = cmd.ctof();
}
/*--------------------------------------------------------------------------*/
void DEV_TRANSLINE::print(int where, int detail)const
{
  TRANSLINE_COMMON* c = (TRANSLINE_COMMON*)common;
  printlabel(where);
  printnodes(where,NUMNODES);
  mprintf(where, "  Z0=%s  F=%s  NL=%s",
	  ftos(c->z0, "", 7, 0),
	  ftos(c->f,  "", 7, 0),
	  ftos(c->nl, "", 7, 0));
  if (c->icset){
    mprintf(where, "  IC=");
    int i;
    for (i = 0;  i < NUM_INIT_COND;  i++)
      mprintf(where, "%s ",ftos(c->ic[i],"", 7, 0));
  }
  mputc('\n', where);
}
/*--------------------------------------------------------------------------*/
/* transmission line for transient analysis
 * stub: doesn't work
 * always returns success
 */
int DEV_TRANSLINE::dotr()
{
  error(bWARNING, "%s: no transmission line in dc or transient\n",
	printlabel());
  return converged = TRUE;
}
/*--------------------------------------------------------------------------*/
void DEV_TRANSLINE::doac()
{
  TRANSLINE_COMMON* c = (TRANSLINE_COMMON*)common;
  double lenth = SIM::freq / c->reson;	/* length in quarter waves */
  double dif = lenth - floor(lenth+.5);	/* avoid divide by zero if close to */
  if (fabs(dif) < LINLENTOL){		/* resonance by tweeking a little */
    error(bDEBUG,
	  "%s: transmission line too close to resonance\n", printlabel());
    lenth = (dif<0.) ? floor(lenth+.5)-LINLENTOL : floor(lenth+.5)+LINLENTOL;
  }
  lenth *= (kPId2);	/* now in radians */
  
  COMPLEX y12 = COMPLEX(0., -1. / (c->z0 * sin(lenth)));
  COMPLEX y11 = COMPLEX(0., tan(lenth/2) / c->z0) + y12;
  
  acx.s(n[OUT1].m,n[OUT1].m) += y11; 	/* BUG: bypasses load functions */
  acx.s(n[OUT2].m,n[OUT2].m) += y11;	/* result is flags may not be   */
  acx.s(n[OUT1].m,n[OUT2].m) -= y11;	/* updated.  No problem yet in  */
  acx.s(n[OUT2].m,n[OUT1].m) -= y11; 	/* AC but this will not work in */
					/* transient.			*/
  acx.s(n[IN1].m,n[IN1].m) += y11;
  acx.s(n[IN2].m,n[IN2].m) += y11;
  acx.s(n[IN1].m,n[IN2].m) -= y11;
  acx.s(n[IN2].m,n[IN1].m) -= y11;
  
  acx.s(n[OUT1].m,n[IN1].m) -= y12;
  acx.s(n[OUT2].m,n[IN2].m) -= y12;
  acx.s(n[OUT1].m,n[IN2].m) += y12;
  acx.s(n[OUT2].m,n[IN1].m) += y12;
  
  acx.s(n[IN1].m,n[OUT1].m) -= y12;
  acx.s(n[IN2].m,n[OUT2].m) -= y12;
  acx.s(n[IN1].m,n[OUT2].m) += y12;
  acx.s(n[IN2].m,n[OUT1].m) += y12;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
