;;;; Default keybindings
;;; This file is loaded by stdlib.tf.

/~loaded kbbind.tf

/require kbfunc.tf

;; Newline

/def -ib'^M'	= /DOKEY NEWLINE

/def defaultbind = \
    /if /!ismacro -msimple -ib'%1'%; /then \
        /def -ib'%1' = /%-1%;\
    /endif

;; ^J is DOWN on some terminals.
/defaultbind ^J dokey newline

;; Keys normally defined by stty.

/defaultbind ^H dokey_bspc
/defaultbind ^? dokey_bspc
/defaultbind ^W dokey_bword
/defaultbind ^U dokey dline
/defaultbind ^R dokey refresh
/defaultbind ^V dokey lnext

;; Keys normally defined by termcap.

/defaultbind ^[[A dokey_up
/defaultbind ^[[B dokey_down
/defaultbind ^[[C dokey_right
/defaultbind ^[[D dokey_left

/defaultbind ^[OA dokey_up
/defaultbind ^[OB dokey_down
/defaultbind ^[OC dokey_right
/defaultbind ^[OD dokey_left

/undef defaultbind

;; Other useful bindings
;; Any dokey operation "foo" can be performed with "/dokey foo" or "/dokey_foo".
;; The only difference between the two invocations is efficiency.

/def -ib'^A'	= /dokey_home
/def -ib'^B'	= /dokey_wleft
/def -ib'^D'	= /dokey_dch
/def -ib'^E'	= /dokey_end
/def -ib'^F'	= /dokey_wright
/def -ib'^G'	= /beep 1
/def -ib'^I'	= /dokey page
/def -ib'^K'	= /dokey_deol
/def -ib'^L'	= /dokey redraw
/def -ib'^N'	= /dokey recallf
/def -ib'^P'	= /dokey recallb
/def -ib'^T'	= /kb_transpose_chars
/def -ib'^[^E'	= /kb_expand_line
/def -ib'^[ '	= /kb_collapse_space
/def -ib'^[-'	= /kb_goto_match
/def -ib'^[.'	= /kb_last_argument
/def -ib'^[<'	= /dokey recallbeg
/def -ib'^[>'	= /dokey recallend
/def -ib'^[J'	= /dokey selflush
/def -ib'^[L'	= /dokey line
/def -ib'^[_'	= /kb_last_argument
/def -ib'^[b'	= /dokey_socketb
/def -ib'^[c'	= /kb_capitalize_word
/def -ib'^[d'	= /dokey_dword
/def -ib'^[f'	= /dokey_socketf
/def -ib'^[h'	= /dokey hpage
/def -ib'^[j'	= /dokey flush
/def -ib'^[l'	= /kb_downcase_word
/def -ib'^[n'	= /dokey searchf
/def -ib'^[p'	= /dokey searchb
/def -ib'^[u'	= /kb_upcase_word
/def -ib'^[v'	= /test insert := !insert
/def -ib'^[^h'	= /kb_backward_kill_word
/def -ib'^[^?'	= /kb_backward_kill_word

;; Other common keyboard-specific mappings
;Insert
/def -ib'^[[2~'	= /test insert := !insert
;F1
/def -ib'^[[11~'= /help
/def -ib'^[OP'	= /help
;PgDn
/def -ib'^[Os'	= /dokey page
;End
/def -ib'^[Oq'	= /dokey flush

