/************************************************************************
 * cmds.h -- part of rpncalc.c						*
 *									*
 * A little RPN (Reverse Polish Notation) calculator,                   *
 * rudimentary emulating a HP 28S. 					*
 * 								        *
 * rpncalc is (c) David Frey, 1993, 1994, 1995				*
 *								        * 
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *									* 
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *									* 
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *									* 
 ************************************************************************/

/* $Id: cmds.h,v 1.0 1995/12/31 18:16:22 david Rel $
 * $Log: cmds.h,v $
 * Revision 1.0  1995/12/31 18:16:22  david
 * Initial revision
 * */

#define FALSE 0
#define TRUE  1

#define STACKSIZE     128

enum BASE { DEC, HEX, OCT };	/* current base (dec,oct..) */

extern double stack[STACKSIZE];
extern short int tos;			/* top of stack */
extern int pushtostack;
extern enum BASE base;
extern int digits;			/* accuracy, number of digits */

double showstack(void);
double pick(double elm);
double pickcmd(double elm);
double depth(void);
