#!/usr/local/bin/perl 

#
# Handle arguments
#

if (@ARGV != 1) {
    print "usage: $0 encfile\n";
    exit(1);
}

$file = shift(@ARGV);

open(FP, $file) || die "couldn't open input file `$file': $!\n";

# Find the start of the table.
$found = 0;
while (<FP>) {
    if ($_ =~ /^-+$/) {
	$found = 1;
	last;
    }
}

if (!$found) {
    die "file `$file' is not a valid encoding file: couldn't find table\n";
}

$file =~ s/\.txt$//g;
$file =~ s/.*\///g;

# Print header.

print <<"EOF";
% 
% $file encoding vector.
% Copyright (c) 1995 Markku Rossi.
% Author: Markku Rossi <mtr\@iki.fi>
%

%
% This file is part of genscript.
% 
% Genscript is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% Genscript is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with genscript; see the file COPYING.  If not, write to
% the Free Software Foundation, 59 Temple Place - Suite 330,
% Boston, MA 02111-1307, USA.
%

% -- code follows this line --
/encode_vector [
EOF

$inum = 0;
sub print_item {
    ($code, $name) = @_;

    printf("8#");
    if ($code < 010) {
	printf("00%o", $code);
    } elsif ($code < 0100) {
	printf("0%o", $code);
    } else {
	printf("%o", $code);
    }
    printf("\t%-14s\t", $name);
    if ((++$inum % 3) == 0) {
	printf("\n");
    }
}

# Process file.

while (<FP>) {
    @cols = split;
    if ($_ =~ /^\s*$/) {
	next;
    } elsif ($_ =~ /non-printable/) {
	# Nothing.
    } elsif (@cols[2] =~ /-/) {
	# Nothing.
    } else {
	print_item(hex(@cols[1]), @cols[2]);
    }
}

# Print trailer.

if (($inum % 3) != 0) {
    printf("\n");
}
print "\] def\n";

close(FP);
