#! /usr/bin/make -f
#
.PHONY: install clean
 
INST_BIN=	install -g root -o root -m 755
INST_DIR=	install -g root -o root -d -m 755
INST_DAT=	install -g root -o root -m 644

root	=
prefix	=	$(root)/usr
config	=	$(root)/etc
BIN	=	$(prefix)/bin
XBIN	=	$(prefix)/X11R6/bin
APPDEF =        $(prefix)/X11R6/lib/X11/app-defaults
LIB	=	$(prefix)/lib
INFO    =       $(prefix)/info
MAN     =       $(prefix)/X11R6/man
DOC	=	$(prefix)/doc


# This is the default action
all:
	xmkmf
	make

# This this installs below $(prefix)
install:
	$(INST_DIR)			$(BIN)
	$(INST_DIR)			$(XBIN)
	$(INST_DIR)			$(config)/X11/xbmbrowser
	$(INST_DIR)			$(APPDEF)
	$(INST_DIR)			$(MAN)/man1
	$(INST_DIR)			$(DOC)/xbmbrowser
	$(INST_BIN) xbmbrowser	$(XBIN)
	$(INST_BIN) XbmBrowser.ad	$(APPDEF)/XbmBrowser
	$(INST_BIN) XbmBrowser-color.ad	$(APPDEF)/XbmBrowser-color
	$(INST_DAT) xbmbrowser.menu	$(config)/X11/xbmbrowser
	$(INST_DAT) xbmbrowser.man	$(MAN)/man1
	$(INST_DAT) xbmbrowser.menu.tut	$(DOC)/xbmbrowser

# This cleans up
clean:
	make clean
	rm -f Makefile

# Local Variables:
#   mode: makefile
# End:

