//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#ifndef _TIMER_H_
#define _TIMER_H_

//
//                 General purpose interval timer class
//
//  Implemented using BSD derived function gettimeofday for greater resolution
//
//   Author : Mike Romberg


#include <sys/time.h>


class Timer {
public:
  Timer( int start = 0 ) { if ( start ) Timer::start(); }
  ~Timer( void ){}

  void start( void ) { gettimeofday( &starttime_, NULL ); }
  void stop( void )  { gettimeofday( &stoptime_, NULL );  }
  //  reports time intervall between calls to start and stop in usec
  long report( void ) { 
    return (stoptime_.tv_sec - starttime_.tv_sec) * 100000
           + stoptime_.tv_usec - starttime_.tv_usec; 
  }
protected:
  struct timeval starttime_, stoptime_;
private:
};

#endif
