/*
   PXKMenuWindow.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@net-community.com>
   Date: May 1997
   
   This file is part of the GNUstep GUI X/DPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __gnustep_xdps_PXKMenuWindow_h__
#define __gnustep_xdps_PXKMenuWindow_h__

#include <AppKit/NSView.h>
#include <gnustep/xdps/PXKWindow.h>

#if !defined(LIB_FOUNDATION_LIBRARY) && !defined(NeXT_PDO)
/* Assume gnustep-base */
# include <gnustep/base/RunLoop.h>
#endif

@class PXKMenu;

@interface PXKMenuWindow : PXKWindow
#if !defined(LIB_FOUNDATION_LIBRARY) && !defined(NeXT_PDO)
/* Assume gnustep-base */
				<FdListening>
#endif
{
  int titleHeight;
  PXKMenu* menu;
}

- (void)setTitleHeight:(int)height;
- (void)setMenu:(PXKMenu*)menu;
- (PXKMenu*)menu;

@end


/* An instance of this class represents the title of the menu window */
@interface PXKMenuWindowTitleView : NSView

- (void)windowBecomeTornOff;

@end


#endif /* __gnustep_xdps_PXKMenuWindow_h__ */
