/* 
   PXKColorWell.m

   NSColorWell for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.
   Author:  Scott Christley <scottc@net-community.com>
   Date: March 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <gnustep/xdps/PXKColorWell.h>
#include <AppKit/NSColor.h>
#include <AppKit/NSGraphics.h>

// Border width and handle width
// 1/64 of an inch
#define PXKBW 1.125
// 1/16 of an inch
#define PXKHW 4.5

@implementation PXKColorWell

//
// Class methods
//
+ (void)initialize
{
  if (self == [PXKColorWell class])
    {
      // Initial version
      [self setVersion:1];
    }
}

//
// Instance methods
//

//
// Drawing
//
- (void)drawWellInside:(NSRect)insideRect
{
  [the_color set];
  NSRectFill(insideRect);
}

- (void)drawRect:(NSRect)rect
{
  NSRect inside = rect;

  // Draw border
  if (is_bordered)
    [self drawBorderRect: rect];

  // Calculate inside rect
  inside.origin.x += PXKBW + PXKHW + PXKBW;
  inside.origin.y += PXKBW + PXKHW + PXKBW;
  inside.size.width -= (4*PXKBW + PXKHW + PXKHW);
  inside.size.height -= (4*PXKBW + PXKHW + PXKHW);

  // Draw the color inside
  [self drawWellInside: inside];
}

@end

//
// GNUstep backend methods
//
@implementation PXKColorWell (GNUstepBackend)

- (void)drawBorderRect:(NSRect)aRect
{
  NSColor *white = [NSColor whiteColor];
  NSColor *black = [NSColor blackColor];
  NSColor *gray = [NSColor lightGrayColor];
  NSRect inside;

  // Fill the area with gray first
  [gray set];
  NSRectFill(bounds);

  // Draw the outside edges
  // draw the top and left light edges
  [white set];
  PSnewpath();
  PSmoveto(aRect.origin.x, aRect.origin.y);
  PSlineto(aRect.origin.x,
	   aRect.origin.y + aRect.size.height);
  PSlineto(aRect.origin.x + aRect.size.width,
	   aRect.origin.y + aRect.size.height);
  PSlineto(aRect.origin.x + aRect.size.width - PXKBW,
	   aRect.origin.y + aRect.size.height - PXKBW);
  PSlineto(aRect.origin.x + PXKBW,
	   aRect.origin.y + aRect.size.height - PXKBW);
  PSlineto(aRect.origin.x + PXKBW, aRect.origin.y + PXKBW);
  PSclosepath();
  PSfill();

  // draw the bottom and right dark edges
  [black set];
  PSnewpath();
  PSmoveto(aRect.origin.x + aRect.size.width,
	   aRect.origin.y + aRect.size.height);
  PSlineto(aRect.origin.x + aRect.size.width,
	   aRect.origin.y);
  PSlineto(aRect.origin.x, aRect.origin.y);
  PSlineto(aRect.origin.x + PXKBW, aRect.origin.y + PXKBW);
  PSlineto(aRect.origin.x + aRect.size.width - PXKBW,
	   aRect.origin.y + PXKBW);
  PSlineto(aRect.origin.x + aRect.size.width - PXKBW,
	   aRect.origin.y + aRect.size.height - PXKBW);
  PSclosepath();
  PSfill();

  // Determine the inside rect
  inside = aRect;
  inside.origin.x += PXKBW + PXKHW;
  inside.origin.y += PXKBW + PXKHW;
  inside.size.width -= (PXKBW + PXKBW + PXKHW + PXKHW);
  inside.size.height -= (PXKBW + PXKBW + PXKHW + PXKHW);

  // Draw the inside edges
  // draw the top and left dark edges
  [black set];
  PSnewpath();
  PSmoveto(inside.origin.x, inside.origin.y);
  PSlineto(inside.origin.x,
	   inside.origin.y + inside.size.height);
  PSlineto(inside.origin.x + inside.size.width,
	   inside.origin.y + inside.size.height);
  PSlineto(inside.origin.x + inside.size.width - PXKBW,
	   inside.origin.y + inside.size.height - PXKBW);
  PSlineto(inside.origin.x + PXKBW,
	   inside.origin.y + inside.size.height - PXKBW);
  PSlineto(inside.origin.x + PXKBW, inside.origin.y + PXKBW);
  PSclosepath();
  PSfill();

  // draw the bottom and right light edges
  [white set];
  PSnewpath();
  PSmoveto(inside.origin.x + inside.size.width,
	   inside.origin.y + inside.size.height);
  PSlineto(inside.origin.x + inside.size.width,
	   inside.origin.y);
  PSlineto(inside.origin.x, inside.origin.y);
  PSlineto(inside.origin.x + PXKBW, inside.origin.y + PXKBW);
  PSlineto(inside.origin.x + inside.size.width - PXKBW,
	   inside.origin.y + PXKBW);
  PSlineto(inside.origin.x + inside.size.width - PXKBW,
	   inside.origin.y + inside.size.height - PXKBW);
  PSclosepath();
  PSfill();

}

@end
