/*      -------------------------------------------------------------------
	xldlas -- A Program for Statistics

	Copyright (C) 1996, 1997 Thor Sigvaldason

	This builds the front end to xldlas using xforms
	
        -------------------------------------------------------------------*/

#include "xldlas.h"
#include "xldlas_logo.xpm"
#include "humboldt_logo.xpm"

extern void nothing(FL_OBJECT *ob, long user_data);
extern void user_quit_xldlas();

extern void return_data_huh(FL_OBJECT *obj, long arg);
extern void add_data(FL_OBJECT *obj, long arg);
extern void double_click_add(FL_OBJECT *obj, long arg);
extern void insert_data(FL_OBJECT *obj, long arg);
extern void replace_data(FL_OBJECT *obj, long arg);
extern void delete_data(FL_OBJECT *obj, long arg);
extern void clear_data(FL_OBJECT *obj, long arg);
extern void end_input_variable(FL_OBJECT *obj, long arg);
extern int click_end_input_variable(FL_FORM *form, void *arg);
extern int click_user_chose_variable(FL_FORM *form, void *arg);
extern int click_done_drop_variable(FL_FORM *form, void *arg);

extern void help_about_general(FL_OBJECT *obj, long arg);
extern void help_about_file(FL_OBJECT *obj, long arg);
extern void help_about_data(FL_OBJECT *obj, long arg);
extern void help_about_log(FL_OBJECT *obj, long arg);
extern void help_about_graph(FL_OBJECT *obj, long arg);
extern void help_about_analysis(FL_OBJECT *obj, long arg);
extern void help_about_license(FL_OBJECT *obj, long arg);
extern void help_about_tutorial(FL_OBJECT *obj, long arg);
extern void help_about_test(FL_OBJECT *obj, long arg);
extern void help_about_filter(FL_OBJECT *obj, long arg);
extern void stop_help(FL_OBJECT *obj, long arg);
extern void push_describe_data(FL_OBJECT *obj, long arg);
extern void user_chose_variable(FL_OBJECT *obj, long arg);
extern void user_drop_variable(FL_OBJECT *obj, long arg);
extern void done_drop_variable(FL_OBJECT *obj, long arg);
extern void drop_all_variables(FL_OBJECT *obj, long arg);

                    
extern int click_abort_list_variables(FL_FORM *form, void *arg);
extern void list_variables(FL_OBJECT *obj, long arg);

extern int click_user_rename_variable(FL_FORM *form, void *arg);
extern void user_rename_variable(FL_OBJECT *obj, long arg);

extern int click_user_summarize_variable(FL_FORM *form, void *arg);
extern void user_summarize_variable(FL_OBJECT *obj, long arg);


extern void load_dataset(FL_OBJECT *ob, long user_data);
extern void save_dataset(FL_OBJECT *ob, long user_data);

extern int click_abort_corr_variables(FL_FORM *form, void *arg);
extern void corr_variables(FL_OBJECT *obj, long arg);

extern int click_abort_regress_variables(FL_FORM *form, void *arg);
extern void regress_variables(FL_OBJECT *obj, long arg);
extern void start_regress_variables(FL_OBJECT *obj, long arg);
extern void done_regress_variables(FL_OBJECT *obj, long arg);

extern int  click_done_graph_variables(FL_FORM *form, void *arg);
extern void done_graph_variables(FL_OBJECT *obj, long arg);
extern void plot_variables(FL_OBJECT *obj, long arg);
extern void start_graph_variables(FL_OBJECT *obj, long arg);
extern void handle_graph_browsers(FL_OBJECT *obj, long arg);
extern void handle_graph_choices(FL_OBJECT *obj, long arg);
extern void set_graph_range_counters(FL_OBJECT *obj, long arg);

extern int  click_done_attributes(FL_FORM *form, void *arg);
extern void done_attributes(FL_OBJECT *obj, long arg);
extern void graph_toggles(FL_OBJECT *obj, long arg);
extern void graph_set_bar(FL_OBJECT *obj, long arg);

extern int  click_done_ga(FL_FORM *form, void *arg);
extern void done_ga(FL_OBJECT *obj, long arg);
extern void handle_ga_counters(FL_OBJECT *obj, long arg);
extern void handle_ga_buttons(FL_OBJECT *obj, long arg);
extern void launch_ga(FL_OBJECT *obj, long arg);

extern int  click_done_logtexlog(FL_FORM *form, void *arg);
extern void logtexlog_routines(FL_OBJECT *obj, long arg);

extern int  click_end_viewfile(FL_FORM *form, void *arg);
extern void end_viewfile(FL_OBJECT *obj, long arg);

extern void handle_prefs_buttons(FL_OBJECT *obj, long arg);
extern void handle_prefs_counters(FL_OBJECT *obj, long arg);
extern void handle_prefs_inputs(FL_OBJECT *obj, long arg);
extern void start_prefs(FL_OBJECT *obj, long arg);
extern int  click_end_prefs(FL_FORM *form, void *arg);
extern void set_font_preference(FL_OBJECT *obj, long arg);

extern void done_gen(FL_OBJECT *obj, long arg);
extern void handle_gen_buttons(FL_OBJECT *obj, long arg);
extern int  click_done_gen(FL_FORM *form, void *arg);

extern void handle_anova_buttons(FL_OBJECT *obj, long arg);
extern void done_anova(FL_OBJECT *obj, long arg);
extern void do_anova(FL_OBJECT *obj, long arg);
extern int  click_done_anova(FL_FORM *form, void *arg);
extern int  click_done_nnet(FL_FORM *form, void *arg);


extern void handle_nnet_buttons(FL_OBJECT *obj, long arg);

extern TOOLTIPS_ERROR tooltips_addtip(FL_OBJECT *whichObjectPtr, char *theTipPtr);

extern void inhibit_graph_input();

extern void test_routines(FL_OBJECT *menu, long user_data); 
extern void filter_routines(FL_OBJECT *menu, long user_data);

extern void done_signtest(FL_OBJECT *obj, long arg);
extern void do_signtest(FL_OBJECT *obj, long arg);
extern void done_eqmeantest(FL_OBJECT *obj, long arg);
extern void do_eqmeantest(FL_OBJECT *obj, long arg);
extern void done_watsontest(FL_OBJECT *obj, long arg);
extern void do_watsontest(FL_OBJECT *obj, long arg);
extern void done_filter(FL_OBJECT *obj, long arg);
extern void do_filter(FL_OBJECT *obj, long arg);

void horizontal_scrolling(FL_OBJECT *obj, long arg)
{
	fl_set_browser_xoffset(main_browser, fl_get_slider_value(horizontal_slider));
}

void set_abort_true(FL_OBJECT *obj, long arg)
{
	general_abort = TRUE;
}

int click_abort_window(FL_FORM *form, void *arg)
{
	return(FL_IGNORE);
}


void set_possible_choices()
{
	if(data_exists == TRUE)
	{
		fl_set_menu_item_mode(file_menu, 3, FL_PUP_NONE);
		fl_set_menu_item_mode(data_menu, 2, FL_PUP_NONE);
		fl_set_menu_item_mode(data_menu, 3, FL_PUP_NONE);
		fl_set_menu_item_mode(data_menu, 4, FL_PUP_NONE);
		fl_set_menu_item_mode(data_menu, 5, FL_PUP_NONE);
		fl_set_menu_item_mode(data_menu, 6, FL_PUP_NONE);
		fl_set_menu_item_mode(data_menu, 7, FL_PUP_NONE);
		fl_set_menu_item_mode(data_menu, 9, FL_PUP_NONE);

		fl_activate_object(analysis_menu);
		fl_set_object_lcol(analysis_menu, FL_BLACK);
		
		fl_activate_object(save_button);
		fl_set_object_lcol(save_button, FL_BLACK);

		fl_activate_object(test_menu);
		fl_set_object_lcol(test_menu, FL_BLACK);

		fl_activate_object(filter_menu);
		fl_set_object_lcol(filter_menu, FL_BLACK);

		fl_activate_object(describe_button);
		fl_set_object_lcol(describe_button, FL_BLACK);

		if(graph_window_open == FALSE)
		{
			fl_activate_object(plot_button);
			fl_set_object_lcol(plot_button, FL_BLACK);

			fl_activate_object(graph_menu);
			fl_set_object_lcol(graph_menu, FL_BLACK);
		}
		else
		{
			fl_deactivate_object(plot_button);
			fl_set_object_lcol(plot_button, FL_INACTIVE);

			fl_deactivate_object(graph_menu);
			fl_set_object_lcol(graph_menu, FL_INACTIVE);
		}
					

		fl_activate_object(regress_button);		
		fl_set_object_lcol(regress_button, FL_BLACK);
		
	}
	else
	{
		fl_set_menu_item_mode(file_menu, 3, FL_PUP_GREY);
		fl_set_menu_item_mode(data_menu, 2, FL_PUP_GREY);
		fl_set_menu_item_mode(data_menu, 3, FL_PUP_GREY);
		fl_set_menu_item_mode(data_menu, 4, FL_PUP_GREY);
		fl_set_menu_item_mode(data_menu, 5, FL_PUP_GREY);
		fl_set_menu_item_mode(data_menu, 6, FL_PUP_GREY);
		fl_set_menu_item_mode(data_menu, 7, FL_PUP_GREY);
		fl_set_menu_item_mode(data_menu, 9, FL_PUP_GREY);

		fl_deactivate_object(graph_menu);
		fl_set_object_lcol(graph_menu, FL_INACTIVE);
					
		fl_deactivate_object(analysis_menu);
		fl_set_object_lcol(analysis_menu, FL_INACTIVE);

		fl_deactivate_object(test_menu);
		fl_set_object_lcol(test_menu, FL_INACTIVE);
		
		fl_deactivate_object(filter_menu);
		fl_set_object_lcol(filter_menu, FL_INACTIVE);
		
		fl_deactivate_object(save_button);
		fl_set_object_lcol(save_button, FL_INACTIVE);

		fl_deactivate_object(describe_button);
		fl_set_object_lcol(describe_button, FL_INACTIVE);

		fl_deactivate_object(plot_button);
		fl_set_object_lcol(plot_button, FL_INACTIVE);

		fl_deactivate_object(regress_button);		
		fl_set_object_lcol(regress_button, FL_INACTIVE);
		
		if(graph_window_open == TRUE)
		{
			done_graph_variables(choose_hist_button,0);
			inhibit_graph_input();
			graph_window_open = FALSE;
		}
	}
	if(oktoquit == TRUE)
	{
		fl_activate_object(load_button);
		fl_set_object_lcol(load_button, FL_BLACK);
		fl_set_menu_item_mode(file_menu, 2, FL_PUP_NONE);
		fl_set_menu_item_mode(file_menu, 6, FL_PUP_NONE);
	}
	else
	{
		fl_deactivate_object(load_button);
		fl_set_object_lcol(load_button, FL_INACTIVE);
		fl_set_menu_item_mode(file_menu, 2, FL_PUP_GREY);
		fl_set_menu_item_mode(file_menu, 6, FL_PUP_GREY);
	}
	if(help_exists[1] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 1, FL_PUP_NONE);
		fl_activate_object(general_help_button);
		fl_set_object_lcol(general_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 1, FL_PUP_GREY);
		fl_deactivate_object(general_help_button);
		fl_set_object_lcol(general_help_button, FL_INACTIVE);
	}
	if(help_exists[2] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 2, FL_PUP_NONE);
		fl_activate_object(file_help_button);
		fl_set_object_lcol(file_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 2, FL_PUP_GREY);
		fl_deactivate_object(file_help_button);
		fl_set_object_lcol(file_help_button, FL_INACTIVE);
	}
	if(help_exists[3] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 3, FL_PUP_NONE);
		fl_activate_object(data_help_button);
		fl_set_object_lcol(data_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 3, FL_PUP_GREY);
		fl_deactivate_object(data_help_button);
		fl_set_object_lcol(data_help_button, FL_INACTIVE);
	}
	if(help_exists[4] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 4, FL_PUP_NONE);
		fl_activate_object(log_help_button);
		fl_set_object_lcol(log_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 4, FL_PUP_GREY);
		fl_deactivate_object(log_help_button);
		fl_set_object_lcol(log_help_button, FL_INACTIVE);
	}
	if(help_exists[5] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 5, FL_PUP_NONE);
		fl_activate_object(graph_help_button);
		fl_set_object_lcol(graph_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 5, FL_PUP_GREY);
		fl_deactivate_object(graph_help_button);
		fl_set_object_lcol(graph_help_button, FL_INACTIVE);
	}
	if(help_exists[6] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 6, FL_PUP_NONE);
		fl_activate_object(analysis_help_button);
		fl_set_object_lcol(analysis_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 6, FL_PUP_GREY);
		fl_deactivate_object(analysis_help_button);
		fl_set_object_lcol(analysis_help_button, FL_INACTIVE);
	}
	if(help_exists[7] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 7, FL_PUP_NONE);
		fl_activate_object(test_help_button);
		fl_set_object_lcol(test_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 7, FL_PUP_GREY);
		fl_deactivate_object(test_help_button);
		fl_set_object_lcol(test_help_button, FL_INACTIVE);
	}
	if(help_exists[8] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 8, FL_PUP_NONE);
		fl_activate_object(filter_help_button);
		fl_set_object_lcol(filter_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 8, FL_PUP_GREY);
		fl_deactivate_object(tutorial_help_button);
		fl_set_object_lcol(tutorial_help_button, FL_INACTIVE);
	}
	if(help_exists[9] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 9, FL_PUP_NONE);
		fl_activate_object(license_help_button);
		fl_set_object_lcol(license_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 9, FL_PUP_GREY);
		fl_deactivate_object(license_help_button);
		fl_set_object_lcol(license_help_button, FL_INACTIVE);
	}
	if(help_exists[10] == TRUE)
	{
		fl_set_menu_item_mode(help_menu, 10, FL_PUP_NONE);
		fl_activate_object(tutorial_help_button);
		fl_set_object_lcol(tutorial_help_button, FL_BLACK);
	}
	else
	{
		fl_set_menu_item_mode(help_menu, 10, FL_PUP_GREY);
		fl_deactivate_object(tutorial_help_button);
		fl_set_object_lcol(tutorial_help_button, FL_INACTIVE);
	}
}


void inhibit_input()
{
	fl_deactivate_object(file_menu);
	fl_set_object_lcol(file_menu, FL_INACTIVE);
	fl_deactivate_object(test_menu);
	fl_set_object_lcol(test_menu, FL_INACTIVE);
	fl_deactivate_object(filter_menu);
	fl_set_object_lcol(filter_menu, FL_INACTIVE);
	fl_deactivate_object(data_menu);
	fl_set_object_lcol(data_menu, FL_INACTIVE);
	fl_deactivate_object(log_menu);
	fl_set_object_lcol(log_menu, FL_INACTIVE);
	fl_deactivate_object(analysis_menu);
	fl_set_object_lcol(analysis_menu, FL_INACTIVE);
	fl_deactivate_object(load_button);
	fl_set_object_lcol(load_button, FL_INACTIVE);
	fl_deactivate_object(save_button);
	fl_set_object_lcol(save_button, FL_INACTIVE);
	fl_deactivate_object(describe_button);
	fl_set_object_lcol(describe_button, FL_INACTIVE);
	fl_deactivate_object(regress_button);
	fl_set_object_lcol(regress_button, FL_INACTIVE);
	fl_deactivate_object(preferences_button);
	fl_set_object_lcol(preferences_button, FL_INACTIVE);
	fl_deactivate_object(clear_button);
	fl_set_object_lcol(clear_button, FL_INACTIVE);
}


void reenable_input()
{
	fl_activate_object(file_menu);
	fl_set_object_lcol(file_menu, FL_BLACK);
	fl_activate_object(test_menu);
	fl_set_object_lcol(test_menu, FL_BLACK);
	fl_activate_object(filter_menu);
	fl_set_object_lcol(filter_menu, FL_BLACK);
	fl_activate_object(data_menu);
	fl_set_object_lcol(data_menu, FL_BLACK);
	fl_activate_object(log_menu);
	fl_set_object_lcol(log_menu, FL_BLACK);
	fl_activate_object(analysis_menu);
	fl_set_object_lcol(analysis_menu, FL_BLACK);
	fl_activate_object(load_button);
	fl_set_object_lcol(load_button, FL_BLACK);
	fl_activate_object(save_button);
	fl_set_object_lcol(save_button, FL_BLACK);
	fl_activate_object(describe_button);
	fl_set_object_lcol(describe_button, FL_BLACK);
	fl_activate_object(regress_button);
	fl_set_object_lcol(regress_button, FL_BLACK);
	fl_activate_object(preferences_button);
	fl_set_object_lcol(preferences_button, FL_BLACK);
	fl_activate_object(clear_button);
	fl_set_object_lcol(clear_button, FL_BLACK);
	set_possible_choices();
}

void user_quit(int signum, void *data)
{
	int choice;
	if(oktoquit == TRUE)
	{
		inhibit_input();
#ifdef XFORMS86
		choice = fl_show_choice("Are you sure you want to quit?",
					"","", 3,
					"Yes","No","Cancel",1);
#else
		choice = fl_show_choice("Are you sure you want to quit?",
					"","", 3,
					"Yes","No","Cancel");

#endif
		if(choice == 1)
		{
			user_quit_xldlas();
		}
		if(choice == 2 || choice == 3)
		{
			reenable_input();
			return;
		}
	}
	else
	{
		fl_show_alert("There is unsaved data!",
			      "Please Drop or Save before Exiting",
			      "",TRUE);
		return;
	}
}
                 
int user_close(FL_FORM *frontend, void *user_data)
{
	int choice;
	if(oktoquit == TRUE)
	{
		inhibit_input();
#ifdef XFORMS86
		choice = fl_show_choice("Are you sure you want to quit?",
					"","", 3,
					"Yes","No","Cancel",2);
#else
		choice = fl_show_choice("Are you sure you want to quit?",
					"","", 3,
					"Yes","No","Cancel");
#endif
		if(choice == 1)
		{
			return(FL_OK);
		}
		if(choice == 2 || choice == 3)
		{
			reenable_input();
			return(FL_IGNORE);
		}
	}		
	fl_show_alert("There is unsaved data!",
		      "Please Drop or Save before Exiting",
		      "",TRUE);
	return(FL_IGNORE);
}
                 
void do_nothing(FL_OBJECT *ob, long user_data)
{
	return;
}

void say_status (char the_status[256])
{
	char string_one[256];
	strcpy(string_one,"@M@C3");
	strcat(string_one,the_status);
	fl_clear_browser(status_browser);
	fl_add_browser_line(status_browser,string_one);
}

void enough_already(FL_OBJECT *obj, long user_data)
{
	window_geometry[XLDLAS_ABOUT][0] = obj->form->x;
	window_geometry[XLDLAS_ABOUT][1] = obj->form->y;
	window_geometry[XLDLAS_ABOUT][2] = obj->form->w;
	window_geometry[XLDLAS_ABOUT][3] = obj->form->h;
	fl_hide_form(about_window);
	say_status("Ready");
}

int click_enough_already(FL_FORM *form, void *user_data)
{
	int which_window;
	which_window = 0;
	if(form == help_window) which_window = XLDLAS_HELP;
	if(form == about_window) which_window = XLDLAS_ABOUT;
	window_geometry[which_window][0] = form->x;
	window_geometry[which_window][1] = form->y;
	window_geometry[which_window][2] = form->w;
	window_geometry[which_window][3] = form->h;
	say_status("Ready");
	return(FL_OK);
}

void about_xldlas(FL_OBJECT *menu, long user_data)
{
	say_status("Displaying information about xldlas");
	if(window_geometry[XLDLAS_ABOUT][0] != -1)
	{
		fl_set_form_geometry(about_window, 
					window_geometry[XLDLAS_ABOUT][0],
					window_geometry[XLDLAS_ABOUT][1],
					window_geometry[XLDLAS_ABOUT][2],
					window_geometry[XLDLAS_ABOUT][3]);
	}	
        fl_show_form(about_window,FL_PLACE_FREE,FL_FULLBORDER,"About xldlas");
}


void clear_main_browser(FL_OBJECT *menu, long user_data)
{
	fl_clear_browser(main_browser);
}

void really_drop(FL_OBJECT *menu, long user_data)
{
	real_drop = TRUE;
}

void dont_really_drop(FL_OBJECT *menu, long user_data)
{
	real_drop = FALSE;
}




void create_frontend()
{
	char	scratch_one[256];
	char	scratch_two[256];
	FL_OBJECT *done_button;
	FL_OBJECT *browse_about;

	FL_OBJECT *obj; 

	FL_OBJECT *icon_button;

	fl_add_signal_callback(SIGINT, user_quit, 0);
	fl_add_signal_callback(SIGQUIT, user_quit, 0);

       	frontend = fl_bgn_form(FL_UP_BOX, 640, 480);

	/*
		The Basic frame of the User Interface
	*/
	
	obj = fl_add_box(FL_UP_BOX,0,0,640,480,"");
  	main_browser = fl_add_browser(FL_NORMAL_BROWSER,10,90,620,350,"");
		fl_set_object_dblbuffer(main_browser, 1);
		fl_set_object_color(main_browser,FL_WHITE,FL_YELLOW);
    		fl_set_browser_fontsize(main_browser,FL_NORMAL_SIZE);
		fl_set_object_gravity(main_browser, FL_NorthWest, FL_SouthEast);

  	obj = fl_add_box(FL_UP_BOX,0,0,640,40,"");
		fl_set_object_gravity(obj, FL_North, FL_North);
		fl_set_object_resize(obj, FL_RESIZE_X);
  	/*
  		The Menu Strip
  	*/
  	
	obj = fl_bgn_group();
  		file_menu = fl_add_menu(FL_PULLDOWN_MENU,10,10,40,20,"File");
    			fl_set_object_shortcut(file_menu,"F",1);
    			fl_set_object_boxtype(file_menu,FL_FLAT_BOX);
    			fl_set_object_lsize(file_menu,FL_NORMAL_SIZE);
			fl_addto_menu(file_menu,"About");
			fl_addto_menu(file_menu,"Load");
			fl_addto_menu(file_menu,"Save");
			fl_addto_menu(file_menu,"Append");
			fl_addto_menu(file_menu,"Import");
			fl_addto_menu(file_menu,"Quit");
			fl_set_object_callback(file_menu,file_routines,0);
			tooltips_addtip(file_menu,"Move data in and out of xldlas");
  		data_menu = fl_add_menu(FL_PULLDOWN_MENU,60,10,40,20,"Data");
    			fl_set_object_shortcut(data_menu,"D",1);
    			fl_set_object_boxtype(data_menu,FL_FLAT_BOX);
    			fl_set_object_lsize(data_menu,FL_NORMAL_SIZE);
			fl_addto_menu(data_menu,"Input");
			fl_addto_menu(data_menu,"Edit");
			fl_addto_menu(data_menu,"Drop");
			fl_addto_menu(data_menu,"Rename");
			fl_addto_menu(data_menu,"Describe");
			fl_addto_menu(data_menu,"List");
			fl_addto_menu(data_menu,"Label");
			fl_addto_menu(data_menu,"Generate");
			fl_set_object_callback(data_menu,data_routines,0);
			tooltips_addtip(data_menu,"Examine and edit current dataset");
  		log_menu = fl_add_menu(FL_PULLDOWN_MENU,110,10,40,20,"Log");
    			fl_set_object_shortcut(log_menu,"L",1);
    			fl_set_object_boxtype(log_menu,FL_FLAT_BOX);
    			fl_set_object_lsize(log_menu,FL_NORMAL_SIZE);
			fl_addto_menu(log_menu,"Standard Log");
			fl_addto_menu(log_menu,"TeX Log");
			fl_addto_menu(log_menu,"HTML Log");
			fl_set_object_callback(log_menu,log_routines,0);
			tooltips_addtip(log_menu,"Log xldlas output in various formats");
  		graph_menu = fl_add_menu(FL_PULLDOWN_MENU,160,10,45,20,"Graph");
    			fl_set_object_shortcut(graph_menu,"G",1);
    			fl_set_object_boxtype(graph_menu,FL_FLAT_BOX);
    			fl_set_object_lsize(graph_menu, FL_NORMAL_SIZE);
			fl_addto_menu(graph_menu,"Histogram");
			fl_addto_menu(graph_menu,"Plot");
			fl_set_object_callback(graph_menu,graph_routines,0);
			tooltips_addtip(graph_menu,"Use gnuplot to graph data");
  		analysis_menu = fl_add_menu(FL_PULLDOWN_MENU,220,10,55,20,"Analysis");
    			fl_set_object_shortcut(analysis_menu,"A",1);
    			fl_set_object_boxtype(analysis_menu,FL_FLAT_BOX);
    			fl_set_object_lsize(analysis_menu,FL_NORMAL_SIZE);
			fl_addto_menu(analysis_menu,"Summarize");
			fl_addto_menu(analysis_menu,"Correlation");
			fl_addto_menu(analysis_menu,"Regress");
			fl_addto_menu(analysis_menu,"GA Fit");
			fl_addto_menu(analysis_menu,"NN Fit");
			fl_addto_menu(analysis_menu,"ANOVA");
			fl_set_object_callback(analysis_menu,analysis_routines,0);
			tooltips_addtip(analysis_menu,"Perform statistical operations");
  		test_menu = fl_add_menu(FL_PULLDOWN_MENU,280,10,55,20,"Test");
    			fl_set_object_shortcut(test_menu,"T",1);
    			fl_set_object_boxtype(test_menu,FL_FLAT_BOX);
    			fl_set_object_lsize(test_menu,FL_NORMAL_SIZE);
			fl_addto_menu(test_menu,"Sign");
			fl_addto_menu(test_menu,"Equality of Means");
			fl_addto_menu(test_menu,"Durbin-Watson");
			fl_set_object_callback(test_menu,test_routines,0);
			tooltips_addtip(test_menu,"Perform statistical tests");
  		filter_menu = fl_add_menu(FL_PULLDOWN_MENU,330,10,55,20,"Filter");
    			fl_set_object_shortcut(filter_menu,"i",1);
    			fl_set_object_boxtype(filter_menu,FL_FLAT_BOX);
    			fl_set_object_lsize(filter_menu,FL_NORMAL_SIZE);
			fl_addto_menu(filter_menu,"Remove Outliers");
			fl_addto_menu(filter_menu,"De-Trend");
			fl_addto_menu(filter_menu,"Transform 0-1");
			fl_set_object_callback(filter_menu,filter_routines,0);
			tooltips_addtip(filter_menu,"Filter existing data");
	fl_end_group();
	fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
	fl_set_object_resize(obj, FL_RESIZE_NONE);

  	help_menu = fl_add_menu(FL_PULLDOWN_MENU,590,10,40,20,"Help");
    		fl_set_object_shortcut(help_menu,"H",1);
    		fl_set_object_boxtype(help_menu,FL_FLAT_BOX);
    		fl_set_object_lsize(help_menu,FL_NORMAL_SIZE);
		fl_addto_menu(help_menu,"General Help");
		fl_addto_menu(help_menu,"File commands");
		fl_addto_menu(help_menu,"Data commands");
		fl_addto_menu(help_menu,"Log commands");
		fl_addto_menu(help_menu,"Graph commands");
		fl_addto_menu(help_menu,"Analysis commands");
		fl_addto_menu(help_menu,"Test commands");
		fl_addto_menu(help_menu,"Filter commands");
		fl_addto_menu(help_menu,"See the License");
		fl_addto_menu(help_menu,"See the Tutorials");
		fl_set_object_callback(help_menu,help_routines,0);
		fl_set_object_gravity(help_menu, FL_NorthEast, FL_NorthEast);
		fl_set_object_resize(help_menu, FL_RESIZE_NONE);
		tooltips_addtip(help_menu,"Get help on xldlas");
    	
    	/*
    		The Button Bar
    	*/
	obj = fl_bgn_group();
  		load_button = fl_add_button(FL_NORMAL_BUTTON,10,50,70,30,"Load");
			fl_set_object_callback(load_button, load_dataset, 0);
			tooltips_addtip(load_button, "Load in a .lda dataset file");
	  	save_button = fl_add_button(FL_NORMAL_BUTTON,90,50,70,30,"Save");
			fl_set_object_callback(save_button, save_dataset, 0);
			tooltips_addtip(save_button, "Save current dataset in a .lda file");
	  	describe_button = fl_add_button(FL_NORMAL_BUTTON,170,50,70,30,"Describe");
			fl_set_object_callback(describe_button, push_describe_data, 0);
			tooltips_addtip(describe_button, "List details of the current dataset");
	  	plot_button = fl_add_button(FL_NORMAL_BUTTON,250,50,70,30,"Plot");
			fl_set_object_callback(plot_button, start_graph_variables, 2);
			tooltips_addtip(plot_button, "Open the graphing window");
	  	regress_button = fl_add_button(FL_NORMAL_BUTTON,330,50,70,30,"Regress");
			fl_set_object_callback(regress_button, start_regress_variables, 0);
			tooltips_addtip(regress_button, "Open the OLS regression window");
	  	preferences_button = fl_add_button(FL_NORMAL_BUTTON,410,50,70,30,"Preferences");
			fl_set_object_callback(preferences_button, start_prefs, 0);
			tooltips_addtip(preferences_button, "Set preferences (ie. turn off these help balloons)");
	  	clear_button = fl_add_button(FL_NORMAL_BUTTON,490,50,70,30,"Clear");
	        	fl_set_object_callback(clear_button, clear_main_browser, 0);
			tooltips_addtip(clear_button, "Clear the main display area");
	fl_end_group();
	fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
  	/*
  		The Icon (did you know you can push it to see
  		"about xldlas" information?)
  	*/
  	icon_button = fl_add_pixmapbutton(FL_NORMAL_BUTTON,595,47,35,35,"");
    		fl_set_object_boxtype(icon_button, FL_UP_BOX);
		fl_set_object_callback(icon_button, about_xldlas, 0);
		fl_set_pixmapbutton_data(icon_button, xldlas_logo_xpm);
		fl_set_object_resize(icon_button, FL_RESIZE_NONE);
		fl_set_object_gravity(icon_button, FL_NorthEast, FL_NorthEast);
		tooltips_addtip(icon_button,"About xldlas");
	/*
		The little text display line at the bottom
	*/
	obj = fl_add_text(FL_NORMAL_TEXT,15,443,620,30,"Status:");
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
	#ifdef XFORMS86
  	status_browser = fl_add_browser(FL_NORMAL_BROWSER,60,447,500,24,"");
		fl_add_browser_line(status_browser,"@M@C3initializing xldlas");
		fl_set_object_resize(status_browser, FL_RESIZE_X);
		fl_set_object_gravity(status_browser, FL_SouthWest, FL_SouthEast);
	#else
  	status_browser = fl_add_browser(FL_NORMAL_BROWSER,60,447,460,24,"");
		fl_add_browser_line(status_browser,"@M@C3initializing xldlas");
		fl_set_object_resize(status_browser, FL_RESIZE_X);
		fl_set_object_gravity(status_browser, FL_SouthWest, FL_SouthEast);
	/*
		The horizontal scrolling buttons
	*/
	horizontal_slider = fl_add_slider(FL_HOR_SLIDER,530, 447,100,25,"");
		fl_set_slider_value(horizontal_slider, 0);
		fl_set_slider_bounds(horizontal_slider,0,XLDLAS_MAX_OFFSET);
		fl_set_slider_step(horizontal_slider, 1.0);
		fl_set_slider_precision(horizontal_slider, 0);
		fl_set_object_resize(horizontal_slider, FL_RESIZE_NONE);
		fl_set_object_gravity(horizontal_slider,FL_SouthEast, FL_SouthEast);
		fl_set_object_callback(horizontal_slider, horizontal_scrolling, 0);
		tooltips_addtip(horizontal_slider,"Scroll the main display area");
	#endif
	/*
		That's it for the main form
	*/
        fl_end_form();
	fl_set_form_minsize(frontend, 640, 100);
	/*
		The about window (form)
	*/

       	about_window = fl_bgn_form(FL_UP_BOX, 400, 280);
	obj = fl_add_pixmap(FL_NORMAL_PIXMAP,5,7,60,70,"");
    		fl_set_object_boxtype(obj,FL_NO_BOX);
		fl_set_pixmapbutton_data(obj, humboldt_logo_xpm);
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_NorthEast, FL_NorthEast);
  	obj = fl_add_text(FL_NORMAL_TEXT,65,10,280,60,"The development of xldlas\n has been supported by\n Humboldt Open Computing.");
    		fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    		fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    		fl_set_object_lstyle(obj,FL_NORMAL_STYLE);
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
	browse_about = fl_add_browser(FL_NORMAL_BROWSER,5,80,390,150,"");
		fl_set_object_gravity(browse_about, FL_NorthWest, FL_SouthEast);
	fl_freeze_form(about_window);
	strcpy(scratch_one,"xldlas v");
	sprintf(scratch_two,"%d",XLDLAS_MAJOR);
	strcat(scratch_one,scratch_two);
	strcat(scratch_one,".");
	sprintf(scratch_two,"%d",XLDLAS_MINOR);
	strcat(scratch_one,scratch_two);
	strcat(scratch_one," -- A Program for Statistics");
	fl_add_browser_line(browse_about,scratch_one);
	strcpy(scratch_one,"Copyright (C) 1996, 1997 ");
	strcat(scratch_one,XLDLAS_AUTHOR);
	fl_add_browser_line(browse_about,scratch_one);
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"Popup Help Balloons based on the tooltips library");
	fl_add_browser_line(browse_about,"Copyright (C) 1996 Michael Chu");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"This program is free software; you can redistribute it and/or modify");
	fl_add_browser_line(browse_about,"it under the terms of the GNU General Public License as published by");
	fl_add_browser_line(browse_about,"the Free Software Foundation; either version 2 of the License, or");
	fl_add_browser_line(browse_about,"(at your option) any later version.");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"This program is distributed in the hope that it will be useful,");
	fl_add_browser_line(browse_about,"but WITHOUT ANY WARRANTY; without even the implied warranty of");
	fl_add_browser_line(browse_about,"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See");
	fl_add_browser_line(browse_about,"the GNU General Public License for more details.");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"You should have received a copy of the GNU General Public License");
	fl_add_browser_line(browse_about,"along with this program; if not, write to the Free Software");
	fl_add_browser_line(browse_about,"Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"-------------------------------------------------------------");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"Code written to compile with the GNU C compiler (GCC) and run");
	fl_add_browser_line(browse_about,"under the Linux operating system. Kudos to Linus Torvalds");
	fl_add_browser_line(browse_about,"the Free Software Foundation, and the developpers of xforms.");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"-------------------------------------------------------------");
	fl_add_browser_line(browse_about,"   ");
	strcpy(scratch_one,"The author can be reached by e-mail at: " XLDLAS_EMAIL);
	fl_add_browser_line(browse_about, scratch_one);
	fl_add_browser_line(browse_about,"The primary site for this software is:");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about, XLDLAS_SITE1);
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"The secondary site for this software is:");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about, XLDLAS_SITE2);
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"where X is the major version number and Y is the minor");
	fl_add_browser_line(browse_about,"version number");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"-------------------------------------------------------------");
	fl_add_browser_line(browse_about,"   ");
	fl_add_browser_line(browse_about,"The source code is dated " XLDLAS_DATE);
	fl_add_browser_line(browse_about,"and was compiled on " __DATE__ " at " __TIME__".");
	fl_add_browser_line(browse_about,"   ");

  	done_button = fl_add_button(FL_NORMAL_BUTTON,5,240,390,30,"Dismiss");
		fl_set_object_callback(done_button, enough_already, 0);
		fl_set_object_resize(done_button, FL_RESIZE_X);
		fl_set_object_gravity(done_button, FL_SouthWest, FL_SouthEast);
		tooltips_addtip(done_button,"OK, I'm done reading about xldlas.");

	fl_unfreeze_form(about_window);
	fl_end_form();
	fl_set_form_atclose(about_window, click_enough_already, 0);
	/*
	
		The input/editing window (form)
	*/
	input_window = fl_bgn_form(FL_UP_BOX, 280, 480);
	input_browser = fl_add_browser(FL_HOLD_BROWSER,106,108,154,316,"");
		fl_set_object_dblbuffer(input_browser, 1);
		fl_set_object_callback(input_browser,do_nothing,0);
		fl_set_browser_dblclick_callback(input_browser,double_click_add,0);
		fl_set_object_gravity(input_browser, FL_NorthWest, FL_SouthEast);
	name_input = fl_add_input(FL_NORMAL_INPUT,58,22,202,26,"Name:");
  		fl_set_object_callback(name_input,do_nothing,0);
		fl_set_input_maxchars(name_input, NAME_LENGTH-1);
		fl_set_object_resize(name_input, FL_RESIZE_X);
		fl_set_object_gravity(name_input, FL_NorthWest, FL_NorthEast);
	desc_input = fl_add_input(FL_NORMAL_INPUT,58,64,202,26,"Desc:");
  		fl_set_object_callback(desc_input,do_nothing,0);
		fl_set_input_maxchars(desc_input, DESC_LENGTH-1);
		fl_set_object_resize(desc_input, FL_RESIZE_X);
		fl_set_object_gravity(desc_input, FL_NorthWest, FL_NorthEast);
	input_object = fl_add_input(FL_FLOAT_INPUT,106,442,154,28,"Values:");
  		fl_set_object_callback(input_object,return_data_huh,0);
		fl_set_object_resize(input_object, FL_RESIZE_X);
		fl_set_object_gravity(input_object, FL_SouthWest, FL_SouthEast);
	obj = fl_add_button(FL_NORMAL_BUTTON,20,108,70,28,"Clear");
		fl_set_object_lcol(obj,FL_RED);
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_callback(obj,clear_data,0);
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
		tooltips_addtip(obj,"Erase all observations");
	obj = fl_add_button(FL_NORMAL_BUTTON,20,150,70,28,"Done");
		fl_set_object_lcol(obj,FL_YELLOW);
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_callback(obj,end_input_variable,0);
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
		tooltips_addtip(obj,"Finished inputing/editing");
	obj = fl_add_button(FL_NORMAL_BUTTON,20,350,70,28,"Insert");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_callback(obj,insert_data,0);
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
		tooltips_addtip(obj,"Insert a new value");
	obj = fl_add_button(FL_NORMAL_BUTTON,20,300,70,28,"Replace");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_callback(obj,replace_data,0);
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
		tooltips_addtip(obj,"Replace current value");
	obj = fl_add_button(FL_NORMAL_BUTTON,20,396,70,28,"Add");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_callback(obj,add_data,0);
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
		tooltips_addtip(obj,"Add value to list");
	obj = fl_add_button(FL_NORMAL_BUTTON,20,250,70,28,"Delete");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_callback(obj,delete_data,0);
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
		tooltips_addtip(obj,"Delete current value");
	fl_end_form();
	fl_set_form_atclose(input_window, click_end_input_variable, 0);
	fl_set_atclose(*user_close, 0);
	/*
	
		The help window
	*/
	
	help_window = fl_bgn_form(FL_NO_BOX, 740, 210);
	obj = fl_add_box(FL_UP_BOX,0,0,740,210,"");
	help_browser = fl_add_browser(FL_NORMAL_BROWSER,10,10,510,190,"");
		fl_set_object_dblbuffer(help_browser, 1);
		fl_set_object_callback(help_browser,do_nothing,0);
		fl_set_browser_fontsize(help_browser, FL_NORMAL_SIZE);
		fl_set_object_gravity(help_browser, FL_NorthWest, FL_SouthEast);
	obj = fl_bgn_group();
		general_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,540,10,80,25,"General");
			fl_set_object_lsize(general_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(general_help_button,help_about_general,0);
		file_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,540,40,80,25,"File");
			fl_set_object_lsize(file_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(file_help_button,help_about_file,0);
		data_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,540,70,80,25,"Data");
			fl_set_object_lsize(data_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(data_help_button,help_about_data,0);
		test_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,540,100,80,25,"Test");
			fl_set_object_lsize(test_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(test_help_button,help_about_test,0);
		log_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,540,130,80,25,"Log");
			fl_set_object_lsize(log_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(log_help_button,help_about_log,0);

		graph_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,630,10,80,25,"Graph");
			fl_set_object_lsize(graph_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(graph_help_button,help_about_graph,0);
		analysis_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,630,40,80,25,"Analysis");
			fl_set_object_lsize(analysis_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(analysis_help_button,help_about_analysis,0);
		license_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,630,70,80,25,"License");
			fl_set_object_lsize(license_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(license_help_button,help_about_license,0);
		filter_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,630,100,80,25,"Filter");
			fl_set_object_lsize(filter_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(filter_help_button,help_about_filter,0);
		tutorial_help_button = fl_add_lightbutton(FL_RADIO_BUTTON,630,130,80,25,"Tutorials");
			fl_set_object_lsize(tutorial_help_button,FL_NORMAL_SIZE);
			fl_set_object_callback(tutorial_help_button,help_about_tutorial,0);
  	fl_end_group();
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_NorthEast, FL_NorthEast);

	obj = fl_add_button(FL_NORMAL_BUTTON,540,170,170,30,"Dismiss");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_callback(obj,stop_help,0);
		fl_set_object_resize(obj, FL_RESIZE_NONE);
		fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);

  	fl_end_form();
	fl_set_form_atclose(help_window, click_enough_already, 0);

	variable_window = fl_bgn_form(FL_NO_BOX, 160, 200);
	obj = fl_add_box(FL_UP_BOX,0,0,160,200,"");
	variable_browser = fl_add_browser(FL_HOLD_BROWSER,10,10,140,150,"");
		fl_set_object_dblbuffer(variable_browser, 1);
		fl_set_object_callback(variable_browser,do_nothing,0);
		fl_set_browser_fontsize(variable_browser, FL_NORMAL_SIZE);
		fl_set_browser_dblclick_callback(variable_browser,user_chose_variable,0);
	obj = fl_add_button(FL_NORMAL_BUTTON,10,165,140,25,"OK");
		fl_set_object_callback(obj,user_chose_variable,0);
	fl_end_form();
	fl_set_form_atclose(variable_window, click_user_chose_variable, 0);


	rename_window = fl_bgn_form(FL_NO_BOX, 160, 200);
	obj = fl_add_box(FL_UP_BOX,0,0,160,200,"");
	rename_browser = fl_add_browser(FL_HOLD_BROWSER,10,10,140,150,"");
		fl_set_object_dblbuffer(rename_browser, 1);
		fl_set_object_callback(rename_browser,do_nothing,0);
		fl_set_browser_fontsize(rename_browser, FL_NORMAL_SIZE);
		fl_set_browser_dblclick_callback(rename_browser,user_rename_variable,0);
	obj = fl_add_button(FL_NORMAL_BUTTON,10,165,140,25,"OK");
		fl_set_object_callback(obj,user_rename_variable,0);
		tooltips_addtip(obj,"OK, I'm happy with this name");
	fl_end_form();
	fl_set_form_atclose(rename_window, click_user_rename_variable, 0);



	drop_window = fl_bgn_form(FL_NO_BOX, 220, 300);
	obj = fl_add_box(FL_UP_BOX,0,0,220,300,"");
	drop_browser = fl_add_browser(FL_HOLD_BROWSER,10,10,200,150,"");
		fl_set_object_dblbuffer(drop_browser, 1);
		fl_set_object_callback(drop_browser,do_nothing,0);
		fl_set_browser_fontsize(drop_browser, FL_NORMAL_SIZE);
		fl_set_browser_dblclick_callback(drop_browser,user_drop_variable,0);
	obj = fl_add_button(FL_NORMAL_BUTTON,10,165,60,25,"Drop");
		fl_set_object_callback(obj,user_drop_variable,0);
		fl_set_object_lcol(obj,FL_YELLOW);
		tooltips_addtip(obj,"Drop selected variables");
	obj = fl_add_button(FL_NORMAL_BUTTON,80,165,60,25,"All!");
		fl_set_object_callback(obj,drop_all_variables,0);
		fl_set_object_lcol(obj,FL_RED);
		tooltips_addtip(obj,"Drop all variables (Careful!)");
	obj = fl_add_button(FL_NORMAL_BUTTON,150,165,60,25,"Done");
		fl_set_object_callback(obj,done_drop_variable,0);
		tooltips_addtip(obj,"OK, I'm done dropping variables");
	obj = fl_bgn_group();
		obj = fl_add_lightbutton(FL_RADIO_BUTTON,10,200,95,30,"All OBS");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			fl_set_button(obj,1);
			fl_set_object_callback(obj,really_drop,0);
			tooltips_addtip(obj,"Set Drop Range to include ALL observations");
		obj = fl_add_lightbutton(FL_RADIO_BUTTON,115,200,95,30,"In Range");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			fl_set_object_callback(obj,dont_really_drop,0);
			tooltips_addtip(obj,"Limit Drop Range to observations between From: and To:");
	fl_end_group();
 	drop_from_counter = fl_add_counter(FL_NORMAL_COUNTER,70,240,140,20,"");
		fl_set_object_callback(drop_from_counter, do_nothing,0);
		fl_set_counter_precision(drop_from_counter,0);

 	drop_to_counter = fl_add_counter(FL_NORMAL_COUNTER,70,270,140,20,"");
		fl_set_object_callback(drop_to_counter, do_nothing,0);
		fl_set_counter_precision(drop_to_counter, 0);
 	obj = fl_add_text(FL_NORMAL_TEXT,10,240,50,20,"From:");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,10,270,50,20,"To:");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
	fl_end_form();
	fl_set_form_atclose(drop_window, click_done_drop_variable, 0);

	/*
		List variable(s) browser
	*/
  	list_window = fl_bgn_form(FL_NO_BOX, 240, 370);
	obj = fl_add_box(FL_UP_BOX,0,0,240,370,"");
	list_browser = fl_add_browser(FL_MULTI_BROWSER,10,10,220,240,"");
		fl_set_object_callback(list_browser, do_nothing,0);
 	list_from_counter = fl_add_counter(FL_NORMAL_COUNTER,90,260,140,20,"");
		fl_set_object_callback(list_from_counter, do_nothing,0);
		fl_set_counter_precision(list_from_counter, 0);
		tooltips_addtip(list_from_counter,"Limit the number of observations listed.");

 	list_to_counter = fl_add_counter(FL_NORMAL_COUNTER,90,290,140,20,"");
		fl_set_object_callback(list_to_counter, do_nothing,0);
		fl_set_counter_precision(list_to_counter, 0);
		tooltips_addtip(list_to_counter,"Limit the number of observations listed.");
 	obj = fl_add_text(FL_NORMAL_TEXT,40,260,50,20,"From:");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,40,290,50,20,"To:");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
	obj = fl_add_button(FL_NORMAL_BUTTON,10,330,220,30,"OK");
		fl_set_object_callback(obj,list_variables,0);
		tooltips_addtip(obj,"I'm ready, go ahead and list the highlighted variables.");

  	fl_end_form();
  	fl_set_form_atclose(list_window, click_abort_list_variables, 0);


	summarize_window = fl_bgn_form(FL_NO_BOX, 200, 260);
	obj = fl_add_box(FL_UP_BOX,0,0,200,260,"");
	summarize_browser = fl_add_browser(FL_MULTI_BROWSER,10,10,180,150,"");
		fl_set_object_dblbuffer(summarize_browser, 1);
		fl_set_object_callback(summarize_browser,do_nothing,0);
		fl_set_browser_fontsize(summarize_browser, FL_NORMAL_SIZE);
	obj = fl_add_button(FL_NORMAL_BUTTON,10,165,180,25,"OK");
		fl_set_object_callback(obj,user_summarize_variable,0);
		tooltips_addtip(obj,"I'm ready, go ahead and summarize the highlighted variables.");

 	summarize_from_counter = fl_add_counter(FL_NORMAL_COUNTER,50,200,140,20,"");
		fl_set_object_callback(summarize_from_counter, do_nothing,0);
		fl_set_counter_precision(summarize_from_counter, 0);
		tooltips_addtip(summarize_from_counter,"Limit the number of observations summarized.");

 	summarize_to_counter = fl_add_counter(FL_NORMAL_COUNTER,50,230,140,20,"");
		fl_set_object_callback(summarize_to_counter, do_nothing,0);
		fl_set_counter_precision(summarize_to_counter, 0);
		tooltips_addtip(summarize_to_counter,"Limit the number of observations summarized.");
 	obj = fl_add_text(FL_NORMAL_TEXT,10,200,40,20,"From:");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,10,230,40,20,"To:");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);

	fl_end_form();
	fl_set_form_atclose(summarize_window, click_user_summarize_variable, 0);


	/*
		corr variable(s) browser
	*/
  	corr_window = fl_bgn_form(FL_NO_BOX, 240, 370);
	obj = fl_add_box(FL_UP_BOX,0,0,240,370,"");
	corr_browser = fl_add_browser(FL_MULTI_BROWSER,10,10,220,240,"");
		fl_set_object_callback(corr_browser, do_nothing,0);
 	corr_from_counter = fl_add_counter(FL_NORMAL_COUNTER,90,260,140,20,"");
		fl_set_object_callback(corr_from_counter, do_nothing,0);
		fl_set_counter_precision(corr_from_counter, 0);

 	corr_to_counter = fl_add_counter(FL_NORMAL_COUNTER,90,290,140,20,"");
		fl_set_object_callback(corr_to_counter, do_nothing,0);
		fl_set_counter_precision(corr_to_counter, 0);
 	obj = fl_add_text(FL_NORMAL_TEXT,40,260,50,20,"From:");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,40,290,50,20,"To:");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
	obj = fl_add_button(FL_NORMAL_BUTTON,10,330,220,30,"OK");
		fl_set_object_callback(obj,corr_variables,0);

  	fl_end_form();
  	fl_set_form_atclose(corr_window, click_abort_corr_variables, 0);


	regress_window = fl_bgn_form(FL_NO_BOX, 300, 350);
	obj = fl_add_box(FL_UP_BOX,0,0,300,350,"");
	regress1_browser = fl_add_browser(FL_HOLD_BROWSER,10,40,130,170,"");
		fl_set_object_callback(regress1_browser,do_nothing,0);
	regress2_browser = fl_add_browser(FL_MULTI_BROWSER,160,40,130,170,"");
		fl_set_object_callback(regress2_browser,do_nothing,0);
	obj = fl_add_text(FL_NORMAL_TEXT,10,10,130,20,"Dependent Var");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,160,10,130,20,"Independent Var(s)");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
 	regress_from_counter = fl_add_counter(FL_NORMAL_COUNTER,40,280,100,20,"From:");
		fl_set_object_callback(regress_from_counter, do_nothing,0);
		fl_set_counter_precision(regress_from_counter, 0);
		fl_set_object_lalign(regress_from_counter,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
 	regress_to_counter = fl_add_counter(FL_NORMAL_COUNTER,190,280,100,20,"To:");
		fl_set_object_callback(regress_to_counter, do_nothing,0);
		fl_set_counter_precision(regress_to_counter, 0);
		fl_set_object_lalign(regress_to_counter,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
	obj = fl_add_button(FL_NORMAL_BUTTON,10,310,130,30,"Go");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_callback(obj, regress_variables,0);
		tooltips_addtip(obj,"Run the specified regression");
	obj = fl_add_button(FL_NORMAL_BUTTON, 160,310, 130,30,"DONE");
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_callback(obj, done_regress_variables,0);
		tooltips_addtip(obj,"I'm done doing regressions");
	fit_variable_input = fl_add_input(FL_NORMAL_INPUT,100,220,190,30,"Fitted Values in:");
		fl_set_object_callback(fit_variable_input,do_nothing,0);
		fl_set_input_maxchars(fit_variable_input, NAME_LENGTH-1);
	fit_overwrite_button = fl_add_checkbutton(FL_PUSH_BUTTON,100,250,70,30,"Overwrite");
		fl_set_object_callback(fit_overwrite_button,do_nothing,0);	
		tooltips_addtip(fit_overwrite_button,"Overwrite existing values in Fit:");
	fl_end_form();
  	fl_set_form_atclose(regress_window, click_abort_regress_variables, 0);


	/*
	
		The Graphing Window
	*/
	



	graph_window = fl_bgn_form(FL_NO_BOX, 950, 220);
		obj = fl_add_box(FL_UP_BOX,0,0,950,220,"");
		xvar_browser = fl_add_browser(FL_HOLD_BROWSER,20,40,170,130,"");
			fl_set_object_callback(xvar_browser, do_nothing, 0);
		yvar_browser = fl_add_browser(FL_MULTI_BROWSER,210,40,170,130,"");
			fl_set_object_callback(yvar_browser, do_nothing,0);
			fl_set_browser_dblclick_callback(yvar_browser, handle_graph_browsers, 0);
			
			
		obj = fl_add_button(FL_NORMAL_BUTTON,210,180,80,30,"Go!");
			fl_set_object_callback(obj, plot_variables, 0);
			tooltips_addtip(obj,"Go ahead and plot it");
		obj = fl_add_button(FL_NORMAL_BUTTON,300,180,80,30,"Done");
			fl_set_object_lcol(obj,FL_YELLOW);
			fl_set_object_callback(obj, done_graph_variables, 0);
			tooltips_addtip(obj,"I'm done graphing variables");

		graph_from_counter = fl_add_counter(FL_NORMAL_COUNTER,630,20,140,30,"");
			fl_set_object_callback(graph_from_counter, do_nothing,0);
			fl_set_counter_precision(graph_from_counter, 0);
		graph_to_counter = fl_add_counter(FL_NORMAL_COUNTER,630,60,140,30,"");
			fl_set_object_callback(graph_to_counter, do_nothing,0);
			fl_set_counter_precision(graph_to_counter, 0);


		graph_save_input = fl_add_input(FL_NORMAL_INPUT,440,20,140,30,"Save As:");
			fl_set_object_callback(graph_save_input,do_nothing,0);
		graph_title_input = fl_add_input(FL_NORMAL_INPUT,440,60,140,30,"Title:");
			fl_set_object_callback(graph_title_input,do_nothing,0);
		graph_ylabel_input = fl_add_input(FL_NORMAL_INPUT,440,100,140,30,"Y Label:");
			fl_set_object_callback(graph_ylabel_input,do_nothing,0);
		graph_xlabel_input = fl_add_input(FL_NORMAL_INPUT,440,140,140,30,"X Label:");
			fl_set_object_callback(graph_xlabel_input,do_nothing,0);

		obj = fl_add_text(FL_NORMAL_TEXT,590,20,40,30,"From:");
			fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
		obj = fl_add_text(FL_NORMAL_TEXT,590,60,40,30,"To:");
			fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);

		graph_bar_counter = fl_add_counter(FL_SIMPLE_COUNTER,630,180,140,30,"");
			fl_set_object_callback(graph_bar_counter, graph_set_bar,0);
			fl_set_counter_precision(graph_bar_counter, 0);
		obj = fl_add_text(FL_NORMAL_TEXT,590,180,40,30,"Bars:");
    			fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);

		obj = fl_bgn_group();
			choose_hist_button = fl_add_lightbutton(FL_PUSH_BUTTON,20,180,80,30,"Histogram");
				fl_set_object_callback(choose_hist_button,handle_graph_choices,1);
				tooltips_addtip(choose_hist_button,"Draw histogram plots");
			choose_plot_button = fl_add_lightbutton(FL_PUSH_BUTTON,110,180,80,30,"Plot");
				fl_set_object_callback(choose_plot_button,handle_graph_choices,2);
				tooltips_addtip(choose_plot_button,"Draw line/scatter plots");
		fl_end_group();

		graph_key_button = fl_add_checkbutton(FL_PUSH_BUTTON,390,180,70,30,"Key");
			fl_set_object_callback(graph_key_button, graph_toggles,1);
			tooltips_addtip(graph_key_button,"Include a variable key in plot");
		graph_overwrite_button = fl_add_checkbutton(FL_PUSH_BUTTON,440,180,80,30,"Overwrite");
			fl_set_object_callback(graph_overwrite_button, graph_toggles,2);
			tooltips_addtip(graph_overwrite_button,"Overwrite exisiting graph files");
		graph_normal_button = fl_add_checkbutton(FL_PUSH_BUTTON,520,180,80,30,"Normal");
			fl_set_object_callback(graph_normal_button, graph_toggles,3);
			tooltips_addtip(graph_normal_button,"Include a normal distribution in a histogram");

		graph_format_input = fl_add_input(FL_NORMAL_INPUT,630,100,140,30,"Format:");
			fl_set_object_callback(graph_format_input,do_nothing,0);
		graph_options_input = fl_add_input(FL_NORMAL_INPUT,630,140,140,30,"Options");
			fl_set_object_callback(graph_options_input,do_nothing,0);

		obj = fl_add_text(FL_NORMAL_TEXT,20,10,170,20,"X Variable");
			fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
		obj = fl_add_text(FL_NORMAL_TEXT,210,10,170,20,"Y Variable(s)");
			fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);

		
		obj = fl_add_text(FL_NORMAL_TEXT, 780, 20, 100, 20, "X Range");
		
		graph_xrange_auto_button = fl_add_checkbutton(FL_PUSH_BUTTON, 850, 20, 60, 20, "Auto");
			fl_set_button(graph_xrange_auto_button, 1);
			fl_set_object_callback(graph_xrange_auto_button, set_graph_range_counters, 1);
			tooltips_addtip(graph_xrange_auto_button,"Let xldlas set the range");
		graph_xrange_from_counter = fl_add_counter(FL_NORMAL_COUNTER, 810, 40, 130, 30,"From:");
			fl_set_object_lalign(graph_xrange_from_counter,FL_ALIGN_LEFT);
			fl_set_object_callback(graph_xrange_from_counter, do_nothing, 1);

		graph_xrange_to_counter = fl_add_counter(FL_NORMAL_COUNTER, 810, 80, 130, 30,"To:");
			fl_set_object_lalign(graph_xrange_to_counter,FL_ALIGN_LEFT);
			fl_set_object_callback(graph_xrange_to_counter, do_nothing, 0);

		obj = fl_add_text(FL_NORMAL_TEXT, 780, 120, 100, 20, "Y Range");

		graph_yrange_auto_button = fl_add_checkbutton(FL_PUSH_BUTTON, 850, 120, 60, 20, "Auto");
			fl_set_button(graph_yrange_auto_button, 1);
			fl_set_object_callback(graph_yrange_auto_button, set_graph_range_counters, 2);
			tooltips_addtip(graph_yrange_auto_button,"Let xldlas set the range");
		graph_yrange_from_counter = fl_add_counter(FL_NORMAL_COUNTER, 810, 140, 130, 30,"From:");
			fl_set_object_lalign(graph_yrange_from_counter,FL_ALIGN_LEFT);
			fl_set_object_callback(graph_yrange_from_counter, do_nothing, 0);

		graph_yrange_to_counter = fl_add_counter(FL_NORMAL_COUNTER, 810, 180, 130, 30,"To:");
			fl_set_object_lalign(graph_yrange_to_counter,FL_ALIGN_LEFT);
			fl_set_object_callback(graph_yrange_to_counter, do_nothing, 0);


	fl_end_form();
  	fl_set_form_atclose(graph_window, click_done_graph_variables, 0);

	att_window = fl_bgn_form(FL_NO_BOX, 230, 110);
		obj = fl_add_box(FL_UP_BOX,0,0,230,110,"");
	att_point_counter = fl_add_counter(FL_SIMPLE_COUNTER,80,10,140,20,"");
			fl_set_object_callback(att_point_counter, do_nothing,0);
			fl_set_counter_precision(att_point_counter, 0);
	att_line_counter = fl_add_counter(FL_SIMPLE_COUNTER,80,40,140,20,"");
			fl_set_object_callback(att_line_counter, do_nothing,0);
			fl_set_counter_precision(att_line_counter, 0);
	obj = fl_add_text(FL_NORMAL_TEXT,10,10,70,20,"Point Style:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,10,40,70,20,"Line Style:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_button(FL_NORMAL_BUTTON,10,70,210,30,"Done");
		fl_set_object_callback(obj,done_attributes,0);
	fl_end_form();
  	fl_set_form_atclose(att_window, click_done_attributes, 0);


	ga_window = fl_bgn_form(FL_NO_BOX, 690, 480);
		obj = fl_add_box(FL_UP_BOX,0,0,690,480,"");
	ga_chart = fl_add_chart(FL_BAR_CHART,10,10,670,190,"");
		fl_set_object_dblbuffer(ga_chart, 1);	
	ga_from_counter = fl_add_counter(FL_NORMAL_COUNTER,350,240,140,30,"");
			fl_set_counter_precision(ga_from_counter, 0);
			fl_set_object_callback(ga_from_counter,handle_ga_counters, 1);
			tooltips_addtip(ga_from_counter,"Limit GA Fit to specific observations.");
	ga_to_counter = fl_add_counter(FL_NORMAL_COUNTER,350,280,140,30,"");
			fl_set_counter_precision(ga_to_counter, 0);
			fl_set_object_callback(ga_to_counter,handle_ga_counters, 2);
			tooltips_addtip(ga_to_counter,"Limit GA Fit to specific observations.");
	ga_cycles_counter = fl_add_counter(FL_NORMAL_COUNTER,350,320,140,30,"");
			fl_set_counter_precision(ga_cycles_counter, 0);
			fl_set_object_callback(ga_cycles_counter,handle_ga_counters, 3);
			tooltips_addtip(ga_cycles_counter,"Iterations to perform of fitting process.");
	ga_update_counter = fl_add_counter(FL_NORMAL_COUNTER,350,360,140,30,"");
			fl_set_counter_precision(ga_update_counter, 0);
			fl_set_object_callback(ga_update_counter,handle_ga_counters, 4);
			tooltips_addtip(ga_update_counter,"Frequency of visual feedback updates.");
	ga_mutate_counter = fl_add_counter(FL_NORMAL_COUNTER,350,400,140,30,"");
			fl_set_counter_precision(ga_mutate_counter, 0);
			fl_set_object_callback(ga_mutate_counter,handle_ga_counters, 5);
			tooltips_addtip(ga_mutate_counter,"1/N probability of a mutation.");
	ga_perturbe_counter = fl_add_counter(FL_NORMAL_COUNTER,350,440,140,30,"");
			fl_set_counter_precision(ga_perturbe_counter, 0);
			fl_set_object_callback(ga_perturbe_counter,handle_ga_counters, 11);
			tooltips_addtip(ga_perturbe_counter,"1/N probability of a perturbation.");
	ga_maxreal_counter = fl_add_counter(FL_NORMAL_COUNTER,540,240,140,30,"");
			fl_set_counter_precision(ga_maxreal_counter, 0);
			fl_set_object_callback(ga_maxreal_counter,handle_ga_counters, 6);
			tooltips_addtip(ga_maxreal_counter,"Largest +/- value that coefficients can take.");
	ga_bitsize_counter = fl_add_counter(FL_NORMAL_COUNTER,540,280,140,30,"");
			fl_set_counter_precision(ga_bitsize_counter, 0);
			fl_set_object_callback(ga_bitsize_counter,handle_ga_counters, 7);
			tooltips_addtip(ga_bitsize_counter,"Set fineness of the grid over real numbers.");
	ga_poolsize_counter = fl_add_counter(FL_NORMAL_COUNTER,540,320,140,30,"");
			fl_set_counter_precision(ga_poolsize_counter, 0);
			fl_set_object_callback(ga_poolsize_counter,handle_ga_counters, 8);
			tooltips_addtip(ga_poolsize_counter,"How many strings in the genetic pool?");
	ga_swap_counter = fl_add_counter(FL_NORMAL_COUNTER,540,360,140,30,"");
			fl_set_counter_precision(ga_swap_counter, 0);
			fl_set_object_callback(ga_swap_counter,handle_ga_counters, 9);
			tooltips_addtip(ga_swap_counter,"How many worst strings to replace by best in each iteration.");
	ga_cross_counter = fl_add_counter(FL_NORMAL_COUNTER,540,400,140,30,"");
			fl_set_counter_precision(ga_cross_counter, 0);
			fl_set_object_callback(ga_cross_counter,handle_ga_counters, 10);
			tooltips_addtip(ga_cross_counter,"1/N probability of a crossover.");
	ga_tolerance_counter = fl_add_counter(FL_NORMAL_COUNTER,540,440,140,30,"");
			fl_set_counter_precision(ga_tolerance_counter, 0);
			fl_set_object_callback(ga_tolerance_counter,handle_ga_counters, 12);
			tooltips_addtip(ga_tolerance_counter,"If fit error falls below this number, stop fitting.");
	obj = fl_add_text(FL_NORMAL_TEXT,300,240,50,30,"From:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,300,280,50,30,"To:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,300,320,50,30,"Cycles:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,300,360,50,30,"Updates:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,300,400,50,30,"Mutate:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,300,440,50,30,"Pert:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,490,240,50,30,"MaxR:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,490,280,50,30,"Bitsize:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,490,320,50,30,"Pool:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,490,360,50,30,"Swap:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,490,400,50,30,"Cross:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,490,440,50,30,"Tol:");
		fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
	ga_yvar_browser = fl_add_browser(FL_HOLD_BROWSER,10,230,140,150,"");
		fl_set_object_callback(ga_yvar_browser,do_nothing,0);
	ga_xvars_browser = fl_add_browser(FL_MULTI_BROWSER,160,230,140,150,"");
		fl_set_object_callback(ga_xvars_browser,do_nothing,0);
	obj = fl_add_text(FL_NORMAL_TEXT,10,210,140,20,"Dependent Variable");
		fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
	obj = fl_add_text(FL_NORMAL_TEXT,160,210,140,20,"Independent Variable(s)");
    		fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
	ga_force_button = fl_add_checkbutton(FL_PUSH_BUTTON,330,210,90,20,"Force Inclusion");
		fl_set_object_callback(ga_force_button, handle_ga_buttons, 4);
			tooltips_addtip(ga_force_button,"Force at least one term for each selected variable");
	ga_mutate_button = fl_add_checkbutton(FL_PUSH_BUTTON,430,210,90,20,"Mutation");
		fl_set_object_callback(ga_mutate_button, handle_ga_buttons, 1);
			tooltips_addtip(ga_mutate_button,"Turn mutation on/off");
	ga_cross_button = fl_add_checkbutton(FL_PUSH_BUTTON,510,210,90,20,"Crossover");
		fl_set_object_callback(ga_cross_button, handle_ga_buttons, 2);
			tooltips_addtip(ga_cross_button,"Turn crossover on/off");
	ga_perturbe_button = fl_add_checkbutton(FL_PUSH_BUTTON,600,210,90,20,"Perturbation");
		fl_set_object_callback(ga_perturbe_button, handle_ga_buttons, 3);
			tooltips_addtip(ga_perturbe_button,"Turn perturbation on/off");
	ga_save_input = fl_add_input(FL_NORMAL_INPUT,50,390,140,30,"Fitted:");
		fl_set_object_callback(ga_save_input,do_nothing,0);
		fl_set_input_maxchars(ga_save_input, NAME_LENGTH-1);
	ga_overwrite_button = fl_add_checkbutton(FL_PUSH_BUTTON,210,395,90,20,"Overwrite");
		fl_set_object_callback(ga_overwrite_button,do_nothing,0);
		tooltips_addtip(ga_overwrite_button,"Overwrite existing observations in Fitted:");
	ga_go_button = fl_add_button(FL_NORMAL_BUTTON,10,430,140,40,"Go!");
		fl_set_object_lsize(ga_go_button,FL_NORMAL_SIZE);
		fl_set_object_callback(ga_go_button, launch_ga,0);
		fl_set_object_lcol(ga_go_button,FL_YELLOW);
		tooltips_addtip(ga_go_button,"OK, go ahead and run the GA (fit data)");
	ga_done_button = fl_add_button(FL_NORMAL_BUTTON,160,430,140,40,"Done");
		fl_set_object_lsize(ga_done_button,FL_NORMAL_SIZE);
		fl_set_object_callback(ga_done_button, done_ga, 0);
		tooltips_addtip(ga_done_button,"I'm finished with the GA routines");
  	fl_end_form();

  	fl_set_form_atclose(ga_window, click_done_ga, 0);


	log_window = fl_bgn_form(FL_NO_BOX, 210, 180);
		obj = fl_add_box(FL_UP_BOX,0,0,210,180,"");
		log_on_button = fl_add_checkbutton(FL_PUSH_BUTTON,10,20,80,20,"Logging");
			fl_set_object_lsize(log_on_button,FL_NORMAL_SIZE);
			fl_set_object_callback(log_on_button,logtexlog_routines, 11);
			tooltips_addtip(log_on_button,"Turn the current log on/off");
		log_verbose_button = fl_add_checkbutton(FL_PUSH_BUTTON,100,20,80,20,"Verbose");
			fl_set_object_lsize(log_verbose_button,FL_NORMAL_SIZE);
			fl_set_object_callback(log_verbose_button,logtexlog_routines, 12);
			tooltips_addtip(log_verbose_button,"Log everything (or just tables)");
		log_file_input = fl_add_input(FL_NORMAL_INPUT,40,50,160,30,"File:");
			fl_set_object_lsize(log_file_input,FL_NORMAL_SIZE);
			fl_set_object_callback(log_file_input,logtexlog_routines, 13);
		log_view_button = fl_add_button(FL_NORMAL_BUTTON,10,100,190,30,"View Log");
			fl_set_object_lsize(log_view_button,FL_NORMAL_SIZE);
			fl_set_object_callback(log_view_button, logtexlog_routines, 14);
			tooltips_addtip(log_view_button,"View the current log file");
		log_print_button = fl_add_button(FL_NORMAL_BUTTON,10,140,90,30,"Print");
			fl_set_object_lsize(log_print_button,FL_NORMAL_SIZE);
			fl_set_object_callback(log_print_button, logtexlog_routines, 16);
			tooltips_addtip(log_print_button,"Print the current log file to via lpr");

		log_done_button = fl_add_button(FL_NORMAL_BUTTON,110,140,90,30,"Done");
			fl_set_object_lsize(log_done_button,FL_NORMAL_SIZE);
			fl_set_object_callback(log_done_button, logtexlog_routines, 17);
			tooltips_addtip(log_done_button,"I'm done setting log options");

	fl_end_form();
  	fl_set_form_atclose(log_window, click_done_logtexlog, 0);
	
	htmllog_window = fl_bgn_form(FL_NO_BOX, 210, 180);
		obj = fl_add_box(FL_UP_BOX,0,0,210,180,"");
		htmllog_on_button = fl_add_checkbutton(FL_PUSH_BUTTON,10,20,80,20,"Logging");
			fl_set_object_lsize(htmllog_on_button,FL_NORMAL_SIZE);
			fl_set_object_callback(htmllog_on_button,logtexlog_routines, 31);
			tooltips_addtip(htmllog_on_button,"Turn the HTML format log on/off");
		htmllog_verbose_button = fl_add_checkbutton(FL_PUSH_BUTTON,100,20,80,20,"Verbose");
			fl_set_object_lsize(htmllog_verbose_button,FL_NORMAL_SIZE);
			fl_set_object_callback(htmllog_verbose_button,logtexlog_routines, 32);
			tooltips_addtip(htmllog_verbose_button,"Log everything (or just tables)");
		htmllog_file_input = fl_add_input(FL_NORMAL_INPUT,40,50,160,30,"File:");
			fl_set_object_lsize(htmllog_file_input,FL_NORMAL_SIZE);
			fl_set_object_callback(htmllog_file_input,logtexlog_routines, 33);
		htmllog_view_button = fl_add_button(FL_NORMAL_BUTTON,10,100,190,30,"View Log");
			fl_set_object_lsize(htmllog_view_button,FL_NORMAL_SIZE);
			fl_set_object_callback(htmllog_view_button, logtexlog_routines, 34);
			tooltips_addtip(htmllog_view_button,"View the current HTML log file (the source)");
		htmllog_done_button = fl_add_button(FL_NORMAL_BUTTON,110,140,90,30,"Done");
			fl_set_object_lsize(htmllog_done_button,FL_NORMAL_SIZE);
			fl_set_object_callback(htmllog_done_button, logtexlog_routines, 37);
			tooltips_addtip(htmllog_done_button,"I'm done setting HTML log options");

	fl_end_form();
  	fl_set_form_atclose(htmllog_window, click_done_logtexlog, 0);
	
	texlog_window = fl_bgn_form(FL_NO_BOX, 210, 180);
		obj = fl_add_box(FL_UP_BOX,0,0,210,180,"");
		texlog_on_button = fl_add_checkbutton(FL_PUSH_BUTTON,10,20,80,20,"Logging");
			fl_set_object_lsize(texlog_on_button,FL_NORMAL_SIZE);
			fl_set_object_callback(texlog_on_button, logtexlog_routines, 21);
			tooltips_addtip(texlog_on_button,"Turn the TeX format log on/off");
		texlog_verbose_button = fl_add_checkbutton(FL_PUSH_BUTTON,100,20,80,20,"Verbose");
			fl_set_object_lsize(texlog_verbose_button,FL_NORMAL_SIZE);
			fl_set_object_callback(texlog_verbose_button, logtexlog_routines, 22);
			tooltips_addtip(texlog_verbose_button,"Log everything (or just tables)");
		texlog_file_input = fl_add_input(FL_NORMAL_INPUT,40,50,160,30,"File:");
			fl_set_object_lsize(texlog_file_input,FL_NORMAL_SIZE);
			fl_set_object_callback(texlog_file_input, logtexlog_routines, 23);
		texlog_source_button = fl_add_button(FL_NORMAL_BUTTON,10,100,90,30,"View Source");
			fl_set_object_lsize(texlog_source_button,FL_NORMAL_SIZE);
			fl_set_object_callback(texlog_source_button, logtexlog_routines, 24);
			tooltips_addtip(texlog_source_button,"View the current TeX format log file (as source)");
		texlog_dvi_button = fl_add_button(FL_NORMAL_BUTTON,110,100,90,30,"View DVI");
			fl_set_object_lsize(texlog_dvi_button,FL_NORMAL_SIZE);
			fl_set_object_callback(texlog_dvi_button, logtexlog_routines, 25);
			tooltips_addtip(texlog_dvi_button,"View the current TeX format log file via xdvi");

		texlog_print_button = fl_add_button(FL_NORMAL_BUTTON,10,140,90,30,"Print");
			fl_set_object_lsize(texlog_print_button,FL_NORMAL_SIZE);
			fl_set_object_callback(texlog_print_button, logtexlog_routines, 26);
			tooltips_addtip(texlog_print_button,"Print the TeX log file via lpr");

		texlog_done_button = fl_add_button(FL_NORMAL_BUTTON,110,140,90,30,"Done");
			fl_set_object_lsize(texlog_done_button,FL_NORMAL_SIZE);
			fl_set_object_callback(texlog_done_button, logtexlog_routines, 27);
			tooltips_addtip(texlog_done_button,"I'm done setting TeX log options");

	fl_end_form();
  	fl_set_form_atclose(texlog_window, click_done_logtexlog, 0);

	viewfile_window = fl_bgn_form(FL_UP_BOX,430,340);
     		viewfile_browser = fl_add_browser(FL_NORMAL_BROWSER,5,5,420,290,"");
			fl_set_object_lsize(viewfile_browser,FL_NORMAL_SIZE);
     		obj = fl_add_button(FL_NORMAL_BUTTON,5,300,420,30,"Dismiss");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			fl_set_object_callback(obj,end_viewfile, 0);
    	fl_end_form();
  	fl_set_form_atclose(viewfile_window, click_end_viewfile, 0);

	abort_window = fl_bgn_form(FL_UP_BOX,150,50);
		general_abort_button = fl_add_button(FL_NORMAL_BUTTON,10,10,130,30,"Abort!");
			fl_set_object_lsize(general_abort_button,FL_NORMAL_SIZE);
			fl_set_object_lcol(general_abort_button, FL_RED);
			fl_set_object_callback(general_abort_button,set_abort_true,0);
			tooltips_addtip(general_abort_button,"Abort the current process");
	fl_end_form();
	fl_set_form_atclose(abort_window, click_abort_window,0);


	prefs_window = fl_bgn_form(FL_NO_BOX, 650, 330);
		obj = fl_add_box(FL_UP_BOX,0,0,650,330,"");

		prefs_quick_dropping_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,20,100,20,"Quick drop");
			fl_set_object_callback(prefs_quick_dropping_button, handle_prefs_buttons, 1);
			tooltips_addtip(prefs_quick_dropping_button,"You probably want this on");
		prefs_graph_overwrite_on_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,60,120,20,"Graph overwrite");
			fl_set_object_callback(prefs_graph_overwrite_on_button, handle_prefs_buttons, 2);
			tooltips_addtip(prefs_graph_overwrite_on_button,"Should new graphic files overwrite old ones?");
		prefs_ga_cross_ok_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,100,100,20,"GA crossover");
			fl_set_object_callback(prefs_ga_cross_ok_button, handle_prefs_buttons, 3);
			tooltips_addtip(prefs_ga_cross_ok_button,"Allow GA strings to mate (exchange information)");
		prefs_ga_mutate_ok_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,120,100,20,"GA mutation");
			fl_set_object_callback(prefs_ga_mutate_ok_button, handle_prefs_buttons, 4);
			tooltips_addtip(prefs_ga_mutate_ok_button,"Allow GA strings to randomly mutate");
		prefs_ga_perturbe_ok_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,140,100,20,"GA perturbation");
			fl_set_object_callback(prefs_ga_perturbe_ok_button, handle_prefs_buttons, 5);
			tooltips_addtip(prefs_ga_perturbe_ok_button,"Include small perturbations in GA fitting values");
		prefs_pearls_of_wisdom_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,220,110,20,"Pearls of Wisdom");
			fl_set_object_callback(prefs_pearls_of_wisdom_button, handle_prefs_buttons, 6);
			tooltips_addtip(prefs_pearls_of_wisdom_button,"Display a little message about statistics/econometrics at startup");
		prefs_graph_key_on_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,40,100,20,"Graph key");
			fl_set_object_callback(prefs_graph_key_on_button, handle_prefs_buttons, 7);
			tooltips_addtip(prefs_graph_key_on_button,"Include a variable key in gnuplot'ed graphs");
		prefs_graph_normal_on_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,80,120,20,"Graph normal");
			fl_set_object_callback(prefs_graph_normal_on_button, handle_prefs_buttons, 8);
			tooltips_addtip(prefs_graph_normal_on_button,"Superimpose a normal distribution on histograms");
		prefs_nnet_annealing_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,180,120,20,"NN annealing");
			fl_set_object_callback(prefs_nnet_annealing_button, handle_prefs_buttons, 9);
			tooltips_addtip(prefs_nnet_annealing_button,"Include some noise in the NN training process");
		prefs_nnet_pictex_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,200,120,20,"NN PiCTeX");
			fl_set_object_callback(prefs_nnet_pictex_button, handle_prefs_buttons, 10);
			tooltips_addtip(prefs_nnet_pictex_button,"If a TexLog is open, include a PiCTeX picture of the network");
		prefs_ga_force_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,160,120,20,"GA Force Inclusion");
			fl_set_object_callback(prefs_ga_force_button, handle_prefs_buttons, 10);
			tooltips_addtip(prefs_ga_force_button,"Force at least one term for every included variable in GA Fit");
		prefs_balloon_help_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,240,110,20,"Balloon Help");
			fl_set_object_callback(prefs_balloon_help_button, handle_prefs_buttons, 10);
			tooltips_addtip(prefs_balloon_help_button,"Turn these little popup help balloons on and off");
		prefs_assume_sample_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,260,120,20,"Assume Sample Data");
			fl_set_object_callback(prefs_assume_sample_button, handle_prefs_buttons, 11);
			tooltips_addtip(prefs_assume_sample_button,"If set on, use N-1 for various estimations");	
	
		prefs_graph_output_format_input = fl_add_input(FL_NORMAL_INPUT,480,20,150,20,"Graph Format:");
			fl_set_object_callback(prefs_graph_output_format_input, handle_prefs_inputs, 10);
			tooltips_addtip(prefs_graph_output_format_input,"Default Gnuplot graph file format");
		prefs_graph_output_options_input = fl_add_input(FL_NORMAL_INPUT,480,40,150,20,"Graph Options:");
			fl_set_object_callback(prefs_graph_output_options_input, handle_prefs_inputs, 11);
			tooltips_addtip(prefs_graph_output_options_input,"Any valid Gnuplot options for the graph file format");
		prefs_gnuplot_geometry_input = fl_add_input(FL_NORMAL_INPUT,480,60,150,20,"Gnuplot geomtery:");
			fl_set_object_callback(prefs_gnuplot_geometry_input, handle_prefs_inputs, 9);
			tooltips_addtip(prefs_gnuplot_geometry_input,"Size of Gnuplot graphing window");
		prefs_print_command_input = fl_add_input(FL_NORMAL_INPUT,480,80,150,20,"Print Command:");
			fl_set_object_callback(prefs_print_command_input, handle_prefs_inputs, 8);
			tooltips_addtip(prefs_print_command_input,"System command to print a normal (ASCII) text file");
		prefs_tex_command_input = fl_add_input(FL_NORMAL_INPUT,480,100,150,20,"TeX Command:");
			fl_set_object_callback(prefs_tex_command_input, handle_prefs_inputs, 7);
			tooltips_addtip(prefs_tex_command_input,"System command to process a TeX input file");
		prefs_dviview_command_input = fl_add_input(FL_NORMAL_INPUT,480,120,150,20,"DVI view command:");
			fl_set_object_callback(prefs_dviview_command_input, handle_prefs_inputs, 6);
			tooltips_addtip(prefs_dviview_command_input,"System command to view a dvi file");
		prefs_dviprint_command_input = fl_add_input(FL_NORMAL_INPUT,480,140,150,20,"DVI print command:");
			fl_set_object_callback(prefs_dviprint_command_input, handle_prefs_inputs, 5);
			tooltips_addtip(prefs_dviprint_command_input,"System command to print a dvi file");
		prefs_tex_preamble_input = fl_add_input(FL_NORMAL_INPUT,480,160,150,20,"TeX preamble:");
			fl_set_object_callback(prefs_tex_preamble_input, handle_prefs_inputs, 4);
			tooltips_addtip(prefs_tex_preamble_input,"Commands to appear at the top of every TeXLog file");
		prefs_tex_graphmacrol_input = fl_add_input(FL_NORMAL_INPUT,480,180,150,20,"TeX graphic left:");
			fl_set_object_callback(prefs_tex_graphmacrol_input, handle_prefs_inputs, 3);
			tooltips_addtip(prefs_tex_graphmacrol_input,"See Help --> TeXLog");
		prefs_tex_graphmacror_input = fl_add_input(FL_NORMAL_INPUT,480,200,150,20,"TeX graphic right:");
			fl_set_object_callback(prefs_tex_graphmacror_input, handle_prefs_inputs, 2);
			tooltips_addtip(prefs_tex_graphmacror_input,"See Help --> TeXLog");
		prefs_missing_value_input = fl_add_input(FL_FLOAT_INPUT,480,220,150,20,"Missing Value:");
			fl_set_object_callback(prefs_missing_value_input, handle_prefs_inputs, 1);
			tooltips_addtip(prefs_missing_value_input,"A floating point value to represent missing data");


		prefs_numb_bars_counter = fl_add_counter(FL_NORMAL_COUNTER,220,20,150,20,"Histogram bars:");
			fl_set_object_lalign(prefs_numb_bars_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_numb_bars_counter,"Number of vertical bars in a histogram");
			fl_set_counter_precision(prefs_numb_bars_counter, 0);
			fl_set_object_callback(prefs_numb_bars_counter, handle_prefs_counters, 1);
		prefs_ga_cycles_counter = fl_add_counter(FL_NORMAL_COUNTER,220,40,150,20,"GA cycles:");
			fl_set_object_lalign(prefs_ga_cycles_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_cycles_counter,"Number of iterations to perform");
			fl_set_counter_precision(prefs_ga_cycles_counter, 0);
			fl_set_object_callback(prefs_ga_cycles_counter, handle_prefs_counters, 2);
		prefs_ga_update_counter = fl_add_counter(FL_NORMAL_COUNTER,220,60,150,20,"GA updates:");
			fl_set_object_lalign(prefs_ga_update_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_update_counter,"Fequency with which visual feedback should be updated");
			fl_set_counter_precision(prefs_ga_update_counter, 0);
			fl_set_object_callback(prefs_ga_update_counter, handle_prefs_counters, 3);
		prefs_ga_mutate_counter = fl_add_counter(FL_NORMAL_COUNTER,220,80,150,20,"GA mutation:");
			fl_set_object_lalign(prefs_ga_mutate_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_mutate_counter,"1/Value probability of a mutation");
			fl_set_counter_precision(prefs_ga_mutate_counter, 0);
			fl_set_object_callback(prefs_ga_mutate_counter, handle_prefs_counters, 4);
		prefs_ga_maxreal_counter = fl_add_counter(FL_NORMAL_COUNTER,220,100,150,20,"GA maxR:");
			fl_set_object_lalign(prefs_ga_maxreal_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_maxreal_counter,"Largest possible absolute value for fitted coefficients");
			fl_set_counter_precision(prefs_ga_maxreal_counter, 0);
			fl_set_object_callback(prefs_ga_maxreal_counter, handle_prefs_counters, 5);
		prefs_ga_bitsize_counter = fl_add_counter(FL_NORMAL_COUNTER,220,120,150,20,"GA bit length:");
			fl_set_object_lalign(prefs_ga_bitsize_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_bitsize_counter,"Number of bits per coefficient");
			fl_set_counter_precision(prefs_ga_bitsize_counter, 0);
			fl_set_object_callback(prefs_ga_bitsize_counter, handle_prefs_counters, 6);
		prefs_ga_poolsize_counter = fl_add_counter(FL_NORMAL_COUNTER,220,140,150,20,"GA pool size:");
			fl_set_object_lalign(prefs_ga_poolsize_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_poolsize_counter,"Number of strings in the GA pool");
			fl_set_counter_precision(prefs_ga_poolsize_counter, 0);
			fl_set_object_callback(prefs_ga_poolsize_counter, handle_prefs_counters, 7);
		prefs_ga_swap_counter = fl_add_counter(FL_NORMAL_COUNTER,220,160,150,20,"GA swaps:");
			fl_set_object_lalign(prefs_ga_swap_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_swap_counter,"How many worst strings to replace with best fitting strings");
			fl_set_counter_precision(prefs_ga_swap_counter, 0);
			fl_set_object_callback(prefs_ga_swap_counter, handle_prefs_counters, 8);
		prefs_ga_cross_counter = fl_add_counter(FL_NORMAL_COUNTER,220,180,150,20,"GA crossover:");
			fl_set_object_lalign(prefs_ga_cross_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_cross_counter,"1/Value probability of a crossover");
			fl_set_counter_precision(prefs_ga_cross_counter, 0);
			fl_set_object_callback(prefs_ga_cross_counter, handle_prefs_counters, 9);
		prefs_ga_perturbe_counter = fl_add_counter(FL_NORMAL_COUNTER,220,200,150,20,"GA perturbation:");
			fl_set_object_lalign(prefs_ga_perturbe_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_perturbe_counter,"1/Value probability of a perturbation");
			fl_set_counter_precision(prefs_ga_perturbe_counter, 0);
			fl_set_object_callback(prefs_ga_perturbe_counter, handle_prefs_counters, 10);
		prefs_ga_tolerance_counter = fl_add_counter(FL_NORMAL_COUNTER,220,220,150,20,"GA tolerance:");
			fl_set_object_lalign(prefs_ga_tolerance_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_ga_tolerance_counter,"Exit fit if errors fall to this amount");
			fl_set_counter_precision(prefs_ga_tolerance_counter, 0);
			fl_set_object_callback(prefs_ga_tolerance_counter, handle_prefs_counters, 11);
		prefs_nn_cycles_counter = fl_add_counter(FL_NORMAL_COUNTER,220,240,150,20,"NN cycles:");
			fl_set_object_lalign(prefs_nn_cycles_counter,FL_ALIGN_LEFT);
			tooltips_addtip(prefs_nn_cycles_counter,"Number of training iterations to perform");
			fl_set_counter_precision(prefs_nn_cycles_counter, 0);
			fl_set_object_callback(prefs_nn_cycles_counter, handle_prefs_counters, 12);
		prefs_nn_learn_counter = fl_add_counter(FL_NORMAL_COUNTER,220,260,150,20,"NN learn:");
			fl_set_counter_precision(prefs_nn_learn_counter, 2);
			tooltips_addtip(prefs_nn_learn_counter,"Learning speed for NN training");
			fl_set_object_lalign(prefs_nn_learn_counter,FL_ALIGN_LEFT);
			fl_set_object_callback(prefs_nn_learn_counter, handle_prefs_counters, 13);
		
		prefs_font_group=fl_bgn_group();
				prefs_font_small_button = fl_add_lightbutton(FL_RADIO_BUTTON,395,250,60,30,"Small");
					fl_set_object_callback(prefs_font_small_button, set_font_preference, 1);
					fl_set_object_lsize(prefs_font_small_button,FL_SMALL_SIZE);
					tooltips_addtip(prefs_font_small_button,"Make main window font small");
				prefs_font_normal_button = fl_add_lightbutton(FL_RADIO_BUTTON,460,250,75,30,"Normal");
					fl_set_object_callback(prefs_font_normal_button, set_font_preference, 2);
					fl_set_object_lsize(prefs_font_normal_button,FL_NORMAL_SIZE);
					tooltips_addtip(prefs_font_normal_button,"Make main window font normal");
					fl_set_button(prefs_font_normal_button, 1);
				prefs_font_large_button = fl_add_lightbutton(FL_RADIO_BUTTON,540,250,90,30,"Large");
					fl_set_object_callback(prefs_font_large_button, set_font_preference, 3);
					fl_set_object_lsize(prefs_font_large_button,FL_LARGE_SIZE);
					tooltips_addtip(prefs_font_large_button,"Make main window font large");
		fl_end_group();	

		obj = fl_add_button(FL_NORMAL_BUTTON,20,290,140,30,"Defaults");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"Set all options to default values");
			fl_set_object_callback(obj, handle_prefs_buttons, 12);
		obj = fl_add_button(FL_NORMAL_BUTTON,170,290,140,30,"Load");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"Read options from ~/.xldlasrc");
			fl_set_object_callback(obj, handle_prefs_buttons, 13);
		obj = fl_add_button(FL_NORMAL_BUTTON,480,290,150,30,"Done");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"OK, I'm done setting preferences");
			fl_set_object_callback(obj, handle_prefs_buttons, 14);
		obj = fl_add_button(FL_NORMAL_BUTTON,320,290,150,30,"Save");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"Save all values to ~/.xldlasrc");
			fl_set_object_callback(obj, handle_prefs_buttons, 15);
	
	fl_end_form();

	fl_set_form_atclose(prefs_window, click_end_prefs,0);


	gen_window = fl_bgn_form(FL_NO_BOX, 290, 480);
		obj = fl_add_box(FL_UP_BOX,0,0,290,480,"");
		gen_data_browser = fl_add_browser(FL_NORMAL_BROWSER,130,190,150,280,"");

		obj = fl_add_button(FL_NORMAL_BUTTON,60,250,20,20,"1");
			fl_set_object_callback(obj, handle_gen_buttons, 11);
		obj = fl_add_button(FL_NORMAL_BUTTON,80,250,20,20,"2");
			fl_set_object_callback(obj, handle_gen_buttons, 12);
		obj = fl_add_button(FL_NORMAL_BUTTON,100,250,20,20,"3");
			fl_set_object_callback(obj, handle_gen_buttons, 13);
		obj = fl_add_button(FL_NORMAL_BUTTON,60,270,20,20,"4");
			fl_set_object_callback(obj, handle_gen_buttons, 14);
		obj = fl_add_button(FL_NORMAL_BUTTON,80,270,20,20,"5");
			fl_set_object_callback(obj, handle_gen_buttons, 15);
		obj = fl_add_button(FL_NORMAL_BUTTON,80,290,20,20,"8");
			fl_set_object_callback(obj, handle_gen_buttons, 18);
		obj = fl_add_button(FL_NORMAL_BUTTON,60,290,20,20,"7");
			fl_set_object_callback(obj, handle_gen_buttons, 17);
		obj = fl_add_button(FL_NORMAL_BUTTON,100,270,20,20,"6");
			fl_set_object_callback(obj, handle_gen_buttons, 16);
		obj = fl_add_button(FL_NORMAL_BUTTON,100,290,20,20,"9");
			fl_set_object_callback(obj, handle_gen_buttons, 19);
		obj = fl_add_button(FL_NORMAL_BUTTON,80,310,20,20,".");
			fl_set_object_callback(obj, handle_gen_buttons, 20);
		obj = fl_add_button(FL_NORMAL_BUTTON,60,310,20,20,"0");
			fl_set_object_callback(obj, handle_gen_buttons, 10);
		obj = fl_add_button(FL_NORMAL_BUTTON,100,310,20,20,"<");
			fl_set_object_callback(obj, handle_gen_buttons, 25);
			fl_set_object_lcol(obj, FL_YELLOW);
			tooltips_addtip(obj,"Erase last entry");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,250,40,20,"+");
			fl_set_object_callback(obj, handle_gen_buttons, 21);
			tooltips_addtip(obj,"Add to current values");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,270,40,20,"-");
			fl_set_object_callback(obj, handle_gen_buttons, 22);
			tooltips_addtip(obj,"Subtract from current values");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,290,40,20,"x");
			fl_set_object_callback(obj, handle_gen_buttons, 23);
			tooltips_addtip(obj,"Multiply by current values");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,310,40,20,"/");
			fl_set_object_callback(obj, handle_gen_buttons, 24);
			tooltips_addtip(obj,"Divide current values");
		gen_name_input = fl_add_input(FL_NORMAL_INPUT,130,10,150,30,"Name:");
			fl_set_object_callback(gen_name_input, do_nothing, 0);
			fl_set_input_maxchars(gen_name_input, NAME_LENGTH-1);
		gen_desc_input = fl_add_input(FL_NORMAL_INPUT,130,40,150,30,"Desc:");
			fl_set_object_callback(gen_desc_input, do_nothing, 0);
			fl_set_input_maxchars(gen_desc_input, DESC_LENGTH-1);
		gen_from_counter = fl_add_counter(FL_NORMAL_COUNTER,130,80,150,20,"From:");
			fl_set_object_lalign(gen_from_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(gen_from_counter, 0);
			fl_set_counter_bounds(gen_from_counter, 1, MAX_OBS);
			fl_set_counter_step(gen_from_counter, 1, 10);
			fl_set_object_callback(gen_from_counter, handle_gen_buttons, 2);
		gen_to_counter = fl_add_counter(FL_NORMAL_COUNTER,130,100,150,20,"To:");
			fl_set_object_lalign(gen_to_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(gen_to_counter, 0);
			fl_set_counter_bounds(gen_to_counter, 1, MAX_OBS);
			fl_set_counter_step(gen_to_counter, 1, 10);
			fl_set_object_callback(gen_to_counter, handle_gen_buttons, 3);
		obj = fl_add_button(FL_NORMAL_BUTTON,10,10,80,30,"Done");
			fl_set_object_callback(obj, done_gen, 0);
			tooltips_addtip(obj,"I'm done generating/modifying data");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,50,80,30,"Cancel");
			fl_set_object_lcol(obj,FL_RED);
			fl_set_object_callback(obj, handle_gen_buttons, -1);
			tooltips_addtip(obj,"Exit without saving data");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,360,55,20,"log");
			fl_set_object_callback(obj, handle_gen_buttons, 51);
			tooltips_addtip(obj,"Take the natural log");
		obj = fl_add_button(FL_NORMAL_BUTTON,65,360,55,20,"% total");
			fl_set_object_callback(obj, handle_gen_buttons, 55);
			tooltips_addtip(obj,"Replace values with percent of total");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,380,55,20,"lag 1");
			fl_set_object_callback(obj, handle_gen_buttons, 52);
			tooltips_addtip(obj,"Shift all observations forward one step");
		obj = fl_add_button(FL_NORMAL_BUTTON,65,380,55,20," = obs");
			fl_set_object_callback(obj, handle_gen_buttons, 56);
			tooltips_addtip(obj,"Set observations equal to observation number");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,400,55,20,"rand");
			fl_set_object_callback(obj, handle_gen_buttons, 53);
			tooltips_addtip(obj,"Replace values with random numbers");
		obj = fl_add_button(FL_NORMAL_BUTTON,65,400,55,20,"1st dif");
			fl_set_object_callback(obj, handle_gen_buttons, 57);
			tooltips_addtip(obj,"Replace observations with first difference");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,90,80,30,"Write");
			fl_set_object_callback(obj, handle_gen_buttons, 1);
			tooltips_addtip(obj,"Save current values as Name:");
		obj = fl_add_box(FL_UP_BOX,10,340,110,10,"");
		obj = fl_add_box(FL_DOWN_BOX,0,130,290,10,"");
		gen_operator_browser = fl_add_browser(FL_NORMAL_BROWSER,10,150,40,30,"");
    			fl_set_browser_fontsize(gen_operator_browser,FL_NORMAL_SIZE);
		gen_argument_browser = fl_add_browser(FL_NORMAL_BROWSER,60,150,170,30,"");
    			fl_set_browser_fontsize(gen_argument_browser,FL_NORMAL_SIZE);
		obj = fl_add_button(FL_NORMAL_BUTTON,240,150,40,30,"Go");
			fl_set_object_lcol(obj,FL_GREEN);
			fl_set_object_callback(obj, handle_gen_buttons, 30);
			tooltips_addtip(obj,"Perform the specified operation");
		gen_var_choice = fl_add_choice(FL_NORMAL_CHOICE,10,190,110,30,"");
			fl_set_object_boxtype(gen_var_choice,FL_UP_BOX);
			fl_set_object_callback(gen_var_choice, handle_gen_buttons, 33);
			tooltips_addtip(gen_var_choice,"Select a variable to perform operation on");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,220,60,20,"lag 1");
			fl_set_object_callback(obj, handle_gen_buttons, 31);
			tooltips_addtip(obj,"Lag the specified variable by one observation");
		obj = fl_add_button(FL_NORMAL_BUTTON,70,220,50,20,"forw 1");
			fl_set_object_callback(obj, handle_gen_buttons, 32);
			tooltips_addtip(obj,"Shift observations in specified variable down one step");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,420,55,20,"sqrt");
			fl_set_object_callback(obj, handle_gen_buttons, 59);
			tooltips_addtip(obj,"Replace values with square root of values");
		obj = fl_add_button(FL_NORMAL_BUTTON,65,420,55,20,"^2");
			fl_set_object_callback(obj, handle_gen_buttons, 60);
			tooltips_addtip(obj,"Square current values");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,450,55,20,"missing");
			fl_set_object_callback(obj, handle_gen_buttons, 54);
			fl_set_object_lcol(obj, FL_YELLOW);
			tooltips_addtip(obj,"Replace current values with missing observations");
		obj = fl_add_button(FL_NORMAL_BUTTON,65,450,55,20,"zero");
			fl_set_object_callback(obj, handle_gen_buttons, 58);
			fl_set_object_lcol(obj, FL_YELLOW);
			tooltips_addtip(obj,"Set all observations to zero");

	fl_end_form();

	fl_set_form_atclose(gen_window, click_done_gen,0);

	anova_window = fl_bgn_form(FL_NO_BOX, 300, 350);
		obj = fl_add_box(FL_UP_BOX,0,0,300,350,"");
		anova_block_browser = fl_add_browser(FL_HOLD_BROWSER,10,30,130,160,"");
			fl_set_object_callback(anova_block_browser, do_nothing, 0);
		anova_variable_browser = fl_add_browser(FL_MULTI_BROWSER,160,30,130,160,"");
			fl_set_object_callback(anova_variable_browser, do_nothing, 0);
		obj = fl_add_text(FL_NORMAL_TEXT,10,10,130,20,"Block Variable");
			fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
		obj = fl_add_text(FL_NORMAL_TEXT,160,10,130,20,"ANOVA Variables");
			fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
		obj = fl_add_button(FL_NORMAL_BUTTON,10,310,130,30,"Go");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			fl_set_object_callback(obj, do_anova, 0);
		obj = fl_add_button(FL_NORMAL_BUTTON,160,310,130,30,"Done");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			fl_set_object_callback(obj, done_anova, 0);
			tooltips_addtip(obj,"OK, I'm done doing ANOVA");
		anova_one_button = fl_add_lightbutton(FL_PUSH_BUTTON,160,200,130,30,"One Way");
			fl_set_object_callback(anova_one_button, handle_anova_buttons, 1);
			tooltips_addtip(anova_one_button,"Select One-Way ANOVA");
		anova_two_button = fl_add_lightbutton(FL_PUSH_BUTTON,10,200,130,30,"Two Way");
			fl_set_object_callback(anova_two_button, handle_anova_buttons, 2);
			tooltips_addtip(anova_two_button,"Select Two-Way ANOVA");
		anova_to_counter = fl_add_counter(FL_NORMAL_COUNTER,100,260,190,20,"To:");
			fl_set_object_lalign(anova_to_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(anova_to_counter, 0);
			fl_set_counter_step(anova_to_counter, 1, 10);
			fl_set_object_callback(anova_to_counter, handle_anova_buttons, 3);
		anova_block_counter = fl_add_counter(FL_NORMAL_COUNTER,100,280,190,20,"Block Categories:");
			fl_set_object_lalign(anova_block_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(anova_block_counter, 0);
			fl_set_counter_step(anova_block_counter, 1, 10);
			fl_set_object_callback(anova_block_counter, handle_anova_buttons, 3);
		anova_from_counter = fl_add_counter(FL_NORMAL_COUNTER,100,240,190,20,"From:");
			fl_set_object_lalign(anova_from_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(anova_from_counter, 0);
			fl_set_counter_step(anova_from_counter, 1, 10);
			fl_set_object_callback(anova_from_counter, handle_anova_buttons, 3);
			
	fl_end_form();
	fl_set_form_atclose(anova_window, click_done_anova,0);


	nnet_window = fl_bgn_form(FL_NO_BOX, 300, 370);
		obj = fl_add_box(FL_UP_BOX,0,0,300,370,"");
		nnet_output_browser = fl_add_browser(FL_HOLD_BROWSER,20,20,120,160,"Output Variable");
			fl_set_object_lalign(nnet_output_browser,FL_ALIGN_TOP);
			fl_set_object_callback(nnet_output_browser, do_nothing, 0);
		nnet_input_browser = fl_add_browser(FL_MULTI_BROWSER,160,20,120,160,"Input Variable(s)");
			fl_set_object_lalign(nnet_input_browser,FL_ALIGN_TOP);
			fl_set_object_callback(nnet_input_browser, do_nothing, 0);
		nnet_go_button = fl_add_button(FL_NORMAL_BUTTON,20,330,120,30,"Go");
			fl_set_object_callback(nnet_go_button, handle_nnet_buttons, 1);
			tooltips_addtip(nnet_go_button,"Go ahead and train the specified network");
		nnet_done_button = fl_add_button(FL_NORMAL_BUTTON,160,330,120,30,"Done");
			fl_set_object_callback(nnet_done_button, handle_nnet_buttons, 0);
			tooltips_addtip(nnet_done_button,"OK, I'm done playing with Neural Networks");
		nnet_variable_input = fl_add_input(FL_NORMAL_INPUT,140,300,140,20,"Fit:");
			fl_set_object_callback(nnet_variable_input, do_nothing, 0);
			tooltips_addtip(nnet_done_button,"Variable name to store fitted observations after training.");
		nnet_overwrite_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,300,90,20,"Overwrite");
			fl_set_object_callback(nnet_overwrite_button, do_nothing, 0);
			tooltips_addtip(nnet_overwrite_button,"Overwrite exisitng values in Fit:");
		nnet_pictex_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,260,90,20,"PiCTeX");
			fl_set_object_callback(nnet_pictex_button, handle_nnet_buttons, 15);
			tooltips_addtip(nnet_pictex_button,"Include PiCTeX image of network in TeXLog");
		nnet_annealing_button = fl_add_checkbutton(FL_PUSH_BUTTON,20,280,90,20,"Annealing");
			fl_set_object_callback(nnet_annealing_button, handle_nnet_buttons, 10);
			tooltips_addtip(nnet_annealing_button,"Add some noise to the training process");
		nnet_cycles_counter = fl_add_counter(FL_NORMAL_COUNTER,140,190,140,20,"Cycles:");
			fl_set_object_lalign(nnet_cycles_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(nnet_cycles_counter, 0);
			tooltips_addtip(nnet_cycles_counter,"How many training iterations should be performed?");
			fl_set_counter_step(nnet_cycles_counter, 1, 10);
			fl_set_object_callback(nnet_cycles_counter, handle_nnet_buttons, 3);
		nnet_from_counter = fl_add_counter(FL_NORMAL_COUNTER,140,210,140,20,"From:");
			fl_set_object_lalign(nnet_from_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(nnet_from_counter, 0);
			tooltips_addtip(nnet_from_counter,"Limit training to these observations.");
			fl_set_counter_step(nnet_from_counter, 1, 10);
			fl_set_object_callback(nnet_from_counter, do_nothing, 0);
		nnet_to_counter = fl_add_counter(FL_NORMAL_COUNTER,140,230,140,20,"To:");
    			fl_set_object_lalign(nnet_to_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(nnet_to_counter, 0);
			tooltips_addtip(nnet_to_counter,"Limit training to these observations.");
			fl_set_counter_step(nnet_to_counter, 1, 10);
			fl_set_object_callback(nnet_to_counter, do_nothing, 0);

		nnet_learn_counter = fl_add_counter(FL_NORMAL_COUNTER,140,250,140,20,"Learn:");
			fl_set_counter_precision(nnet_learn_counter, 2);
    			fl_set_object_lalign(nnet_learn_counter,FL_ALIGN_LEFT);
			tooltips_addtip(nnet_learn_counter,"Set learning speed (smaller is slower, but more likely to reach optimum).");
			fl_set_counter_step(nnet_learn_counter, 0.01, 0.1);
			fl_set_object_callback(nnet_learn_counter, handle_nnet_buttons, 4);

		nnet_hidden_counter = fl_add_counter(FL_NORMAL_COUNTER,140,270,140,20,"Hidden:");
    			fl_set_object_lalign(nnet_hidden_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(nnet_hidden_counter, 0);
			tooltips_addtip(nnet_hidden_counter,"How many hidden nodes for the network?");
			fl_set_counter_step(nnet_hidden_counter, 1, 10);
			fl_set_counter_bounds(nnet_hidden_counter, 1, MAX_VARS);
			fl_set_object_callback(nnet_hidden_counter, handle_nnet_buttons, 5);
		

		nnet_squasher_buttons = fl_bgn_group();
			nnet_step_button = fl_add_lightbutton(FL_RADIO_BUTTON,20,190,80,20,"step");
				fl_set_object_callback(nnet_step_button, handle_nnet_buttons, 11);
				tooltips_addtip(nnet_step_button,"Use a discontinuous squasher function");
			nnet_straight_button = fl_add_lightbutton(FL_RADIO_BUTTON,20,210,80,20,"straight");
				fl_set_object_callback(nnet_straight_button, handle_nnet_buttons, 12);
				tooltips_addtip(nnet_straight_button,"Use a linear squasher function");
			nnet_sigmoid_button = fl_add_lightbutton(FL_RADIO_BUTTON,20,230,80,20,"sigmoid");
				fl_set_object_callback(nnet_sigmoid_button, handle_nnet_buttons, 13);
				tooltips_addtip(nnet_sigmoid_button,"Use the standard squasher function");
		fl_end_group();
		
	
	
	fl_end_form();
	fl_set_form_atclose(nnet_window, click_done_nnet,0);

	do_nnet_window = fl_bgn_form(FL_NO_BOX, 500, 200);
		obj = fl_add_box(FL_UP_BOX,0,0,500,200,"");
		obj = fl_add_button(FL_NORMAL_BUTTON,10,160,200,30,"Abort");
			fl_set_object_lcol(obj,FL_RED);
			fl_set_object_callback(obj,set_abort_true,0);
			fl_set_object_gravity(obj, FL_SouthWest, FL_SouthEast);
			fl_set_object_resize(obj, FL_RESIZE_NONE);
			tooltips_addtip(obj,"Abort the current fitting attempt");
		do_nnet_chart = fl_add_chart(FL_LINE_CHART,10,10,480,140,"");
			fl_set_object_gravity(do_nnet_chart, FL_NorthWest, FL_SouthEast);
		do_nnet_browser = fl_add_browser(FL_NORMAL_BROWSER,340,160,150,30,"Status:");
			fl_set_object_dblbuffer(do_nnet_browser, 1);
			fl_set_object_lalign(do_nnet_browser,FL_ALIGN_LEFT);
			fl_set_object_gravity(do_nnet_browser, FL_SouthEast, FL_SouthEast);
			fl_set_object_resize(do_nnet_browser, FL_RESIZE_X);
	fl_end_form();
	fl_set_form_atclose(do_nnet_window, click_abort_window,0);


	sign_window = fl_bgn_form(FL_NO_BOX, 300, 300);
  		obj = fl_add_box(FL_UP_BOX,0,0,300,300,"");
		sign_one_browser = fl_add_browser(FL_HOLD_BROWSER,10,30,130,130,"First Matched Pair");
			fl_set_object_lsize(sign_one_browser, FL_NORMAL_SIZE);
			fl_set_object_lalign(sign_one_browser, FL_ALIGN_TOP);
			fl_set_object_callback(sign_one_browser, do_nothing, 0);
		sign_two_browser = fl_add_browser(FL_HOLD_BROWSER,160,30,130,130,"Second Matched Pair");
			fl_set_object_lsize(sign_two_browser,FL_NORMAL_SIZE);
			fl_set_object_lalign(sign_two_browser,FL_ALIGN_TOP);
			fl_set_object_callback(sign_two_browser, do_nothing, 0);
		sign_from_counter = fl_add_counter(FL_NORMAL_COUNTER,100,180,140,20,"From:");
			fl_set_object_lsize(sign_from_counter,FL_NORMAL_SIZE);
			fl_set_object_lalign(sign_from_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(sign_from_counter, 0);
			fl_set_counter_bounds(sign_from_counter, 0, MAX_OBS);
			fl_set_counter_step(sign_from_counter, 1, 100);
			tooltips_addtip(sign_from_counter,"Limit test to observations beginning here.");
			fl_set_object_callback(sign_from_counter, do_nothing, 0);
		sign_to_counter = fl_add_counter(FL_NORMAL_COUNTER,100,200,140,20,"To:");
			fl_set_object_lsize(sign_to_counter,FL_NORMAL_SIZE);
			fl_set_object_lalign(sign_to_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(sign_to_counter, 0);
			fl_set_counter_bounds(sign_to_counter, 0, MAX_OBS);
			fl_set_counter_step(sign_to_counter, 1, 100);
			tooltips_addtip(sign_to_counter,"Limit test to observations ending here.");
			fl_set_object_callback(sign_to_counter, do_nothing, 0);
		sign_null_counter = fl_add_counter(FL_NORMAL_COUNTER,100,230,140,20,"Null: p =");
			fl_set_object_lsize(sign_null_counter,FL_NORMAL_SIZE);
			fl_set_object_lalign(sign_null_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(sign_null_counter, 2);
			fl_set_counter_bounds(sign_null_counter, 0.01, 0.99);
			fl_set_counter_step(sign_null_counter, 0.01, 0.1);
			fl_set_counter_value(sign_null_counter, 0.5);
			tooltips_addtip(sign_null_counter,"Set probability for the null hypothesis");
			fl_set_object_callback(sign_null_counter, do_nothing, 0);
		obj = fl_add_button(FL_NORMAL_BUTTON,10,260,130,30,"Go");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"Perform the test.");
			fl_set_object_callback(obj, do_signtest, 0);
		obj = fl_add_button(FL_NORMAL_BUTTON,160,260,130,30,"Done");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"OK, I'm done doing sign tests.");
			fl_set_object_callback(obj, done_signtest, 0);
	fl_end_form();
	fl_set_form_atclose(sign_window, click_abort_window,0);

	eqmean_window = fl_bgn_form(FL_NO_BOX, 300, 260);
  		obj = fl_add_box(FL_UP_BOX,0,0,300,260,"");
		eqmean_one_browser = fl_add_browser(FL_HOLD_BROWSER,10,30,130,130,"Sample One");
			fl_set_object_lsize(eqmean_one_browser, FL_NORMAL_SIZE);
			fl_set_object_lalign(eqmean_one_browser, FL_ALIGN_TOP);
			fl_set_object_callback(eqmean_one_browser, do_nothing, 0);
		eqmean_two_browser = fl_add_browser(FL_HOLD_BROWSER,160,30,130,130,"Sample Two");
			fl_set_object_lsize(eqmean_two_browser,FL_NORMAL_SIZE);
			fl_set_object_lalign(eqmean_two_browser,FL_ALIGN_TOP);
			fl_set_object_callback(eqmean_two_browser, do_nothing, 0);
		eqmean_from_counter = fl_add_counter(FL_NORMAL_COUNTER,100,170,140,20,"From:");
			fl_set_object_lsize(eqmean_from_counter,FL_NORMAL_SIZE);
			fl_set_object_lalign(eqmean_from_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(eqmean_from_counter, 0);
			fl_set_counter_bounds(eqmean_from_counter, 0, MAX_OBS);
			fl_set_counter_step(eqmean_from_counter, 1, 100);
			tooltips_addtip(eqmean_from_counter,"Limit test to observations beginning here.");
			fl_set_object_callback(eqmean_from_counter, do_nothing, 0);
		eqmean_to_counter = fl_add_counter(FL_NORMAL_COUNTER,100,190,140,20,"To:");
			fl_set_object_lsize(eqmean_to_counter,FL_NORMAL_SIZE);
			fl_set_object_lalign(eqmean_to_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(eqmean_to_counter, 0);
			fl_set_counter_bounds(eqmean_to_counter, 0, MAX_OBS);
			fl_set_counter_step(eqmean_to_counter, 1, 100);
			tooltips_addtip(eqmean_to_counter,"Limit test to observations ending here.");
			fl_set_object_callback(eqmean_to_counter, do_nothing, 0);
		obj = fl_add_button(FL_NORMAL_BUTTON,10,220,130,30,"Go");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"Perform the test.");
			fl_set_object_callback(obj, do_eqmeantest, 0);
		obj = fl_add_button(FL_NORMAL_BUTTON,160,220,130,30,"Done");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"OK, I'm done doing testing.");
			fl_set_object_callback(obj, done_eqmeantest, 0);
	fl_end_form();
	fl_set_form_atclose(eqmean_window, click_abort_window,0);

	watson_window = fl_bgn_form(FL_NO_BOX, 300, 260);
  		obj = fl_add_box(FL_UP_BOX,0,0,300,260,"");
		watson_browser = fl_add_browser(FL_HOLD_BROWSER,10,30,280,130,"Residuals Variable");
			fl_set_object_lsize(watson_browser, FL_NORMAL_SIZE);
			fl_set_object_lalign(watson_browser, FL_ALIGN_TOP);
			fl_set_object_callback(watson_browser, do_nothing, 0);
		watson_from_counter = fl_add_counter(FL_NORMAL_COUNTER,100,170,140,20,"From:");
			fl_set_object_lsize(watson_from_counter,FL_NORMAL_SIZE);
			fl_set_object_lalign(watson_from_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(watson_from_counter, 0);
			fl_set_counter_bounds(watson_from_counter, 0, MAX_OBS);
			fl_set_counter_step(watson_from_counter, 1, 100);
			tooltips_addtip(watson_from_counter,"Limit test to observations beginning here.");
			fl_set_object_callback(watson_from_counter, do_nothing, 0);
		watson_to_counter = fl_add_counter(FL_NORMAL_COUNTER,100,190,140,20,"To:");
			fl_set_object_lsize(watson_to_counter,FL_NORMAL_SIZE);
			fl_set_object_lalign(watson_to_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(watson_to_counter, 0);
			fl_set_counter_bounds(watson_to_counter, 0, MAX_OBS);
			fl_set_counter_step(watson_to_counter, 1, 100);
			tooltips_addtip(watson_to_counter,"Limit test to observations ending here.");
			fl_set_object_callback(watson_to_counter, do_nothing, 0);
		obj = fl_add_button(FL_NORMAL_BUTTON,10,220,130,30,"Go");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"Perform the test.");
			fl_set_object_callback(obj, do_watsontest, 0);
		obj = fl_add_button(FL_NORMAL_BUTTON,160,220,130,30,"Done");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			tooltips_addtip(obj,"OK, I'm done doing testing.");
			fl_set_object_callback(obj, done_watsontest, 0);
	fl_end_form();
	fl_set_form_atclose(watson_window, click_abort_window,0);

	filter_window = fl_bgn_form(FL_NO_BOX, 300, 280);
		obj = fl_add_box(FL_UP_BOX,0,0,300,280,"");
		filter_browser = fl_add_browser(FL_MULTI_BROWSER,20,30,170,140,"Variable to Overwrite");
			fl_set_object_lsize(filter_browser,FL_NORMAL_SIZE);
			fl_set_object_lalign(filter_browser,FL_ALIGN_TOP);
			fl_set_object_callback(filter_browser, do_nothing, 0);
		obj = fl_bgn_group();
			filter_outliers_button = fl_add_lightbutton(FL_RADIO_BUTTON,200,50,90,30,"X Outliers");
				fl_set_object_lsize(filter_outliers_button,FL_NORMAL_SIZE);
				fl_set_object_callback(filter_outliers_button, do_nothing, 0);
				tooltips_addtip(filter_outliers_button,"Remove observation more than 3 SD from Mean");
			filter_detrend_button = fl_add_lightbutton(FL_RADIO_BUTTON,200,90,90,30,"Detrend");
				fl_set_object_lsize(filter_detrend_button,FL_NORMAL_SIZE);
				fl_set_object_callback(filter_detrend_button, do_nothing, 0);
				tooltips_addtip(filter_detrend_button,"Remove linear trend.");
			filter_zo_button = fl_add_lightbutton(FL_RADIO_BUTTON,200,130,90,30,"Trans 0-1");
				fl_set_object_lsize(filter_zo_button,FL_NORMAL_SIZE);
				fl_set_object_callback(filter_zo_button, do_nothing, 0);
				tooltips_addtip(filter_zo_button,"Transform Data to lie between 0.0 and 1.0");
		fl_end_group();
		obj = fl_add_text(FL_NORMAL_TEXT,210,30,80,20,"Filter to Use");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
		filter_from_counter = fl_add_counter(FL_NORMAL_COUNTER,90,180,140,20,"From:");
			fl_set_object_lsize(filter_from_counter,FL_NORMAL_SIZE);
			fl_set_object_lalign(filter_from_counter,FL_ALIGN_LEFT);
			fl_set_counter_precision(filter_from_counter, 0);
			fl_set_counter_bounds(filter_from_counter, 0, MAX_OBS);
			fl_set_counter_step(filter_from_counter, 1, 100);
			tooltips_addtip(filter_from_counter,"Limit filter to observations starting here.");
			fl_set_object_callback(filter_from_counter, do_nothing, 0);
		filter_to_counter = fl_add_counter(FL_NORMAL_COUNTER,90,200,140,20,"To:");
			fl_set_object_lsize(filter_to_counter, FL_NORMAL_SIZE);
			fl_set_object_lalign(filter_to_counter, FL_ALIGN_LEFT);
			fl_set_counter_precision(filter_to_counter, 0);
			fl_set_counter_bounds(filter_to_counter, 0, MAX_OBS);
			fl_set_counter_step(filter_to_counter, 1, 100);
			tooltips_addtip(filter_to_counter,"Limit filter to observations ending here.");
			fl_set_object_callback(filter_to_counter, do_nothing, 0);
		obj = fl_add_button(FL_NORMAL_BUTTON,30,230,100,30,"Go");
			fl_set_object_lcol(obj,FL_RED);
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			fl_set_object_callback(obj, do_filter, 0);
			tooltips_addtip(obj, "Perform the selected filtration.");
		obj = fl_add_button(FL_NORMAL_BUTTON,170,230,100,30,"Done");
			fl_set_object_lsize(obj,FL_NORMAL_SIZE);
			fl_set_object_callback(obj, done_filter, 0);
			tooltips_addtip(obj, "OK, I'm done filtering.");
	fl_end_form();
	fl_set_form_atclose(filter_window, click_abort_window,0);


}


