// KPPPLoad - a PPP load monitor
// Copyright (C) 1998  Sean Vyain, svyain@mail.tds.net
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _Options_h_
#define _Options_h_

#include <qobject.h>

class KConfig;

class Options :public QObject {
    Q_OBJECT
    KConfig* _config;
public:
    Options();

    void sync();

    bool          getShowTxRate();
    bool          getShowRxRate();
    bool          getShowTxTotal();
    bool          getShowRxTotal();
    int           getStatsInterval();
    int           getPeriodicInterval();
    const QString getPPPCommand();
    const QString getPeriodicCommand();
    int           getLinkNumber();
    int           getRetryInterval();
    int           getRateDivider();
    int           getStatsPeriod();
    QColor        getRxColor();
    QColor        getTxColor();

    void setShowTxRate( bool b );
    void setShowRxRate( bool b );
    void setShowTxTotal( bool b );
    void setShowRxTotal( bool b );
    void setStatsInterval( int i );
    void setPeriodicInterval( int i );
    void setPPPCommand( const char* str );
    void setPeriodicCommand( const char* str );
    void setLinkNumber( int i );
    void setRetryInterval( int i );
    void setRateDivider( int i );
    void setStatsPeriod( int i );
    void setRxColor( QColor c );
    void setTxColor( QColor c );
signals:
    void sigShowTxRate();
    void sigShowRxRate();
    void sigShowTxTotal();
    void sigShowRxTotal();
    void sigStatsInterval();
    void sigPeriodicInterval();
    void sigPPPCommand();
    void sigPeriodicCommand();
    void sigLinkNumber();
    void sigRetryInterval();
    void sigRateDivider();
    void sigStatsPeriod();
    void sigRxColor();
    void sigTxColor();
};

extern Options* options;

#endif
