/*
 * $Id: warn.c,v 1.1 1997/05/22 21:05:13 tvr Exp $
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 * Written by
 *   Teemu Rantanen (tvr@cs.hut.fi)
 *
 * $Log: warn.c,v $
 * Revision 1.1  1997/05/22 21:05:13  tvr
 * Initial revision
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "warn.h"

struct warn_s
{
    char		*name;
    struct warn_s	*pnext;
    int			 nrwarn;
    char		*pwarn;
};

static warn_t *warnlist = NULL;

warn_t *warn_init(char *name, int nrwarnings)
{
    warn_t		*p;
    p = malloc(sizeof(*p));
    p->name = name;
    p->pnext = warnlist;
    warnlist = p;
    p->nrwarn = nrwarnings;
    if (nrwarnings)
    {
	p->pwarn = malloc((p->nrwarn+7)/8);
	memset(p->pwarn, 0, (p->nrwarn+7)/8);
    }
    else
	p->pwarn = NULL;
    return p;
}

void warn(warn_t *pwarn, int warnid, char *msg, ...)
{
    char			*p;
    int				 m;
    va_list			 ap;

    if (warnid >= 0 && warnid < pwarn->nrwarn)
    {
	p = &pwarn->pwarn[warnid/8];
	m = 1 << (warnid % 8);
	if (*p & m)
	    return;
	*p |= m;
    }
    va_start(ap, msg);
    fprintf(stdout, "%s: warning: ", pwarn->name);
    vfprintf(stdout, msg, ap);
    fprintf(stdout, "\n");
    va_end(ap);
}

void warn_reset(warn_t *pwarn)
{
    warn_t		*p;
    if (pwarn)
    {
	if (pwarn->nrwarn)
	    memset(pwarn->pwarn, 0, (pwarn->nrwarn+7)/8);
	return;
    }
    for (p = warnlist; p; p = p->pnext)
	warn_reset(p);
}
