/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "analyze.pas" */


#include "cfuncs.h"


#define ANALYZE_G
#include "analyze.h"


#ifndef STRINGS_H

#endif

#ifndef PREAMBLE_H
#include "preamble.h"
#endif


static short bottom_length;


static short find_voice(char *s)
{
  short i, FORLIM;

  if (strlen(s) == 1) {
    i = pos1(s[0], digits);
    if (i > 0 && i <= nvoices)
      return i;
  }
  FORLIM = nvoices;
  for (i = 1; i <= FORLIM; i++) {
    if (!strcmp(voice_label[i-1], s))
      return i;
  }
  return 0;
}


char *meter_change(char *Result, short n1, short n2, boolean blind)
{
  char s1[256], s2[256];
  short f = 64;
  short l;

  l = n1 * (64 / n2);
  if (blind) {
    while ((l & 1) == 0 && f > meterdenom) {
      l /= 2;
      f /= 2;
    }
  } else {
    l = n1;
    f = n2;
  }
  strnum(s1, l);
  strnum(s2, f);
  if (!strcmp(s1, "1"))
    strcpy(s1, "o");
  if (!strcmp(s2, "1"))
    strcpy(s2, "o");
  if (!blind) {
    sprintf(Result, "m%s%s%s%s", s1, s2, s1, s2);
    return Result;
  }
  sprintf(Result, "m%s%s00 ", s1, s2);
  printf("Blind meter change to %d/%d on line %d\n", l, f, line_no);
  return Result;
}


void test_paragraph(void)
{
  short voice, j, l;
  short leader = 0, nv = 0;
  short cmp[maxvoices];
  short FORLIM;
  line_info *WITH;
  short FORLIM1;

  nbars = 0;
  pickup = 0;
  nleft = 0;
  if (top > bottom)
    return;
  pickup = 0;
  FORLIM = bottom;
  for (voice = top; voice <= FORLIM; voice++) {
    WITH = &info[voice-1];
    if (WITH->mus > 0) {   /** -------------- Voice is present  ---- */
      nv++;
      line_no = orig_line_no[WITH->mus - 1];
      scan_music(voice, &l);
      strcpy(P[WITH->mus - 1], WITH->line);
      if (!pmx_preamble_done) {
	if (voice == top)
	  pickup = l;
	else if (pickup != l)
	  error("The same pickup must appear in all voices");
      }
      if (WITH->nbar > nbars || WITH->nbar == nbars && WITH->left > nleft) {
	nbars = WITH->nbar;
	nleft = WITH->left;
	leader = voice;
      }
      if (!final_paragraph && WITH->left > 0)
	error("Line does not end at complete bar");
      if (pmx_preamble_done && l > 0)
	error("Short bar with no meter change");
    }
  }
  if (!pmx_preamble_done) {
    xmtrnum0 = (double)pickup / one_beat;
    if (verbose > 0)
      printf("Pickup = %d/64\n", pickup);
  }
  FORLIM = bottom;
  for (voice = top - 1; voice <= FORLIM - 1; voice++) {
    WITH = &info[voice];
    if (WITH->mus > 0) {
      cmp[voice] = 0;
      line_no = orig_line_no[WITH->mus - 1];
      FORLIM1 = bottom;
      for (j = top - 1; j <= FORLIM1 - 1; j++) {
	if (info[j].mus > 0) {
	  if (info[voice].nbar != info[j].nbar ||
	      info[voice].left != info[j].left)
	    cmp[voice]++;
	}
      }
      if (cmp[voice] > 1 || cmp[voice] == 1 && nv == 2 && voice + 1 != leader) {
	printf("Line has %d bars + %d/64 notes\n", WITH->nbar, WITH->left);
	error("Line duration anomaly");
      }
    }
  }
}


void describe_paragraph(void)
{
  short w, bar, voice;
  char STR2[256];
  short FORLIM;
  line_status *WITH;
  line_info *WITH1, *WITH2;
  short FORLIM1;

  printf("---- Paragraph %d starting at line %d bar %d\n",
	 paragraph_no, orig_line_no[0], bar_no);
  FORLIM = bottom;
  for (voice = top; voice <= FORLIM; voice++) {
    WITH = &current[voice-1];
    WITH1 = &info[voice-1];
    printf("Voice `%s' is on line %d", voice_label[voice-1], WITH1->mus);
    if (WITH1->vocal) {
      printf(", is vocal");
      if (WITH1->has_lyrics == none)
	printf(" but has no own lyrics\n");
      else {
	printf(" with ");
	if (WITH1->has_lyrics == auxiliary)
	  printf("auxiliary ");
	printf("lyrics on line %d", abs(WITH1->lyr));
	if (WITH1->nlyr > 1)
	  printf(" to line %d", abs(WITH1->lyr) + WITH1->nlyr - 1);
	putchar('\n');
      }
    } else {
      if (WITH1->chord > 0)
	printf(" and has chords on line %d", WITH1->chord);
      putchar('\n');
    }
    if (verbose > 1) {
      WITH2 = &info[voice-1];
      printf("Line has %d bars", WITH2->nbar);
      if (WITH2->left > 0)
	printf(" + %d/64 notes\n", WITH2->left);
      else
	putchar('\n');
      printf("Bars:");
      FORLIM1 = WITH2->nbar;
      for (bar = 1; bar <= FORLIM1; bar++)
	printf(" %s ", get_bar(STR2, voice, bar));
      printf("\nWord types:");
      FORLIM1 = WITH2->nword;
      for (w = 0; w <= FORLIM1 - 1; w++)
	printf(" %s", name[(long)WITH2->scan[w]]);
      putchar('\n');
    }
  }
}


void lyr_translate(char *P)
{
  short k, l;
  char Q[256];

  *Q = '\0';
  l = strlen(P);
  for (k = 0; k <= l - 1; k++) {
    if (P[k] != '_')
      sprintf(Q + strlen(Q), "%c", P[k]);
    else if (k + 1 > 1 && P[k-1] == '\\')
      strcat(Q, "lowlyrlink ");
    else
      strcat(Q, "\\lyrlink ");
  }
  strcpy(P, Q);
}


#define maxlyrlen       (PMXlinelength - 15)


/* static variables for paragraph_setup: */
struct LOC_paragraph_setup {
  short *voice, i, k, s;
  char tag[256], w[256];
} ;

static void convertlyrics(short voicepos, struct LOC_paragraph_setup *LINK)
{
  /* --- musixlyr only --- */
  static char setlyr[256] = "%%\\\\\\setlyrics{";
  char STR1[256];
  line_info *WITH;
  char STR2[256];

  if (!dolyrics)
    return;
  NextWord(LINK->w, P[LINK->i-1], blank, dummy);
  LINK->s = info[LINK->k-1].voice_stave;
  WITH = &info[LINK->k-1];
  if (*LINK->w == '\0') {
    if (WITH->has_lyrics == normal) {
      *tags[LINK->s-1] = '\0';
      WITH->has_lyrics = none;
      return;
    }
    if (WITH->has_lyrics == auxiliary) {
      *auxtags[LINK->s-1] = '\0';
      WITH->has_lyrics = none;
    }
    return;
  }
  if (LINK->w[0] == '{') {
    global_lyrics = true;
    if (voicepos < 0) {
      WITH->has_lyrics = normal;
      substr_(tags[LINK->s-1], LINK->w, 2, strlen(LINK->w) - 2);
    } else {
      WITH->has_lyrics = auxiliary;
      substr_(auxtags[LINK->s-1], LINK->w, 2, strlen(LINK->w) - 2);
    }
    return;
  }
  global_lyrics = false;
  strnum(LINK->tag, LINK->k * 10 + info[LINK->k-1].nlyr);
  if (voicepos < 0) {
    if (!strcmp(tags[LINK->s-1], "."))
      *tags[LINK->s-1] = '\0';
    else
      strcat(tags[LINK->s-1], ",");
    strcat(tags[LINK->s-1], LINK->tag);
    WITH->has_lyrics = normal;
  } else {
    if (!strcmp(auxtags[LINK->s-1], "."))
      *auxtags[LINK->s-1] = '\0';
    else
      strcat(auxtags[LINK->s-1], ",");
    strcat(auxtags[LINK->s-1], LINK->tag);
    WITH->has_lyrics = auxiliary;
  }
  stripblanks(P[LINK->i-1]);
  lyr_translate(P[LINK->i-1]);
  if (strlen(P[LINK->i-1]) + strlen(LINK->tag) > maxlyrlen) {
    sprintf(STR2, "%s%s}{\\\n\\\\\\:%s}\\", setlyr, LINK->tag, P[LINK->i-1]);
    strcpy(P[LINK->i-1], STR2);
  } else {
    sprintf(STR1, "%s%s}{%s}\\", setlyr, LINK->tag, P[LINK->i-1]);
    strcpy(P[LINK->i-1], STR1);
  }
}

#undef maxlyrlen

static void maybe_uptext(struct LOC_paragraph_setup *LINK)
{
  if (!dotext)
    return;
  if (strlen(LINK->w) == 1 && *LINK->voice == nvoices)
    warning("Uptext line below bottom voice should be labelled");
  if (strlen(LINK->w) == 1) {   /**  Standard chord line ------ */
    LINK->k = *LINK->voice + 1;
    if (LINK->k > nvoices)
      LINK->k--;
    info[LINK->k-1].uptext = LINK->i;
    /**  Labelled chord line  ---- */
    return;
  }
  predelete(LINK->w, 1);
  LINK->k = find_voice(LINK->w);
  if (LINK->k == 0)
    error("Uptext line belongs to unknown voice");
  else
    info[LINK->k-1].uptext = LINK->i;
}

static void maybe_chords(struct LOC_paragraph_setup *LINK)
{
  if (!dochords)
    return;
  if (strlen(LINK->w) == 1 && *LINK->voice == 0)
    warning("Chord line above top voice should be labelled");
  if (strlen(LINK->w) == 1) {   /**  Standard chord line ------ */
    LINK->k = *LINK->voice;
    if (LINK->k == 0)
      LINK->k = 1;
    info[LINK->k-1].chord = LINK->i;
    /**  Labelled chord line  ---- */
    return;
  }
  predelete(LINK->w, 1);
  LINK->k = find_voice(LINK->w);
  if (LINK->k == 0)
    error("Chord line belongs to unknown voice");
  else
    info[LINK->k-1].chord = LINK->i;
}

static void maybe_lyrics(struct LOC_paragraph_setup *LINK)
{
  line_info *WITH;

  if (!dolyrics)
    return;
  if (strlen(LINK->w) == 1 && *LINK->voice == 0)
    warning("Lyrics line above top voice should be labelled");
  if (strlen(LINK->w) == 1) {   /**  Standard lyrics line -------- */
    LINK->k = *LINK->voice;
    if (LINK->k == 0)
      LINK->k = 1;
    if (info[LINK->k-1].nlyr == 0)   /* first time only */
      info[LINK->k-1].lyr = -LINK->i;
    info[LINK->k-1].nlyr++;
    if (musixlyr)
      convertlyrics(-1, LINK);
    return;
  }
  predelete(LINK->w, 1);
  LINK->k = find_voice(LINK->w);
  if (LINK->k == 0) {
    error("Lyrics line belongs to unknown voice");
    /**  Labelled lyrics line -- */
    return;
  }
  WITH = &info[LINK->k-1];
  WITH->lyr = LINK->i;
  WITH->nlyr++;
  if (musixlyr)
    convertlyrics(WITH->voice_pos, LINK);
}


void paragraph_setup(short *voice_)
{
  struct LOC_paragraph_setup V;
  short l, v, FORLIM;
  line_info *WITH1;

  V.voice = voice_;
  *V.voice = 0;
  bottom = 0;
  top = nvoices + 1;
  global_lyrics = true;
  FORLIM = nvoices;
  for (V.i = 1; V.i <= FORLIM; V.i++) {
/* p2c: analyze.pas: Note: Eliminated unused assignment statement [338] */
    WITH1 = &info[V.i-1];
    WITH1->chord = 0;
    WITH1->mus = 0;
    WITH1->lyr = 0;
    WITH1->nlyr = 0;
    WITH1->uptext = 0;
  }
  FORLIM = nstaves;
  for (V.k = 1; V.k <= FORLIM; V.k++) {
    strcpy(tags[V.k-1], ".");
    strcpy(auxtags[V.k-1], ".");
  }
  FORLIM = para_len;
  for (V.i = 1; V.i <= FORLIM; V.i++)
  {   /* ----- Paragraph analysis main loop ----- */
    if (*P[V.i-1] != '\0' && P[V.i-1][0] != comment) {
      NextWord(V.w, P[V.i-1], blank, colon);
      line_no = orig_line_no[V.i-1];
      l = strlen(V.w);
      if (V.w[l-1] == colon && V.w[l-2] != barsym) {
	/** ---------- Line is labelled -------------------------- */
	predelete(P[V.i-1], l);
	shorten(V.w, l - 1);
	if (V.w[0] == 'L')
	  maybe_lyrics(&V);
	else if (V.w[0] == 'C')
	  maybe_chords(&V);
	else if (V.w[0] == 'U')
	  maybe_uptext(&V);
	else {
	  V.k = find_voice(V.w);
	  if (V.k > 0) {
	    *V.voice = V.k;
	    info[*V.voice - 1].mus = V.i;
	  } else {
	    uppercase(V.w);
	    if (match(V.w, "SPACE")) {
	      set_space(P[V.i-1]);
	      must_respace = true;
	    } else {
	      error("Label on line belongs to unknown voice");
	      /** ------------ Maybe Space command ------------ */
	    }
	  }
	}
      } else {
	/** ------------ Other labelled line --------------------- */
	(*V.voice)++;
	info[*V.voice - 1].mus = V.i;
      }
      /** ------------- Unlabelled line -------------------------- */
      if (*V.voice > bottom)
	bottom = *V.voice;
      if (*V.voice > 0 && *V.voice < top)
	top = *V.voice;
    }
  }
  if (global_lyrics)
    return;

  FORLIM = nvoices;
  for (v = 0; v <= FORLIM - 1; v++) {
    WITH1 = &info[v];
    if (WITH1->lyr == 0)
      WITH1->has_lyrics = none;
  }
}




/* End. */
