/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "mtx.pas" */


#include "cfuncs.h"


#define MTX_G
#include "mtx.h"


#ifndef STRINGS_H

#endif


#define dot             '.'
#define comma           ','
#define dotcode         'd'

#define pause           "rp"
#define flagged         "8136"

#define ndurs           7
#define crotchet        16


static char terminators[256] = ".x";
static char durations[ndurs + 1] = "0248136";

static short count64['8' + 1 - '0'] = {
  64, 4, 32, 2, 16, 0, 1, 0, 8
};


char init_octave(short voice_stave)
{
  char Result;

  if (pos1(clef[voice_stave-1], "Gt0") > 0)
    Result = '4';
  else
    Result = '3';
  if (verbose > 1)
    printf("  Stave %d  Clef %c  Position %d\n",
	   voice_stave, clef[voice_stave-1],
	   pos1(clef[voice_stave-1], "Gt0"));
  return Result;
}


void text_translate(char *uptext, char *font)
{
  short k;
  char STR1[256];
  char STR2[256], STR3[256];
  char STR4[256];
  short FORLIM;

  if (*uptext == '\0')
    return;
  k = pos1('%', uptext);
  if (k > 0) {
    sprintf(STR4, "%s$\\flat$%s",
	    substr_(STR1, uptext, 1, k - 1),
	    substr_(STR3, uptext, k + 1, strlen(uptext) - k));
    strcpy(uptext, STR4);
  }
  k = pos1('#', uptext);
  if (k > 0) {
    sprintf(STR2, "%s$\\sharp$%s",
	    substr_(STR1, uptext, 1, k - 1),
	    substr_(STR4, uptext, k + 1, strlen(uptext) - k));
    strcpy(uptext, STR2);
  }
  if (!strcmp(uptext, "<") || !strcmp(uptext, ">"))
    strcpy(uptext, "\\icresc");
  else if (!strcmp(uptext, "<."))
    strcpy(uptext, "\\tcresc");
  else if (!strcmp(uptext, ">."))
    strcpy(uptext, "\\tdecresc");
  FORLIM = strlen(uptext);
  for (k = 0; k <= FORLIM - 1; k++) {
    if (pos1(uptext[k], "mpfzrs") == 0)
      return;
  }
  strcpy(font, "\\ppff");
}


static short logtwo(short denom)
{
  short l = 0;

  while (denom > 1) {
    l++;
    denom /= 2;
  }
  return l;
}


char *rests(char *Result, short len, short meterdenom)
{
  static char dur[8] = "0248136";
  char STR1[256];

  if (len == 0)
    return strcpy(Result, "");
  else {
    if (len >= 64 / meterdenom) {
      sprintf(Result, "%sr%c ",
	      rests(STR1, len - 64 / meterdenom, meterdenom),
	      dur[logtwo(meterdenom)]);
      return Result;
    } else
      return (rests(Result, len, meterdenom * 2));
  }
}


static void extract_duration_code(char *note, char *code)
{
  short i = 2;
  short l;

  *code = unspecified;
  l = strlen(note);
  if (l < 2 || pos1(note[0], has_duration) == 0)
    return;
  while (i <= l) {
    if (pos1(note[i-1], durations) > 0) {
      *code = note[i-1];
      delete1(note, i);
      return;
    }
    if (pos1(note[i-1], terminators) > 0)
      return;
    i++;
  }
}


static char duration_code(char *note_)
{
  char note[256];
  char code;

  strcpy(note, note_);
  extract_duration_code(note, &code);
  return code;
}


static void add_duration(char *note, char *dur)
{
  short i, l;

  if (!strcmp(note, pause))
    return;
  l = strlen(note);
  for (i = 1; i <= l - 1; i++) {
    if (pos1(note[i], durations) > 0) {
      *dur = note[i];
      return;
    }
    if (pos1(note[i], terminators) > 0) {
      insertchar(*dur, note, 2);
      return;
    }
  }
  insertchar(*dur, note, 2);
}


static char half(char dur)
{
  char Result;
  short k;
  char STR1[20];
  char STR2[24];

  k = pos1(dur, durations);
  Result = dur;
  if (k == 0) {
    sprintf(STR1, "Invalid duration %c", dur);
    error(STR1);
    return Result;
  }
  if (k <= ndurs)
    return (durations[k]);
  sprintf(STR2, "%c is too short to halve", dur);
  error(STR2);
  return Result;
}


typedef enum {
  solitary, three_one, two_one
} grouptype;


/* static variables for expand: */
struct LOC_expand {
  char *note, *xnote;
  char *dur;
  char note1[256];
  grouptype group;
} ;

static void dotme(struct LOC_expand *LINK)
{
  char STR1[256];

  if (split_dots)
    *LINK->dur = half(*LINK->dur);
  if (LINK->group == two_one)
    GetNextWord(LINK->note1, LINK->note, comma, dummy);
  else
    sprintf(LINK->note1, "%s%c",
	    GetNextWord(STR1, LINK->note, dot, dummy), dotcode);
  add_duration(LINK->note1, LINK->dur);
  *LINK->dur = half(*LINK->dur);
  add_duration(LINK->note, LINK->dur);
  strcpy(LINK->xnote, LINK->note);
  strcpy(LINK->note, LINK->note1);
}


/* Expand dot groups */
static void expand(char *note_, char *xnote_, char dur1, char *dur_)
{
  struct LOC_expand V;
  short k;
  char dur2;

  V.note = note_;
  V.xnote = xnote_;
  V.dur = dur_;
  *V.xnote = '\0';
  if (*V.note == '\0' || pos1(V.note[0], has_duration) == 0 ||
      !strcmp(V.note, pause))
    return;
  extract_duration_code(V.note, &dur2);
  if (dur2 == unspecified)
    *V.dur = dur1;
  else
    *V.dur = dur2;
  k = pos1(dot, V.note);
  if (k > 0)
    V.group = three_one;
  else {
    k = pos1(comma, V.note);
    if (k > 0)
      V.group = two_one;
    else
      V.group = solitary;
  }
  if (k == strlen(V.note))
    error("Note may not end in dot or comma");
  else if (V.group != solitary && pos1(V.note[k], note_names) == 0)
    error("Dot or comma must be followed by notename");
  if (V.group == solitary)
    insertchar(*V.dur, V.note, 2);
  else
    dotme(&V);
}


short new_pitch(char *note, line_status stat)
{
  short i, l, interval, npitch;

  interval = note[0] - stat.lastnote;
  if (interval > 3)
    interval -= 7;
  if (interval < -3)
    interval += 7;
  npitch = stat.pitch + interval;
  l = strlen(note);
  for (i = 0; i <= l - 1; i++) {
    if (note[i] == '+')
      npitch += 7;
    else if (note[i] == '-')
      npitch -= 7;
  }
  return npitch;
}


static void repitch(char *note, short diff)
{
  short i, l;

  diff /= 7;
  i = pos1('+', note);
  if (i == 0)
    i = pos1('-', note);
  if (i == 0)
    i = 2;
  if (diff > 0) {
    for (l = 1; l <= diff; l++) {
      if (note[i-1] == '-')
	delete1(note, i);
      else
	insertchar('+', note, i);
    }
    return;
  }
  for (l = -1; l >= diff; l--) {
    if (note[i-1] == '+')
      delete1(note, i);
    else
      insertchar('-', note, i);
  }
}


/* Translate MTX extensions to PMX note syntax and semantics */
void extend(char *note, short voice)
{
  short i, pstat;
  line_status *WITH;
  line_info *WITH1, *WITH2;

  WITH = &current[voice-1];
  WITH1 = &info[voice-1];
  i = pos1('=', note);
  if (i > 0) {
    delete1(note, i);
    WITH->octave = init_octave(WITH1->voice_stave);
  }
  add_duration(note, &WITH->duration);
  /* If first note, supply octave */
  if (note[0] != rest && WITH->octave != blank) {
    i = 2;
    do {
      if (note[i-1] == '+') {
	WITH->octave++;
	delete1(note, i);
      } else if (note[i-1] == '-') {
	WITH->octave--;
	delete1(note, i);
      } else if (pos1(note[i-1], terminators) > 0)
	i = strlen(note);
      i++;
    } while (i <= strlen(note));
    insertchar(WITH->octave, note, 3);
    WITH->octave = blank;
  }
  /* mark debeamed */
  WITH2 = &info[voice-1];
  if (WITH2->vocal && WITH->after_slur == 0 && unbeam_if_vocal &&
      pos1(WITH->duration, flagged) > 0)
    insertchar('a', note, 3);
  /* calculate new pitch */
  if (note[0] < 'a' || note[0] > 'g')
    return;
  pstat = new_pitch(note, cstat[voice-1]);
  WITH->pitch = new_pitch(note, current[voice-1]);
  if (WITH->pitch != pstat)
    repitch(note, WITH->pitch - pstat);
  if (verbose > 2 && WITH->pitch != pstat)
    printf("Pitch from melodic line = %d   from last chordal note = %d\n",
	   WITH->pitch, pstat);
  WITH->lastnote = note[0];
}


short l64(char *note)
{
  return (count64[duration_code(note) - '0']);
}


short note_length(char *note, short voice)
{
  short Result = 0, i = 2;
  short l, nl, tnl;
  char dur1, dur2;
  char STR1[256];

  dur1 = current[voice-1].duration;
  if (*note == '\0')
    return Result;
  if (!strcmp(note, pause))
    return full_bar;
  if (pos1(note[0], has_duration) <= 0)
    return Result;
  dur2 = duration_code(note);
  if (dur2 != unspecified)
    dur1 = dur2;
  nl = count64[dur1 - '0'];
  tnl = nl;
  l = strlen(note);
  while (i <= l) {
    sprintf(STR1, "%c", dotcode);
    if (pos1(note[i-1], STR1) > 0) {
      nl /= 2;
      tnl += nl;
    } else if (pos1(note[i-1], terminators) > 0)
      i = l;
    i++;
  }
  if (pos1(dot, note) > 0)
    tnl += tnl;
  else if (pos1(comma, note) > 0)
    tnl += tnl / 2;
  return tnl;
/* p2c: mtx.pas: Note: Deleting unreachable code [255] */
}


static void maybe_meter(char *w_, short *bar)
{
  char w[256];
  short j, n1, n2;

  strcpy(w, w_);
  if (w[0] == 'm') {
    j = 2;
    onumber(w, &j, &n1);
    onumber(w, &j, &n2);
  } else
    get_nums(w, &n1, &n2);
  *bar = n1 * (64 / n2);
}


/* static variables for scan_music: */
struct LOC_scan_music {
  short voice;
  char buf[256], note[256];
  boolean beam_next;
  short bar, bar_length, dotme, i, l, nl, ngrace, nmulti;
  char dur1, dur2;
  music_word nscan;
} ;

static void GetNextMusWord(struct LOC_scan_music *LINK)
{
  char maybe_error[256];
  char STR2[256];

  GetNextWord(LINK->note, LINK->buf, blank, dummy);
  if (*LINK->note == '\0')
    return;
  if (LINK->note[0] == '\\') {
    *maybe_error = '\0';
    if (LINK->note[strlen(LINK->note) - 1] != '\\')
      strcpy(maybe_error, LINK->note);
    while (*LINK->buf != '\0' && LINK->note[strlen(LINK->note) - 1] != '\\')
      sprintf(LINK->note + strlen(LINK->note), " %s",
	      GetNextWord(STR2, LINK->buf, blank, dummy));
    if (LINK->note[strlen(LINK->note) - 1] != '\\')
      error3(LINK->voice, "Unterminated TeX literal");
    LINK->nscan = texword;
    if (*maybe_error != '\0') {
      sprintf(STR2, "Possible unterminated TeX literal: %s", maybe_error);
      warning(STR2);
    }
    return;
  }
  switch (LINK->note[0]) {

  case 'a':
  case 'b':
  case 'c':
  case 'd':
  case 'e':
  case 'f':
  case 'g':
    LINK->nscan = abcdefg;
    break;

  case 'z':
    LINK->nscan = zword;
    break;

  case '(':
  case '{':
    LINK->nscan = lparen;
    break;

  case ')':
  case '}':
    if (pos1('(', LINK->note) == 0)
      LINK->nscan = rparen;
    else
      LINK->nscan = rlparen;
    break;

  case '[':
    LINK->nscan = lbrac;
    break;

  case ']':
    LINK->nscan = rbrac;
    break;

  case '@':
    LINK->nscan = atword;
    break;

  case 'm':
    LINK->nscan = mword;
    break;

  case 'r':
    LINK->nscan = rword;
    break;

  case '#':
  case '-':
  case 'n':
  case 'x':
  case '?':
    LINK->nscan = pmxl;
    break;

  case 'G':
    if (pos1('A', LINK->note) > 0)
      LINK->nscan = pmxl;
    else
      LINK->nscan = other;
    break;

  case '1':
  case '2':
  case '3':
  case '4':
  case '5':
  case '6':
  case '7':
  case '8':
  case '9':
    if (pos1('/', LINK->note) > 0)
      LINK->nscan = mword;
    else
      LINK->nscan = pmxl;
    break;

  case 'o':
    LINK->nscan = oword;
    break;

  case 'A':
  case 'V':
    LINK->nscan = FirstOnly;
    break;

  case '/':
    if (!strcmp(LINK->note, "//"))
      LINK->nscan = nextvoice;
    else if (!strcmp(LINK->note, "/")) {
      strcpy(LINK->note, "//");
      warning("/ changed to //");
      LINK->nscan = nextvoice;
    } else {
      error3(LINK->voice, "Word starts with /: do you mean \\?");
      LINK->nscan = err;
    }
    break;

  default:
    if (pos1('|', LINK->note) > 0)
      LINK->nscan = barword;
    else
      LINK->nscan = other;
    break;
  }
}

/* static variables for count_it: */
struct LOC_count_it {
  struct LOC_scan_music *LINK;
} ;

static void incbar(short nl, struct LOC_count_it *LINK)
{
  LINK->LINK->bar_length += nl;
  if (LINK->LINK->bar_length > LINK->LINK->bar)
    error3(LINK->LINK->voice, "Bar end occurs in mid-note");
}

static void count_it(struct LOC_scan_music *LINK)
{
  struct LOC_count_it V;
  line_info *WITH;
  char STR1[256];

  V.LINK = LINK;
  if (LINK->ngrace > 0) {
    LINK->ngrace--;
    return;
  }
  if (LINK->nmulti > 0) {
    LINK->nmulti--;
    return;
  }
  WITH = &info[LINK->voice-1];
  LINK->dur2 = duration_code(LINK->note);
  if (LINK->dur2 != unspecified)
    LINK->dur1 = LINK->dur2;
  LINK->nl = count64[LINK->dur1 - '0'];
  incbar(LINK->nl, &V);
  if (pos1(comma, LINK->note) > 0)
    incbar(LINK->nl / 2, &V);
  else {
    if (pos1(dot, LINK->note) > 0)
      LINK->dotme = 2;
    else
      LINK->dotme = 1;
    if (!split_dots && LINK->dotme == 2) {
      LINK->dotme = 1;
      incbar(LINK->nl, &V);
    }
    LINK->l = strlen(LINK->note);
    LINK->i = 2;
    while (LINK->i <= LINK->l) {
      sprintf(STR1, "%c", dotcode);
      if (pos1(LINK->note[LINK->i-1], STR1) > 0) {
	LINK->nl /= 2;
	incbar(LINK->nl, &V);
      } else if (pos1(LINK->note[LINK->i-1], terminators) > 0)
	LINK->i = LINK->l;
      LINK->i++;
    }
  }
  /* ------------ did you forget duration under beam? ------------ */
  if (LINK->beam_next && LINK->nl / LINK->dotme >= crotchet)
    warning("Note under beam has length 1/4 or more");
  LINK->beam_next = false;
  /* ------------------------------------------------------------- */
  LINK->l = pos1(multi_group, LINK->note);
  if (LINK->l <= 0)
    return;
  predelete(LINK->note, LINK->l);
  get_num(LINK->note, &LINK->nmulti);
  LINK->nmulti--;
}

static void maybe_group(struct LOC_scan_music *LINK)
{
  switch (LINK->note[0]) {

  case start_beam:
    LINK->beam_next = true;
    break;

  case grace_group:
    if (strlen(LINK->note) == 1)
      LINK->ngrace = 1;
    else
      LINK->ngrace = pos1(LINK->note[1], digits);
    /* bug if ngrace>9 */
    if (LINK->ngrace > 0)
      LINK->ngrace--;
    break;
  }
}

static void regroup(struct LOC_scan_music *LINK)
{
  short i, j, j1;
  short j2 = 0;
  line_info *WITH;
  short FORLIM;

  WITH = &info[LINK->voice-1];
  FORLIM = WITH->nbar;
  for (i = 1; i <= FORLIM; i++) {
    j1 = j2 + 1;
    j2 = WITH->bar_bound[i];
    j = j2 + 1;
    while (j <= WITH->here && bind_left[(long)WITH->scan[j-1]]) {
      WITH->bar_bound[i]++;
      j++;
    }
  }
  if (WITH->left > 0)
    WITH->bar_bound[WITH->nbar + 1] = WITH->here;
  WITH->nword = WITH->here;
}


void scan_music(short voice_, short *l1)
{
  struct LOC_scan_music V;
  char enote[256], xnote[256];
  boolean has_next = false, done = false;
  char lastdur;
  line_info *WITH;
  char STR1[256];

  V.voice = voice_;
  if (extended_dots)
    strcpy(terminators, "d.x");
  WITH = &info[V.voice-1];
  strcpy(V.buf, P[WITH->mus - 1]);
  *WITH->line = '\0';
  *l1 = 0;
  V.bar = full_bar;
  V.bar_length = 0;
  WITH->bar_bound[0] = 0;
  WITH->word_bound[0] = 0;
  WITH->nbar = 0;
  WITH->here = 0;
  V.ngrace = 0;
  V.nmulti = 0;
  V.dur1 = current[V.voice-1].duration;
  lastdur = V.dur1;
  V.beam_next = false;
  do {
    GetNextMusWord(&V);
    if (V.nscan == mword) {
      if (V.bar_length > 0)
	error3(V.voice, "Meter change only allowed at start of bar");
      else
	maybe_meter(V.note, &V.bar);
    }
    if (*V.note != '\0') {
      WITH->here++;
      WITH->scan[WITH->here - 1] = V.nscan;
    }
    strcpy(enote, V.note);
    if (V.ngrace + V.nmulti == 0) {
      expand(enote, xnote, V.dur1, &lastdur);
      if (*xnote != '\0') {
	sprintf(WITH->line + strlen(WITH->line), "%s%c", enote, blank);
	WITH->word_bound[WITH->here] = strlen(WITH->line);
	WITH->here++;
	WITH->scan[WITH->here - 1] = V.nscan;
	strcpy(enote, xnote);
      }
    }
    sprintf(WITH->line + strlen(WITH->line), "%s%c", enote, blank);
    if (*V.note == '\0')
      done = true;
    else
      WITH->word_bound[WITH->here] = strlen(WITH->line);
    sprintf(STR1, "%c", barsym);
    if (!strcmp(V.note, STR1)) {
      if (V.bar_length == 0) {
	if (WITH->nbar == 0)
	  error3(V.voice, "Empty bar");
	else
	  WITH->bar_bound[WITH->nbar] = WITH->here;
      } else if (WITH->nbar == 0 && V.bar_length < V.bar) {
	if (has_next)
	  has_next = false;   /*Should check whether pickups are equal*/
	else if (*l1 > 0)
	  error3(V.voice, "Bar after pickup is too short");
	*l1 = V.bar_length;
	V.bar_length = 0;
      }
    }
    if (V.nscan == nextvoice) {
      if (V.bar_length > 0)
	error3(V.voice, "Next voice before bar is full");
      else
	WITH->nbar--;
      has_next = true;
    } else if (!strcmp(V.note, pause))
      V.bar_length += V.bar;
    else if (!done && pos1(V.note[0], has_duration) > 0)
      count_it(&V);
    else
      maybe_group(&V);
    if (V.bar_length >= V.bar && V.ngrace + V.nmulti == 0) {
      WITH->nbar += V.bar_length / V.bar;
      V.bar_length %= V.bar;
/* p2c: mtx.pas, line 409:
 * Note: Using % for possibly-negative arguments [317] */
      WITH->bar_bound[WITH->nbar] = WITH->here;
    }
  } while (!done);
  WITH->left = V.bar_length;
  WITH->scan[WITH->here] = other;
  if (V.dur1 != lastdur)
    warning("Explicit duration probably needed in next paragraph");
  regroup(&V);
}


char *get_bar(char *Result, short voice, short bar)
{
  line_info *WITH;

  WITH = &info[voice-1];
  return (substr_(Result, P[WITH->mus - 1],
		  WITH->word_bound[WITH->bar_bound[bar-1]] + 1,
		  WITH->word_bound[WITH->bar_bound[bar]] -
		  WITH->word_bound[WITH->bar_bound[bar-1]]));
}




/* End. */
