/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "preamble.pas" */


#include "cfuncs.h"


#define PREAMBLE_G
#include "preamble.h"


char stylefilename[256] = "mtxstyle.txt";

#ifndef STRINGS_H

#endif


typedef enum {
  none_, title, composer, pmx, options, msize, bars, shortnote, style, sharps,
  flats, meter, space, pages, systems
} command_type;


#define c1              title
#define cn              systems

#define blank_          ' '
#define colon_          ':'
#define semicolon       ';'
#define comma           ','
#define dummy_          '\020'

#define max_styles      24


static char commands[15][256] = {
  "NONE", "TITLE", "COMPOSER", "PMX", "OPTIONS", "SIZE", "BARS/LINE", "SHORT",
  "STYLE", "SHARPS", "FLATS", "METER", "SPACE", "PAGES", "SYSTEMS"
};

static char cline[15][256] = {
  "", "", "", "", "", "20", "", "1/4", "", "0", "", "C", "", "1", "1"
};

static boolean redefined[15] = {
  false, false, false, false, false, false, false, false, false, false, false,
  false, false, false, false
};

static short known_styles = 12;

/** Known styles */

static char known_style[max_styles][256] = {
  "SATB:    Voices S,A T,B; Choral; Clefs G F",
  "SATB4:   Voices S A T B; Choral; Clefs G G G F",
  "SINGER:  Voices Voice; Vocal; Clefs G",
  "PIANO:   Voices RH LH; Continuo; Clefs G F",
  "ORGAN:   Voices RH LH Ped; Continuo; Clefs G F F",
  "SOLO:    Voices V; Clefs G", "DUET:    Voices V1 Vc; Clefs G F",
  "TRIO:    Voices V1 Va Vc; Clefs G C F",
  "QUARTET: Voices V1 V2 Va Vc; Clefs G G C F",
  "QUINTET: Voices V1 V2 Va Vc Vc; Clefs G G C F F",
  "SEXTET:  Voices V1 V2 Va Va Vc Vc; Clefs G G C C F F",
  "SEPTET:  Voices V1 V2 Va Va Vc Vc Cb; Clefs G G C C F F F", "", "", "", "",
  "", "", "", "", "", "", "", ""
};


static void add_style(char *S_)
{
  char S[256];

  strcpy(S, S_);
  if (known_styles >= max_styles) {
    error("Can't add another style - table full");
    return;
  }
  known_styles++;
  uppercase(S);
  strcpy(known_style[known_styles-1], S);
}


static void read_styles(void)
{
  boolean eofstyle;
  char S[256];
  char *TEMP;

  if (teststyle != 0)
    eofstyle = true;
  else
    eofstyle = P_eof(stylefile);
  while (!eofstyle) {
    fgets(S, 256, stylefile);
    TEMP = strchr(S, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (*S != '\0')
      add_style(S);
    eofstyle = P_eof(stylefile);
  }
}


static short voice_count(char *s_)
{
  char s[256];
  short i, l;

  strcpy(s, s_);
  l = strlen(s);
  for (i = 0; i <= l - 1; i++) {
    if (s[i] == comma)
      s[i] = blank_;
  }
  return (word_count(s));
}


static void apply_style(char *s_, char *stylename, short first_inst,
			short first_stave)
{
  char s[256];
  char subline[256], subcommand[256];
  short i, last_inst, last_stave;
  boolean toosoon;
  char STR2[256];

  strcpy(s, s_);
  last_inst = first_inst - 1;
  GetNextWord(subline, s, blank_, colon_);
  while (*s != '\0') {
    GetNextWord(subline, s, semicolon, dummy_);
    i = curtail(subline, semicolon);
    GetNextWord(subcommand, subline, blank_, dummy_);
    uppercase(subcommand);
    toosoon = false;
    if (!strcmp(subcommand, "VOICES")) {
/* p2c: preamble.pas: Note: Eliminated unused assignment statement [338] */
      sprintf(voices + strlen(voices), " %s", subline);
      last_stave = first_stave + word_count(subline) - 1;
      last_inst = first_inst + voice_count(subline) - 1;
    } else if (!strcmp(subcommand, "CLEFS"))
      sprintf(clefs + strlen(clefs), " %s", subline);
    else if (!strcmp(subcommand, "VOCAL")) {
      if (last_inst < first_inst)
	toosoon = true;
      else {
	some_vocal = true;
	for (i = first_inst - 1; i <= last_inst - 1; i++)
	  info[i].vocal = true;
      }
    } else if (!strcmp(subcommand, "CHORAL") || !strcmp(subcommand, "GROUP")) {
      if (last_inst < first_inst)
	toosoon = true;
      else {
	if (!strcmp(subcommand, "CHORAL")) {
	  some_vocal = true;
	  for (i = first_inst - 1; i <= last_inst - 1; i++)
	    info[i].vocal = true;
	}
	if (ngroups == maxgroups)
	  error("Too many groups");
	else {
	  ngroups++;
	  group_start[ngroups-1] = first_stave;
	  group_stop[ngroups-1] = last_stave;
	}
      }
    } else if (!strcmp(subcommand, "CONTINUO")) {
      if (last_inst < first_inst)
	toosoon = true;
      else
	continuo = last_stave - first_stave;
    } else {
      sprintf(STR2, "Subcommand %s in STYLE unknown", subcommand);
      error(STR2);
    }
    if (toosoon) {
      sprintf(STR2, "You must first give VOICES before specifying %s",
	      subcommand);
      error(STR2);
    }
  }
  if (first_stave == last_stave || continuo > 0)
    strcpy(instr_name[first_stave-1], stylename);
  else {
    for (i = first_stave - 1; i <= last_stave - 1; i++)
      *instr_name[i] = '\0';
  }
}


static void apply_styles(void)
{
  short i, j, l, n1, n2;
  char s[256], stylename[256];
  char STR2[256];

  *voices = '\0';
  *clefs = '\0';
  while (*cline[(long)style] != '\0') {
    n1 = voice_count(voices) + 1;
    n2 = word_count(voices) + 1;
    GetNextWord(s, cline[(long)style], blank_, comma);
    strcpy(stylename, s);
    l = curtail(s, comma);
    uppercase(s);
    i = 0;
    j = 0;
    sprintf(s + strlen(s), "%c", colon_);
    while (j == 0 && i < known_styles) {
      i++;
      if (match(known_style[i-1], s)) {
	apply_style(known_style[i-1], stylename, n1, n2);
	j = i;
      }
      style_applied = true;
    }
    if (j == 0) {
      sprintf(STR2, "Style %s unknown", s);
      error(STR2);
    }
  }
}


/* static variables for set_voices: */
struct LOC_set_voices {
  char w[256];
} ;

static void check_label(struct LOC_set_voices *LINK)
{
  char STR2[256];

  if (strlen(LINK->w) > 2)
    return;
  if (pos1(LINK->w[0], "CLU") > 0) {
    if (strlen(LINK->w) > 1) {
      if (pos1(LINK->w[1], "123456789") == 0)
	return;
    }
  } else if (pos1(LINK->w[0], "123456789") == 0)
    return;
  sprintf(STR2, "Voice label %s conflicts with reserved label", LINK->w);
  error(STR2);
}


static void set_voices(char *line)
{
  struct LOC_set_voices V;
  short k, l;
  char s[256];
  char STR1[256];

  nvoices = 0;
  nstaves = 0;
  do {
    GetNextWord(s, line, blank_, dummy_);
    if (*s != '\0') {
      nstaves++;
      k = 0;
      do {
	GetNextWord(V.w, s, blank_, comma);
	l = curtail(V.w, comma);
	if (*V.w != '\0') {
	  k++;
	  if (k <= 2) {
	    nvoices++;
	    check_label(&V);
	    strcpy(voice_label[nvoices-1], V.w);
	    if (*instr_name[nstaves-1] == '\0')
	      strcpy(instr_name[nstaves-1], V.w);
	    info[nvoices-1].voice_pos = k;
	    info[nvoices-1].voice_stave = nstaves;
	  }
	}
      } while (*V.w != '\0');
      if (k > 2) {
	sprintf(STR1, "More than two voices per stave: %s", s);
	error(STR1);
      }
      if (k == 2)
	sprintf(instr_name[nstaves-1], "\\voices{%s}{%s}",
		voice_label[nvoices-2], voice_label[nvoices-1]);
    }
  } while (*line != '\0');
}


static void set_clefs(char *line_)
{
  char line[256];
  char s[256];

  strcpy(line, line_);
  nclefs = 0;
  do {
    GetNextWord(s, line, blank_, dummy_);
    if (*s != '\0') {
      nclefs++;
      if (strlen(s) == 1)
	clef[nclefs-1] = s[0];
      else
	clef[nclefs-1] = s[1];
    }
  } while (*s != '\0');
}


void set_space(char *line_)
{
  char line[256];
  short i = 0;
  char word[256];

  strcpy(line, line_);
  while (i < ninstr) {
    GetNextWord(word, line, blank_, dummy_);
    if (*word == '\0')
      return;
    i++;
    get_num(word, &nspace[i-1]);
  }
}


static void set_size(char *line_)
{
  char line[256];
  short i = 0;
  char word[256];

  strcpy(line, line_);
  while (i < ninstr) {
    GetNextWord(word, line, blank_, dummy_);
    if (*word == '\0')
      return;
    i++;
    get_num(word, &musicsize);
    stave_size[i-1] = musicsize;
  }
  if (musicsize < 16)
    musicsize = 16;
  else if (musicsize > 20)
    musicsize = 20;
}


void read_meter(char *meter_, short *meternum, short *meterdenom,
		short *pmnum, short *pmdenom)
{
  char meter[256];
  short j;

  strcpy(meter, meter_);
  if (meter[0] == 'm') {
    j = 2;
    onumber(meter, &j, meternum);
    onumber(meter, &j, meterdenom);
    onumber(meter, &j, pmnum);
    onumber(meter, &j, pmdenom);
  } else {
    get_nums(meter, meternum, meterdenom);
    *pmnum = *meternum;
    *pmdenom = *meterdenom;
  }
  if (*meterdenom == 0)
    error("Meter denominator must be nonzero");
}


static void set_meter(char *line_)
{
  char line[256];
  char meter_[256];

  strcpy(line, line_);
  GetNextWord(meter_, line, blank_, dummy_);
  if (!strcmp(meter_, "C/")) {
    meternum = 2;
    meterdenom = 2;
    pmdenom = 5;
    pmnum = 0;
  } else if (!strcmp(meter_, "C")) {
    meternum = 4;
    meterdenom = 4;
    pmdenom = 6;
    pmnum = 0;
  } else
    read_meter(meter_, &meternum, &meterdenom, &pmnum, &pmdenom);
  switch (meterdenom) {

  case 2:
    default_duration = '2';
    break;

  case 4:
    default_duration = '4';
    break;

  case 8:
    default_duration = '8';
    break;

  case 16:
    default_duration = '1';
    break;

  case 32:
    default_duration = '3';
    break;

  case 64:
    default_duration = '6';
    break;
  }
}


static command_type find_command(char *command)
{
  command_type j;

  uppercase(command);
  if (!strcmp(command, "STYLE"))
    style_supplied = true;
  for (j = c1; j <= cn; j = (command_type)((long)j + 1)) {
    if (!strcmp(command, commands[(long)j]))
      return j;
  }
  return none_;
}


line_type do_command(char *line_)
{
  line_type Result = command_line;
  char line[256];
  char command[256];
  short j;
  command_type k;
  char STR1[256], STR2[256];

  strcpy(line, line_);
  if (line[0] == comment)
    return comment_line;
  GetNextWord(command, line, blank_, colon_);
  j = curtail(command, colon_);
  k = find_command(command);
  if (k != none_) {
    strcpy(cline[(long)k], line);
    if (redefined[(long)k]) {
      sprintf(STR1, "You have redefined preamble command %s", command);
      warning(STR1);
    }
    redefined[(long)k] = true;
    return Result;
  }
  if (j <= 0)
    return plain_line;
  Result = colon_line;
  sprintf(STR2, "%s%c%s", command, colon_, line);
  add_style(STR2);
  return Result;
}


void interpret_commands(void)
{
  short num, den, nbars;

  strcpy(title_line, cline[(long)title]);
  strcpy(composer_line, cline[(long)composer]);
  strcpy(pmx_line, cline[(long)pmx]);
  GetNextWord(options_line, cline[(long)options], blank_, dummy_);
  if (teststyle == 0)
    read_styles();
  apply_styles();
  set_voices(voices);
  ninstr = nstaves - continuo;
  set_clefs(clefs);
  set_meter(cline[(long)meter]);
  if (redefined[(long)pages] || redefined[(long)systems]) {
    if (redefined[(long)bars])
      warning("BARS/LINE ignored since you specified PAGES or SYSTEMS");
    if (redefined[(long)systems])
      get_num(cline[(long)systems], &n_systems);
    else
      warning("PAGES specified but not SYSTEMS");
    if (redefined[(long)pages])
      get_num(cline[(long)pages], &n_pages);
    else
      warning("SYSTEMS specified but not PAGES");
  } else if (redefined[(long)bars]) {
    get_num(cline[(long)bars], &nbars);
    if (nbars > 0) {
      n_pages = 0;
      n_systems = nbars;
    }
  }
  get_num(cline[(long)sharps], &n_sharps);
  set_space(cline[(long)space]);
  set_size(cline[(long)msize]);
  get_nums(cline[(long)shortnote], &num, &den);
  if (den == 0)
    den = 1;
  short_note = num * 64 / den;
  if (*cline[(long)flats] != '\0') {
    get_num(cline[(long)flats], &n_sharps);
    n_sharps = -n_sharps;
  }
}


void preamble_defaults(void)
{
  short i;

  xmtrnum0 = 0.0;
  strcpy(fracindent, "0");
  musicsize = 20;
  continuo = 0;
  some_vocal = false;
  ngroups = 0;
  style_supplied = false;
  style_applied = false;
  for (i = 0; i <= maxvoices - 1; i++)
    info[i].vocal = false;
  for (i = 0; i <= maxstaves - 1; i++) {
    nspace[i] = unspec;
    stave_size[i] = unspec;
  }
  stave_size[0] = default_size;
  n_pages = 1;
  n_systems = 1;
  read_styles();
}


void preamble_guess(short maybe_voices)
{
  switch (maybe_voices) {

  case 1:
    strcpy(cline[(long)style], "Solo");
    break;

  case 2:
    strcpy(cline[(long)style], "Duet");
    break;

  case 3:
    strcpy(cline[(long)style], "Trio");
    break;

  case 4:
    strcpy(cline[(long)style], "Quartet");
    break;

  case 5:
    strcpy(cline[(long)style], "Quintet");
    break;

  case 6:
    strcpy(cline[(long)style], "Sextet");
    break;

  case 7:
    strcpy(cline[(long)style], "Septet");
    break;

  default:
    printf("Do you really have %d voices?  Please supply a setup paragraph.\n",
	   maybe_voices);
    error("I cannot even guess a style");
    return;
    break;
  }
  printf("I guess this piece is a %s for strings in C major.\n",
	 cline[(long)style]);
  printf("  If there are any non-musical lines (lyrics, chords, etc) this guess \n");
  printf("  is wrong and you will get some pretty weird error messages.\n");
  printf("  Why not provide a STYLE in the setup paragraph to make sure?\n");
}




/* End. */
