// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _SgmlCatalog_h_
#define _SgmlCatalog_h_

extern "C"
{
#include <stdio.h>
}
#include <qdialog.h>
#include <qlist.h>
#include <qobject.h>
#include <qstring.h>
#include "CatalogEntry.h"

class QComboBox;
class QFrame;
class QLabel;
class QLineEdit;
class QListBox;

//: The SgmlCatalog class maintains and allows editing of a list of SGML CatalogEntry's.
//. There is exactly one SgmlCatalog for the entire application.  This catalog
//. provides a mapping from SGML object types and their public identifiers to
//. their storage object identifiers.  The SgmlCatalog object is also a modal
//. dialog for editing the catalog entries.
class SgmlCatalog : public QDialog {
    Q_OBJECT
    QList<CatalogEntry> _entries;
    QListBox*    _list;
    QLabel*      _typeLabel;
    QComboBox*   _typeCombo;
    QLabel*      _publicIdLabel;
    QLineEdit*   _publicIdEntry;
    QLabel*      _storageIdLabel;
    QLineEdit*   _storageIdEntry;
    QFrame*      _separator;
    QPushButton* _addButton;
    QPushButton* _updateButton;
    QPushButton* _deleteButton;
    QPushButton* _closeButton;

    //. Return the next token from the open file.  Tokens are delimited by
    //. white space and single or double quotes.
    QString getToken( FILE* fp ) const;
private slots:
    //. Add a new catalog entry based on the data in the edit fields.
    void doAdd();

    //. Delete the selected listbox row from the catalog.
    void doDelete();

    //. Update the catalog with the data in the edit fields.
    void doUpdate();

    //. When a row is selected in the listbox, copy the catalog entry data
    //. into the edit fields.
    void doHighlighted( int index );
protected:
    //. Reposition my widgets (duh).
    void resizeEvent( QResizeEvent* e );
public:
    //. Create the SGML catalog and read in the catalog entries from the
    //. catalog file.
    SgmlCatalog();

    //. Destroy the SGML catalog and all its entries.
    ~SgmlCatalog();

    //. Locate the catalog entry with the given type and public identifier.
    CatalogEntry* find( CatalogEntry::Type type, QString id );

    //. Return a reference to the list of all catalog entries.
    QList<CatalogEntry>& entries() { return _entries; }

    //. Convert the given catalog entry to a string that can be displayed in a
    //. listbox or written to a catalog file.
    QString entryToString( const CatalogEntry* e );

    //. Convert the string form of a catalog entry (as shown in the catalog
    //. listbox during editing) to its component parts.
    void stringToEntry( const QString str, int& type, QString& id, QString& soi );

    //. Write the SGML Catalog to the file given in the options object.
    void save();
};

extern SgmlCatalog* sgmlCatalog;

#endif
