// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _TextAreaRenderer_h_
#define _TextAreaRenderer_h_

#include "FormObjectRenderer.h"

class QMultiLineEdit;

//: The TextAreaRenderer class provides a QMultiLineEdit that can be embedded in an HTML form.
class TextAreaRenderer : public FormObjectRenderer {
    Q_OBJECT
    QMultiLineEdit* _mle;
    QString         _value;
public:
    TextAreaRenderer( int         rows,
                      int         cols,
                      Canvas*     canvas,
                      int         clipWidth=0,
                      QObject*    parent=0,
                      const char* name=0 );

    //. A value is returned only if the MLE has a name.  Otherwise, an
    //. empty string is returned.
    QString value();

    void reset();

    //. Do nothing.
    bool redraw();
public slots:
    //. Do nothing.
    void endOfData();

    //. Append the text to the end of the text in the MLE.
    void content( QString text );
};

#endif
