/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: file_list.h,v $
 *
 * $Revision: 1.2 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 *
 */

#ifndef __FILE_LIST_H__
#define __FILE_LIST_H__

#include "data_tree.h"
#include "expl_vfsl.h"
#include "dialogs.h"

#include "data_win.h"


//>------------- This widget forms the right part of the screen ( if you want )

class   FileListWidget:public QWidget
{
	Q_OBJECT

  protected:

	void    paintEvent(QPaintEvent *);
	void    resizeEvent(QResizeEvent *);
	void    mousePressEvent(QMouseEvent *);
	void    mouseReleaseEvent(QMouseEvent *);
	void    mouseMoveEvent(QMouseEvent *);
	void    mouseDoubleClickEvent(QMouseEvent *);

	void    closeEvent(QCloseEvent *);

  private:

	VFSL_Class * io_class;

	OptionsPopup *mouse_popup;
	OperationPopup *op_popup;		

	FileTreeNode *the_root;		// to guaranty access to the real root

	FileTreeNode *tree_top;
	FileTreeNode *tree_node;

	UpDownScroll *scroll_ud;
	LeftRightScroll *scroll_lr;

	char    dnd_active;
	char    attempt_dnd;
	char    select_active;
	//char    multiple_select;
	char    has_focus;

	int     x_start,
	        y_start;
	int     x_new,
	        y_new;
	int     x_old,
	        y_old;
	        
        int     button1_clip,
                button2_clip,
                button3_clip;

	char    still_dragging_on;

        void    evaluate_mbutton (QMouseEvent *,FileTreeNode *); 
	void    compose_directory(FileTreeNode *);

  public:

	FileListWidget(QWidget *,
                       const char *,
                       UpDownScroll *,
                       LeftRightScroll *,
                       VFSL_Class *,
                       OptionsPopup *,
                       OperationPopup *);

	void deselect(void);
	void redraw(void);
	void update_uds(int);
	void set_root_node(FileTreeNode *);
	void set_the_root(FileTreeNode *);
	void set_clip_bounds (int,int,int);
	int  count_selection(); 
	char get_focus ();	
	FileTreeNode *get_target (void);
	FileTreeNode *get_filelist (void);

  public  slots:

	void    update_pane();
	void    reset_root_node(FileTreeNode *);
	void	reread_dir (const char *);
	void	reread_list ();	

	void    selection_removed(); 
	void    select_all ();
	void    select_inverse ();
	
	void    remove_focus ();
	void    set_focus ();
	
	void    drag_and_drop(bool);
	
  signals:

	void    update_widgets();

	void    set_nr_objects(int);
	void    set_files_info(int, unsigned long);

        void    remove_selection ();
	void    dragging_and_dropping(bool);

	void    change_dir(FileTreeNode *);
	
	void    take_focus ();
	
	void    signal_movement (QPoint &);
};

//>-----------------

class   FileListContainer:public QFrame
{
	Q_OBJECT

	protected:

	void    resizeEvent(QResizeEvent *);

	UpDownScroll *scroll_ud;
	LeftRightScroll *scroll_lr;

	QPushButton *Name;
	QPushButton *Size;
	QPushButton *Rights;

	int     name_size,
	        size_size,
	        rights_size;

	QPushButton *fill_btn2;

	FileListWidget *child_widget;

	public:

	FileListContainer (QWidget *, 
	                   const char *, 
	                   VFSL_Class *,
                           OptionsPopup *,
                           OperationPopup *);
	FileListWidget *get_child();

};

#endif
