#! /bin/sh
#
# create a prototype for silo boot floppy image for dinstall
# (C) Eric Delaunay <delaunay@debian.org>, 1998

set -e
#set -v
set -x

. common.sh

arch="`dpkg --print-architecture`"

if [ $# != 3 ]; then
	echo "Usage: $0 archive-path image-name blocks" >&2
	exit 1
fi

archive=$1
image=$2
blocks=$3

loopdev=loop3
device=/dev/$loopdev

mountpoint=/var/tmp/mnt.siloproto
tmp=/var/tmp/silo_proto.$$

# clean up old run aborted
umount $mountpoint || umount $device || true
losetup -d $device || true

# set the size of the floppy image
dd if=/dev/zero of=$image bs=1024 count=$blocks

losetup $device $image
if [ ! -d $mountpoint ]; then
	mkdir $mountpoint
fi

if [ $arch = sparc ]; then
	# define floppy type
	case $blocks in
	1440)
		sectors=18 ;;
	720)
		sectors=9 ;;
	*)
		echo "unsupported floppy size ($blocks kB)" >&2
		exit 1
	esac
	# create a valid first sector (required by Sun to boot from floppy)
	# only one whole disk partition (#3)
	fdisk $device << EOF
0
2
$sectors
80
0



0
d
1
d
2
p
w
EOF
	# then create the filesystem
	mke2fs $device $blocks

	# and mount the floppy image
	mount $device $mountpoint

	# fill it
	mkdir $mountpoint/boot
	silopkg=`make_paths silo`
	dpkg --extract $silopkg $tmp
	cp -p $tmp/boot/first.b $tmp/boot/second.b $mountpoint/boot
	mkdir $mountpoint/etc
	cat > $mountpoint/etc/silo.conf << EOF
partition=3
root=/dev/fd0
timeout=100
image=/linux
label=linux
append="load_ramdisk=1 prompt_ramdisk=1"
read-write
EOF
	# silo 0.7.2 requires the loop device to be registered in chroot'ed /dev
	# create it temporarily
	mkdir $mountpoint/dev
	(cd $mountpoint/dev && /dev/MAKEDEV -I $loopdev)
	# run silo to register first & second stage loaders
	$tmp/sbin/silo -r $mountpoint
	# then cleanup
	rm -fr $mountpoint/dev

	rm -fr $tmp &
fi

# clean up
umount $mountpoint
losetup -d $device
rmdir $mountpoint
ls -l $image
exit 0
