#include <stdio.h>
#include <strings.h>
#include <errno.h>
#include <newt.h>
#include "dinstall.h"
#include "lang.h"

#ifdef LOG

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

void dinstall_log(const char * pattern, ...) {
   int     fd;
   FILE *  con = 0;
   va_list arguments;

   if ( ((fd = open("/dev/tty4",O_WRONLY|O_NOCTTY)) < 0)
     ||  ((con = fdopen(fd, "w")) == NULL) )
     return;

   va_start(arguments, pattern);
   vfprintf(con, pattern, arguments);
   va_end(arguments);
   fclose(con);
}
#endif

int pleaseWaitBox(const char *text) {
    int height;
    newtComponent f1, t1;
    newtOpenWindow (10, 8, 60, 5, MSG_PLEASE_WAIT);
    f1 = newtForm(NULL, NULL, 0);
    t1 = newtTextbox (1, 1, 59, 4, NEWT_FLAG_WRAP);
    newtTextboxSetText(t1,text);
    height=newtTextboxGetNumLines(t1);
    newtTextboxSetHeight(t1,height);
    newtFormAddComponent (f1 , t1);
    newtDrawForm(f1);
    newtRefresh();
    newtFormDestroy(f1);
    return 0;
}

int problemBox(const char *text, const char *title) {
    newtComponent f1, t1, b1;
    int height;

    t1 = newtTextbox (1, 1, 60, 10, NEWT_FLAG_WRAP);
    newtTextboxSetText(t1, text);
    height=newtTextboxGetNumLines(t1);
    newtTextboxSetHeight(t1,height);
    newtOpenWindow (10, 9-height/2, 61, height+3, title);
    b1 = newtCompactButton ( 23, height+2, MSG_CONTINUE );
    f1 = newtForm(NULL, NULL, 0);
    newtFormAddComponents (f1, t1, b1, NULL);
    newtRunForm(f1);
    newtPopWindow();
    newtFormDestroy(f1);
    return 0;
}

int perrorBox(const char *text) {
    sprintf(prtbuf,"%s: %s",text,strerror(errno));
    problemBox(prtbuf,MSG_ERROR);
    return 0;
}

int twoButtonBox(const char *text, const char *title, const char *button1, const char* button2) {
    newtComponent f1, t1, b1, b2, ans;
    int height;

    t1 = newtTextbox (1, 1, 60, 10, NEWT_FLAG_WRAP);
    newtTextboxSetText(t1, text);
    height=newtTextboxGetNumLines(t1);
    newtTextboxSetHeight(t1,height);
    newtOpenWindow (10, 9-height/2, 61, height+3, title);
    b1 = newtCompactButton ( 20, height+2, button1 );
    b2 = newtCompactButton ( 32, height+2, button2 );
    f1 = newtForm(NULL, NULL, 0);
    newtFormAddComponents (f1, t1, b1, b2, NULL);
    ans = newtRunForm(f1);
    newtPopWindow();
    newtFormDestroy(f1);
    if (ans == b1) return -1;
    return 0;
}

int yesNoBox(const char *text, const char *title) {
    return twoButtonBox(text, title, MSG_YES, MSG_NO);
}

char *inputBox(const char *text, const char *title, const char *proto) { 
    newtComponent f1, t1, i1, b1, b2, ans;
    char *val, *res;
    int height;

    t1 = newtTextbox (1, 1, 60, 10, NEWT_FLAG_WRAP);
    newtTextboxSetText(t1, text);
    height=newtTextboxGetNumLines(t1);
    newtTextboxSetHeight(t1,height);
    newtOpenWindow (10, 9-height/2, 61, height+5, title);
    i1 = newtEntry(1, height+2, proto, 59, &val, 
                     NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT);
    b1 = newtCompactButton ( 20, height+4, MSG_OK );
    b2 = newtCompactButton ( 32, height+4, MSG_CANCEL );
    f1 = newtForm(NULL, NULL, 0);
    newtFormAddComponents (f1, t1, i1, b1, b2, NULL);
    ans = newtRunForm(f1);
    res = strdup(val);
    newtPopWindow();
    newtFormDestroy(f1);
    if (ans != b2) return res;
    free(res);
    return NULL;
}

#define _ButtonH (1)

int choice_box(const char* text, const char* title, int height, int width,
	       struct d_choices* choices,int nchoices, int* selected)
{
  newtComponent form,tbox,okay,cancel,sb=NULL,*cb,answer;
  newtComponent subform;
  char buf[80], format[20];
  int rc=DLG_OKAY;
  int top,idx;
  int max_width=0;
  int listheight=(nchoices>height-_ButtonH-6) ? height-_ButtonH-6 : nchoices ;
  
  cb=calloc(nchoices,sizeof(newtComponent));
  if(!cb) return DLG_ERROR;

  for(max_width=idx=0;idx<nchoices;idx++)
    if(strlen(choices[idx].tag)>(unsigned int)max_width)
      max_width=strlen(choices[idx].tag);

  newtOpenWindow (39-width/2, 12-height/2, width, height, title);

  form=newtForm(NULL, NULL, 0);
  tbox = newtTextbox (1, 0, width-2, 10, NEWT_FLAG_WRAP);
  newtTextboxSetText(tbox, text);
  top=newtTextboxGetNumLines(tbox);
  newtTextboxSetHeight(tbox,top);

  if(listheight!=nchoices)
    {
      sb=newtVerticalScrollbar(width - 4,
			       top + 1,
			       listheight,
			       NEWT_COLORSET_CHECKBOX,
			       NEWT_COLORSET_ACTCHECKBOX);
      newtFormAddComponent(form,sb);
    }
  
  subform=newtForm(sb,NULL,0);
  newtFormSetBackground(subform,NEWT_COLORSET_CHECKBOX);
  sprintf(format,"%%-%ds %%s",max_width);
  for(idx=0;idx<nchoices;idx++) 
    {
      sprintf(buf,format,choices[idx].tag,choices[idx].string);
      cb[idx]=newtRadiobutton(4,top+1+idx,buf,
			      choices[idx].state,
			      idx ? cb[idx-1] : NULL);
      newtFormAddComponent(subform,cb[idx]);
    }
  newtFormSetHeight(subform, listheight);
  newtFormSetWidth(subform,width - 10);
  okay = newtCompactButton ( (width-18)/3, height-_ButtonH, MSG_OK);
  cancel = newtCompactButton ( (width-18)/3*2+9, height-_ButtonH, MSG_CANCEL);
  newtFormAddComponents(form,tbox,subform,okay,cancel,NULL);
  
  answer=newtRunForm(form);

  if(answer==cancel)
    rc=DLG_CANCEL;
  
  answer=newtRadioGetCurrent(cb[0]);

  for(idx=0;idx<nchoices;idx++)
    if(cb[idx]==answer)
      *selected=idx;

  newtPopWindow();
  newtFormDestroy(form);
  return rc;
}

#define _MAX_LIST_HEIGHT  (4)
#define OPT_OFFSET       (1000)
int menus(const char* text,const char* title,struct d_choices* choices,int nchoices)
{
  char buf[512];
  char format[80];
  newtComponent form;
  newtComponent textbox;
  newtComponent listbox;
  int *entry=calloc(nchoices,sizeof(int));
  int result,*rs;
  int height;
  int mstring=0;
  int mtag=0;
  int ix,tmp;

  textbox = newtTextbox (1, 1, 60, 5, NEWT_FLAG_WRAP);
  newtTextboxSetText(textbox, text);
  height= 6 + ((nchoices<_MAX_LIST_HEIGHT) ? nchoices : _MAX_LIST_HEIGHT);
  newtOpenWindow (10, 7-height/2, 63,
		  height+3,
		  title);
  form = newtForm(NULL, NULL, 0);
  listbox = newtListbox(2, 7-height/2+3, height-4,
			NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);

  for(ix=0;ix<nchoices;ix++)
    {
      if((tmp=strlen(choices[ix].string))>mstring)
	mstring=tmp;
      if((tmp=strlen(choices[ix].tag))>mtag)
	mtag=tmp;
    }
  snprintf(format,80,"%%-%ds: %%-%ds  ",mstring,mtag);

  for(ix=0;ix<nchoices;ix++)
    {
      entry[ix]=OPT_OFFSET+ix;
      snprintf(buf,512,format,choices[ix].string,choices[ix].tag);
      newtListboxAddEntry(listbox,buf,&entry[ix]);
    }

  newtFormAddComponents(form, textbox, listbox, NULL);

  newtRunForm(form);
  rs= newtListboxGetCurrent(listbox);
  newtPopWindow();

  result=(*rs)-OPT_OFFSET;
  free(entry);
  return result;
}

int check_box(const char* text, const char* title, int height, int width,
	      char** choices, char** values, int nchoices)
{
  newtComponent form,tbox,okay,cancel,sform;
  newtComponent answer;
  newtComponent *chk;
  newtComponent sb=NULL;
  int rc=DLG_OKAY;
  int top,ix;
  char *result;

  int lheight=(nchoices>height - _ButtonH - 6)
    ? height - _ButtonH - 6 : nchoices;

  chk=calloc(nchoices,sizeof(newtComponent));
  if(!chk)
    return DLG_ERROR;

  result=calloc(nchoices+1,sizeof(char));
  if(!result)
    return DLG_ERROR;
  else
    result[nchoices]='\0';

  newtOpenWindow (39-width/2, 12-height/2, width, height, title);

  form=newtForm(NULL, NULL, 0);
  tbox=newtTextbox(1, 0, width-2, 10, NEWT_FLAG_WRAP);
  newtTextboxSetText(tbox, text);
  top=newtTextboxGetNumLines(tbox);
  newtTextboxSetHeight(tbox,top);
  
  if(lheight!=nchoices) /* We need a scrollbar. */
    {
      sb=newtVerticalScrollbar(width - 4, top + 1,
			       lheight,
                               NEWT_COLORSET_CHECKBOX,
                               NEWT_COLORSET_ACTCHECKBOX);
      newtFormAddComponent(form,sb);
    }

  sform=newtForm(sb,NULL,0);
  newtFormSetBackground(sform, NEWT_COLORSET_CHECKBOX);
  for(ix=0;ix<nchoices;ix++)
    {
      chk[ix]=newtCheckbox(4 , top + 1 + ix, choices[ix],
			   (*values)[ix],NULL,&result[ix]);
      newtFormAddComponent(sform, chk[ix]);
    }

  newtFormSetHeight(sform, lheight);
  newtFormSetWidth(sform,width - 10);
  okay = newtCompactButton ( (width-18)/3, height-_ButtonH, MSG_OK);
  cancel = newtCompactButton ( (width-18)/3*2+9, height-_ButtonH, MSG_CANCEL);
  newtFormAddComponents(form,tbox,sform,okay,cancel,NULL);
  
  answer=newtRunForm(form);

  if(answer==cancel)
    rc=DLG_CANCEL;
  else
    strcpy(*values,result);

  newtPopWindow();
  newtFormDestroy(form);

  free(result);
  free(chk);
  return rc;
}
