/* $Id: client.c,v 1.3 1997/11/06 22:22:47 janssen Exp $ */

#include <unistd.h>		/* for gethostname */
#include <math.h>		/* for sqrt */

#include <stdlib.h>
#include <sys/time.h>
#include <sys/times.h>
#include <string.h>

#ifdef ILU20A9
#include <iluntrnl.h>
#endif

#include "w3muxtest.h"
#include <transprt.h>

typedef ilu_boolean (*ForkProc)(void (*)(void *arg), void *arg, ilu_Error *);

extern int gethostname(char *, int);

#define ILU_TEST_DOMAIN	"parc.xerox.com"

static char    *progname = NULL;

static void usage (int ac, char **av, int i)
{
  fprintf (stderr, "Don't understand argument %d:  \"%s\".\n", i+1, av[i]);
  fprintf (stderr, "Usage:  %s [-n COUNT] "
#ifdef ILU_OS_THREADED
	   "[-threads] "
#endif
	   "[-hostname HOSTNAME] [-p PROTOCOL] [-t TRANSPORT...] \n", av[0]);
  fprintf (stderr, "  Default:  %s -n 1\n", av[0]);
  exit(1);
}

int
main(int ac, char **av)
{
  char		hostname[1000], sid[1000];
  ilu_Error	err;
  w3muxtest_p	handle, uc;
  int		i, count = 3;
  char *	pinfo = "sunrpc";
  char *	tinfo[10] = { "w3mux_0", "tcp_0_0", ILU_NIL };
  ilu_boolean	threaded = ilu_FALSE, ans = ilu_TRUE;
  ILU_C_Server	s3;
  ILU_C_ENVIRONMENT e;
  ilu_cardinal	val1, val2;

  i = 1;
  gethostname(hostname, sizeof(hostname));
  while (i < ac) {
    if (strcmp(av[i], "-p") == 0) {
      if (i++ < ac)
	pinfo = av[i++];
      else
	usage(ac, av, i);
    } else if (strcmp(av[i], "-n") == 0) {
      if (++i < ac)
	count = atoi(av[i++]);
      else
	usage(ac, av, i);
    } else if (strcmp(av[i], "-t") == 0) {
      int j = 0;
      ++i;
      while ((i < ac) && (av[i][0] != '-'))
	tinfo[j++] = av[i++];
      tinfo[j] = ILU_NIL;
    } else if (strcmp(av[i], "-hostname") == 0) {
      strcpy (hostname, av[++i]);
      i++;
#ifdef ILU_OS_THREADED
    } else if (strcmp(av[i], "-threads") == 0) {
      threaded = ilu_TRUE;
      i++;
#endif
    } else
      usage(ac, av, i);
  }

#ifdef ILU_OS_THREADED
  if (threaded) {
    ILU_C_USE_OS_THREADS;
  };
#endif

  w3muxtest__Initialize();
  w3muxtest__InitializeServer();
  progname = av[0];

  s3 = ILU_C_InitializeServer (ILU_NIL, ILU_NIL, pinfo, tinfo, ILU_NIL, ilu_TRUE);
  if (s3 == ILU_NIL) {
    fprintf(stderr, "Can't create server 3.\n");
    exit(1);
  };    
  uc = w3muxtest_p__CreateTrue ( ILU_NIL, s3, ILU_NIL );

  sprintf(sid, "w3muxtest.1.%s.%s", hostname, ILU_TEST_DOMAIN);
  handle = ILU_C_LookupObject(sid, "0", w3muxtest_p__MSType);
  if (handle == NULL) {
    fprintf(stderr, "error:  Can't obtain object <%s>\n", sid);
    exit(1);
  }

  if (val1 = 32, val2 = w3muxtest_p_ping1(handle, val1, &e), val2 != (val1 * val1))
    fprintf (stderr, "*** Bad val %d returned from ping1(%d)\n", val2, val1);

  for (i = 0;  i < count;  i++) {
    if (val1 = 456, val2 = w3muxtest_p_ping1(handle, val1, &e), val2 != (val1 * val1))
      fprintf (stderr, "*** Bad val %d returned from ping1(%d)\n", val2, val1);
    
    w3muxtest_p_send(handle, uc, &e);

    if (val1 = 7, val2 = w3muxtest_p_ping1(handle, val1, &e), val2 != (val1 * val1))
      fprintf (stderr, "*** Bad val %d returned from ping1(%d)\n", val2, val1);
  }

  return 0;
}


ilu_cardinal
  server_w3muxtest_p_ping1 (w3muxtest_p h, CORBA_unsigned_long p1, ILU_C_ENVIRONMENT *e)
{
  return (p1);
}

void
  server_w3muxtest_p_send (w3muxtest_p h, w3muxtest_p p1, ILU_C_ENVIRONMENT *e)
{
  w3muxtest_p_ping1 (p1, 37, e);
}
