#
# alpha_osf1_3.2.mk - make variables and rules specific to Digital Unix 3.2.
#

PLATFORM = alpha_osf1_3.2
LIBDIR   = $(TOP)/lib
BINDIR   = $(TOP)/bin

#
# C preprocessor macro definitions for this architecture
#

PLATFORM_CPPFLAGS = -D__osf1__ -D__alpha__ -D__OSVERSION__=3

#
# Standard programs
#

AR              = ar clq
RANLIB		= ranlib
MKDIRHIER	= /usr/bin/X11/mkdirhier
CP		= cp
MV		= mv -f
RM              = rm -f 

CXX             = cxx
CXXFLAGS        = $(CXXDEBUGFLAGS) $(CXXOPTIONS) $(CPPFLAGS)
CXXDEBUGFLAGS   = -O
CXXLINK		= $(CXX)
CXXLINKOPTIONS  = $(CXXDEBUGFLAGS) $(CXXOPTIONS) -call_shared

CPPFLAGS        = $(DIR_CPPFLAGS) $(PLATFORM_CPPFLAGS)


.SUFFIXES: .o .cc .C .cpp .cxx

.cc.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<

.C.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<

.cpp.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<

.cxx.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<


OMNITHREAD_POSIX_CPPFLAGS = -DPthreadDraftVersion=4 -DNoNanoSleep
OMNITHREAD_CPPFLAGS = -I$(TOP)/include -D_REENTRANT
OMNITHREAD_LIB = -lomnithread -lpthreads -lmach -lc_r
OMNITHREAD_STATIC_LIB = $(LIBDIR)/libomnithread.a -lpthreads -lmach -lc_r

# Default location of the omniORB2 configuration file [falls back to this if
# the environment variable OMNIORB_CONFIG is not set] :
OMNIORB_CONFIG_DEFAULT_LOCATION = \"/etc/omniORB.cfg\"

OMNIORB_CPPFLAGS = -D__OMNIORB2__ $(OMNITHREAD_CPPFLAGS)
OMNIORB_LIB = -lomniORB2 $(OMNITHREAD_LIB) 
OMNIORB_STATIC_LIB = $(LIBDIR)/libomniORB2.a $(OMNITHREAD_STATIC_LIB)

# Default directory for the omniNames log files.
OMNINAMES_LOG_DEFAULT_LOCATION = \"/var/omninames\"
