#|------------------------------------------------------------*-Scheme-*--|
 | File:    compiler/modules/bldctx.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.4
 | File mod date:    1997.11.29 23:10:27
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  (rsc)
 |
 `------------------------------------------------------------------------|#


;; a <build-context> is a compilation context, which includes
;; an underlying module being built


(define-class <build-context> (<object>)
    name   ;; the name of the module
    (part-names init-value: '())
    (file-names init-value: '())
    (public-interface-file init-value: #f)
    (private-interface-file init-value: #f)
    (base-filename init-value: #f)
    (root-variables init-value: '())
    (c-files init-value: '())
    (h-files init-value: '())
    (extern-h-files init-value: '())
    (public-h-files init-value: '())  ;; our `.h' files that are public
    (parts init-value: '())
    (dest-dir init-value: '#uninit type: <directory-name>)
    (dest-dir-exists? init-value: #f)
    (image-dest-dir init-value: '#uninit type: <directory-name>)
    (building init-value: '#uninit type: <module>)
    (needs-c-context init-value: #f type: <boolean>)
    (rewriter-envt init-value: #f)
    (rewriter-cache init-value: #f)
    (top-level-icode init-value: '())
    (patch-time-only-icode init-value: '())
    (documentation-data init-value: '())
    (copied-files init-value: '())
    (fn-def-are-const? init-value: #f))  ;; function definitions are const?


(define (ensure-dest-dir (self <build-context>))
  (if (not (dest-dir-exists? self))
      (set-dest-dir-exists?!
       self
       (let ((path (pathname->string (dest-dir self))))
	 (if (file-exists? path)
	     #t
	     (mkdir path))))))

(define-method initialize ((self <build-context>))
    ;; compute a reasonable base file name from the module name
    (set-base-filename! 
     self
     (alloc-file-name self (link-name (building self))))
    ;; check to make sure the directory exists
    (set-public-interface-file! self
				(make <file-name>
				      filename: (base-filename self)
				      extension: "h"
				      file-directory: (dest-dir self)))
    (set-private-interface-file! self
				 (make <file-name>
				       filename: (alloc-file-name 
						  self
						  (string-append
						   (base-filename self)
						   "_p"))
				       extension: "h"
				       file-directory: (dest-dir self)))
    self)

;; allocate a new part name, starting from the
;; given base name

(define (alloc-part-name (m <build-context>) (basename <string>))
    (let ((n (if (member basename (part-names m))
		 (let loop ((i 1))
		    (let ((adjusted-name (format #f "~a~d" basename i)))
			(if (member adjusted-name (part-names m))
			    (loop (+ i 1))
			    adjusted-name)))
		 basename)))
      (set-part-names! m (cons n (part-names m)))
      n))

(define (form-file-name (basename <string>) uniquifier)
    (let ((u (if uniquifier (number->string uniquifier)
    			    "")))
	(if (> (+ (string-length u) (string-length basename)) 8)
	    (string-append (substring basename 0 (- 8 (string-length u)))
			    u)
	    (string-append basename u))))

;; basically the same as above
;; except we strip enough source characters to make the
;; result fit in 8 characters (MS-DOS SUCKS)

(define (alloc-file-name (m <build-context>) (basename <string>))
    (let ((n (if (member (form-file-name basename #f) (file-names m))
		 (let loop ((i 1))
		    (let ((adjusted-name (form-file-name basename i)))
			(if (member adjusted-name (file-names m))
			    (loop (+ i 1))
			    adjusted-name)))
		 (form-file-name basename #f))))
	(set-file-names! m (cons n (file-names m)))
	n))

