#|------------------------------------------------------------*-Scheme-*--|
 | File:    handc/demo/calc/scanner.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.3
 | File mod date:    1997.11.29 23:10:29
 | System build:     v0.7.2, 97.12.21
 |
 `------------------------------------------------------------------------|#

(define *reserved-words* '(=))

;;
;;  a zebu scanner returns a pair whose car
;;  is the token itself and whose cdr is the
;;  category, or type
;;
;;  for this simple calculator, we just use
;;  the underlying scheme scanner, which has
;;  been modified to return <semicolon> instead
;;  of interpreting ';' as a comment
;;
;;  we also recognize certain reserved words, and
;;  return those as their own syntactic catagories

(define *identifier-category-table* (make-symbol-table))
(define *token-type-category-table* (make-symbol-table))

(define-syntax (def-token-type type-name terminal-name)
  (let ((a (assoc (mquote terminal-name) terminal-alist)))
    (if a
	(table-insert! *token-type-category-table* 
		       (mquote type-name)
		       (cdr a))
	(error "~s is not a terminal in the grammar" (mquote terminal-name)))))

(define-syntax (def-keyword name)
  (let ((a (assoc (mquote name) terminal-alist)))
    (if a
	(table-insert! *identifier-category-table* 
		       (mquote name)
		       (cdr a))
	(error "~s is not a terminal in the grammar" (mquote name)))))

(def-keyword =)
(def-keyword +)
(def-keyword -)
(def-keyword *)
(def-keyword /)
(def-keyword define)
(def-keyword method)
(def-keyword end)
(def-keyword ::)

(def-token-type <literal> LITERAL)
(def-token-type <semicolon> SEMICOLON)
(def-token-type <symbol> ID)
(def-token-type <open-paren> LPAREN)
(def-token-type <close-paren> RPAREN)
(def-token-type <open-bracket> LBRACKET)
(def-token-type <close-bracket> RBRACKET)
(def-token-type <dot> DOT)
(def-token-type unquote COMMA)
(def-token-type <rest> REST)
(def-token-type <key> KEY)

(define (scan-calc-token*)
  (bind ((type val line (scan-token)))
    (if (eof-object? type)
	(values '() end-symbol-index)
	(case type
	  ;;
	  ((<symbol>)
	   (let ((a (table-lookup *identifier-category-table* val)))
	     (if a
		 (values val a)
		 (values val 
			 (table-lookup *token-type-category-table* 
				       '<symbol>)))))
	  ;;
	  ((<literal>)
	   (if (eq? val '#rest)
	       (values val
		       (table-lookup *token-type-category-table* '<rest>))
	       (if (eq? val '#key)
		   (values val
			   (table-lookup *token-type-category-table* 
					 '<key>))
		   (let ((c (table-lookup *token-type-category-table* type)))
		     (if c
			 (values val c)
			 (error
			  "bummer: token type ~s doesn't map onto grammar" 
			  type))))))
	  ;;
	  (else
	   (let ((c (table-lookup *token-type-category-table* type)))
	     (if c
		 (values val c)
		 (error "bummer: token type ~s doesn't map onto grammar" 
			type))))))))

(define (scan-calc-token)
  (bind ((token category (scan-calc-token*)))
#|    
    (format #t "Returning token => ~s (category ~s = ~s)\n" 
	    token
	    category
	    (vector-ref lexicon category))
|#  
    (cons (cons token category) '())))
