/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>	/* vsnprintf */
#include <stdarg.h>	/* vsnprintf */

#include <gtk/gtk.h>

#include "xqf.h"
#include "utils.h"
#include "dialogs.h"


void dialog_ok (char *title, char *fmt, ...) {
  GtkWidget *window;
  GtkWidget *main_vbox;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *button;
  GtkWidget *label;

  char buf[2048];
  va_list ap;

  if (!fmt)
    return;

  va_start (ap, fmt);
  vsnprintf (buf, 2048, fmt, ap);
  va_end (ap);

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (window), (title)? title : "Warning!");
  gtk_window_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (window_delete_event_callback), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_grab_add (GTK_WIDGET (window));

  register_window (window);

  main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 8);
  gtk_container_add (GTK_CONTAINER (window), main_vbox);

  /* Message */

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox), 32);
  gtk_box_pack_start (GTK_BOX (main_vbox), vbox, TRUE, TRUE, 0);

  label = gtk_label_new (buf);
  gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  gtk_widget_show (vbox);

  /* Buttons */

  hbox = gtk_hbox_new (TRUE, 4);
  gtk_container_border_width (GTK_CONTAINER (hbox), 4);
  gtk_box_pack_start (GTK_BOX (main_vbox), hbox, FALSE, TRUE, 0);

  button = gtk_button_new_with_label ("Ok");
  gtk_widget_set_usize (button, 96, -1);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, FALSE, 0);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  gtk_widget_show (hbox);

  gtk_widget_show (main_vbox);

  gtk_widget_show (window);

  gtk_main ();

  unregister_window (window);
}


static void yes_button_clicked_callback (GtkWidget *widget, int *data) {
  *data = 1;
}


static void no_button_clicked_callback (GtkWidget *widget, int *data) {
  *data = 0;
}


int dialog_yesno (char *title, int defbutton, char *fmt, ...) {
  GtkWidget *window;
  GtkWidget *main_vbox;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *button;
  GtkWidget *label;
  int res = -1;

  char buf[2048];
  va_list ap;

  if (!fmt)
    return;

  va_start (ap, fmt);
  vsnprintf (buf, 2048, fmt, ap);
  va_end (ap);

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (window), (title)? title : "Warning!");
  gtk_window_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (window_delete_event_callback), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_grab_add (GTK_WIDGET (window));

  register_window (window);

  main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 8);
  gtk_container_add (GTK_CONTAINER (window), main_vbox);

  /* Message */

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox), 32);
  gtk_box_pack_start (GTK_BOX (main_vbox), vbox, TRUE, TRUE, 0);

  label = gtk_label_new (buf);
  gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  gtk_widget_show (vbox);

  /* Buttons */

  hbox = gtk_hbox_new (TRUE, 4);
  gtk_container_border_width (GTK_CONTAINER (hbox), 4);
  gtk_box_pack_start (GTK_BOX (main_vbox), hbox, FALSE, TRUE, 0);

  button = gtk_button_new_with_label ("Yes");
  gtk_widget_set_usize (button, 96, -1);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (yes_button_clicked_callback), &res);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  if (defbutton == 1)
    gtk_widget_grab_default (button);
  gtk_widget_show (button);

  button = gtk_button_new_with_label ("No");
  gtk_widget_set_usize (button, 96, -1);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (no_button_clicked_callback), &res);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  if (defbutton == 0)
    gtk_widget_grab_default (button);
  gtk_widget_show (button);

  gtk_widget_show (hbox);

  gtk_widget_show (main_vbox);

  gtk_widget_show (window);

  gtk_main ();

  unregister_window (window);

  if (res == -1)	/* window deleted */
    res = defbutton;

  return res;
}


static void enter_string_activate_callback (GtkWidget *widget, char **str) {
  *str = strdup_strip (gtk_entry_get_text (GTK_ENTRY (widget)));
}


char *enter_string_dialog (char *fmt, ...) {
  GtkWidget *window;
  GtkWidget *hbox;
  GtkWidget *button;
  GtkWidget *label;
  GtkWidget *entry;
  char *res = NULL;

  char buf[2048];
  va_list ap;

  va_start (ap, fmt);
  vsnprintf (buf, 2048, fmt, ap);
  va_end (ap);

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (window), buf);
  gtk_window_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (window_delete_event_callback), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_grab_add (GTK_WIDGET (window));

  register_window (window);

  hbox = gtk_hbox_new (FALSE, 8);
  gtk_container_border_width (GTK_CONTAINER (hbox), 16);
  gtk_container_add (GTK_CONTAINER (window), hbox);

  /* Message */

  label = gtk_label_new (buf);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  /* Entry */

  entry = gtk_entry_new_with_max_length (40);
  gtk_widget_set_usize (GTK_WIDGET (entry), 128, -1);
  gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 4);
  gtk_signal_connect (GTK_OBJECT (entry), "activate",
		      GTK_SIGNAL_FUNC (enter_string_activate_callback), &res);
  gtk_signal_connect_object (GTK_OBJECT (entry), "activate",
                    GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
  gtk_widget_grab_focus (GTK_WIDGET (entry));
  gtk_widget_show (entry);

  /* Cancel Button */

  button = gtk_button_new_with_label (" Cancel ");
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
  gtk_widget_show (button);

  gtk_widget_show (hbox);

  gtk_widget_show (window);

  gtk_main ();

  unregister_window (window);

  return res;
}



