/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <string.h>	/* strlen, strncpy */
#include <ctype.h>	/* isspace */
#include <unistd.h>	/* getuid */
#include <pwd.h>	/* getpwuid */
#include <sys/types.h>	/* getpwuid */
#include <stdlib.h>	/* getenv */

#include <gtk/gtk.h>

#include "utils.h"


/*
 *  Returns duplicated string with stripped spaces on both ends
 */ 

char *strdup_strip (const char *str) {
  const char *start;
  const char *end;
  char *res;

  if (!str)
    return NULL;

  for (start = str; *start && isspace (*start); start++);

  for (end = str + strlen (str) - 1; end >= start && isspace (*end); end--);

  if (start > end)
    return NULL;

  res = g_malloc (end - start + 1 + 1);
  strncpy (res, start, end - start + 1);
  res[end - start + 1] = '\0';

  return res;
}


char *get_user_name (void) {
  char *str;
  struct passwd *pwd;
  char *user;

  if ((str = getenv ("USER")) != NULL || (str = getenv ("LOGNAME")) != NULL)
    user = g_strdup (str);
  else {
    pwd = getpwuid (getuid ());
    if (pwd)
      user = g_strdup (pwd->pw_name);
  }
  return user;
}


char *get_user_home (void) {
  char *str;
  struct passwd *pwd;
  char *home;

  if ((str = getenv ("HOME")) != NULL || (str = getenv ("LOGDIR")) != NULL)
    home = g_strdup (str);
  else {
    pwd = getpwuid (getuid ());
    if (pwd)
      home = g_strdup (pwd->pw_dir);
  }
  return home;
}


char *file_in_dir (const char *dir, const char *file) {
  char *res, *tmp;
  int need_slash = 0;

  if (!dir || dir[0] == '\0')			/* dir "" is current dir */
    return (file)? g_strdup (file) : NULL;

  if (!file)
    return g_strdup (dir);

  if (dir[strlen (dir) - 1] != '/')
    need_slash = 1;

  tmp = res = g_malloc (strlen (dir) + strlen (file) + need_slash + 1);

  strcpy (tmp, dir);
  tmp += strlen (dir);
  if (need_slash)
    *tmp++ = '/';
  strcpy (tmp, file);

  return res;
}


int str_isempty (const char *str) {
  if (!str)
    return TRUE;

  for (; *str; str++) 
    if (!isspace (*str))
      return FALSE;

  return TRUE;
}

