#!
# This implements some new widgets and other stuff 
# in tcl/tk. Some of them try to mimic N*XTSTEP widgets.
#
# Copyright (c) 1996 by Alfredo K. Kojima
#
# You can use this software for any purpose as long as this copyright
# notice appear unchanged in it's derivative works. This software is provided
# AS IS and I disclaim any warranties about it.
#

#
#   tksColorChooser --
#
#
#
#
#
proc tksColorChooser {} {
	global tk_library
	
	exec $tk_library/demos/tcolor2 &
}


#
#   tksColorWell --
#   	You can use this to select colors for something. You can drop
#	a color from a color chooser or another color well and set it's 
#	color. The color selected is stored in the textvariable you
#	supply
#	If the ColorWell already exists, the variable is replaced with the new
#	value
#
#	w	- path for the ColorWell
#	var	- global variable to hold color
#	text    - text to display inside well
proc tksColorWell { w  var {text ""} } {
	upvar $var col

	proc aux { w } {
		global tk_library
		
		set col [$w cget -bg]
		dnd_setdata Text $col 
		dnd_handledrag "@$tk_library/paint.xbm $tk_library/paintm.xbm $col white"
	}
	proc chcol { w var color } {
		upvar $var cv
		
		$w configure -bg $color
		set cv $color
	}
	if "[winfo exists $w]" { 
	#change variable...
		bind $w.b <Drop> [list if {"%P"=="Text"} "chcol $w.b $var %D"]
		chcol $w.b $var $col
	#...and get out
		return
	}
	frame $w -bd 2 -relief raised	
	label $w.b -bd 2 -relief sunken -bg $col \
		 -padx 12 -pady 0 -text $text
	pack $w.b -in $w -padx 5 -pady 5
	bind $w.b <Drop> [list if {"%P"=="Text"} "chcol $w.b $var %D"]
	bind $w.b <Drag> [list aux $w.b]
	bind $w <Button-1> {tksColorChooser}
	
	return $w
}

#   
#   tksStopButton --
#  	This is a button that changes it's label when it is first pressed
#   	and released, and changes back the label after a second press.
#
#	w 	- path for the button
#	image1 	- default image to be shown
#	image2  - image to show after first press
#	var	- variable to hold current button state
#	args	- other arguments as for normal buttons
#
#proc tksStopButton {w image1 image2 var args} {
#}
