/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1998 */
/* See the file NOTICE for conditions of use and distribution. */

/* Header for the aliasfile director */

/* Structure for the private options. */

typedef struct {
  char *file;
  char *queries;
  char *query;
  char *home_dir;
  char *current_dir;
  char *syntax_errors_to;
  char *expand_uid;
  char *expand_gid;
  uid_t uid;
  gid_t gid;
  int   modemask;
  int   partial_match;
  int   search_type;
  int  *owners;
  int  *owngroups;
  BOOL  uid_set;
  BOOL  gid_set;
  BOOL  include_domain;
  BOOL  check_ancestor;
  BOOL  initgroups;
  BOOL  expand;
  BOOL  optional;
  BOOL  qualify_preserve_domain;
  BOOL  forbid_file;
  BOOL  forbid_pipe;
  BOOL  freeze_missing_include;
  BOOL  rewrite;
  BOOL  skip_syntax_errors;
  transport_instance *directory_transport;
  transport_instance *directory2_transport;
  transport_instance *file_transport;
  transport_instance *pipe_transport;
} aliasfile_director_options_block;

/* Data for reading the private options. */

extern optionlist aliasfile_director_options[];
extern int aliasfile_director_options_count;

/* Block containing default values. */

extern aliasfile_director_options_block aliasfile_director_option_defaults;

/* The main and initialization entry points */

extern int aliasfile_director_entry(director_instance *, address_item *,
  address_item **, address_item **, address_item **, address_item **, BOOL);
extern void aliasfile_director_init(director_instance *);

/* End of directors/aliasfile.h */
