#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <stdio.h>
#include "winutils.h"
#include <dos.h>

static double dbltime(struct time *tm)
{
  return(3600.0*tm->ti_hour+60.0*tm->ti_min+tm->ti_sec+0.01*tm->ti_hund);
}

void Delay(unsigned n)
{
  double first, second;
  struct time tm;

  gettime(&tm);
  first = 1000.0 * dbltime(&tm);
  do {
    gettime(&tm);
    second = 1000.0 * dbltime(&tm);
  } while (second - first < n);
}

void SysBeep(int n)
{
  for (; n > 0; n -= 10)
    MessageBeep(0);
}

void FlushAllEvents(void)
{
  MSG msg;

  while (PeekMessage(&msg, NULL, WM_KEYFIRST, WM_MOUSELAST, PM_REMOVE | PM_NOYIELD));
}

int WarningBox(char *msg)
{
  SysBeep(10);
  return(MessageBox(GetFocus(),
		    (LPSTR) msg,
		    "XLISP-STAT",
		    MB_ICONASTERISK | MB_OK));
}

int OKorCancelBox(char *msg)
{
  return(MessageBox(GetFocus(),
		    (LPSTR) msg,
		    "XLISP-STAT",
		    MB_ICONQUESTION | MB_OKCANCEL));
}

