/*
 *  nwrevoke.c
 *
 *  Remove trustee rights from file or directory
 *
 *  Copyright (C) 1996 by Volker Lendecke
 *
 */

#include "nwcalls.h"
#include <unistd.h>
#include <stdlib.h>

static char *progname;

static void
usage(void)
{
	fprintf(stderr, "usage: %s [options]\n", progname);
}

static void
help(void)
{
	printf("\n");
	printf("usage: %s [options] file/directory\n", progname);
	printf("\n"
	       "-h             Print this help text\n"
	       "-S server      Server name to be used\n"
	       "-U username    Username sent to server\n"
	       "-P password    Use this password\n"
	       "-n             Do not use any password\n"
	       "-C             Don't convert password to uppercase\n"
	       "\n"
	       "-o object_name Name of object removed as trustee\n"
	       "-t type        Object type (decimal value)\n"
	       "\n"
	       "file/directory\n"
	       "\n");
}

int
main(int argc, char *argv[])
{
	struct ncp_conn *conn;
	char *object_name = NULL;
	int object_type = -1;
	struct ncp_bindery_object o;
	char *path = NULL;
	long err;
	int result = 1;
	int opt;
	char volume[1000];
	int useConn = 0;

	progname = argv[0];

	if ((conn = ncp_initialize_2(&argc, argv, 1, NCP_BINDERY_USER, &err, 0)) == NULL)
	{
		useConn = 1;
	}
	while ((opt = getopt(argc, argv, "h?o:t:")) != EOF)
	{
		switch (opt)
		{
		case 'o':
			object_name = optarg;
			str_upper(object_name);
			break;
		case 't':
			object_type = atoi(optarg);
			break;
		case 'h':
		case '?':
			help();
			goto finished;
		default:
			usage();
			goto finished;
		}
	}

	if (object_type < 0)
	{
		fprintf(stderr, "%s: You must specify an object type\n",
			argv[0]);
		goto finished;
	}
	if (object_name == NULL)
	{
		fprintf(stderr, "%s: You must specify an object name\n",
			argv[0]);
		goto finished;
	}
	if (!useConn) {
		if (optind != argc - 1)
		{
			fprintf(stderr, "%s: You must specify a directory\n",
				progname);
			goto finished;
		}
		path = argv[optind];
	} else {
		char directory[1000];

		if (optind < argc)
			path = argv[optind];
		else
			path = ".";
		
		if (NWParsePath(path, NULL, &conn, volume, directory) || !conn) {
			fprintf(stderr, "%s: Could not find directory %s\n",
					progname, path);
			goto finished;
		}
		strcat(volume, ":");
		strcat(volume, directory);
		path = volume;
	}
	if (ncp_get_bindery_object_id(conn, object_type, object_name, &o) != 0)
	{
		fprintf(stderr, "%s: Could not find object %s\n",
			progname, object_name);
		goto finished;
	}
	if (ncp_delete_trustee(conn, 0, path, o.object_id) != 0)
	{
		fprintf(stderr, "%s: Could not remove trustee rights\n",
			progname);
		goto finished;
	}
	result = 0;

      finished:
	ncp_close(conn);
	return result;
}
