/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.89 96/05/25 21:02:21 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 80
#define YY_END_OF_BUFFER 81
static yyconst short int yy_accept[217] =
    {   0,
        0,    0,    0,    0,    0,    0,   81,   79,    1,   78,
       77,   10,    2,   79,   74,   79,   79,   71,   70,   69,
       79,   72,    8,   79,   66,   63,   64,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   21,   12,   11,   80,
        4,    5,    4,    1,    2,    9,   31,   31,    3,    0,
        0,    8,   57,   67,   68,   65,   76,   76,   76,   76,
       76,   76,   76,   76,   37,   76,   76,   76,   41,   76,
       76,   76,   43,   61,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   21,   20,   13,   14,   18,

       19,   15,   17,   16,    6,   30,    0,   30,    0,    0,
        0,    0,    0,    0,    0,   58,    0,   59,   76,   76,
       76,   76,   76,   73,   76,   39,   76,   76,   75,   60,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       54,   76,   76,   62,   13,   14,   29,   22,    0,    0,
       23,   27,   28,   24,   26,   25,    0,   76,   76,   76,
       76,   76,   38,   76,   42,   76,   76,   76,   76,   76,
       76,   76,   51,   52,   76,   76,   56,   13,   22,    0,
       23,    0,   32,   33,   34,   35,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   53,   55,    0,   76,   76,

       76,   45,   46,   76,   48,   49,   50,    7,   36,   76,
       76,   47,   40,   76,   44,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    5,    6,    7,    8,    1,    9,   10,
       11,   12,   13,    1,   14,   15,   16,   17,   17,   17,
       17,   17,   17,   17,   17,   18,   18,   19,    1,   20,
       21,   22,    1,    1,   23,   23,   23,   23,   23,   23,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
        1,   25,    1,    1,   26,    1,   27,   28,   29,   30,

       31,   32,   33,   34,   35,   24,   36,   37,   38,   39,
       40,   41,   24,   42,   43,   44,   45,   46,   47,   48,
       49,   24,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[50] =
    {   0,
        1,    1,    2,    1,    3,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    4,    4,    1,    1,
        1,    1,    4,    5,    3,    5,    4,    4,    4,    4,
        4,    4,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5
    } ;

static yyconst short int yy_base[226] =
    {   0,
        0,    0,   47,   48,   51,   52,  277,  278,  274,  278,
      278,  278,    0,    0,  278,  250,  262,  278,  278,  278,
      258,  278,   41,  251,   39,  278,  250,    0,   23,   26,
      230,   35,   30,  224,   39,  228,  227,   42,  224,  234,
       47,   43,  225,  236,   45,  222,    0,  278,  278,   68,
      278,  278,  250,  258,    0,    0,  250,  104,  278,  243,
       64,   72,  278,  278,  278,  278,    0,  227,  214,  222,
      223,  214,  220,  205,    0,  207,  219,  209,    0,  216,
      216,  201,    0,    0,  204,   62,  201,  205,  210,  199,
      195,  196,  202,  192,  193,    0,  278,   76,   80,  278,

      278,  278,  278,  278,  278,  278,  225,  224,   99,  102,
      223,  222,  221,  220,  219,  278,   84,    0,  200,  191,
      198,  181,  196,    0,  191,    0,  192,  182,    0,    0,
      190,  178,  186,  172,  170,  183,  182,  173,  180,  175,
        0,  172,  174,    0,   97,  106,  278,  278,  109,  116,
      278,  278,  278,  278,  278,  278,  111,  158,  167,  169,
      160,  158,    0,  158,    0,  170,  158,  172,  171,  155,
      165,  166,    0,    0,  157,  162,    0,  113,  278,  132,
      278,  120,    0,    0,    0,    0,  155,  156,  160,  159,
      144,  142,  140,  136,  130,    0,    0,  122,  123,  122,

      102,    0,    0,   98,    0,    0,    0,  127,    0,   70,
       62,    0,    0,   64,    0,  278,  150,  155,  160,   84,
      165,  167,  172,  177,  182
    } ;

static yyconst short int yy_def[226] =
    {   0,
      216,    1,  217,  217,  218,  218,  216,  216,  216,  216,
      216,  216,  219,  220,  216,  221,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  223,  216,  216,  224,
      216,  216,  216,  216,  219,  220,  216,  225,  216,  216,
      216,  216,  216,  216,  216,  216,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  223,  216,  216,  216,  216,

      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  216,  216,  216,
      216,  216,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  216,  222,  222,

      222,  222,  222,  222,  222,  222,  222,  216,  222,  222,
      222,  222,  222,  222,  222,    0,  216,  216,  216,  216,
      216,  216,  216,  216,  216
    } ;

static yyconst short int yy_nxt[328] =
    {   0,
        8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
        8,   18,   19,   20,   21,   22,   23,   23,   24,   25,
       26,   27,   28,   28,    8,    8,   29,   30,   31,   32,
       33,   34,   28,   28,   35,   28,   28,   36,   37,   38,
       39,   40,   41,   42,   43,   44,   45,   46,   28,   48,
       48,   49,   49,   52,   52,   61,   70,   62,   62,   64,
       65,   68,   53,   53,   69,   73,   76,   71,   77,   74,
       79,   50,   50,   83,   75,   87,   89,   88,   93,   94,
      117,  117,   80,   84,   98,   99,   61,   56,   62,   62,
      132,   90,  145,  146,  215,  100,  146,  146,  157,  101,

      117,  117,  133,  214,  134,  135,  102,  148,  213,  103,
      151,  104,  108,  178,  146,  149,  150,  179,  150,  150,
      109,  110,  146,  146,  181,  180,  150,  182,  182,  146,
      146,  111,  150,  150,  198,  112,  182,  182,  208,  208,
      179,  212,  113,  208,  208,  114,  211,  115,  150,  150,
       47,   47,   47,   47,   47,   51,   51,   51,   51,   51,
       55,  210,   55,   55,   55,   57,  209,   57,   57,   57,
       67,   67,   96,  207,  206,   96,   96,   97,  205,   97,
       97,   97,  107,  204,  107,  107,  107,  203,  202,  201,
      200,  199,  197,  196,  195,  194,  193,  192,  191,  190,

      189,  188,  187,  186,  185,  184,  183,  177,  176,  175,
      174,  173,  172,  171,  170,  169,  168,  167,  166,  165,
      164,  163,  162,  161,  160,  159,  158,  156,  155,  154,
      153,  152,  147,  147,  144,  143,  142,  141,  140,  139,
      138,  137,  136,  131,  130,  129,  128,  127,  126,  125,
      124,  123,  122,  121,  120,  119,  118,  116,  106,   54,
      105,   95,   92,   91,   86,   85,   82,   81,   78,   72,
       66,   63,   60,   59,   58,   54,  216,    7,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,

      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216
    } ;

static yyconst short int yy_chk[328] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    3,
        4,    3,    4,    5,    6,   23,   30,   23,   23,   25,
       25,   29,    5,    6,   29,   32,   33,   30,   33,   32,
       35,    3,    4,   38,   32,   41,   42,   41,   45,   45,
       61,   61,   35,   38,   50,   50,   62,  220,   62,   62,
       86,   42,   98,   98,  214,   50,   99,   99,  117,   50,

      117,  117,   86,  211,   86,   86,   50,  109,  210,   50,
      110,   50,   58,  145,  145,  109,  109,  149,  110,  110,
       58,   58,  146,  146,  150,  149,  149,  157,  157,  178,
      178,   58,  150,  150,  182,   58,  182,  182,  198,  198,
      180,  204,   58,  208,  208,   58,  201,   58,  180,  180,
      217,  217,  217,  217,  217,  218,  218,  218,  218,  218,
      219,  200,  219,  219,  219,  221,  199,  221,  221,  221,
      222,  222,  223,  195,  194,  223,  223,  224,  193,  224,
      224,  224,  225,  192,  225,  225,  225,  191,  190,  189,
      188,  187,  176,  175,  172,  171,  170,  169,  168,  167,

      166,  164,  162,  161,  160,  159,  158,  143,  142,  140,
      139,  138,  137,  136,  135,  134,  133,  132,  131,  128,
      127,  125,  123,  122,  121,  120,  119,  115,  114,  113,
      112,  111,  108,  107,   95,   94,   93,   92,   91,   90,
       89,   88,   87,   85,   82,   81,   80,   78,   77,   76,
       74,   73,   72,   71,   70,   69,   68,   60,   57,   54,
       53,   46,   44,   43,   40,   39,   37,   36,   34,   31,
       27,   24,   21,   17,   16,    9,    7,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,

      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "mgllex.l"
#define INITIAL 0
#line 2 "mgllex.l"
/*
 * mgllex.l  -  Lexer for Bootrom Menu Generation Language
 *
 * Copyright (C) 1997,1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "mknbi.h"
#include "mgl.h"
#include "gencode.h"
#include "y.tab.h"



/*
 ********************************************************************
 *
 * Definition of builtin data types. We need this here for the definition
 * of internal functions.
 */

/* No type - used to catch errors in type definitions */
struct typesdef none_type = {
	EXPR_NONE,   0, { { 0, 0, -1 } },		NULL
};

/* Integer type */
struct typesdef int_type = {
	EXPR_NUM,    2, { { -MAX_INT, MAX_INT, -1 } },	&none_type
};

/* String type */
struct typesdef string_type = {
	EXPR_STRING, MAX_STR_LEN, { { 0, 0, -1 } },	&int_type
};

/* Type for string index */
struct typesdef strindex_type = {
	EXPR_NUM,    2, { { 0, 255, -1 } },		& string_type
};

/* Character type */
struct typesdef char_type = {
	EXPR_CHAR,   1, { { 0, MAX_CHAR, -1 } },	&strindex_type
};

/* Boolean type */
struct typesdef bool_type = {
	EXPR_BOOL,   1, { { 0, 1, -1 } },		&char_type
};

/* Table of names for predefined types */
struct {
	char            *name;
	struct typesdef *t;
} predeftypes[] = {
	{ "integer",	&int_type    },
	{ "string",	&string_type },
	{ "char",	&char_type   },
	{ "boolean",	&bool_type   },
	{ "logical",	&bool_type   },
	{ NULL,		NULL         }
};



/*
 ********************************************************************
 *
 * List of internally defined constants
 */
struct {
	char            *name;
	char            *strval;
	int              numval;
	struct typesdef *t;
} predefconsts[] = {
	{ "maxint",		NULL, MAX_INT,	&int_type  },
	{ "true",		NULL, 1,	&bool_type },
	{ "false",		NULL, 0,	&bool_type },
	{ "BOOTP_HOSTNAME",	NULL, 12,	&int_type  },
	{ "BOOTP_DOMAIN",	NULL, 15,	&int_type  },
	{ "BOOTP_ROOTPATH",	NULL, 17,	&int_type  },
	{ NULL,			NULL, 0,	NULL       }
};



/*
 ********************************************************************
 *
 * List of internally defined variables.
 */
struct {
	char            *name;
        long             addr;
        struct typesdef *t;
} predefvars[] = {
	{ "servername", ADDR_SERVERNAME, &string_type },
	{ "hostname",   ADDR_HOSTNAME,   &string_type },
	{ NULL,         0,               NULL         }
};



/*
 ********************************************************************
 *
 * Definition of internal functions. To add a new internal function,
 * simply assign a new CMD_* value to pass to the runtime module, and
 * add a new entry here. You might optionally add a collapsing function
 * into mglparse.y for constant arguments.
 */
struct {
	char           *name;
	struct funcdef  f;
} functab[] = {
	/* This is a general scalar operation - int types are just dummies */
	{ "pred",	{ 0, 0, CMD_PRED, 1, &int_type,
				{ &int_type },    { ATTR_NONE  } } },
	/* This is a general scalar operation - int types are just dummies */
	{ "succ",	{ 0, 0, CMD_SUCC, 1, &int_type,
				{ &int_type },    { ATTR_NONE  } } },
	/* This is a general scalar operation - int types are just dummies */
	{ "ord",	{ 0, 0, CMD_ORD, 1, &int_type,
				{ &int_type },    { ATTR_NONE  } } },
	{ "odd",	{ 0, 0, CMD_ODD, 1, &bool_type,
				{ &int_type },    { ATTR_NONE  } } },
	{ "chr",	{ 0, 0, CMD_CHR, 1, &char_type,
				{ &int_type },    { ATTR_NONE  } } },
	{ "strlen",	{ 0, 0, CMD_STRLEN, 1, &int_type,
				{ &string_type }, { ATTR_CONST } } },
	{ "strsub",	{ 0, 0, CMD_STRSUB, 3, &string_type,
				{ &string_type, &int_type, &int_type },
				{ ATTR_CONST, ATTR_NONE, ATTR_NONE } } },
	{ "abs",	{ 0, 0, CMD_ABS, 1, &int_type,
				{ &int_type },    { ATTR_NONE  } } },
	{ "sqr",	{ 0, 0, CMD_SQR, 1, &int_type,
				{ &int_type },    { ATTR_NONE  } } },
	{ "cls",	{ 0, 0, CMD_CLS, 0, NULL,
				{ NULL },         { ATTR_NONE  } } },
	{ NULL,		{ 0, 0, CMD_NONE, 0, NULL,
				{ NULL },         { ATTR_NONE  } } }
};



/*
 ********************************************************************
 *
 * Some symbols are used internally by the lexer, and just return a
 * token to the parser. This way, we can redefine the symbols in the
 * user program, and still use them as tokens in the parser.
 */
struct {
	char *name;
	int   token;
} specialtab[] = {
	{ "at",		AT      },
	{ "from",	FROM    },
	{ "gateway",	GATEWAY },
	{ "get",	GET     },
	{ "gotoxy",	GOTOXY  },
	{ "load",	LOAD    },
	{ "menu",	MENU    },
	{ "print",	PRINT   },
	{ "timeout",	TIMEOUT },
	{ NULL,         0       }
};



/*
 ********************************************************************
 *
 * Global variables
 */
char *curfile;			/* Name of current input file */



/*
 ********************************************************************
 *
 * String buffer for C style strings
 */
static char string_buf[MAX_STR_LEN + 1];	/* string buffer */
static char *string_pos;			/* current string position */
static int string_flag;				/* flag if string too long */



/*
 ********************************************************************
 *
 * Routine to add a character to the constant string
 */
static void add_string(c)
char c;
{
  if (string_pos >= &string_buf[MAX_STR_LEN]) {
	if (!string_flag) {
		warning("string too long, truncating");
		string_flag++;
	}
  } else
	*string_pos++ = c;
}
/*
********************************************************************
*
* Define some generally useful regular expressions
*/
/*
********************************************************************
*
* Always use a pointer for yytext
*/
/*
********************************************************************
*
* Define an exclusive start state for scanning C style strings
*/
#define Cstring 1
#define Comment 2

#line 748 "lex.yy.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 257 "mgllex.l"




	/*
	 ********************************************************************
	 *
	 * Skip all whitespace and comments
	 */
#line 909 "lex.yy.c"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 217 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 278 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 266 "mgllex.l"
;
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 267 "mgllex.l"
;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 269 "mgllex.l"
{ BEGIN Comment; }	/* Switch to comment mode */
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 270 "mgllex.l"
;			/* Throw away any comment text */
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 271 "mgllex.l"
{ lineno++; }		/* We still have to count line numbers */
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 272 "mgllex.l"
{ BEGIN INITIAL; }	/* Return to regular mode */
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Parse an IP number
	 */
case 7:
YY_RULE_SETUP
#line 281 "mgllex.l"
{
#ifdef HAVE_INET
		static struct in_addr addr;

		if ((unsigned long)(addr.s_addr = inet_addr(yytext)) ==
							(unsigned long)-1) {
			warning("invalid IP address, assuming 0.0.0.0");
			addr.s_addr = INADDR_ANY;
		}
#else
		static char addr[INADDR_SIZE];

		warning("no IP address support available, assuming 0.0.0.0");
		memset(addr, 0, INADDR_SIZE);
#endif
		yylval.inaddr = (char *)&addr;
		return(INADDR);
	}
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Parse an integer number
	 */
case 8:
YY_RULE_SETUP
#line 307 "mgllex.l"
{
		/* Decimal number */

		char *cp;
		unsigned long result = 0;

		for (cp = yytext; *cp; cp++) {
			result = result * 10 + *cp - '0';
			if (result > MAX_INT) {
				warning("integer number too large, assuming maximum");
				result = MAX_INT;
				break;
			}
		}
		yylval.intarg = result;
		return(NUM);
	}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 325 "mgllex.l"
{
		/* Hex number */

		char *cp;
		unsigned long result = 0;

		for (cp = yytext; *cp; cp++) {
			if (*cp >= '0' && *cp <= '9')
				result = result * 16 + *cp - '0';
			else if (*cp >= 'a' && *cp <= 'f')
				result = result * 16 + *cp + 10 - 'a';
			else if (*cp >= 'A' && *cp <= 'F')
				result = result * 16 + *cp + 10 - 'F';
			if (result > MAX_INT) {
				warning("integer number too large, assuming maximum");
				result = MAX_INT;
				break;
			}
		}
		yylval.intarg = result;
		return(NUM);
	}
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Parse a C type string
	 */
case 10:
YY_RULE_SETUP
#line 355 "mgllex.l"
{
		string_flag = 0;
		string_pos = string_buf;
		BEGIN Cstring;
	}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 361 "mgllex.l"
{
		/* All done at closing quote */
		BEGIN INITIAL;
		*string_pos = '\0';
		yylval.string = string_buf;
		return(QSTRING);
	}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 369 "mgllex.l"
{
		/* Unterminated string constant */
		BEGIN INITIAL;
		warning("unterminated string constant");
		*string_pos = '\0';
		yylval.string = string_buf;
		return(QSTRING);
	}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 378 "mgllex.l"
{
		/* Octal escape sequence */
		int result;

		if (sscanf(yytext + 1, "%o", &result) != 1) {
			warning("invalid octal number in string constant, "
							"assuming \\377");
			result = '\377';
		}
		if (result > 0xff) {
			warning("octal number in string constant too large, "
							"assuming \\377");
			result = '\377';
		}
		add_string(result);
	}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 395 "mgllex.l"
{
		/* Bad escape sequence */
		warning("bad escape sequence, skipping");
	}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 400 "mgllex.l"
{ add_string('\n'); }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 401 "mgllex.l"
{ add_string('\t'); }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 402 "mgllex.l"
{ add_string('\r'); }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 403 "mgllex.l"
{ add_string('\b'); }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 404 "mgllex.l"
{ add_string('\f'); }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 405 "mgllex.l"
{ add_string(yytext[1]); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 407 "mgllex.l"
{
		char *yptr = yytext;

		while (*yptr)
			add_string(*yptr++);
	}
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Parse a C type character value
	 */
case 22:
YY_RULE_SETUP
#line 421 "mgllex.l"
{
		/* Octal escape sequence */
		int result;

		yytext[strlen(yytext) - 1] = '\0';
		if (sscanf(yytext + 2, "%o", &result) != 1) {
			warning("invalid octal number in character constant, "
							"assuming \\377");
			result = '\377';
		}
		if (result > 0xff) {
			warning("octal number in character constant too large, "
							"assuming \\377");
			result = '\377';
		}
		yylval.chrarg = result & 0xff;
		return(CHR);
	}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 440 "mgllex.l"
{
		/* Bad escape sequence */
		warning("bad escape sequence, assuming \\377");
		yylval.chrarg = 0xff;
		return(CHR);
	}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 447 "mgllex.l"
{ yylval.chrarg = '\n'; return(CHR); }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 448 "mgllex.l"
{ yylval.chrarg = '\t'; return(CHR); }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 449 "mgllex.l"
{ yylval.chrarg = '\r'; return(CHR); }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 450 "mgllex.l"
{ yylval.chrarg = '\b'; return(CHR); }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 451 "mgllex.l"
{ yylval.chrarg = '\f'; return(CHR); }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 452 "mgllex.l"
{ yylval.chrarg = yytext[2]; return(CHR); }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 454 "mgllex.l"
{
		yylval.chrarg = yytext[1];
		return(CHR);
	}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 459 "mgllex.l"
{
		warning("missing closing quote in character constant");
		yylval.chrarg = yytext[1];
		return(CHR);
	}
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Rules to parse reserved names
	 */
case 32:
YY_RULE_SETUP
#line 472 "mgllex.l"
{ return(ARRAY); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 473 "mgllex.l"
{ return(CBEGIN); }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 474 "mgllex.l"
{ return(BREAK); }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 475 "mgllex.l"
{ return(CONST); }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 476 "mgllex.l"
{ return(DEFAULT); }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 477 "mgllex.l"
{ return(DO); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 478 "mgllex.l"
{ return(ELSE); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 479 "mgllex.l"
{ return(END); }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 480 "mgllex.l"
{ return(FUNCTION); }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 481 "mgllex.l"
{ return(IF); }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 482 "mgllex.l"
{ return(ITEM); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 483 "mgllex.l"
{ return(OF); }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 484 "mgllex.l"
{ return(PROCEDURE); }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 485 "mgllex.l"
{ return(RECORD); }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 486 "mgllex.l"
{ return(REPEAT); }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 487 "mgllex.l"
{ return(RESTART); }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 488 "mgllex.l"
{ return(RETURN); }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 489 "mgllex.l"
{ return(SCREEN); }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 490 "mgllex.l"
{ return(SELECT); }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 491 "mgllex.l"
{ return(THEN); }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 492 "mgllex.l"
{ return(TYPE); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 493 "mgllex.l"
{ return(UNTIL); }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 494 "mgllex.l"
{ return(VAR); }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 495 "mgllex.l"
{ return(WHILE); }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 496 "mgllex.l"
{ return(WITH); }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 498 "mgllex.l"
{ return(ASSIGN); }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 499 "mgllex.l"
{ return(DOTS); }
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Logical operations
	 */
case 59:
YY_RULE_SETUP
#line 508 "mgllex.l"
{ yylval.op = CMD_AND; return(ANDOP); }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 509 "mgllex.l"
{ yylval.op = CMD_NOT; return(NOTOP); }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 510 "mgllex.l"
{ yylval.op = CMD_OR;  return(OROP); }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 511 "mgllex.l"
{ yylval.op = CMD_XOR; return(XOROP); }
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Comparison rules
	 */
case 63:
YY_RULE_SETUP
#line 520 "mgllex.l"
{ yylval.op = CMD_EQ; return(COMPARISON); }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 521 "mgllex.l"
{ yylval.op = CMD_GT; return(COMPARISON); }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 522 "mgllex.l"
{ yylval.op = CMD_GE; return(COMPARISON); }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 523 "mgllex.l"
{ yylval.op = CMD_LT; return(COMPARISON); }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 524 "mgllex.l"
{ yylval.op = CMD_LE; return(COMPARISON); }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 525 "mgllex.l"
{ yylval.op = CMD_NE; return(COMPARISON); }
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Arithmetic operations
	 */
case 69:
YY_RULE_SETUP
#line 534 "mgllex.l"
{ yylval.op = '-'; return(ADDOP); }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 535 "mgllex.l"
{ yylval.op = '+'; return(ADDOP); }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 536 "mgllex.l"
{ yylval.op = '*'; return(MULOP); }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 537 "mgllex.l"
{ yylval.op = '/'; return(MULOP); }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 538 "mgllex.l"
{ yylval.op = '/'; return(MULOP); }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 539 "mgllex.l"
{ yylval.op = '%'; return(MULOP); }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 540 "mgllex.l"
{ yylval.op = '%'; return(MULOP); }
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Symbol names
	 */
case 76:
YY_RULE_SETUP
#line 549 "mgllex.l"
{
		struct sym *sp;

		yylval.symbol = NULL;
		if (strlen(yytext) > MAX_ID_LEN) {
			warning("ID too long, truncating to 16 characters");
			yytext[MAX_ID_LEN] = '\0';
		}

		/* Search if symbol already exists */
		for (sp = symtab; sp != NULL; sp = sp->next)
			if (!strcmp(sp->name, yytext))
				break;

		/* If it's a special symbol, return it's token */
		if (isspecialsym(sp))
			return(sp->def.s.token);

		/* If symbol doesn't exist, create it. */
		if (sp == NULL) {
			sp = (struct sym *)mymalloc(sizeof(struct sym));
			sp->type = nosym;
			sp->level = curlevel;
			if ((sp->name = strdup(yytext)) == NULL) {
				perror(progname);
				exit(EXIT_MEMORY);
			}
			sp->next = symtab;
			symtab = sp;
		}

		/* Return the symbol to the parser */
		yylval.symbol = sp;
		return(ID);
	}
	YY_BREAK
/*
	 ********************************************************************
	 *
	 * Misc. rules: count lines and ignore \r, return all other
	 * characters as is to the parser.
	 */
case 77:
YY_RULE_SETUP
#line 593 "mgllex.l"
;
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 594 "mgllex.l"
{ lineno++; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 595 "mgllex.l"
{ return(yytext[0]); }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 597 "mgllex.l"
ECHO;
	YY_BREAK
#line 1600 "lex.yy.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(Cstring):
case YY_STATE_EOF(Comment):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 217 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 217 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 216);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						{
						yy_c_buf_p = yytext_ptr + offset;
						return EOF;
						}

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;

				case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
					YY_FATAL_ERROR(
					"unexpected last match in yyinput()" );
#else
					YY_FATAL_ERROR(
					"unexpected last match in input()" );
#endif
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *str )
#else
YY_BUFFER_STATE yy_scan_string( str )
yyconst char *str;
#endif
	{
	int len;
	for ( len = 0; str[len]; ++len )
		;

	return yy_scan_bytes( str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 597 "mgllex.l"




/*
 *****************************************************************************
 *
 * Print current token. This has to be here because the definition of yytext
 * is in the lexer, and it's not consistent among different lex versions.
 */
void print_token()
{
  fprintf(stderr, "'%s'", yytext);
}



/*
 *****************************************************************************
 *
 * Initialize lexer
 */
void yylexinit(infile)
char *infile;
{
  struct sym *sp;
  long size;
  int i;

  /* Open input file */
  if (infile == NULL || !*infile)
	yyin = stdin;
  else if ((yyin = fopen(infile, "r")) == NULL) {
	perror(progname);
	exit(EXIT_MGL_PROGOPEN);
  }

  /* Set name of current input file */
  curfile = infile;

  /* Preset the list of known types with builtin static type list */
  typetab = &bool_type;
  for (i = 0; predeftypes[i].name != NULL; i++) {
	sp = (struct sym *)mymalloc(sizeof(struct sym));
	sp->type = typesym;
	sp->name = predeftypes[i].name;
	sp->level = -1;
	sp->def.t = predeftypes[i].t;
	sp->next = symtab;
	symtab = sp;
  }

  /* The string type is special */
  string_type.def.a.elementnum = MAX_STR_LEN;
  string_type.def.a.indextype = &strindex_type;
  string_type.def.a.basetype = &char_type;

  /* Preset the list of internal functions */
  for (i = 0; functab[i].name != NULL; i++) {
	sp = (struct sym *)mymalloc(sizeof(struct sym));
	sp->type = funcsym;
	sp->name = functab[i].name;
	sp->level = -1;
	sp->def.f = functab[i].f;
	sp->next = symtab;
	symtab = sp;
  }

  /* Preset the list of special symbols */
  for (i = 0; specialtab[i].name != NULL; i++) {
	sp = (struct sym *)mymalloc(sizeof(struct sym));
	sp->type = specialsym;
	sp->name = specialtab[i].name;
	sp->level = -1;
	sp->def.s.token = specialtab[i].token;
	sp->next = symtab;
	symtab = sp;
  }

  /* Preset the list of internal constants */
  for (i = 0; predefconsts[i].name != NULL; i++) {
	sp = (struct sym *)mymalloc(sizeof(struct sym));
	sp->type = constsym;
	sp->name = predefconsts[i].name;
	sp->level = -1;
	sp->def.c.t = predefconsts[i].t;
	switch (predefconsts[i].t->type) {
		case EXPR_NUM:
			sp->def.c.val.i = predefconsts[i].numval;
			break;
		case EXPR_BOOL:
			sp->def.c.val.b = predefconsts[i].numval;
			break;
		case EXPR_CHAR:
			sp->def.c.val.c = predefconsts[i].numval;
			break;
		default:
			break;
	}
	sp->next = symtab;
	symtab = sp;
  }

  /* Preset the list of internally defined variables */
  for (i = 0; predefvars[i].name != NULL; i++) {
#ifdef PARANOID
	if (dataptr != predefvars[i].addr)
		interror(118, "internal variable address doesn't match default");
#endif
	size = predefvars[i].t->size;
	if (predefvars[i].t->type == EXPR_STRING)
		size++;
	dataptr += (size + 1) & 0xfffe;
	sp = (struct sym *)mymalloc(sizeof(struct sym));
	sp->type = varsym;
	sp->name = predefvars[i].name;
	sp->addr = predefvars[i].addr;
	sp->level = -1;
	sp->def.v.t = predefvars[i].t;
	sp->def.v.attr = ATTR_CONST;
	sp->next = symtab;
	symtab = sp;
  }
}



/*
 *****************************************************************************
 *
 * Terminate lexer
 */
void yylexterm()
{
  /* Close input file */
  if (curfile != NULL && *curfile)
	fclose(yyin);
}



/*
 *****************************************************************************
 *
 * We don't want to need to use a library, so define yywrap here, if it's
 * not a macro.
 */
#ifndef yywrap
int yywrap()
{
  return(1);
}
#endif

