/*
  $Id: debug.c,v 1.9 1996/08/20 14:55:30 luik Exp $

  debug.c - omirrd debug module.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "common.h"

#if defined(RCSID) && !defined(lint)
static char rcsid[] UNUSED__ = "$Id: debug.c,v 1.9 1996/08/20 14:55:30 luik Exp $";
#endif /* defined(RCSID) && !defined(lint) */

#include "debug.h"
#include "optflags.h"


#ifdef DEBUG

static OptTableEntRec debug_list[] = {
    { "cf",		DEBUG_CF,		0 },
    { "config",		DEBUG_CF,		0 },
    { "conn",		DEBUG_CONN,		0 },
    { "daemon",		DEBUG_DAEMON,		0 },
    { "dprot",		DEBUG_DPROT,		0 },
    { "iname",		DEBUG_INAME,		0 },
    { "kprot",		DEBUG_KPROT,		0 },
    { "op",		DEBUG_OP,		0 },
    { "prot",		DEBUG_PROT,		0 },
    { "sock",		DEBUG_SOCK,		0 },
    { NULL,		0,			0 }
};

/* debugParseLevels - parses the `optstring' for a comma separated
   list of debug levels. These levels are returned in the bit mask
   `*setp' which is zero'ed at the beginning. Returns 0 on success and
   -1 if the optstring could not be parsed, setting `*unknown_argsp'
   to a string containing the unparsable parts of the `optstring'.  */

int debugParseLevels(char *optstring, unsigned long *setp, char **unknown_argsp)
{
    int result = 0;
    unsigned long clear;	/* unused */

    *setp = 0L;

    if (optstring == NULL || *optstring == '\0')
	return 0;

    result = optParseList(optstring, setp, &clear, unknown_argsp, debug_list);
    return (result);
}
#endif /* defined(DEBUG) */

