/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include <sys/wait.h>
#include "connect.h"
#include "main.h"

extern void sending(struct client_type *);
extern void receive_data(void *);
extern short get_var_from_pftprc(const char *, char *);

void client_filter_programm(void *cstruct)
{
   struct client_type *clientstr = (struct client_type *)cstruct;
   int pfds[2];
   int pid;
   /*
    * Start a child process for the filter of the client.
    */
   if (pipe(pfds) < 0) {
      fprintf(stderr, "** pipe: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   if ((pid = fork()) < 0) {
      fprintf(stderr, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   /*
    * Here goes the child 'sending'.
    */
   if (pid) {
      close(*pfds);
      (*statstr)->fp = fdopen(*(pfds+1), "w");
      if ((*statstr)->_STANDARD_INPUT_) {
         setvbuf((*statstr)->fp, \
         (*statstr)->_STDIN_BUFFER_, \
         (*statstr)->_STDIN_BUFFER_ ?  _IOFBF : _IONBF, \
         (*statstr)->_SET_STDIN_BUF_ ? (*statstr)->_STDIN_BUFSIZ_: BUFSIZ);
      }
      sending(clientstr);
      fclose((*statstr)->fp);
      fflush(stderr);
#ifdef NEXTSTEP
      while (wait((union wait *)0) != pid); 
#else
      while (wait((int *)0) != pid);
#endif
#ifdef USE_POSIX_THREAD
      pthread_exit(0);
#else
      exit(0);
#endif
   }
   else {
      /*
       * Set descriptors for the filter of the client.
       */
      dup2(*pfds, 0);
      /* close(*pfds); */
      close(*(pfds+1));
      dup2(s, 1);
      close(s);

      /*
       * Execute the filter programm specified
       * by the environment variable PFTPCFILTER.
       */
      execvp(*filter, filter);
      fprintf(stderr, "** exec: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
}

void server_filter_programm(void *snum)
{
   FILE *fp;
   int strnum = (int)*(int *)snum;
   int pfds[2];
   int pid;
   int size=(*(statstr+strnum))->size;
   /*
    * Reset the signals to its defaults behavoir.
    */
   signal(SIGCHLD, SIG_DFL);
#ifndef USE_POSIX_THREAD
   signal(SIGINT, SIG_DFL);
   signal(SIGQUIT, SIG_DFL);
#endif

   /*
    * Start a child for the filter of the server.
    */
   if (pipe(pfds) < 0) {
      fprintf(stderr, "** pipe: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   if ((pid = fork()) < 0) {
      fprintf(stderr, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
   /*
    * Here goes the child 'receive_data'.
    */
   if (pid) {
      close(*(pfds+1));
      fp = fdopen(*pfds, "r");
      if ((*(statstr+strnum))->_STANDARD_INPUT_) {
         setvbuf(fp, \
         (*statstr)->_STDIN_BUFFER_, \
         (*statstr)->_STDIN_BUFFER_ ?  _IOFBF : _IONBF, \
         (*statstr)->_SET_STDIN_BUF_ ? (*statstr)->_STDIN_BUFSIZ_: BUFSIZ);
      }
      (*(statstr+strnum))->fp = fp;
      (*(statstr+strnum))->REMOTEHOSTNAME[size] = '\0';
      receive_data((void *)&strnum);
#ifdef NEXTSTEP
      while (wait((union wait *)0) != pid); 
#else
      while (wait((int *)0) != pid);
#endif
      close(*pfds);
      fflush(stderr);
#ifdef USE_POSIX_THREAD
      pthread_exit(0);
#else
      exit(0);
#endif
   }
   else {
      /*
#ifdef USE_POSIX_THREAD
      signal(SIGCHLD, SIG_DFL);
      signal(SIGINT, SIG_DFL);
      signal(SIGQUIT, SIG_DFL);
#endif
      */
      /*
       * Set descriptors for the filter of the server.
       */
      close(*pfds);
      dup2((*(statstr+strnum))->ns, 0);
      close((*(statstr+strnum))->ns);
      dup2(*(pfds+1), 1);
      close(*(pfds+1));

      /*
       * Execute the filter programm specified
       * by the environment variable PFTPSFILTER.
       */
      execvp(*filter, filter);
      fprintf(stderr, "** exec: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
}

void set_filter(short isserver)
{
   int i=0, j, h=(*statstr)->usefilter;
   char last = '\0', *str=NULL;

   if (isserver) {
      if (!(str = getenv("PFTPSFILTER"))) {
         MEM_CHECK((str = (char *) calloc(SONAME, sizeof(char))));
         if (!get_var_from_pftprc("PFTPSFILTER", str)) {
            fprintf(stderr, "** Please set the environment variable PFTPSFILTER!\n");
            exit(1);
         }
      }
   }
   else {
      if (!(str = getenv("PFTPCFILTER"))) {
         MEM_CHECK((str = (char *) calloc(SONAME, sizeof(char))));
         if (!get_var_from_pftprc("PFTPCFILTER", str)) {
            fprintf(stderr, "** Please set the environment variable PFTPCFILTER!\n");
            exit(1);
         }
      }
   }
   /*
    * Get memory.
    */
   MEM_CHECK((*filter = (char *)calloc(SONAME, sizeof(char))));

   /*
    * Set vector filter.
    */
   for (--(*statstr)->usefilter,i=0; (*statstr)->usefilter && *(str+i) != '\0'; i++) {
      if (*(str+i) == ':') (*statstr)->usefilter--;
   }
   if ((*statstr)->usefilter) {
      fprintf(stderr, "** Filter %d not found. Check your filter variable.\n\n", h);
      exit(1);
   }
   for (;*(str+i) == ' ' && *(str+i); i++);
   for (j=h=0; *(str+i) && *(str+i) != ':'; i++) {
      if (*(str+i) != ' ') {
         *(filter[j]+h) = *(str+i);
         h++;
      }
      else if (last != ' ') {
         *(filter[j]+h) = '\0';
         j++;
         h = 0;
         /*
          * Get memory.
          */
         MEM_CHECK((*(filter+j) = (char *)calloc(SONAME, sizeof(char))));
      }
      last = *(str+i);
   }
   if (!getenv("PFTPSFILTER") && !getenv("PFTPCFILTER")) free(str);
   if (!*(filter[j])) *(filter+j) = (char *)NULL;
   else *(filter+j+1) = (char *)NULL;

   /*
    * Print out filter type.
    */
   fprintf(stderr, "* Using `");
   for (j=0; *(filter+j); j++)
   fprintf(stderr, "%s ", *(filter+j));
   fprintf(stderr, "\b' as filter.\n");
}


/*
 * accs--Get a socket to work with.
 */
void accs(void)
{
   /*
    * Get a socket to work with.  This socket will
    * be in the Internet domain, and will be a
    * stream socket.
    */
   if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      fprintf(stderr, "** socket: %s\n", _PFTP_ERROR_ARRAY_);
      exit(1);
   }
}
