/*
 * PPPupd - A Daemon which keeps your PPP connection up.
 * For use with an ISP who boots you off after x minutes of
 * 	inactivity. PPPupd will send timed pings, and test the status
 *	of the connection every DELAY seconds.
 *
 * On startup, pppupd will read a simple conf file to obtain operating
 *	parameters.
 *
 *	Jake Bouvrie <swarthy@thetasys.com>
 *	Fri Jan 26 02:59:30 EST 1996
 */
	
#include	"pppupd.h"

int	outlog = 0,	/* for use as an extern for subs */
	sysl = 0,	/* another var, to reflect weather we have sysloging */
	level = 0,
	facility = 0;

FILE	*logfile = NULL;

void
main(int	argc,char	**argv)
{
	OPT	*options;

	umask(022);
	nice(38);

	options = ParseConfigFile();
	outlog = options->stdoutlogging;
	sysl = options->sysloglogging;
	
	if ( setuid(options->uid) == -1 )
		perror("setuid");
	if ( setgid(options->gid) == -1 )
		perror("setgid");

	if (fork())
		exit(0);

	if ( (logfile = fopen(options->logpath, "a+")) == NULL) {
		perror(options->logpath);
		printf("Log file could not be created, will send to stdout.\n");
		logfile = stdout;
	}

#ifdef _DEBUG_
	printf("Debug: Facil: %d  Level: %d\n", facility, level);
#endif

	fprintf(logfile, "%s: Log started at %s\n", argv[0], getdate());
	if (outlog)
		printf("%s: Log started at %s\n", argv[0], getdate());
	if (sysl)
		syslog( facility | level, "%s: Log started at %s\n", argv[0], getdate());
	fflush(logfile);
	
#ifdef _REPORT_
	printf("LogPath = %s\nConnectScriptPath = %s\nKillScriptPath = %s\n \
		PingProgPath = %s\nPingAddr = %s\nCheckDelay = %d\n \
		DaemonUid = %d\nDaemonGid = %d\nPidPath = %s\nStdOutLog = %s\n", \
		options->logpath, options->connectscriptpath, options->killscriptpath, \
		options->pingpath, options->pingaddr,  options->delay, \
		options->uid, options->gid, options->pidpath, \
		options->stdoutlogging ? "yes" : "no");
#endif

	while ( 1 ) {
		if ( (PPPConnectTest(options)) != 0 ) {
			PPPKill(options->killscriptpath);
			PPPConnect(options);
		}
		sleep(options->delay);
		PPPSendPing(options);
	}
}

