/*  VER 015  TAB P   $Id: list.c,v 1.1 1997/08/14 13:40:42 src Exp $
 *
 *  fetch the active list
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "nntp.h"
#include "statistics.h"

/*
 *  report one group
 */
static void
report_list(FILE *f,char *group, char status, char *filename)
{
    if (!f) return;

    if (fprintf(f,"%s %c\n",group,status) <= 0) {
	log_msg(L_ERRno,"error writing to \"%s\"",filename);
	fclose(f);
	unlock_exit(8);
    }
}

/*
 *  report one group description
 */
static void
report_desc(FILE *f,char *desc, char *filename)
{
    if (!f) return;

    if (fprintf(f,"%s\n",desc) <= 0) {
	log_msg(L_ERRno,"error writing to \"%s\"",filename);
	fclose(f);
	unlock_exit(8);
    }
}

/*
 *  read the group list proper
 *  return false on errors that mean we should not continue
 */
static int 
read_list(FILE *f_all,FILE *f_new, int is_desc)
{
    char line[NNTP_STRLEN+1];
    long len;
    char *p;
    char c;
    char status;

    line[NNTP_STRLEN] = '\0'; /* better safe than sorry */

    for (;;) {
	if (!get_server_msg(line, NNTP_STRLEN)) {
	    /* timeout: simply give up */
	    return 0;
	}
	len = strlen(line);
	gross_bytecount += len;

	/* end of file */
	if (line[0]=='.' && (line[1]=='\r' || line[1]=='\n')) break;

	/* find and strip newlines */
	while (len > 0 && (line[len-1]=='\r' || line[len-1]=='\n')) {
	    --len;
	}
	if (len > 0) {
	    line[len] = '\0';
	    p = line;
	    while (*p) {
		if (*p==' ' || *p=='\t') {
		    if (is_desc) {
			int doit;
			c = *p;
			*p = '\0';
			doit = (f_new && is_in_active(line));
			*p = c;
			if (doit) report_desc(f_new,line,group_desc);
			report_desc(f_all,line,group_alldesc);
		    } else {
			long n1,n2;
			/* pick moderation status too */
			status = 'y';
			sscanf(p+1,"%ld %ld %c",&n1,&n2,&status);
			if (f_new && !is_in_active(line)) {
			    report_list(f_new,line,status,group_newlist);
			}
			report_list(f_all,line,status,group_list);
		    }
		    break;
		}
		++p;
	    }


	}
    }
    return 1;
}

/*
 *  fetch list proper
 *  return false if no point in continuing
 */
static int 
handle_list(char *status, long dummy)
{
    FILE *f_all = 0;
    FILE *f_new = 0;
    int pid_all;
    int pid_new;
    char *endptr;
    int ok;

    switch (strtoul(status,&endptr,10)) {
    case OK_GROUPS:			/* group list OK */
	if (group_list && !(f_all = open_any(group_list,&pid_all))) 
	    unlock_exit(8);
	if (group_newlist && !(f_new = open_any(group_newlist,&pid_new)))
	    unlock_exit(8);

	ok = read_list(f_all,f_new,0);

	if (f_all && close_any(f_all,pid_all) < 0) 
	    unlock_exit(8);
	if (f_new && close_any(f_new,pid_new) < 0) 
	    unlock_exit(8);
	return ok;

    default:				/* otherwise, protocol error */
	log_msg(L_ERR,"NNTP can't get newsgroup list, got \"%s\"", status);
	/* stop here */
	return 0;
    }
}

/*
 *  fetch description proper
 */
static int 
handle_desc(char *status, long dummy)
{
    FILE *f_all = 0;
    FILE *f_new = 0;
    int pid_all;
    int pid_new;
    char *endptr;
    int ok;

    switch (strtoul(status,&endptr,10)) {
    case OK_GROUPS:			/* group list OK */
	if (group_alldesc && !(f_all = open_any(group_alldesc,&pid_all)))
	    unlock_exit(8);
	if (group_desc && !(f_new = open_any(group_desc,&pid_new)))
	    unlock_exit(8);

	ok = read_list(f_all,f_new,1);

	if (f_all && close_any(f_all,pid_all) < 0) 
	    unlock_exit(8);
	if (f_new && close_any(f_new,pid_new) < 0) 
	    unlock_exit(8);
	return ok;

    default:				/* otherwise, protocol error */
	log_msg(L_ERR,"NNTP can't get newsgroup descriptions, got \"%s\"", status);
	/* stop here */
	return 0;
    }
}

/*
 *  get list of groups 
 */
int
get_list(void)
{
    char request[NNTP_STRLEN+1];

    if (!group_list && !group_newlist) return;

    progtitle("get list");

    if (group_list) log_msg(L_DEBUG,"get full list to %s",group_list);
    if (group_newlist) log_msg(L_DEBUG,"get new list to %s",group_newlist);

    sprintf(request, "LIST%s", newline);

    return put_request(request,handle_list,0L);
}

/*
 *  get list of group description
 */
int
get_desc(void)
{
    char request[NNTP_STRLEN+1];

    if (!group_desc && !group_alldesc) return;

    progtitle("get desc");

    if (group_desc) log_msg(L_DEBUG,"get descriptions to %s",group_desc);
    if (group_alldesc) log_msg(L_DEBUG,"get all descriptions to %s",group_alldesc);

    sprintf(request, "LIST NEWSGROUPS%s", newline);

    return put_request(request,handle_desc,0L);
}

