/* 
   CAM - Cpu's Audio Mixer for Linux 
   (c) 1994-1996 
   AUTHOR: Jan 'TWP' VANDENBERGHE (jvdbergh@uia.ua.ac.be) 
 
*/ 
 
/* 
     This program is free software; you can redistribute it and/or 
     modify it under the terms of the GNU General Public License 
     as published by the Free Software Foundation; either version 2 
     of the License, or (at your option) any later version. 
 
     This program is distributed in the hope that it will be useful, 
     but WITHOUT ANY WARRANTY; without even the implied warranty of 
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
     GNU General Public License for more details. 
 
     You should have received a copy of the GNU General Public License 
     along with this program; if not, write to the Free Software 
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/ 
 
 
#include "cam.h" 

#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <sys/ioctl.h>

#define DIV 1285
#define SPACE (COLS - (2*35)) / 3
#define LPOS (SPACE+14)
#define RPOS (21+SPACE)


int mixer_fd, recmask, devmask, stereodevs, recsrc;
char *devname[DEV_COUNT] = SOUND_DEVICE_LABELS;
char *mixer_dev = "/dev/mixer";
struct devices
{
  int vol_left, vol_right;
  int dev_nr;
} dev_vol[DEV_COUNT];
int dev_count = 0;


void close_mixer(void)
{
  if (close(mixer_fd) != 0)
     fprintf(stderr,"Error closing device %s",mixer_dev);
}

/* gets n bits from x starting from position p */
int getbits(int x, int p, int n)
{
    return ( x >> ( p+1-n) ) & ~(~0 << n );
}

/* sets the volume of a given device */
void adjust(int dev_nr, int left, int right) 
{ 
     int temp_0 = 0,temp_1 = 0, temp = 0; 
     temp_0 = left * DIV ; 
     temp_1 = right * DIV; 
     temp_0 =  getbits(temp_0,7,8); 
     temp_1 = getbits(temp_1,15,8) << 8; 
     temp = temp_1 + temp_0; 

     if (ioctl(mixer_fd, MIXER_WRITE(dev_nr), &temp) == -1) { 
        finish(0);
        fprintf(stderr,"MIXER_WRITE : Can't write to %s !",mixer_dev); 
        exit(1); 
     } 
 
} 
  

/* evaluates an argument */ 
int eval_argv(char *arg) 
{ 
   if ( (strcmp(arg,"-v") == 0) ||  (strcmp(arg,"--volume") == 0) ) 
      return 0; 
   else if ( (strcmp(arg,"-b") == 0) ||  (strcmp(arg,"--bass") == 0) ) 
	return 1; 
   else if ( (strcmp(arg,"-t") == 0) ||  (strcmp(arg,"--treble") == 0) ) 
        return 2; 
   else if ( (strcmp(arg,"-s") == 0) ||  (strcmp(arg,"--synth") == 0) ) 
        return 3; 
   else if ( (strcmp(arg,"-p") == 0) ||  (strcmp(arg,"--pcm") == 0) ) 
           return 4; 
   else if ( (strcmp(arg,"-S") == 0) ||  (strcmp(arg,"--speaker") == 0) ) 
        return 5; 
   else if ( (strcmp(arg,"-l") == 0) ||  (strcmp(arg,"--line") == 0) ) 
	return 6; 
   else if ( (strcmp(arg,"-m") == 0) ||  (strcmp(arg,"--mic") == 0) ) 
        return 7; 
   else if ( (strcmp(arg,"-c") == 0) ||  (strcmp(arg,"--cd") == 0) ) 
        return 8; 
   else if ( (strcmp(arg,"-I") == 0) ||  (strcmp(arg,"--imix") == 0) ) 
        return 9;         
   else if ( (strcmp(arg,"-a") == 0) ||  (strcmp(arg,"--altpcm") == 0) ) 
        return 10;         
   else if ( (strcmp(arg,"-r") == 0) ||  (strcmp(arg,"--reclev") == 0) ) 
        return 11;         
   else if ( (strcmp(arg,"-i") == 0) ||  (strcmp(arg,"--igain") == 0) ) 
        return 12;         
   else if ( (strcmp(arg,"-o") == 0) ||  (strcmp(arg,"--ogain") == 0) ) 
        return 13;
   else if ( (strcmp(arg,"-l1") == 0) ||  (strcmp(arg,"--line1") == 0) ) 
        return 14;         
   else if ( (strcmp(arg,"-l2") == 0) ||  (strcmp(arg,"--line2") == 0) ) 
        return 15;         
   else if ( (strcmp(arg,"-l3") == 0) ||  (strcmp(arg,"--line3") == 0) ) 
        return 16;         
                 
   else if ( (strcmp(arg,"-h") == 0) || (strcmp(arg,"-?") == 0) || (strcmp(arg,"--help") == 0))
        return 20; 
   else if (strcmp(arg,"-get") == 0) 
        return 21; 
   else if (strcmp(arg,"-getfile") == 0)
        return 22;
   else if (strcmp(arg,"-save") == 0) 
        return 23; 
   else if (strcmp(arg,"-savefile") == 0)
        return 24;        
   else  
      return 99; 
} 

/* sets sound given from command line */ 
void set_sound(int argc, char *argv[]) 
{ 
   int ii, vol_left, vol_right,dummy,pos; 
   int argc_count = 1;
   FILE *save_file; 
   char *SAVE_FILE;
   int device;
   int left,right;
   
   SAVE_FILE = getenv("HOME");
   strcat(SAVE_FILE,"/.camrc");
   
   init_sound();
   do {
       switch (eval_argv(argv[argc_count])) { 
	  case 20 : /* get */
	       comm_help();
	       break; 
	  case 21 : 
	       if (( save_file = fopen(SAVE_FILE,"r")) == NULL) 
		  printf("\nNo save file available\n\n"); 
	       else { 
		  fscanf(save_file,"%i\n",&dummy); 
 
		  for (ii = 0 ; ii < DEV_COUNT ; ii++) { 
		      fscanf(save_file,"%i %i\n",&vol_left, &vol_right); 
		      
		      fflush(save_file); 
		      if (DEV_EXIST(ii))
			 adjust(ii,vol_left, vol_right); 
		  } 
	       } 
	       fclose(save_file);
	       break; 
	  case 22 : /* getfile */
	       argc_count++;
	       if (( save_file = fopen(argv[argc_count],"r")) == NULL) 
		  printf("\nNo save file available\n\n"); 
	       else { 
		  fscanf(save_file,"%i\n",&dummy); 
 
		  for (ii = 0 ; ii < DEV_COUNT ; ii++) { 
		      fscanf(save_file,"%i %i\n",&vol_left, &vol_right); 
		      fflush(save_file); 
		      if (DEV_EXIST(ii)) 
			 adjust(ii,vol_left, vol_right); 
		  } 
		  fclose(save_file);
	       } 
	       break; 
	  case 23 :  /* save */
	       if ((save_file = fopen(SAVE_FILE,"w")) == NULL) {
	          message("Unable to save settings");
	          break;
	        }
	        fprintf(save_file,"%i\n",0);
   	        for (ii =0; ii < DEV_COUNT; ii++) {
	            if ( DEV_EXIST(ii) ) {
                       if (ioctl(mixer_fd, MIXER_READ(ii), &pos) == -1 ) {
                          finish(0);
                          fprintf(stderr,"MIXER_READ : Error reading %s\n",mixer_dev);
                          exit(1);
                       }
                       vol_left = getbits(pos,7,8) / (DIV >>8);
                       if (STEREO(ii)) {
                          vol_right = getbits(pos,15,8) / (DIV >>8);
                       } else
                         vol_right = -1;
	            } else {
	              vol_left = -1;
	              vol_right = -1;
	            }
	            fprintf(save_file,"%i %i\n",vol_left, vol_right);
	        }
                fclose(save_file);	     
	       break; 
	  case 24 : /* savefile */
	       argc_count++;
	       if ((save_file = fopen(argv[argc_count],"w")) == NULL) {
	          message("Unable to save settings");
	          break;
	        }
	        fprintf(save_file,"%i\n",0);
   	        for (ii =0; ii < DEV_COUNT; ii++) {
	            if ( DEV_EXIST(ii) ) {
                       if (ioctl(mixer_fd, MIXER_READ(ii), &pos) == -1 ) {
                          finish(0);
                          fprintf(stderr,"MIXER_READ : Error reading %s\n",mixer_dev);
                          exit(1);
                       }
                       vol_left = getbits(pos,7,8) / (DIV >>8);
                       if (STEREO(ii)) {
                          vol_right = getbits(pos,15,8) / (DIV >>8);
                       } else
                         vol_right = -1;
	            } else {
	              vol_left = -1;
	              vol_right = -1;
	            }
	            fprintf(save_file,"%i %i\n",vol_left, vol_right);
	        }
                fclose(save_file);	     	       
	       break; 	       

	  case 0 : case 1 : case 2 : case 3 : case 4 : case 5 : case 6 : case 7 : case 8 : 
	  case 9 : case 10 : case 11 : case 12 : case 13 : case 14 : case 15 : case 16 :     

	       device = eval_argv(argv[argc_count]);
	       argc_count++;	       
	       
	       if DEV_EXIST(device) {
   	          sscanf(argv[argc_count],"%i,%i",&left,&right);
	          adjust(device,left,right);
	       } else
	          fprintf(stderr,"\nDevice not supported\n\n");
               break;	  
          case 99 :
               fprintf(stderr,"\nIllegal option %s\n",argv[argc_count]);
               argc_count++;
               break;     
        } 
       argc_count++;
     } while ( argc_count < argc);
} 



void init_sliders(void)
{
   int X,Y ;
   int dev_nr;
   int pos;
   int max_dev = ((LINES -2 -3) / 3) * 2 ;
   X = SPACE;
   Y = -1;
   for (dev_nr = 0; dev_nr < DEV_COUNT; dev_nr++) {
       if ( DEV_EXIST(dev_nr) ) {
          if (dev_count >= max_dev)
             break;
          if ( Y + 6 > LINES -3 ) {
             Y = 2;
             X = COLS - (35 + SPACE);
          } else 
             Y = Y + 3; 
          
          if (ioctl(mixer_fd, MIXER_READ(dev_nr), &pos) == -1 ) {
              finish(0);
              fprintf(stderr,"MIXER_READ : Error reading %s\n",mixer_dev);
              exit(1);
          }

          dev_vol[dev_count].vol_left = getbits(pos,7,8) / ( DIV >> 8) ;
          if (STEREO(dev_nr))
             dev_vol[dev_count].vol_right = getbits(pos,15,8) / (DIV >> 8) ;
          else
             dev_vol[dev_count].vol_right = dev_vol[dev_count].vol_left;

          draw_slider( Y, X, devname[dev_nr]);
          draw_handle( Y+1, X+14+dev_vol[dev_count].vol_left, FALSE, 4);
          if (STEREO(dev_nr))
             draw_handle( Y+2, X+14+dev_vol[dev_count].vol_right, FALSE, 4);          
          dev_vol[dev_count++].dev_nr = dev_nr;             
       }
   }
}

void ctrl_sliders(void)
{
    int ch;
    int X,Y;
    int left = TRUE;   
    int locked = FALSE;  
    FILE *save_file; 
    int dev_nr = 0; 
    char *SAVE_FILE; 
    int *volume;  
    int X_rest = LPOS;
    int dev_nrs;
    int pos;
    int vol_left, vol_right;
    int dev_nr_tmp ,X_tmp, Y_tmp, X_rest_tmp;    
    
    SAVE_FILE = getenv("HOME");
    strcat(SAVE_FILE,"/.camrc");
   
    init_sound();
    init_sliders();    

    keypad(stdscr, TRUE); 
    cbreak(); 
    noecho(); 

    volume = &dev_vol[dev_nr].vol_left;    

    X = X_rest+*volume;
    Y = 3;
                                                      
    draw_handle(Y,X,TRUE,4); 
    do { 
       
       status( ((locked  == TRUE) ? "  LOCKED  " : " UNLOCKED ")); 
       ch = getch(); 
       fflush(stdin); 
       message("");
       switch (ch) { 
	case 27 : case 'q' : case 'Q' :
 	     break; 
	case KEY_LEFT :  
             if  ( *volume > 0)  { 
                 *volume = *volume-1;
                 X--;
		 draw_handle(Y,X,TRUE,3);
		 
		 if ( (locked) && (STEREO(dev_vol[dev_nr].dev_nr)) ) { 
		     dev_vol[dev_nr].vol_right--; 
                     draw_handle(Y+1,X,TRUE,3);
                 }
             }   
	     break;
	case KEY_RIGHT: 
             if (*volume < 20) { 
                *volume = *volume+1;
                X++;
                draw_handle(Y,X-1,TRUE,1); 

                if ( (locked)  && (STEREO(dev_vol[dev_nr].dev_nr)) ) {    
                   dev_vol[dev_nr].vol_right++; 
                   draw_handle( Y+1,X-1,TRUE,1); 
	        }
	     }
	     break;
	case KEY_UP: 
 
             draw_handle(Y,X,FALSE,4); 
             if ( (locked) && STEREO(dev_vol[dev_nr].dev_nr)) 
                draw_handle(Y+1,X,FALSE,4); 
             
             if ((left == TRUE) || (locked == TRUE ) || (!STEREO(dev_vol[dev_nr].dev_nr))) {
                dev_nr = (dev_nr + dev_count - 1) % dev_count;
                if (dev_nr == dev_count-1) {
                   int tmp;
                                   
                   X_rest = COLS - RPOS;
                   tmp = dev_count - ((LINES - 3 -2) / 3);
                   if (STEREO(dev_vol[dev_nr].dev_nr))                   
                      Y = 2 + (tmp * 3) +1;
                   else
                      Y = 2 + (tmp * 3) +1 - 1; 
                }
                if ( Y > 5 ) {
                   if (STEREO(dev_vol[dev_nr].dev_nr) && (!locked))
                      Y -= 2;
                   else
                      Y -= 3;   
                } else {
                    if (STEREO(dev_vol[dev_nr].dev_nr) && (!locked))
                       Y = 1+(dev_nr+1) *3 ;
                    else
                       Y = 1+((dev_nr+1) *3 -1);
                    X_rest =  LPOS;
                  }

                if ( locked && (STEREO(dev_vol[dev_nr].dev_nr))) { 
                   int temp_vol;

                   X = dev_vol[dev_nr].vol_left + X_rest;                    
                   draw_handle(Y,X,FALSE,5);
                   X = dev_vol[dev_nr].vol_right + X_rest;
                   draw_handle(Y+1,X,FALSE,5);

                   temp_vol = (dev_vol[dev_nr].vol_left + dev_vol[dev_nr].vol_right) / 2;
                   dev_vol[dev_nr].vol_left = temp_vol;
                   dev_vol[dev_nr].vol_right = temp_vol;
                   
                } 
                if (STEREO(dev_vol[dev_nr].dev_nr) && (!locked)) {
                   X = dev_vol[dev_nr].vol_right + X_rest;
                   volume = &dev_vol[dev_nr].vol_right;
                   left = FALSE;
                } else {
                   X = dev_vol[dev_nr].vol_left + X_rest;
                   volume = &dev_vol[dev_nr].vol_left;
                   left = TRUE;                
                  }
                
             } else
                if ( (left == FALSE ) && (STEREO(dev_vol[dev_nr].dev_nr)) ) {
                   Y--;
                   volume = &dev_vol[dev_nr].vol_left;
                   X = X_rest+*volume;
                   left = TRUE;
                }

             draw_handle(Y,X,TRUE,4);
             if ((locked) && STEREO(dev_vol[dev_nr].dev_nr))
                draw_handle(Y+1,X,TRUE,4);
	     break; 
 
	case KEY_DOWN: 
             draw_handle(Y,X,FALSE,4); 
             if ((locked) && STEREO(dev_vol[dev_nr].dev_nr)) 
                draw_handle(Y+1,X,FALSE,4);

             if ((left == FALSE) || (locked) || (!STEREO(dev_vol[dev_nr].dev_nr))) {
                dev_nr = (dev_nr + 1) % dev_count;
                
                if (dev_nr == 0)
                {
                   X_rest = LPOS;
                   if (locked)
                      Y = 0;
                   else
                      Y = 1;
                }
                if ( Y+4 < LINES-3) {
                   if (left == FALSE)
                      Y += 2;
                   else
                      Y += 3;
                 } else {
                     Y = 3;
                     X_rest = COLS - RPOS;
                   }
                   
                if ( locked && (STEREO(dev_vol[dev_nr].dev_nr))) { 
                   int temp_vol;

                   X = dev_vol[dev_nr].vol_left + X_rest;                    
                   draw_handle(Y,X,FALSE,5);
                   X = dev_vol[dev_nr].vol_right + X_rest;
                   draw_handle(Y+1,X,FALSE,5);

                   temp_vol = (dev_vol[dev_nr].vol_left + dev_vol[dev_nr].vol_right) / 2;
                   dev_vol[dev_nr].vol_left = temp_vol;
                   dev_vol[dev_nr].vol_right = temp_vol;
                    
                }                    
                   
                X = dev_vol[dev_nr].vol_left + X_rest;                   
                volume = &dev_vol[dev_nr].vol_left;
                left = TRUE;
             } else
                 if ( (left == TRUE ) && (STEREO(dev_vol[dev_nr].dev_nr)) ) {
                    Y++;
                    volume = &dev_vol[dev_nr].vol_right;
                    X = X_rest+*volume;
                    left = FALSE;
                 }
 


	     draw_handle(Y,X,TRUE,4);      
             if ((locked) && STEREO(dev_vol[dev_nr].dev_nr)) 
                draw_handle(Y+1,X,TRUE,4); 
	     break; 
           
	case 'l' : case 'L': 
      
             if ((locked) && STEREO(dev_vol[dev_nr].dev_nr) ) {
                if (left)
                   draw_handle(Y+1,X,FALSE,4);  
                else
                   draw_handle(Y-1,X,FALSE,4);
                }
             else if ((!locked) && STEREO(dev_vol[dev_nr].dev_nr) ) { 
                     int temp_vol;
                     
                     draw_handle(Y,X,FALSE,5);
                     if (left) {
                        X = dev_vol[dev_nr].vol_right + X_rest;
                        draw_handle(Y+1,X,FALSE,5);
                     } else {
                        X = dev_vol[dev_nr].vol_left + X_rest;
                        draw_handle(Y-1,X,FALSE,5);
                       }
                     temp_vol = (dev_vol[dev_nr].vol_left + dev_vol[dev_nr].vol_right) / 2;
                     dev_vol[dev_nr].vol_left = temp_vol;
                     dev_vol[dev_nr].vol_right = temp_vol;
                     
                     X = dev_vol[dev_nr].vol_left + X_rest;
                     draw_handle(Y,X,TRUE,4);
                     if (left)
                        draw_handle(Y+1,X,TRUE,4);
                     else
                        draw_handle(Y-1,X,TRUE,4);
        	     
                  } 
	     locked =  (locked+1) % 2; 
	     if (!left) {
	        Y--;
                left = TRUE;
       	        volume = &dev_vol[dev_nr].vol_left;                        
	     }
	     break; 
	case 's' : case 'S' : 
	     if ( (save_file = fopen(SAVE_FILE,"w")) == NULL) {
	        message("Unable to save settings");
	        break;
	     }
	     fprintf(save_file,"%i\n",locked);
	     for (dev_nrs =0; dev_nrs < DEV_COUNT; dev_nrs++) {
	         if ( DEV_EXIST(dev_nrs) ) {
                    if (ioctl(mixer_fd, MIXER_READ(dev_nrs), &pos) == -1 ) {
                       finish(0);
                       fprintf(stderr,"MIXER_READ : Error reading %s\n",mixer_dev);
                       exit(1);
                    }
                    vol_left = getbits(pos,7,8) / (DIV >>8);
                    if (STEREO(dev_nrs)) {
                       vol_right = getbits(pos,15,8) / (DIV >>8);
                    } else
                       vol_right = -1;
	         } else {
	            vol_left = -1;
	            vol_right = -1;
	           }
	        fprintf(save_file,"%i %i\n",vol_left, vol_right);
	           
	     }
             fclose(save_file);	     
             message("Settings saved");
	     break;
	case 'g' : case 'G' :
	
	     if ( (save_file = fopen(SAVE_FILE,"r")) == NULL) {
	        message("No save file available");
	        break;
	     }
	     fscanf(save_file,"%i\n",&locked);
	     dev_nr_tmp = 0;
	     X_rest_tmp = LPOS;
	     Y_tmp = 3;
	     for (dev_nrs =0; dev_nrs < DEV_COUNT; dev_nrs++) {

 	         fscanf(save_file,"%i %i\n",&vol_left, &vol_right);	     
                 fflush(save_file);
	         if ( DEV_EXIST(dev_nrs) ) {
                    adjust(dev_nrs,vol_left,vol_right);

                    X_tmp = X_rest_tmp + dev_vol[dev_nr_tmp].vol_left;
                    draw_handle(Y_tmp,X_tmp,FALSE,5);

                    dev_vol[dev_nr_tmp].vol_left = vol_left;
                    X_tmp = X_rest_tmp + vol_left;
                    
                    if ( (dev_nr_tmp == dev_nr) && (locked || left == TRUE) ) {
                       draw_handle(Y_tmp,X_tmp,TRUE,4);
                       X = X_tmp;
                    } else
                       draw_handle(Y_tmp,X_tmp,FALSE,4);                    

                    if (STEREO(dev_nrs)) {
                       X_tmp = X_rest_tmp + dev_vol[dev_nr_tmp].vol_right;
                    
                       draw_handle(Y_tmp+1,X_tmp,FALSE,5);

                       dev_vol[dev_nr_tmp].vol_right = vol_right;
                       X_tmp = X_rest_tmp + vol_right;
                       if ( (dev_nr_tmp == dev_nr) && (locked || left == FALSE) ) {
                          draw_handle(Y_tmp+1,X_tmp,TRUE,4);
                          X = X_tmp;
                       } else
                          draw_handle(Y_tmp+1,X_tmp,FALSE,4);                       

                    }
   	            dev_nr_tmp++;
                    if ( Y_tmp+4 < LINES-3) {
                       Y_tmp += 3;
                     } else {
                        Y_tmp = 3;
                        X_rest_tmp = COLS - RPOS;
                       }
                 }
	     }
             fclose(save_file);	     
             message("Settings loaded");
	     break;	
        case 'h' : case 'H' :
             help();
             break;
     } 
     if ( (ch != 27) && (ch != 'Q') &&  (ch != 'q') )  { 
        adjust( dev_vol[dev_nr].dev_nr, dev_vol[dev_nr].vol_left, dev_vol[dev_nr].vol_right);   
     } 
   } 
   while ( (ch != 27) && (ch != 'Q') &&  (ch != 'q') ); 
   
}


/* initializes the sound */ 
void init_sound() 
{ 

  if ((mixer_fd = open(mixer_dev, O_RDWR)) < 0) { 
     finish(0); 
     fprintf(stderr,"Error opening %s. : you probably don't have an audiocard that supports a mixer",mixer_dev); 
     exit(1); 
  } 
  if (ioctl(mixer_fd, SOUND_MIXER_READ_DEVMASK, &devmask) == -1) {  
    finish(0); 
    fprintf(stderr,"SOUND_MIXER_READ_DEVMASK : Error reading %s\n", mixer_dev); 
    exit(-1); 
  } 
  if (ioctl(mixer_fd, SOUND_MIXER_READ_RECMASK, &recmask) == -1)  { 
    finish(0); 
    fprintf(stderr,"SOUND_MIXER_READ_RECMASK : Error reading %s\n", mixer_dev); 
    exit(-1); 
  } 
  if (ioctl(mixer_fd, SOUND_MIXER_READ_RECSRC, &recsrc) == -1)  { 
    finish(0); 
    fprintf(stderr,"SOUND_MIXER_READ_RECSRC : Error reading %s\n", mixer_dev); 
    exit(-1); 
  } 
  if (ioctl(mixer_fd, SOUND_MIXER_READ_STEREODEVS, &stereodevs) == -1)  { 
    finish(0); 
    fprintf(stderr,"SOUND_MIXER_READ_STEREODEVS : Error reading %s\n", mixer_dev); 
    exit(-1); 
 
  }

  if (!devmask) { 
     finish(0);
     fprintf(stderr,"No device found.\n"); 
     exit(1); 
  } 
} 
