// framemodifier.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
// DataModifier subclass for processing "vertical" frames from Data objects
// (vertical means all channels for a given frame)

#ifndef FRAMEMODIFIER_H
// #ifdef __GNUG__
// #pragma interface
// #endif
#define FRAMEMODIFIER_H

#include "datamodifier.h"

class FrameModifier : public DataModifier {
public:
	FrameModifier(Data* data) : DataModifier(data) {}
	virtual int modifyFrame(Data *) = 0;
protected:
	redefined int doApply(Data *data) { return data->apply(*this); }
};

#endif
